/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend.impl;

import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FileManager;
import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.ObjCRuntime;
import org.clang.basic.VersionTuple;
import org.clang.basic.target.TargetInfo;
import org.clang.frontend.FrontendOptions;
import org.clang.frontend.frontend;
import org.clang.lex.PTHManager;
import org.clang.lex.Preprocessor;
import org.clang.serialization.ASTReader;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.APFloat;
import org.llvm.adt.APInt;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.support.fltSemantics;
import org.llvm.support.llvm;
import org.llvm.support.raw_string_ostream;

public final class InitPreprocessorStatics {
    public static boolean MacroBodyEndsInBackslash(StringRef MacroBody) {
        while (!MacroBody.empty() && ClangGlobals.isWhitespace((byte)MacroBody.back())) {
            MacroBody.$assignMove(MacroBody.drop_back());
        }
        return !MacroBody.empty() && MacroBody.back() == NativePointer.$((char)'\\');
    }

    public static void DefineBuiltinMacro(MacroBuilder Builder, StringRef Macro, DiagnosticsEngine Diags) {
        std.pair MacroPair = Macro.split(NativePointer.$((char)'='));
        StringRef MacroName = (StringRef)MacroPair.first;
        StringRef MacroBody = (StringRef)MacroPair.second;
        if (MacroName.size() != Macro.size()) {
            int End = MacroBody.find_first_of((CharSequence)"\n\r");
            if (End != StringRef.npos) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)Diags.Report(478L), (StringRef)MacroName).$destroy();
            }
            MacroBody.$assignMove(MacroBody.substr(0, End));
            if (InitPreprocessorStatics.MacroBodyEndsInBackslash(new StringRef(MacroBody))) {
                Builder.defineMacro(new Twine(MacroName), llvm.$plus_Twine((Twine)new Twine(MacroBody), (Twine)new Twine(NativePointer.$((String)"\\\n"))));
            } else {
                Builder.defineMacro(new Twine(MacroName), new Twine(MacroBody));
            }
        } else {
            Builder.defineMacro(new Twine(Macro));
        }
    }

    public static void AddImplicitInclude(MacroBuilder Builder, StringRef File) {
        Builder.append(llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)new Twine(NativePointer.$((String)"#include \"")), (Twine)new Twine(File)), (Twine)new Twine(NativePointer.$((String)"\""))));
    }

    public static void AddImplicitIncludeMacros(MacroBuilder Builder, StringRef File) {
        Builder.append(llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)new Twine(NativePointer.$((String)"#__include_macros \"")), (Twine)new Twine(File)), (Twine)new Twine(NativePointer.$((String)"\""))));
        Builder.append(new Twine(NativePointer.$((String)"##")));
    }

    public static void AddImplicitIncludePTH(MacroBuilder Builder, Preprocessor PP, StringRef ImplicitIncludePTH) {
        PTHManager P = PP.getPTHManager();
        char.ptr OriginalFile = Native.$tryClone((char.ptr)(P != null ? P.getOriginalSourceFile() : null));
        if (OriginalFile == null) {
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)PP.getDiagnostics().Report(418L), (StringRef)new StringRef(ImplicitIncludePTH)).$destroy();
            return;
        }
        InitPreprocessorStatics.AddImplicitInclude(Builder, new StringRef(OriginalFile));
    }

    public static void AddImplicitIncludePCH(MacroBuilder Builder, Preprocessor PP, StringRef ImplicitIncludePCH) {
        std.string OriginalFile = ASTReader.getOriginalSourceFile((std.string)ImplicitIncludePCH.$basic_string(), (FileManager)PP.getFileManager(), (DiagnosticsEngine)PP.getDiagnostics());
        if (OriginalFile.empty()) {
            return;
        }
        InitPreprocessorStatics.AddImplicitInclude(Builder, new StringRef(OriginalFile));
    }

    public static <T> T PickFP(fltSemantics Sem, T IEEESingleVal, T IEEEDoubleVal, T X87DoubleExtendedVal, T PPCDoubleDoubleVal, T IEEEQuadVal) {
        if (Sem == APFloat.IEEEsingle) {
            return IEEESingleVal;
        }
        if (Sem == APFloat.IEEEdouble) {
            return IEEEDoubleVal;
        }
        if (Sem == APFloat.x87DoubleExtended) {
            return X87DoubleExtendedVal;
        }
        if (Sem == APFloat.PPCDoubleDouble) {
            return PPCDoubleDoubleVal;
        }
        assert (Sem == APFloat.IEEEquad);
        return IEEEQuadVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DefineFloatMacros(MacroBuilder Builder, StringRef Prefix, fltSemantics Sem, StringRef Ext) {
        SmallString DefPrefix = null;
        try {
            CharSequence DenormMin = (CharSequence)Native.$tryClone((Object)InitPreprocessorStatics.PickFP(Sem, "1.40129846e-45", "4.9406564584124654e-324", "3.64519953188247460253e-4951", "4.94065645841246544176568792868221e-324", "6.47517511943802511092443895822764655e-4966"));
            int Digits = InitPreprocessorStatics.PickFP(Sem, 6, 15, 18, 31, 33);
            CharSequence Epsilon = (CharSequence)Native.$tryClone((Object)InitPreprocessorStatics.PickFP(Sem, "1.19209290e-7", "2.2204460492503131e-16", "1.08420217248550443401e-19", "4.94065645841246544176568792868221e-324", "1.92592994438723585305597794258492732e-34"));
            int MantissaDigits = InitPreprocessorStatics.PickFP(Sem, 24, 53, 64, 106, 113);
            int Min10Exp = InitPreprocessorStatics.PickFP(Sem, -37, -307, -4931, -291, -4931);
            int Max10Exp = InitPreprocessorStatics.PickFP(Sem, 38, 308, 4932, 308, 4932);
            int MinExp = InitPreprocessorStatics.PickFP(Sem, -125, -1021, -16381, -968, -16381);
            int MaxExp = InitPreprocessorStatics.PickFP(Sem, 128, 1024, 16384, 1024, 16384);
            CharSequence Min = (CharSequence)Native.$tryClone((Object)InitPreprocessorStatics.PickFP(Sem, "1.17549435e-38", "2.2250738585072014e-308", "3.36210314311209350626e-4932", "2.00416836000897277799610805135016e-292", "3.36210314311209350626267781732175260e-4932"));
            CharSequence Max = (CharSequence)Native.$tryClone((Object)InitPreprocessorStatics.PickFP(Sem, "3.40282347e+38", "1.7976931348623157e+308", "1.18973149535723176502e+4932", "1.79769313486231580793728971405301e+308", "1.18973149535723176508575932662800702e+4932"));
            DefPrefix = new SmallString(32);
            DefPrefix.$assign((CharSequence)"__");
            DefPrefix.$addassign(Prefix);
            DefPrefix.$addassign((CharSequence)"_");
            Builder.defineMacro(llvm.$plus_StringRef_char$ptr((StringRef)DefPrefix.$StringRef(), (char.ptr)NativePointer.$((String)"DENORM_MIN__")), llvm.$plus_Twine((Twine)new Twine(DenormMin), (Twine)new Twine(Ext)));
            Builder.defineMacro(llvm.$plus_StringRef_char$ptr((StringRef)DefPrefix.$StringRef(), (char.ptr)NativePointer.$((String)"HAS_DENORM__")));
            Builder.defineMacro(llvm.$plus_StringRef_char$ptr((StringRef)DefPrefix.$StringRef(), (char.ptr)NativePointer.$((String)"DIG__")), new Twine(JavaDifferentiators.Int.INSTANCE, Digits));
            Builder.defineMacro(llvm.$plus_StringRef_char$ptr((StringRef)DefPrefix.$StringRef(), (char.ptr)NativePointer.$((String)"EPSILON__")), llvm.$plus_Twine((Twine)new Twine(Epsilon), (Twine)new Twine(Ext)));
            Builder.defineMacro(llvm.$plus_StringRef_char$ptr((StringRef)DefPrefix.$StringRef(), (char.ptr)NativePointer.$((String)"HAS_INFINITY__")));
            Builder.defineMacro(llvm.$plus_StringRef_char$ptr((StringRef)DefPrefix.$StringRef(), (char.ptr)NativePointer.$((String)"HAS_QUIET_NAN__")));
            Builder.defineMacro(llvm.$plus_StringRef_char$ptr((StringRef)DefPrefix.$StringRef(), (char.ptr)NativePointer.$((String)"MANT_DIG__")), new Twine(JavaDifferentiators.Int.INSTANCE, MantissaDigits));
            Builder.defineMacro(llvm.$plus_StringRef_char$ptr((StringRef)DefPrefix.$StringRef(), (char.ptr)NativePointer.$((String)"MAX_10_EXP__")), new Twine(JavaDifferentiators.Int.INSTANCE, Max10Exp));
            Builder.defineMacro(llvm.$plus_StringRef_char$ptr((StringRef)DefPrefix.$StringRef(), (char.ptr)NativePointer.$((String)"MAX_EXP__")), new Twine(JavaDifferentiators.Int.INSTANCE, MaxExp));
            Builder.defineMacro(llvm.$plus_StringRef_char$ptr((StringRef)DefPrefix.$StringRef(), (char.ptr)NativePointer.$((String)"MAX__")), llvm.$plus_Twine((Twine)new Twine(Max), (Twine)new Twine(Ext)));
            Builder.defineMacro(llvm.$plus_StringRef_char$ptr((StringRef)DefPrefix.$StringRef(), (char.ptr)NativePointer.$((String)"MIN_10_EXP__")), llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)new Twine(NativePointer.$((String)"(")), (Twine)new Twine(JavaDifferentiators.Int.INSTANCE, Min10Exp)), (Twine)new Twine(NativePointer.$((String)")"))));
            Builder.defineMacro(llvm.$plus_StringRef_char$ptr((StringRef)DefPrefix.$StringRef(), (char.ptr)NativePointer.$((String)"MIN_EXP__")), llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)new Twine(NativePointer.$((String)"(")), (Twine)new Twine(JavaDifferentiators.Int.INSTANCE, MinExp)), (Twine)new Twine(NativePointer.$((String)")"))));
            Builder.defineMacro(llvm.$plus_StringRef_char$ptr((StringRef)DefPrefix.$StringRef(), (char.ptr)NativePointer.$((String)"MIN__")), llvm.$plus_Twine((Twine)new Twine(Min), (Twine)new Twine(Ext)));
        }
        finally {
            if (DefPrefix != null) {
                DefPrefix.$destroy();
            }
        }
    }

    public static void DefineTypeSize(Twine MacroName, int TypeWidth, StringRef ValSuffix, boolean isSigned, MacroBuilder Builder) {
        APInt MaxVal = isSigned ? APInt.getSignedMaxValue((int)TypeWidth) : APInt.getMaxValue((int)TypeWidth);
        Builder.defineMacro(MacroName, llvm.$plus_Twine((Twine)new Twine(MaxVal.__toString(10, isSigned)), (Twine)new Twine(ValSuffix)));
    }

    public static void DefineTypeSize(Twine MacroName, TargetInfo.IntType Ty, TargetInfo TI, MacroBuilder Builder) {
        InitPreprocessorStatics.DefineTypeSize(MacroName, TI.getTypeWidth(Ty), new StringRef(TI.getTypeConstantSuffix(Ty)), TargetInfo.isTypeSigned((TargetInfo.IntType)Ty), Builder);
    }

    public static void DefineFmt(Twine Prefix, TargetInfo.IntType Ty, TargetInfo TI, MacroBuilder Builder) {
        boolean IsSigned = TargetInfo.isTypeSigned((TargetInfo.IntType)Ty);
        StringRef FmtModifier = new StringRef(TargetInfo.getTypeFormatModifier((TargetInfo.IntType)Ty));
        char.ptr Fmt = Native.$tryClone((char.ptr)(IsSigned ? NativePointer.$((String)"di") : NativePointer.$((String)"ouxX")));
        while (Fmt.$star() != 0) {
            Builder.defineMacro(llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)Prefix, (Twine)new Twine(NativePointer.$((String)"_FMT"))), (Twine)new Twine(JavaDifferentiators.Char.INSTANCE, Fmt.$star())), (Twine)new Twine(NativePointer.$((String)"__"))), llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)new Twine(NativePointer.$((String)"\"")), (Twine)new Twine(FmtModifier)), (Twine)new Twine(JavaDifferentiators.Char.INSTANCE, Fmt.$star())), (Twine)new Twine(NativePointer.$((String)"\""))));
            Fmt.$preInc();
        }
    }

    public static void DefineType(Twine MacroName, TargetInfo.IntType Ty, MacroBuilder Builder) {
        Builder.defineMacro(MacroName, new Twine(TargetInfo.getTypeName((TargetInfo.IntType)Ty)));
    }

    public static void DefineTypeWidth(StringRef MacroName, TargetInfo.IntType Ty, TargetInfo TI, MacroBuilder Builder) {
        Builder.defineMacro(new Twine(MacroName), new Twine(JavaDifferentiators.Uint.INSTANCE, (long)TI.getTypeWidth(Ty)));
    }

    public static void DefineTypeSizeof(StringRef MacroName, long BitWidth, TargetInfo TI, MacroBuilder Builder) {
        Builder.defineMacro(new Twine(MacroName), new Twine(JavaDifferentiators.Uint.INSTANCE, BitWidth / (long)TI.getCharWidth()));
    }

    public static void DefineExactWidthIntType(TargetInfo.IntType Ty, TargetInfo TI, MacroBuilder Builder) {
        int TypeWidth = TI.getTypeWidth(Ty);
        boolean IsSigned = TargetInfo.isTypeSigned((TargetInfo.IntType)Ty);
        if (TypeWidth == 64) {
            Ty = IsSigned ? TI.getInt64Type() : TI.getUInt64Type();
        }
        char.ptr Prefix = Native.$tryClone((char.ptr)(IsSigned ? NativePointer.$((String)"__INT") : NativePointer.$((String)"__UINT")));
        InitPreprocessorStatics.DefineType(llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.Int.INSTANCE, TypeWidth)), (Twine)new Twine(NativePointer.$((String)"_TYPE__"))), Ty, Builder);
        InitPreprocessorStatics.DefineFmt(llvm.$plus_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.Int.INSTANCE, TypeWidth)), Ty, TI, Builder);
        StringRef ConstSuffix = new StringRef(TI.getTypeConstantSuffix(Ty));
        Builder.defineMacro(llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.Int.INSTANCE, TypeWidth)), (Twine)new Twine(NativePointer.$((String)"_C_SUFFIX__"))), new Twine(ConstSuffix));
    }

    public static void DefineExactWidthIntTypeSize(TargetInfo.IntType Ty, TargetInfo TI, MacroBuilder Builder) {
        int TypeWidth = TI.getTypeWidth(Ty);
        boolean IsSigned = TargetInfo.isTypeSigned((TargetInfo.IntType)Ty);
        if (TypeWidth == 64) {
            Ty = IsSigned ? TI.getInt64Type() : TI.getUInt64Type();
        }
        char.ptr Prefix = Native.$tryClone((char.ptr)(IsSigned ? NativePointer.$((String)"__INT") : NativePointer.$((String)"__UINT")));
        InitPreprocessorStatics.DefineTypeSize(llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.Int.INSTANCE, TypeWidth)), (Twine)new Twine(NativePointer.$((String)"_MAX__"))), Ty, TI, Builder);
    }

    public static void DefineLeastWidthIntType(int TypeWidth, boolean IsSigned, TargetInfo TI, MacroBuilder Builder) {
        TargetInfo.IntType Ty = TI.getLeastIntTypeByWidth(TypeWidth, IsSigned);
        if (Ty == TargetInfo.IntType.NoInt) {
            return;
        }
        char.ptr Prefix = Native.$tryClone((char.ptr)(IsSigned ? NativePointer.$((String)"__INT_LEAST") : NativePointer.$((String)"__UINT_LEAST")));
        InitPreprocessorStatics.DefineType(llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.Uint.INSTANCE, (long)TypeWidth)), (Twine)new Twine(NativePointer.$((String)"_TYPE__"))), Ty, Builder);
        InitPreprocessorStatics.DefineTypeSize(llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.Uint.INSTANCE, (long)TypeWidth)), (Twine)new Twine(NativePointer.$((String)"_MAX__"))), Ty, TI, Builder);
        InitPreprocessorStatics.DefineFmt(llvm.$plus_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.Uint.INSTANCE, (long)TypeWidth)), Ty, TI, Builder);
    }

    public static void DefineFastIntType(int TypeWidth, boolean IsSigned, TargetInfo TI, MacroBuilder Builder) {
        TargetInfo.IntType Ty = TI.getLeastIntTypeByWidth(TypeWidth, IsSigned);
        if (Ty == TargetInfo.IntType.NoInt) {
            return;
        }
        char.ptr Prefix = Native.$tryClone((char.ptr)(IsSigned ? NativePointer.$((String)"__INT_FAST") : NativePointer.$((String)"__UINT_FAST")));
        InitPreprocessorStatics.DefineType(llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.Uint.INSTANCE, (long)TypeWidth)), (Twine)new Twine(NativePointer.$((String)"_TYPE__"))), Ty, Builder);
        InitPreprocessorStatics.DefineTypeSize(llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.Uint.INSTANCE, (long)TypeWidth)), (Twine)new Twine(NativePointer.$((String)"_MAX__"))), Ty, TI, Builder);
        InitPreprocessorStatics.DefineFmt(llvm.$plus_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.Uint.INSTANCE, (long)TypeWidth)), Ty, TI, Builder);
    }

    public static char.ptr getLockFreeValue(int TypeWidth, int TypeAlign, int InlineWidth) {
        if (TypeWidth == TypeAlign && (TypeWidth & TypeWidth - 1) == 0 && TypeWidth <= InlineWidth) {
            return NativePointer.$((String)"2");
        }
        return NativePointer.$((String)"1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void AddObjCXXARCLibstdcxxDefines(LangOptions LangOpts, MacroBuilder Builder) {
        std.string Result = null;
        try {
            Builder.defineMacro(new Twine(NativePointer.$((String)"_GLIBCXX_PREDEFINED_OBJC_ARC_IS_SCALAR")));
            Result = new std.string();
            raw_string_ostream Out = null;
            try {
                Out = new raw_string_ostream(Result);
                Out.$out(NativePointer.$((String)"namespace std {\n")).$out(NativePointer.$((String)"\n")).$out(NativePointer.$((String)"struct __true_type;\n")).$out(NativePointer.$((String)"struct __false_type;\n")).$out(NativePointer.$((String)"\n"));
                Out.$out(NativePointer.$((String)"template<typename _Tp> struct __is_scalar;\n")).$out(NativePointer.$((String)"\n"));
                Out.$out(NativePointer.$((String)"template<typename _Tp>\n")).$out(NativePointer.$((String)"struct __is_scalar<__attribute__((objc_ownership(strong))) _Tp> {\n")).$out(NativePointer.$((String)"  enum { __value = 0 };\n")).$out(NativePointer.$((String)"  typedef __false_type __type;\n")).$out(NativePointer.$((String)"};\n")).$out(NativePointer.$((String)"\n"));
                if (LangOpts.ObjCARCWeak) {
                    Out.$out(NativePointer.$((String)"template<typename _Tp>\n")).$out(NativePointer.$((String)"struct __is_scalar<__attribute__((objc_ownership(weak))) _Tp> {\n")).$out(NativePointer.$((String)"  enum { __value = 0 };\n")).$out(NativePointer.$((String)"  typedef __false_type __type;\n")).$out(NativePointer.$((String)"};\n")).$out(NativePointer.$((String)"\n"));
                }
                Out.$out(NativePointer.$((String)"template<typename _Tp>\n")).$out(NativePointer.$((String)"struct __is_scalar<__attribute__((objc_ownership(autoreleasing)))")).$out(NativePointer.$((String)" _Tp> {\n")).$out(NativePointer.$((String)"  enum { __value = 0 };\n")).$out(NativePointer.$((String)"  typedef __false_type __type;\n")).$out(NativePointer.$((String)"};\n")).$out(NativePointer.$((String)"\n"));
                Out.$out(NativePointer.$((String)"}\n"));
            }
            finally {
                if (Out != null) {
                    Out.$destroy();
                }
            }
            Builder.append(new Twine(Result));
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
        }
    }

    public static void InitializeStandardPredefinedMacros(TargetInfo TI, LangOptions LangOpts, FrontendOptions FEOpts, MacroBuilder Builder) {
        if (!LangOpts.MSVCCompat && !LangOpts.TraditionalCPP) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__STDC__")));
        }
        if (LangOpts.Freestanding) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__STDC_HOSTED__")), new Twine(NativePointer.$((String)"0")));
        } else {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__STDC_HOSTED__")));
        }
        if (!LangOpts.CPlusPlus) {
            if (LangOpts.C11) {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__STDC_VERSION__")), new Twine(NativePointer.$((String)"201112L")));
            } else if (LangOpts.C99) {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__STDC_VERSION__")), new Twine(NativePointer.$((String)"199901L")));
            } else if (!LangOpts.GNUMode && LangOpts.Digraphs) {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__STDC_VERSION__")), new Twine(NativePointer.$((String)"199409L")));
            }
        } else if (LangOpts.CPlusPlus1z) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cplusplus")), new Twine(NativePointer.$((String)"201406L")));
        } else if (LangOpts.CPlusPlus14) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cplusplus")), new Twine(NativePointer.$((String)"201402L")));
        } else if (LangOpts.CPlusPlus11) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cplusplus")), new Twine(NativePointer.$((String)"201103L")));
        } else {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cplusplus")), new Twine(NativePointer.$((String)"199711L")));
        }
        Builder.defineMacro(new Twine(NativePointer.$((String)"__STDC_UTF_16__")), new Twine(NativePointer.$((String)"1")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__STDC_UTF_32__")), new Twine(NativePointer.$((String)"1")));
        if (LangOpts.ObjC1) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__OBJC__")));
        }
        if (LangOpts.AsmPreprocessor) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__ASSEMBLER__")));
        }
    }

    public static void InitializeCPlusPlusFeatureTestMacros(LangOptions LangOpts, MacroBuilder Builder) {
        if (LangOpts.RTTI) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_rtti")), new Twine(NativePointer.$((String)"199711")));
        }
        if (LangOpts.CXXExceptions) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_exceptions")), new Twine(NativePointer.$((String)"199711")));
        }
        if (LangOpts.CPlusPlus11) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_unicode_characters")), new Twine(NativePointer.$((String)"200704")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_raw_strings")), new Twine(NativePointer.$((String)"200710")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_unicode_literals")), new Twine(NativePointer.$((String)"200710")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_user_defined_literals")), new Twine(NativePointer.$((String)"200809")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_lambdas")), new Twine(NativePointer.$((String)"200907")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_constexpr")), new Twine(LangOpts.CPlusPlus14 ? NativePointer.$((String)"201304") : NativePointer.$((String)"200704")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_range_based_for")), new Twine(NativePointer.$((String)"200907")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_static_assert")), new Twine(NativePointer.$((String)"200410")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_decltype")), new Twine(NativePointer.$((String)"200707")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_attributes")), new Twine(NativePointer.$((String)"200809")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_rvalue_references")), new Twine(NativePointer.$((String)"200610")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_variadic_templates")), new Twine(NativePointer.$((String)"200704")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_initializer_lists")), new Twine(NativePointer.$((String)"200806")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_delegating_constructors")), new Twine(NativePointer.$((String)"200604")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_nsdmi")), new Twine(NativePointer.$((String)"200809")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_inheriting_constructors")), new Twine(NativePointer.$((String)"200802")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_ref_qualifiers")), new Twine(NativePointer.$((String)"200710")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_alias_templates")), new Twine(NativePointer.$((String)"200704")));
        }
        if (LangOpts.CPlusPlus14) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_binary_literals")), new Twine(NativePointer.$((String)"201304")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_digit_separators")), new Twine(NativePointer.$((String)"201309")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_init_captures")), new Twine(NativePointer.$((String)"201304")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_generic_lambdas")), new Twine(NativePointer.$((String)"201304")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_decltype_auto")), new Twine(NativePointer.$((String)"201304")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_return_type_deduction")), new Twine(NativePointer.$((String)"201304")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_aggregate_nsdmi")), new Twine(NativePointer.$((String)"201304")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_variable_templates")), new Twine(NativePointer.$((String)"201304")));
        }
        if (LangOpts.SizedDeallocation) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__cpp_sized_deallocation")), new Twine(NativePointer.$((String)"201309")));
        }
    }

    public static void InitializePredefinedMacros(TargetInfo TI, LangOptions LangOpts, FrontendOptions FEOpts, MacroBuilder Builder) {
        long PIELevel;
        long PICLevel;
        Builder.defineMacro(new Twine(NativePointer.$((String)"__llvm__")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__clang__")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__clang_major__")), new Twine(NativePointer.$((String)"3")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__clang_minor__")), new Twine(NativePointer.$((String)"6")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__clang_patchlevel__")), new Twine(NativePointer.$((String)"0")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__clang_version__")), new Twine(std.$plus_str_T((std.string)std.$plus_T_str((Object)NativePointer.$((String)"\"3.6.0 "), (std.string)ClangGlobals.getClangFullRepositoryVersion()), (char.iterator)NativePointer.$((String)"\""))));
        if (!LangOpts.MSVCCompat) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GNUC_MINOR__")), new Twine(NativePointer.$((String)"2")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GNUC_PATCHLEVEL__")), new Twine(NativePointer.$((String)"1")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GNUC__")), new Twine(NativePointer.$((String)"4")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GXX_ABI_VERSION")), new Twine(NativePointer.$((String)"1002")));
        }
        Builder.defineMacro(new Twine(NativePointer.$((String)"__ATOMIC_RELAXED")), new Twine(NativePointer.$((String)"0")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__ATOMIC_CONSUME")), new Twine(NativePointer.$((String)"1")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__ATOMIC_ACQUIRE")), new Twine(NativePointer.$((String)"2")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__ATOMIC_RELEASE")), new Twine(NativePointer.$((String)"3")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__ATOMIC_ACQ_REL")), new Twine(NativePointer.$((String)"4")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__ATOMIC_SEQ_CST")), new Twine(NativePointer.$((String)"5")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__PRAGMA_REDEFINE_EXTNAME")), new Twine(NativePointer.$((String)"1")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__VERSION__")), llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)new Twine(NativePointer.$((String)"\"4.2.1 Compatible ")), (Twine)new Twine(ClangGlobals.getClangFullCPPVersion())), (Twine)new Twine(NativePointer.$((String)"\""))));
        if (!LangOpts.GNUMode && !LangOpts.MSVCCompat) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__STRICT_ANSI__")));
        }
        if (!LangOpts.MSVCCompat && LangOpts.CPlusPlus11) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GXX_EXPERIMENTAL_CXX0X__")));
        }
        if (LangOpts.ObjC1) {
            if (LangOpts.ObjCRuntime.isNonFragile()) {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__OBJC2__")));
                if (LangOpts.ObjCExceptions) {
                    Builder.defineMacro(new Twine(NativePointer.$((String)"OBJC_ZEROCOST_EXCEPTIONS")));
                }
            }
            if (LangOpts.getGC() != LangOptions.GCMode.NonGC) {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__OBJC_GC__")));
            }
            if (LangOpts.ObjCRuntime.isNeXTFamily()) {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__NEXT_RUNTIME__")));
            }
            if (LangOpts.ObjCRuntime.getKind() == ObjCRuntime.Kind.ObjFW) {
                VersionTuple tuple = new VersionTuple(LangOpts.ObjCRuntime.getVersion());
                long minor = 0L;
                if (tuple.getMinor().hasValue()) {
                    minor = tuple.getMinor().getValue();
                }
                long subminor = 0L;
                if (tuple.getSubminor().hasValue()) {
                    subminor = tuple.getSubminor().getValue();
                }
                Builder.defineMacro(new Twine(NativePointer.$((String)"__OBJFW_RUNTIME_ABI__")), new Twine(JavaDifferentiators.Uint.INSTANCE, tuple.getMajor() * 10000L + minor * 100L + subminor));
            }
            Builder.defineMacro(new Twine(NativePointer.$((String)"IBOutlet")), new Twine(NativePointer.$((String)"__attribute__((iboutlet))")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"IBOutletCollection(ClassName)")), new Twine(NativePointer.$((String)"__attribute__((iboutletcollection(ClassName)))")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"IBAction")), new Twine(NativePointer.$((String)"void)__attribute__((ibaction)")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"IBInspectable")), new Twine(NativePointer.$((String)"")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"IB_DESIGNABLE")), new Twine(NativePointer.$((String)"")));
        }
        if (LangOpts.CPlusPlus) {
            InitPreprocessorStatics.InitializeCPlusPlusFeatureTestMacros(LangOpts, Builder);
        }
        if (!LangOpts.NoConstantCFStrings) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__CONSTANT_CFSTRINGS__")));
        }
        if (LangOpts.ObjC2) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"OBJC_NEW_PROPERTIES")));
        }
        if (LangOpts.PascalStrings) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__PASCAL_STRINGS__")));
        }
        if (LangOpts.Blocks) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__block")), new Twine(NativePointer.$((String)"__attribute__((__blocks__(byref)))")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__BLOCKS__")));
        }
        if (!LangOpts.MSVCCompat && LangOpts.Exceptions) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__EXCEPTIONS")));
        }
        if (!LangOpts.MSVCCompat && LangOpts.RTTI) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GXX_RTTI")));
        }
        if (LangOpts.SjLjExceptions) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__USING_SJLJ_EXCEPTIONS__")));
        }
        if (LangOpts.Deprecated) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__DEPRECATED")));
        }
        if (!LangOpts.MSVCCompat && LangOpts.CPlusPlus) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GNUG__")), new Twine(NativePointer.$((String)"4")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GXX_WEAK__")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__private_extern__")), new Twine(NativePointer.$((String)"extern")));
        }
        if (LangOpts.MicrosoftExt && LangOpts.WChar) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"_WCHAR_T_DEFINED")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"_NATIVE_WCHAR_T_DEFINED")));
        }
        if (LangOpts.Optimize) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__OPTIMIZE__")));
        }
        if (LangOpts.OptimizeSize) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__OPTIMIZE_SIZE__")));
        }
        if (LangOpts.FastMath) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__FAST_MATH__")));
        }
        Builder.defineMacro(new Twine(NativePointer.$((String)"__ORDER_LITTLE_ENDIAN__")), new Twine(NativePointer.$((String)"1234")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__ORDER_BIG_ENDIAN__")), new Twine(NativePointer.$((String)"4321")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__ORDER_PDP_ENDIAN__")), new Twine(NativePointer.$((String)"3412")));
        if (TI.isBigEndian()) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__BYTE_ORDER__")), new Twine(NativePointer.$((String)"__ORDER_BIG_ENDIAN__")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__BIG_ENDIAN__")));
        } else {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__BYTE_ORDER__")), new Twine(NativePointer.$((String)"__ORDER_LITTLE_ENDIAN__")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__LITTLE_ENDIAN__")));
        }
        if (TI.getPointerWidth(0) == 64 && TI.getLongWidth() == 64 && TI.getIntWidth() == 32) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"_LP64")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__LP64__")));
        }
        if (TI.getPointerWidth(0) == 32 && TI.getLongWidth() == 32 && TI.getIntWidth() == 32) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"_ILP32")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__ILP32__")));
        }
        assert (TI.getCharWidth() == 8) : "Only support 8-bit char so far";
        Builder.defineMacro(new Twine(NativePointer.$((String)"__CHAR_BIT__")), new Twine(NativePointer.$((String)"8")));
        InitPreprocessorStatics.DefineTypeSize(new Twine(NativePointer.$((String)"__SCHAR_MAX__")), TargetInfo.IntType.SignedChar, TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine(NativePointer.$((String)"__SHRT_MAX__")), TargetInfo.IntType.SignedShort, TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine(NativePointer.$((String)"__INT_MAX__")), TargetInfo.IntType.SignedInt, TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine(NativePointer.$((String)"__LONG_MAX__")), TargetInfo.IntType.SignedLong, TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine(NativePointer.$((String)"__LONG_LONG_MAX__")), TargetInfo.IntType.SignedLongLong, TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine(NativePointer.$((String)"__WCHAR_MAX__")), TI.getWCharType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine(NativePointer.$((String)"__INTMAX_MAX__")), TI.getIntMaxType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine(NativePointer.$((String)"__SIZE_MAX__")), TI.getSizeType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine(NativePointer.$((String)"__UINTMAX_MAX__")), TI.getUIntMaxType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine(NativePointer.$((String)"__PTRDIFF_MAX__")), TI.getPtrDiffType(0), TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine(NativePointer.$((String)"__INTPTR_MAX__")), TI.getIntPtrType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine(NativePointer.$((String)"__UINTPTR_MAX__")), TI.getUIntPtrType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef(NativePointer.$((String)"__SIZEOF_DOUBLE__")), TI.getDoubleWidth(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef(NativePointer.$((String)"__SIZEOF_FLOAT__")), TI.getFloatWidth(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef(NativePointer.$((String)"__SIZEOF_INT__")), TI.getIntWidth(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef(NativePointer.$((String)"__SIZEOF_LONG__")), TI.getLongWidth(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef(NativePointer.$((String)"__SIZEOF_LONG_DOUBLE__")), TI.getLongDoubleWidth(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef(NativePointer.$((String)"__SIZEOF_LONG_LONG__")), TI.getLongLongWidth(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef(NativePointer.$((String)"__SIZEOF_POINTER__")), TI.getPointerWidth(0), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef(NativePointer.$((String)"__SIZEOF_SHORT__")), TI.getShortWidth(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef(NativePointer.$((String)"__SIZEOF_PTRDIFF_T__")), TI.getTypeWidth(TI.getPtrDiffType(0)), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef(NativePointer.$((String)"__SIZEOF_SIZE_T__")), TI.getTypeWidth(TI.getSizeType()), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef(NativePointer.$((String)"__SIZEOF_WCHAR_T__")), TI.getTypeWidth(TI.getWCharType()), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef(NativePointer.$((String)"__SIZEOF_WINT_T__")), TI.getTypeWidth(TI.getWIntType()), TI, Builder);
        if (TI.hasInt128Type() && TI.getTriple().getArch() != Triple.ArchType.mips64el && TI.getTriple().getArch() != Triple.ArchType.mips64) {
            InitPreprocessorStatics.DefineTypeSizeof(new StringRef(NativePointer.$((String)"__SIZEOF_INT128__")), 128L, TI, Builder);
        }
        InitPreprocessorStatics.DefineType(new Twine(NativePointer.$((String)"__INTMAX_TYPE__")), TI.getIntMaxType(), Builder);
        InitPreprocessorStatics.DefineFmt(new Twine(NativePointer.$((String)"__INTMAX")), TI.getIntMaxType(), TI, Builder);
        Builder.defineMacro(new Twine(NativePointer.$((String)"__INTMAX_C_SUFFIX__")), new Twine(TI.getTypeConstantSuffix(TI.getIntMaxType())));
        InitPreprocessorStatics.DefineType(new Twine(NativePointer.$((String)"__UINTMAX_TYPE__")), TI.getUIntMaxType(), Builder);
        InitPreprocessorStatics.DefineFmt(new Twine(NativePointer.$((String)"__UINTMAX")), TI.getUIntMaxType(), TI, Builder);
        Builder.defineMacro(new Twine(NativePointer.$((String)"__UINTMAX_C_SUFFIX__")), new Twine(TI.getTypeConstantSuffix(TI.getUIntMaxType())));
        InitPreprocessorStatics.DefineTypeWidth(new StringRef(NativePointer.$((String)"__INTMAX_WIDTH__")), TI.getIntMaxType(), TI, Builder);
        InitPreprocessorStatics.DefineType(new Twine(NativePointer.$((String)"__PTRDIFF_TYPE__")), TI.getPtrDiffType(0), Builder);
        InitPreprocessorStatics.DefineFmt(new Twine(NativePointer.$((String)"__PTRDIFF")), TI.getPtrDiffType(0), TI, Builder);
        InitPreprocessorStatics.DefineTypeWidth(new StringRef(NativePointer.$((String)"__PTRDIFF_WIDTH__")), TI.getPtrDiffType(0), TI, Builder);
        InitPreprocessorStatics.DefineType(new Twine(NativePointer.$((String)"__INTPTR_TYPE__")), TI.getIntPtrType(), Builder);
        InitPreprocessorStatics.DefineFmt(new Twine(NativePointer.$((String)"__INTPTR")), TI.getIntPtrType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeWidth(new StringRef(NativePointer.$((String)"__INTPTR_WIDTH__")), TI.getIntPtrType(), TI, Builder);
        InitPreprocessorStatics.DefineType(new Twine(NativePointer.$((String)"__SIZE_TYPE__")), TI.getSizeType(), Builder);
        InitPreprocessorStatics.DefineFmt(new Twine(NativePointer.$((String)"__SIZE")), TI.getSizeType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeWidth(new StringRef(NativePointer.$((String)"__SIZE_WIDTH__")), TI.getSizeType(), TI, Builder);
        InitPreprocessorStatics.DefineType(new Twine(NativePointer.$((String)"__WCHAR_TYPE__")), TI.getWCharType(), Builder);
        InitPreprocessorStatics.DefineTypeWidth(new StringRef(NativePointer.$((String)"__WCHAR_WIDTH__")), TI.getWCharType(), TI, Builder);
        InitPreprocessorStatics.DefineType(new Twine(NativePointer.$((String)"__WINT_TYPE__")), TI.getWIntType(), Builder);
        InitPreprocessorStatics.DefineTypeWidth(new StringRef(NativePointer.$((String)"__WINT_WIDTH__")), TI.getWIntType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeWidth(new StringRef(NativePointer.$((String)"__SIG_ATOMIC_WIDTH__")), TI.getSigAtomicType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine(NativePointer.$((String)"__SIG_ATOMIC_MAX__")), TI.getSigAtomicType(), TI, Builder);
        InitPreprocessorStatics.DefineType(new Twine(NativePointer.$((String)"__CHAR16_TYPE__")), TI.getChar16Type(), Builder);
        InitPreprocessorStatics.DefineType(new Twine(NativePointer.$((String)"__CHAR32_TYPE__")), TI.getChar32Type(), Builder);
        InitPreprocessorStatics.DefineTypeWidth(new StringRef(NativePointer.$((String)"__UINTMAX_WIDTH__")), TI.getUIntMaxType(), TI, Builder);
        InitPreprocessorStatics.DefineType(new Twine(NativePointer.$((String)"__UINTPTR_TYPE__")), TI.getUIntPtrType(), Builder);
        InitPreprocessorStatics.DefineFmt(new Twine(NativePointer.$((String)"__UINTPTR")), TI.getUIntPtrType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeWidth(new StringRef(NativePointer.$((String)"__UINTPTR_WIDTH__")), TI.getUIntPtrType(), TI, Builder);
        InitPreprocessorStatics.DefineFloatMacros(Builder, new StringRef(NativePointer.$((String)"FLT")), TI.getFloatFormat(), new StringRef(NativePointer.$((String)"F")));
        InitPreprocessorStatics.DefineFloatMacros(Builder, new StringRef(NativePointer.$((String)"DBL")), TI.getDoubleFormat(), StringRef.EMPTY);
        InitPreprocessorStatics.DefineFloatMacros(Builder, new StringRef(NativePointer.$((String)"LDBL")), TI.getLongDoubleFormat(), new StringRef(NativePointer.$((String)"L")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__POINTER_WIDTH__")), new Twine(JavaDifferentiators.Int.INSTANCE, TI.getPointerWidth(0)));
        if (!LangOpts.CharIsSigned) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__CHAR_UNSIGNED__")));
        }
        if (!TargetInfo.isTypeSigned((TargetInfo.IntType)TI.getWCharType())) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__WCHAR_UNSIGNED__")));
        }
        if (!TargetInfo.isTypeSigned((TargetInfo.IntType)TI.getWIntType())) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__WINT_UNSIGNED__")));
        }
        InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.SignedChar, TI, Builder);
        if (TI.getShortWidth() > TI.getCharWidth()) {
            InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.SignedShort, TI, Builder);
        }
        if (TI.getIntWidth() > TI.getShortWidth()) {
            InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.SignedInt, TI, Builder);
        }
        if (TI.getLongWidth() > TI.getIntWidth()) {
            InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.SignedLong, TI, Builder);
        }
        if (TI.getLongLongWidth() > TI.getLongWidth()) {
            InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.SignedLongLong, TI, Builder);
        }
        InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.UnsignedChar, TI, Builder);
        InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.UnsignedChar, TI, Builder);
        InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.SignedChar, TI, Builder);
        if (TI.getShortWidth() > TI.getCharWidth()) {
            InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.UnsignedShort, TI, Builder);
            InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.UnsignedShort, TI, Builder);
            InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.SignedShort, TI, Builder);
        }
        if (TI.getIntWidth() > TI.getShortWidth()) {
            InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.UnsignedInt, TI, Builder);
            InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.UnsignedInt, TI, Builder);
            InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.SignedInt, TI, Builder);
        }
        if (TI.getLongWidth() > TI.getIntWidth()) {
            InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.UnsignedLong, TI, Builder);
            InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.UnsignedLong, TI, Builder);
            InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.SignedLong, TI, Builder);
        }
        if (TI.getLongLongWidth() > TI.getLongWidth()) {
            InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.UnsignedLongLong, TI, Builder);
            InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.UnsignedLongLong, TI, Builder);
            InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.SignedLongLong, TI, Builder);
        }
        InitPreprocessorStatics.DefineLeastWidthIntType(8, true, TI, Builder);
        InitPreprocessorStatics.DefineLeastWidthIntType(8, false, TI, Builder);
        InitPreprocessorStatics.DefineLeastWidthIntType(16, true, TI, Builder);
        InitPreprocessorStatics.DefineLeastWidthIntType(16, false, TI, Builder);
        InitPreprocessorStatics.DefineLeastWidthIntType(32, true, TI, Builder);
        InitPreprocessorStatics.DefineLeastWidthIntType(32, false, TI, Builder);
        InitPreprocessorStatics.DefineLeastWidthIntType(64, true, TI, Builder);
        InitPreprocessorStatics.DefineLeastWidthIntType(64, false, TI, Builder);
        InitPreprocessorStatics.DefineFastIntType(8, true, TI, Builder);
        InitPreprocessorStatics.DefineFastIntType(8, false, TI, Builder);
        InitPreprocessorStatics.DefineFastIntType(16, true, TI, Builder);
        InitPreprocessorStatics.DefineFastIntType(16, false, TI, Builder);
        InitPreprocessorStatics.DefineFastIntType(32, true, TI, Builder);
        InitPreprocessorStatics.DefineFastIntType(32, false, TI, Builder);
        InitPreprocessorStatics.DefineFastIntType(64, true, TI, Builder);
        InitPreprocessorStatics.DefineFastIntType(64, false, TI, Builder);
        char.ptr Prefix = Native.$tryClone((char.ptr)TI.getUserLabelPrefix());
        if (Prefix != null) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__USER_LABEL_PREFIX__")), new Twine(Prefix));
        }
        if (LangOpts.FastMath || LangOpts.FiniteMathOnly) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__FINITE_MATH_ONLY__")), new Twine(NativePointer.$((String)"1")));
        } else {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__FINITE_MATH_ONLY__")), new Twine(NativePointer.$((String)"0")));
        }
        if (!LangOpts.MSVCCompat) {
            if (LangOpts.GNUInline) {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__GNUC_GNU_INLINE__")));
            } else {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__GNUC_STDC_INLINE__")));
            }
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GCC_ATOMIC_TEST_AND_SET_TRUEVAL")), new Twine(NativePointer.$((String)"1")));
            int InlineWidthBits = TI.getMaxAtomicInlineWidth();
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GCC_ATOMIC_BOOL_LOCK_FREE")), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getBoolWidth(), TI.getBoolAlign(), InlineWidthBits)));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GCC_ATOMIC_CHAR_LOCK_FREE")), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getCharWidth(), TI.getCharAlign(), InlineWidthBits)));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GCC_ATOMIC_CHAR16_T_LOCK_FREE")), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getChar16Width(), TI.getChar16Align(), InlineWidthBits)));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GCC_ATOMIC_CHAR32_T_LOCK_FREE")), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getChar32Width(), TI.getChar32Align(), InlineWidthBits)));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GCC_ATOMIC_WCHAR_T_LOCK_FREE")), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getWCharWidth(), TI.getWCharAlign(), InlineWidthBits)));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GCC_ATOMIC_SHORT_LOCK_FREE")), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getShortWidth(), TI.getShortAlign(), InlineWidthBits)));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GCC_ATOMIC_INT_LOCK_FREE")), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getIntWidth(), TI.getIntAlign(), InlineWidthBits)));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GCC_ATOMIC_LONG_LOCK_FREE")), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getLongWidth(), TI.getLongAlign(), InlineWidthBits)));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GCC_ATOMIC_LLONG_LOCK_FREE")), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getLongLongWidth(), TI.getLongLongAlign(), InlineWidthBits)));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GCC_ATOMIC_POINTER_LOCK_FREE")), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getPointerWidth(0), TI.getPointerAlign(0), InlineWidthBits)));
        }
        if (LangOpts.NoInlineDefine) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__NO_INLINE__")));
        }
        if ((PICLevel = (long)LangOpts.PICLevel) != 0L) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__PIC__")), new Twine(JavaDifferentiators.Uint.INSTANCE, PICLevel));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__pic__")), new Twine(JavaDifferentiators.Uint.INSTANCE, PICLevel));
        }
        if ((PIELevel = (long)LangOpts.PIELevel) != 0L) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__PIE__")), new Twine(JavaDifferentiators.Uint.INSTANCE, PIELevel));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__pie__")), new Twine(JavaDifferentiators.Uint.INSTANCE, PIELevel));
        }
        Builder.defineMacro(new Twine(NativePointer.$((String)"__FLT_EVAL_METHOD__")), new Twine(JavaDifferentiators.Uint.INSTANCE, (long)TI.getFloatEvalMethod()));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__FLT_RADIX__")), new Twine(NativePointer.$((String)"2")));
        int Dig = InitPreprocessorStatics.PickFP(TI.getLongDoubleFormat(), -1, 17, 21, 33, 36);
        Builder.defineMacro(new Twine(NativePointer.$((String)"__DECIMAL_DIG__")), new Twine(JavaDifferentiators.Int.INSTANCE, Dig));
        if (LangOpts.getStackProtector() == LangOptions.StackProtectorMode.SSPOn) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__SSP__")));
        } else if (LangOpts.getStackProtector() == LangOptions.StackProtectorMode.SSPStrong) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__SSP_STRONG__")), new Twine(NativePointer.$((String)"2")));
        } else if (LangOpts.getStackProtector() == LangOptions.StackProtectorMode.SSPReq) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__SSP_ALL__")), new Twine(NativePointer.$((String)"3")));
        }
        if (FEOpts.ProgramAction == frontend.ActionKind.RewriteObjC) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__weak")), new Twine(NativePointer.$((String)"__attribute__((objc_gc(weak)))")));
        }
        if (FEOpts.ProgramAction == frontend.ActionKind.RunAnalysis) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__clang_analyzer__")));
        }
        if (LangOpts.FastRelaxedMath) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__FAST_RELAXED_MATH__")));
        }
        if (LangOpts.ObjCAutoRefCount) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__weak")), new Twine(NativePointer.$((String)"__attribute__((objc_ownership(weak)))")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__strong")), new Twine(NativePointer.$((String)"__attribute__((objc_ownership(strong)))")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__autoreleasing")), new Twine(NativePointer.$((String)"__attribute__((objc_ownership(autoreleasing)))")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__unsafe_unretained")), new Twine(NativePointer.$((String)"__attribute__((objc_ownership(none)))")));
        }
        if (LangOpts.OpenMP) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"_OPENMP")), new Twine(NativePointer.$((String)"201307")));
        }
        if (LangOpts.CUDAIsDevice) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__CUDA_ARCH__")));
        }
        TI.getTargetDefines(LangOpts, Builder);
    }
}

