/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend.impl;

import java.util.Comparator;
import org.clang.basic.ClangGlobals;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.SourceLocation;
import org.clang.frontend.impl.PrintPPOutputHelper;
import org.clang.frontend.impl.PrintPPOutputPPCallbacks;
import org.clang.lex.MacroDirective;
import org.clang.lex.MacroInfo;
import org.clang.lex.Preprocessor;
import org.clang.lex.SmallVectorToken;
import org.clang.lex.Token;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringMapEntryBase;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public final class PrintPreprocessedOutputStatics {
    private static final Comparator<std.pair<IdentifierInfo, MacroInfo>> MacroIDCompareCallback = new Comparator<std.pair<IdentifierInfo, MacroInfo>>(){

        @Override
        public int compare(std.pair<IdentifierInfo, MacroInfo> o1, std.pair<IdentifierInfo, MacroInfo> o2) {
            return PrintPreprocessedOutputStatics.MacroIDCompare(o1, o2);
        }
    };

    public static void PrintMacroDefinition(IdentifierInfo II, MacroInfo MI, Preprocessor PP, raw_ostream OS) {
        OS.$out((CharSequence)"#define ").$out(II.getName());
        if (MI.isFunctionLike()) {
            OS.$out('(');
            if (!MI.arg_empty()) {
                IdentifierInfo[] ArgumentList = MI.$ArgumentList();
                int AI = 0;
                int E = MI.getNumArgs();
                while (AI + 1 != E) {
                    OS.$out(ArgumentList[AI].getName());
                    OS.$out(',');
                    ++AI;
                }
                if (llvm.$eq_StringRef((StringRef)ArgumentList[AI].getName(), (StringRef)StringRef.__VA_ARGS__)) {
                    OS.$out((CharSequence)"...");
                } else {
                    OS.$out(ArgumentList[AI].getName());
                }
            }
            if (MI.isGNUVarargs()) {
                OS.$out((CharSequence)"...");
            }
            OS.$out(')');
        }
        if (MI.tokens_empty() || !MI.tokens_begin().$star().hasLeadingSpace()) {
            OS.$out(NativePointer.$SPACE);
        }
        SmallString SpellingBuffer = new SmallString(128);
        SmallVectorToken.iterator I = (SmallVectorToken.iterator)Native.$tryClone((NativeCloneable)MI.tokens_begin());
        SmallVectorToken.iterator E = (SmallVectorToken.iterator)Native.$tryClone((NativeCloneable)MI.tokens_end());
        while (I.$noteq((Object)E)) {
            if (I.$star().hasLeadingSpace()) {
                OS.$out(NativePointer.$SPACE);
            }
            OS.$out(PP.getSpelling(I.$star(), SpellingBuffer));
            I.$preInc();
        }
    }

    public static void outputPrintable(raw_ostream OS, std.string Str) {
        int e = Str.size();
        for (int i = 0; i != e; ++i) {
            byte Char2 = Str.$at(i);
            if (ClangGlobals.isPrintable((byte)Char2) && Char2 != NativePointer.$SLASH && Char2 != NativePointer.$DBL_QUOTE) {
                OS.$out(Char2);
                continue;
            }
            OS.$out(NativePointer.$SLASH).$out((byte)(NativePointer.$0 + (Char2 >> 6 & 7))).$out((byte)(NativePointer.$0 + (Char2 >> 3 & 7))).$out((byte)(NativePointer.$0 + (Char2 >> 0 & 7)));
        }
    }

    public static void PrintPreprocessedTokens(Preprocessor PP, Token Tok, PrintPPOutputPPCallbacks Callbacks, raw_ostream OS) {
        boolean DropComments = PP.getLangOpts().TraditionalCPP && !PP.getCommentRetentionState();
        PrintPPOutputHelper $Helper = Callbacks.$getPrintPPOutputHelper();
        Token PrevPrevTok = $Helper.$PrevPrevTok();
        Token PrevTok = $Helper.$PrevTok();
        PrevPrevTok.startToken();
        PrevTok.startToken();
        while (true) {
            if (Callbacks.hasEmittedDirectiveOnThisLine()) {
                Callbacks.startNewLineIfNeeded();
                Callbacks.MoveToLine(Tok.getRawLocation());
            }
            if ((!Tok.isAtStartOfLine() || !Callbacks.HandleFirstTokOnLine(Tok)) && (Tok.hasLeadingSpace() || Callbacks.hasEmittedTokensOnThisLine() && Callbacks.AvoidConcat(PrevPrevTok, PrevTok, Tok))) {
                OS.$out(NativePointer.$SPACE);
            }
            if (DropComments && Tok.is((short)4)) {
                int StartLoc = Tok.getRawLocation();
                Callbacks.MoveToLine(SourceLocation.getRawLocWithOffset((int)StartLoc, (int)Tok.getLength()));
            } else {
                if (Tok.is((short)318) || Tok.is((short)319) || Tok.is((short)320)) {
                    PP.Lex(Tok);
                    continue;
                }
                IdentifierInfo II = Tok.getIdentifierInfo();
                if (II != null) {
                    StringMapEntryBase entry = II.getEntry();
                    assert (entry != null);
                    OS.write(entry.getKeyArray(), (long)entry.getKeyArrayIndex(), (long)entry.getKeyLength());
                } else if (Tok.isLiteral() && !Tok.needsCleaning() && Tok.$CharPtrData() != null) {
                    OS.write(Tok.$CharPtrData(), (long)Tok.$CharPtrDataIndex(), (long)Tok.getLength());
                } else if (Tok.isLiteral() && !Tok.needsCleaning() && Tok.getLiteralData() != null) {
                    OS.write(Tok.getLiteralData(), (long)Tok.getLength());
                } else if (Tok.getLength() < 256) {
                    char.ptr TokPtr = $Helper.$CharBufPtr();
                    long Len = PP.getSpelling(Tok, TokPtr);
                    OS.write(TokPtr, Len);
                    if (Tok.getKind() == 4 || Tok.getKind() == 0) {
                        Callbacks.HandleNewlinesInToken(TokPtr, Len);
                    }
                    $Helper.$reset$CharBufPtr();
                } else {
                    std.string S = PP.getSpelling(Tok);
                    OS.write(S.data(), (long)S.size());
                    if (Tok.getKind() == 4 || Tok.getKind() == 0) {
                        Callbacks.HandleNewlinesInToken(S.data(), S.size());
                    }
                }
            }
            Callbacks.setEmittedTokensOnThisLine();
            if (Tok.is((short)1)) break;
            PrevPrevTok.$assign(PrevTok);
            PrevTok.$assign(Tok);
            PP.Lex(Tok);
        }
        Callbacks.$releasePrintPPOutputHelper($Helper);
    }

    public static int MacroIDCompare(std.pair<IdentifierInfo, MacroInfo> LHS, std.pair<IdentifierInfo, MacroInfo> RHS) {
        return ((IdentifierInfo)LHS.first).getName().compare(((IdentifierInfo)RHS.first).getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DoPrintMacros(Preprocessor PP, raw_ostream OS) {
        SmallVector MacrosByID = null;
        try {
            PP.IgnorePragmas();
            PP.EnterMainSourceFile();
            Token Tok = new Token();
            do {
                PP.Lex(Tok);
            } while (Tok.isNot((short)1));
            MacrosByID = new SmallVector(128, (Object)new std.pair());
            DenseMapIterator I = (DenseMapIterator)Native.$tryClone((NativeCloneable)PP.macro_begin());
            DenseMapIterator E = (DenseMapIterator)Native.$tryClone((NativeCloneable)PP.macro_end());
            while (I.$noteq(E)) {
                if (((IdentifierInfo)I.$star().first).hasMacroDefinition()) {
                    MacrosByID.push_back((Object)new std.pair(I.$star().first, (Object)((MacroDirective)I.$star().second).getMacroInfo()));
                }
                I.$preInc();
            }
            llvm.array_pod_sort((type.ptr)MacrosByID.begin().toPointer(), (type.ptr)MacrosByID.end().toPointer(), MacroIDCompareCallback);
            long e = MacrosByID.size();
            for (long i = 0L; i != e; ++i) {
                MacroInfo MI = (MacroInfo)((std.pair)MacrosByID.$at((long)i)).second;
                if (MI.isBuiltinMacro()) continue;
                PrintPreprocessedOutputStatics.PrintMacroDefinition((IdentifierInfo)((std.pair)MacrosByID.$at((long)i)).first, MI, PP, OS);
                OS.$out(NativePointer.$LF);
            }
        }
        finally {
            if (MacrosByID != null) {
                MacrosByID.$destroy();
            }
        }
    }
}

