/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.annotate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.remote.FileInformation;
import org.netbeans.modules.mercurial.remote.FileStatus;
import org.netbeans.modules.mercurial.remote.FileStatusCache;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.annotate.AnnotateLine;
import org.netbeans.modules.mercurial.remote.ui.annotate.AnnotationBar;
import org.netbeans.modules.mercurial.remote.ui.annotate.AnnotationBarManager;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class AnnotateAction
extends ContextAction {
    public static final String ICON_RESOURCE = "org/netbeans/modules/mercurial/remote/resources/icons/annotate.png";

    public AnnotateAction() {
        super(ICON_RESOURCE);
    }

    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        if (!HgUtils.isFromHgRepository(context)) {
            return false;
        }
        if (context.getRootFiles().size() > 0 && this.activatedEditorCookie(nodes) != null) {
            FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
            VCSFileProxy file = this.activatedFile(nodes);
            if (file == null) {
                return false;
            }
            FileInformation info = cache.getCachedStatus(file);
            if (info != null) {
                int status = info.getStatus();
                return status != 4 && status != 2;
            }
            return true;
        }
        return false;
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return this.visible(nodes) ? "CTL_MenuItem_HideAnnotations" : "CTL_MenuItem_ShowAnnotations";
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        if (this.visible(nodes)) {
            JEditorPane pane = this.activatedEditorPane(nodes);
            AnnotationBarManager.hideAnnotationBar(pane);
        } else {
            EditorCookie ec = this.activatedEditorCookie(nodes);
            if (ec == null) {
                return;
            }
            VCSFileProxy file = this.activatedFile(nodes);
            JEditorPane[] panes = ec.getOpenedPanes();
            if (panes == null) {
                ec.open();
                panes = ec.getOpenedPanes();
            }
            if (panes == null) {
                return;
            }
            JEditorPane currentPane = panes[0];
            AnnotateAction.showAnnotations(currentPane, file, null, true);
        }
    }

    public static void showAnnotations(JEditorPane currentPane, VCSFileProxy file, String revision) {
        AnnotateAction.showAnnotations(currentPane, file, revision, true);
    }

    static void showAnnotations(JEditorPane currentPane, final VCSFileProxy file, final String revision, boolean requestActive) {
        if (currentPane == null || file == null) {
            return;
        }
        if (requestActive) {
            TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, currentPane);
            tc.requestActive();
        }
        final AnnotationBar ab = AnnotationBarManager.showAnnotationBar(currentPane);
        ab.setAnnotationMessage(NbBundle.getMessage(AnnotateAction.class, (String)"CTL_AnnotationSubstitute"));
        final VCSFileProxy repository = Mercurial.getInstance().getRepositoryRoot(file);
        if (repository == null) {
            return;
        }
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                VCSFileProxy annotatedFile = file;
                FileStatus st = Mercurial.getInstance().getFileStatusCache().getStatus(file).getStatus(null);
                if (st != null && st.isCopied() && st.getOriginalFile() != null) {
                    annotatedFile = st.getOriginalFile();
                    ab.setReferencedFile(annotatedFile);
                }
                if (revision != null) {
                    ab.setReferencedFile(annotatedFile);
                }
                OutputLogger logger = this.getLogger();
                logger.outputInRed(NbBundle.getMessage(AnnotateAction.class, (String)"MSG_ANNOTATE_TITLE"));
                logger.outputInRed(NbBundle.getMessage(AnnotateAction.class, (String)"MSG_ANNOTATE_TITLE_SEP"));
                AnnotateAction.computeAnnotations(repository, annotatedFile, this, ab, revision);
                logger.output("\t" + file.getPath());
                logger.outputInRed(NbBundle.getMessage(AnnotateAction.class, (String)"MSG_ANNOTATE_DONE"));
            }
        };
        support.start(rp, repository, NbBundle.getMessage(AnnotateAction.class, (String)"MSG_Annotation_Progress"));
    }

    private static void computeAnnotations(VCSFileProxy repository, VCSFileProxy file, HgProgressSupport progress, AnnotationBar ab, String revision) {
        List<String> list = null;
        try {
            list = HgCommand.doAnnotate(repository, file, revision, progress.getLogger());
        }
        catch (HgException.HgCommandCanceledException ex) {
        }
        catch (HgException ex) {
            HgUtils.notifyException(ex);
        }
        if (progress.isCanceled()) {
            ab.setAnnotationMessage(NbBundle.getMessage(AnnotateAction.class, (String)"CTL_AnnotationFailed"));
            return;
        }
        if (list == null) {
            ab.setAnnotationMessage(NbBundle.getMessage(AnnotateAction.class, (String)"CTL_AnnotationFailed"));
            return;
        }
        AnnotateLine[] lines = AnnotateAction.toAnnotateLines(list);
        List<String> revisions = AnnotateAction.getRevisionNumbers(lines);
        HgLogMessage initialRevision = null;
        HgLogMessage[] logs = new HgLogMessage[]{};
        if (!revisions.isEmpty()) {
            logs = HgCommand.getLogMessages(repository, Collections.singleton(file), revisions.get(0), "0", false, false, false, 1, Collections.emptyList(), OutputLogger.getLogger(null), true);
            if (logs.length == 1) {
                initialRevision = logs[0];
            }
            logs = HgCommand.getRevisionInfo(repository, revisions, progress.getLogger());
        }
        if (progress.isCanceled()) {
            return;
        }
        if (logs == null) {
            return;
        }
        AnnotateAction.fillCommitMessages(lines, logs, initialRevision);
        ab.setAnnotatedRevision(revision);
        ab.annotationLines(file, Arrays.asList(lines));
    }

    private static List<String> getRevisionNumbers(AnnotateLine[] lines) {
        HashSet<String> revisions = new HashSet<String>(lines.length);
        for (AnnotateLine line : lines) {
            if (line instanceof FakeAnnotationLine) continue;
            String revision = line.getRevision();
            try {
                Long.parseLong(revision);
                revisions.add(revision);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        ArrayList<String> retval = new ArrayList<String>(revisions);
        Collections.sort(retval);
        return retval;
    }

    private static void fillCommitMessages(AnnotateLine[] annotations, HgLogMessage[] logs, HgLogMessage initialRevision) {
        for (int i = 0; i < annotations.length; ++i) {
            AnnotateLine annotation = annotations[i];
            if (annotation == null) {
                Mercurial.LOG.log(Level.WARNING, "AnnotateAction: annotation {0} of {1} is null", new Object[]{i, annotations.length});
                continue;
            }
            for (int j = 0; j < logs.length; ++j) {
                HgLogMessage log = logs[j];
                if (log == null) {
                    Mercurial.LOG.log(Level.WARNING, "AnnotateAction: log {0} of {1} is null", new Object[]{j, logs.length});
                    continue;
                }
                if (!annotation.getRevision().equals(log.getRevisionNumber())) continue;
                annotation.setDate(log.getDate());
                annotation.setId(log.getCSetShortID());
                annotation.setCommitMessage(log.getMessage());
            }
        }
        String lowestRev = initialRevision == null ? "-1" : initialRevision.getRevisionNumber();
        for (int i = 0; i < annotations.length; ++i) {
            AnnotateLine annotation = annotations[i];
            if (annotation == null) {
                Mercurial.LOG.log(Level.WARNING, "AnnotateAction: annotation {0} of {1} is null", new Object[]{i, annotations.length});
                continue;
            }
            annotation.setCanBeRolledBack(!annotation.getRevision().equals(lowestRev));
        }
    }

    private static AnnotateLine[] toAnnotateLines(List<String> annotations) {
        boolean GROUP_AUTHOR = true;
        int GROUP_REVISION = 2;
        int GROUP_FILENAME = 3;
        int GROUP_LINE_NUMBER = 4;
        int GROUP_CONTENT = 5;
        ArrayList<AnnotateLine> lines = new ArrayList<AnnotateLine>();
        int i = 0;
        Pattern p = Pattern.compile("^\\s*(\\S+\\b)\\s+(\\d+)\\s+(\\b\\S*):\\s*(\\d+):\\s(.*)$");
        for (String line : annotations) {
            AnnotateLine anLine;
            ++i;
            Matcher m = p.matcher(line);
            if (!m.matches()) {
                Mercurial.LOG.log(Level.WARNING, "AnnotateAction: toAnnotateLines(): Failed when matching: {0}", new Object[]{line});
                anLine = new FakeAnnotationLine();
            } else {
                anLine = new AnnotateLine();
                anLine.setAuthor(m.group(1));
                anLine.setRevision(m.group(2));
                anLine.setFileName(m.group(3));
                try {
                    anLine.setPrevLineNum(Integer.parseInt(m.group(4)));
                }
                catch (NumberFormatException ex) {
                    anLine.setPrevLineNum(-1);
                }
                anLine.setContent(m.group(5));
            }
            anLine.setLineNum(i);
            lines.add(anLine);
        }
        return lines.toArray(new AnnotateLine[lines.size()]);
    }

    public boolean visible(Node[] nodes) {
        JEditorPane currentPane = this.activatedEditorPane(nodes);
        return AnnotationBarManager.annotationBarVisible(currentPane);
    }

    private JEditorPane activatedEditorPane(Node[] nodes) {
        final EditorCookie ec = this.activatedEditorCookie(nodes);
        if (ec != null) {
            return (JEditorPane)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<JEditorPane>(){

                public JEditorPane run() {
                    return NbDocument.findRecentEditorPane((EditorCookie)ec);
                }
            });
        }
        return null;
    }

    private EditorCookie activatedEditorCookie(Node[] nodes) {
        if (nodes == null) {
            nodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
        }
        if (nodes.length == 1) {
            Node node = nodes[0];
            return (EditorCookie)node.getLookup().lookup(EditorCookie.class);
        }
        return null;
    }

    private VCSFileProxy activatedFile(Node[] nodes) {
        Node node;
        DataObject dobj;
        if (nodes.length == 1 && (dobj = (DataObject)(node = nodes[0]).getLookup().lookup(DataObject.class)) != null) {
            FileObject fo = dobj.getPrimaryFile();
            return VCSFileProxy.createFileProxy((FileObject)fo);
        }
        return null;
    }

    private static class FakeAnnotationLine
    extends AnnotateLine {
        public FakeAnnotationLine() {
            String fakeItem = NbBundle.getMessage(AnnotateAction.class, (String)"MSG_AnnotateAction.lineDetail.unknown");
            this.setAuthor(fakeItem);
            this.setContent(fakeItem);
            this.setRevision(fakeItem);
            this.setFileName(fakeItem);
        }
    }
}

