/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.commit;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.mercurial.remote.FileInformation;
import org.netbeans.modules.mercurial.remote.HgFileNode;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.ui.commit.CommitOptions;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.NbBundle;

public class CommitTableModel
extends AbstractTableModel {
    public static final String COLUMN_NAME_COMMIT = "commit";
    public static final String COLUMN_NAME_NAME = "name";
    public static final String COLUMN_NAME_STATUS = "status";
    public static final String COLUMN_NAME_ACTION = "action";
    public static final String COLUMN_NAME_PATH = "path";
    public static final String COLUMN_NAME_BRANCH = "branch";
    private RootFile rootFile;
    private static final Map<String, String[]> columnLabels = new HashMap<String, String[]>(4);
    private CommitOptions[] commitOptions;
    private HgFileNode[] nodes;
    private String[] columns;
    private final VCSFileProxy repository;

    public CommitTableModel(VCSFileProxy repository, String[] columns) {
        ResourceBundle loc = NbBundle.getBundle(CommitTableModel.class);
        columnLabels.put(COLUMN_NAME_COMMIT, new String[]{loc.getString("CTL_CommitTable_Column_Commit"), loc.getString("CTL_CommitTable_Column_Description")});
        columnLabels.put(COLUMN_NAME_NAME, new String[]{loc.getString("CTL_CommitTable_Column_File"), loc.getString("CTL_CommitTable_Column_File")});
        columnLabels.put(COLUMN_NAME_BRANCH, new String[]{loc.getString("CTL_CommitTable_Column_Branch"), loc.getString("CTL_CommitTable_Column_Branch")});
        columnLabels.put(COLUMN_NAME_STATUS, new String[]{loc.getString("CTL_CommitTable_Column_Status"), loc.getString("CTL_CommitTable_Column_Status")});
        columnLabels.put(COLUMN_NAME_ACTION, new String[]{loc.getString("CTL_CommitTable_Column_Action"), loc.getString("CTL_CommitTable_Column_Action")});
        columnLabels.put(COLUMN_NAME_PATH, new String[]{loc.getString("CTL_CommitTable_Column_Folder"), loc.getString("CTL_CommitTable_Column_Folder")});
        this.repository = repository;
        this.setColumns(columns);
        this.setNodes(new HgFileNode[0]);
    }

    void setNodes(HgFileNode[] nodes) {
        this.nodes = nodes;
        this.commitOptions = HgUtils.createDefaultCommitOptions(nodes, HgModuleConfig.getDefault(this.repository).getExludeNewFiles());
        this.fireTableDataChanged();
    }

    void setColumns(String[] cols) {
        if (Arrays.equals(cols, this.columns)) {
            return;
        }
        this.columns = cols;
        this.fireTableStructureChanged();
    }

    public Map<HgFileNode, CommitOptions> getCommitFiles() {
        HashMap<HgFileNode, CommitOptions> ret = new HashMap<HgFileNode, CommitOptions>(this.nodes.length);
        for (int i = 0; i < this.nodes.length; ++i) {
            ret.put(this.nodes[i], this.commitOptions[i]);
        }
        return ret;
    }

    @Override
    public String getColumnName(int column) {
        return columnLabels.get(this.columns[column])[0];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public int getRowCount() {
        return this.nodes.length;
    }

    public Class getColumnClass(int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals(COLUMN_NAME_COMMIT)) {
            return Boolean.class;
        }
        if (col.equals(COLUMN_NAME_ACTION)) {
            return CommitOptions.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        return col.equals(COLUMN_NAME_COMMIT);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals(COLUMN_NAME_COMMIT)) {
            return this.commitOptions[rowIndex] != CommitOptions.EXCLUDE;
        }
        if (col.equals(COLUMN_NAME_NAME)) {
            return this.nodes[rowIndex].getName();
        }
        if (col.equals(COLUMN_NAME_STATUS)) {
            HgFileNode node = this.nodes[rowIndex];
            FileInformation finfo = node.getInformation();
            return finfo.getStatusText();
        }
        if (col.equals(COLUMN_NAME_ACTION)) {
            return this.commitOptions[rowIndex];
        }
        if (col.equals(COLUMN_NAME_PATH)) {
            String shortPath = null;
            if (this.rootFile != null) {
                shortPath = this.rootFile.repositoryPath;
            } else {
                shortPath = HgUtils.getRelativePath(this.nodes[rowIndex].getFile());
                if (shortPath == null) {
                    shortPath = NbBundle.getMessage(CommitTableModel.class, (String)"CTL_CommitForm_NotInRepository");
                }
            }
            return shortPath;
        }
        throw new IllegalArgumentException("Column index out of range: " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals(COLUMN_NAME_ACTION)) {
            this.commitOptions[rowIndex] = (CommitOptions)aValue;
        } else if (col.equals(COLUMN_NAME_COMMIT)) {
            this.commitOptions[rowIndex] = (Boolean)aValue != false ? this.getCommitOptions(rowIndex) : CommitOptions.EXCLUDE;
        } else {
            throw new IllegalArgumentException("Column index out of range: " + columnIndex);
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public HgFileNode getNode(int row) {
        return this.nodes[row];
    }

    public CommitOptions getOptions(int row) {
        return this.commitOptions[row];
    }

    void setRootFile(String repositoryPath, String rootLocalPath) {
        this.rootFile = new RootFile();
        this.rootFile.repositoryPath = repositoryPath;
        this.rootFile.rootLocalPath = rootLocalPath;
    }

    void setIncluded(int[] rows, boolean include) {
        for (int rowIndex : rows) {
            this.commitOptions[rowIndex] = include ? this.getCommitOptions(rowIndex) : CommitOptions.EXCLUDE;
        }
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    private CommitOptions getCommitOptions(int rowIndex) {
        HgFileNode node = this.nodes[rowIndex];
        FileInformation finfo = node.getInformation();
        return (finfo.getStatus() & 0x900) == 0 ? CommitOptions.COMMIT : CommitOptions.COMMIT_REMOVE;
    }

    private static class RootFile {
        String repositoryPath;
        String rootLocalPath;

        private RootFile() {
        }
    }
}

