/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.diff;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.VersionsCache;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class DiffStreamSource
extends StreamSource {
    private final VCSFileProxy baseFile;
    private final HgLogMessage.HgRevision revision;
    private final String title;
    private String mimeType;
    private Boolean start;
    private VCSFileProxy remoteFile;
    private Boolean canWriteBaseFile;
    private final VCSFileProxy fileInRevision;
    private VCSFileProxy encodingHolder;

    public DiffStreamSource(VCSFileProxy fileInRevision, VCSFileProxy baseFile, HgLogMessage.HgRevision revision, String title) {
        this.baseFile = VCSFileProxySupport.isMac((VCSFileProxy)baseFile) ? baseFile.normalizeFile() : baseFile;
        this.fileInRevision = fileInRevision;
        this.revision = revision;
        this.title = title;
        this.start = true;
    }

    public DiffStreamSource(String title) {
        this.baseFile = null;
        this.fileInRevision = null;
        this.revision = null;
        this.title = title;
        this.start = true;
    }

    public String getName() {
        if (this.baseFile != null) {
            return this.baseFile.getName();
        }
        return NbBundle.getMessage(DiffStreamSource.class, (String)"LBL_Diff_Anonymous");
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized String getMIMEType() {
        if (this.baseFile.isDirectory()) {
            return "content/unknown";
        }
        try {
            this.init();
        }
        catch (IOException e) {
            return null;
        }
        return this.mimeType;
    }

    public synchronized Reader createReader() throws IOException {
        if (this.baseFile.isDirectory()) {
            return new StringReader(NbBundle.getMessage(DiffStreamSource.class, (String)"LBL_Diff_NoFolderDiff"));
        }
        this.init();
        if (this.revision == null || this.remoteFile == null) {
            return null;
        }
        if (!this.mimeType.startsWith("text/")) {
            return null;
        }
        return Utils.createReader((FileObject)this.remoteFile.toFileObject());
    }

    public Writer createWriter(Difference[] conflicts) throws IOException {
        throw new IOException("Operation not supported");
    }

    public boolean isEditable() {
        return HgLogMessage.HgRevision.CURRENT.equals(this.revision) && this.isPrimary() && this.isBaseFileWritable();
    }

    private boolean isBaseFileWritable() {
        if (this.canWriteBaseFile == null) {
            FileObject fo = this.baseFile.toFileObject();
            this.canWriteBaseFile = fo != null && fo.canWrite();
        }
        return this.canWriteBaseFile;
    }

    private boolean isPrimary() {
        FileObject fo = this.baseFile.toFileObject();
        if (fo != null) {
            try {
                DataObject dao = DataObject.find((FileObject)fo);
                return fo.equals(dao.getPrimaryFile());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    public synchronized Lookup getLookup() {
        try {
            this.init();
        }
        catch (IOException e) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        if (this.remoteFile == null || !this.isPrimary()) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        FileObject remoteFo = this.remoteFile.toFileObject();
        if (remoteFo == null) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        return Lookups.fixed((Object[])new Object[]{remoteFo});
    }

    public void close() {
        if (this.start.booleanValue()) {
            return;
        }
        EditorCookie.Observable ec = DiffStreamSource.getEditableCookie(this.remoteFile);
        if (ec != null && ec.getOpenedPanes() == null && !ec.isModified()) {
            ec.close();
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void init() throws IOException {
        if (this.baseFile.isDirectory()) {
            return;
        }
        if (!this.start.booleanValue()) {
            return;
        }
        this.start = false;
        if (this.remoteFile != null || this.revision == null) {
            return;
        }
        this.mimeType = Mercurial.getInstance().getMimeType(this.baseFile);
        try {
            if (this.isEditable()) {
                this.remoteFile = VersionsCache.getInstance().getFileRevision(this.baseFile, this.revision);
            } else {
                VCSFileProxy tempFolder = VCSFileProxySupport.getTempFolder((VCSFileProxy)this.baseFile, (boolean)true);
                Set allFiles = VCSFileProxySupport.getAllDataObjectFiles((VCSFileProxy)this.baseFile);
                HashMap<VCSFileProxy, VCSFileProxy> allFilePairs = new HashMap<VCSFileProxy, VCSFileProxy>(allFiles.size());
                boolean renamed = !this.baseFile.equals((Object)this.fileInRevision);
                for (VCSFileProxy vCSFileProxy : allFiles) {
                    if (renamed) {
                        allFilePairs.put(this.renameFile(vCSFileProxy, this.baseFile, this.fileInRevision), vCSFileProxy);
                        continue;
                    }
                    allFilePairs.put(vCSFileProxy, vCSFileProxy);
                }
                for (Map.Entry entry : allFilePairs.entrySet()) {
                    VCSFileProxy file = (VCSFileProxy)entry.getKey();
                    VCSFileProxy currentPair = (VCSFileProxy)entry.getValue();
                    boolean isBase = file.equals((Object)this.fileInRevision);
                    try {
                        VCSFileProxy rf = VersionsCache.getInstance().getFileRevision(file, this.revision);
                        if (rf == null || !rf.exists()) {
                            this.remoteFile = null;
                            return;
                        }
                        VCSFileProxy newRemoteFile = VCSFileProxy.createFileProxy((VCSFileProxy)tempFolder, (String)file.getName());
                        Utils.copyStreamsCloseAll((OutputStream)VCSFileProxySupport.getOutputStream((VCSFileProxy)newRemoteFile), (InputStream)rf.getInputStream(false));
                        VCSFileProxySupport.deleteOnExit((VCSFileProxy)newRemoteFile);
                        if (!isBase) continue;
                        this.remoteFile = newRemoteFile;
                        this.encodingHolder = currentPair;
                        if (this.encodingHolder.exists()) {
                            VCSFileProxySupport.associateEncoding((VCSFileProxy)this.encodingHolder, (VCSFileProxy)newRemoteFile);
                            continue;
                        }
                        if (this.remoteFile == null) continue;
                        boolean created = false;
                        try {
                            if (!this.encodingHolder.getParentFile().exists()) continue;
                            created = VCSFileProxySupport.createNew((VCSFileProxy)this.encodingHolder);
                            VCSFileProxySupport.associateEncoding((VCSFileProxy)this.encodingHolder, (VCSFileProxy)newRemoteFile);
                        }
                        catch (IOException ex) {}
                        continue;
                        finally {
                            if (!created) continue;
                            VCSFileProxySupport.delete((VCSFileProxy)this.encodingHolder);
                        }
                    }
                    catch (Exception e) {
                        if (!isBase) continue;
                        throw e;
                    }
                }
            }
            if (!this.baseFile.exists() && this.remoteFile != null && this.remoteFile.exists()) {
                this.mimeType = Mercurial.getInstance().getMimeType(this.remoteFile);
            }
        }
        catch (Exception e) {
            throw new IOException("Can not load remote file for " + this.baseFile, e);
        }
    }

    private static EditorCookie.Observable getEditableCookie(VCSFileProxy file) {
        EditorCookie.Observable editorCookie = null;
        if (file == null) {
            return null;
        }
        FileObject fileObj = file.toFileObject();
        if (fileObj != null) {
            try {
                EditorCookie cookie;
                DataObject dao = DataObject.find((FileObject)fileObj);
                if (dao instanceof MultiDataObject) {
                    MultiDataObject mdao = (MultiDataObject)dao;
                    for (MultiDataObject.Entry entry : mdao.secondaryEntries()) {
                        CookieSet.Factory factory;
                        EditorCookie ec;
                        if (fileObj != entry.getFile() || !(entry instanceof CookieSet.Factory) || !((ec = (EditorCookie)(factory = (CookieSet.Factory)entry).createCookie(EditorCookie.class)) instanceof EditorCookie.Observable)) continue;
                        editorCookie = (EditorCookie.Observable)ec;
                    }
                }
                if (editorCookie == null && (cookie = (EditorCookie)dao.getLookup().lookup(EditorCookie.class)) instanceof EditorCookie.Observable) {
                    editorCookie = (EditorCookie.Observable)cookie;
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return editorCookie;
    }

    private VCSFileProxy renameFile(VCSFileProxy toRename, VCSFileProxy baseFile, VCSFileProxy renamedBaseFile) {
        String toRenameFileName;
        VCSFileProxy parent = renamedBaseFile.getParentFile();
        String baseFileName = baseFile.getName();
        String renamedFileName = renamedBaseFile.getName();
        String retval = toRenameFileName = toRename.getName();
        if (!renamedFileName.equals(baseFileName)) {
            String baseNameNoExt = this.getFileNameNoExt(baseFileName);
            String renamedNameNoExt = this.getFileNameNoExt(renamedFileName);
            if (toRenameFileName.startsWith(baseNameNoExt)) {
                retval = renamedNameNoExt;
                if (toRenameFileName.length() > baseNameNoExt.length()) {
                    retval = retval + toRenameFileName.substring(baseNameNoExt.length());
                }
            }
        }
        return VCSFileProxy.createFileProxy((VCSFileProxy)parent, (String)retval);
    }

    private String getFileNameNoExt(String fileName) {
        int pos = fileName.lastIndexOf(46);
        if (pos != -1) {
            return fileName.substring(0, pos);
        }
        return fileName;
    }
}

