/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.diff;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.ui.merge.MergeAction;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ImportDiffAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_ImportDiff";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        ImportDiffAction.importDiff(context);
    }

    private static void importDiff(VCSContext ctx) {
        VCSFileProxy[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        final VCSFileProxy root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        VCSFileProxy oldFolder = VCSFileProxySupport.getResource((VCSFileProxy)root, (String)HgModuleConfig.getDefault(root).getImportFolder());
        final JFileChooser fileChooser = VCSFileProxySupport.createFileChooser((VCSFileProxy)oldFolder);
        fileChooser.setDialogTitle(NbBundle.getMessage(ImportDiffAction.class, (String)"ImportBrowse_title"));
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogType(0);
        fileChooser.setApproveButtonMnemonic(NbBundle.getMessage(ImportDiffAction.class, (String)"Import").charAt(0));
        fileChooser.setApproveButtonText(NbBundle.getMessage(ImportDiffAction.class, (String)"Import"));
        JPanel panel = new JPanel();
        final JRadioButton asPatch = new JRadioButton(NbBundle.getMessage(ImportDiffAction.class, (String)"CTL_Import_PatchOption"));
        Mnemonics.setLocalizedText((AbstractButton)asPatch, (String)asPatch.getText());
        final JRadioButton asBundle = new JRadioButton(NbBundle.getMessage(ImportDiffAction.class, (String)"CTL_Import_BundleOption"));
        Mnemonics.setLocalizedText((AbstractButton)asBundle, (String)asBundle.getText());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(asBundle);
        buttonGroup.add(asPatch);
        asPatch.setSelected(true);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(asPatch);
        panel.add(asBundle);
        fileChooser.setAccessory(panel);
        DialogDescriptor dd = new DialogDescriptor((Object)fileChooser, NbBundle.getMessage(ImportDiffAction.class, (String)"ImportBrowse_title"));
        dd.setOptions(new Object[0]);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String state = e.getActionCommand();
                if (state.equals("ApproveSelection")) {
                    VCSFileProxy patchFile = VCSFileProxySupport.getSelectedFile((JFileChooser)fileChooser);
                    HgModuleConfig.getDefault(root).setImportFolder(patchFile.getParentFile().getPath());
                    RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
                    ImportDiffProgressSupport.Kind kind = asBundle.isSelected() ? ImportDiffProgressSupport.Kind.BUNDLE : (asPatch.isSelected() ? ImportDiffProgressSupport.Kind.PATCH : null);
                    ImportDiffProgressSupport support = new ImportDiffProgressSupport(root, patchFile, kind);
                    support.start(rp, root, NbBundle.getMessage(ImportDiffAction.class, (String)"LBL_ImportDiff_Progress"));
                }
                dialog.dispose();
            }
        });
        dialog.setVisible(true);
    }

    private static class ImportDiffProgressSupport
    extends HgProgressSupport {
        private final VCSFileProxy patchFile;
        private final VCSFileProxy repository;
        private final Kind kind;

        public ImportDiffProgressSupport(VCSFileProxy repository, VCSFileProxy patchFile, Kind kind) {
            this.repository = repository;
            this.patchFile = patchFile;
            this.kind = kind;
        }

        @Override
        public void perform() {
            if (this.kind == Kind.BUNDLE) {
                this.performUnbundle();
            } else if (this.kind == Kind.PATCH) {
                this.performImport();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performUnbundle() {
            final OutputLogger logger = this.getLogger();
            try {
                logger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_UNBUNDLE_TITLE"));
                logger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_UNBUNDLE_TITLE_SEP"));
                HgUtils.runWithoutIndexing(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        List<String> list = HgCommand.doUnbundle(ImportDiffProgressSupport.this.repository, ImportDiffProgressSupport.this.patchFile, true, logger);
                        if (list != null && !list.isEmpty()) {
                            List<String> updatedFilesList = list;
                            logger.output(HgUtils.replaceHttpPassword(list));
                            boolean bMergeNeededDueToPull = HgCommand.isMergeNeededMsg(list.get(list.size() - 1));
                            boolean bConfirmMerge = false;
                            boolean warnMoreHeads = true;
                            if (bMergeNeededDueToPull) {
                                bConfirmMerge = HgUtils.confirmDialog(ImportDiffAction.class, "MSG_UNBUNDLE_MERGE_CONFIRM_TITLE", "MSG_UNBUNDLE_MERGE_CONFIRM_QUERY");
                                warnMoreHeads = false;
                            } else {
                                boolean bOutStandingUncommittedMerges = HgCommand.isMergeAbortUncommittedMsg(list.get(list.size() - 1));
                                if (bOutStandingUncommittedMerges) {
                                    bConfirmMerge = HgUtils.confirmDialog(ImportDiffAction.class, "MSG_UNBUNDLE_MERGE_CONFIRM_TITLE", "MSG_UNBUNDLE_MERGE_UNCOMMITTED_CONFIRM_QUERY");
                                }
                            }
                            if (bConfirmMerge) {
                                logger.output("");
                                logger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_UNBUNDLE_MERGE_DO"));
                                List<String> mergeResult = MergeAction.doMergeAction(ImportDiffProgressSupport.this.repository, null, logger);
                                if (mergeResult != null) {
                                    updatedFilesList.addAll(mergeResult);
                                }
                            } else {
                                HgLogMessage[] heads = HgCommand.getHeadRevisionsInfo(ImportDiffProgressSupport.this.repository, false, OutputLogger.getLogger(null));
                                Map<String, Collection<HgLogMessage>> branchHeads = HgUtils.sortByBranch(heads);
                                if (!branchHeads.isEmpty()) {
                                    MergeAction.displayMergeWarning(branchHeads, logger, warnMoreHeads);
                                }
                            }
                            boolean fileUpdated = ImportDiffProgressSupport.isUpdated(updatedFilesList);
                            if (fileUpdated) {
                                HgUtils.notifyUpdatedFiles(ImportDiffProgressSupport.this.repository, updatedFilesList);
                                HgUtils.forceStatusRefresh(ImportDiffProgressSupport.this.repository);
                            }
                        }
                        return null;
                    }
                }, this.repository);
            }
            catch (HgException.HgCommandCanceledException ex) {
            }
            catch (HgException ex) {
                HgUtils.notifyException(ex);
            }
            finally {
                logger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_UNBUNDLE_DONE"));
                logger.output("");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performImport() {
            final OutputLogger logger = this.getLogger();
            try {
                logger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_IMPORT_TITLE"));
                logger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_IMPORT_TITLE_SEP"));
                HgUtils.runWithoutIndexing(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        List<String> list = HgCommand.doImport(ImportDiffProgressSupport.this.repository, ImportDiffProgressSupport.this.patchFile, logger);
                        Mercurial.getInstance().historyChanged(ImportDiffProgressSupport.this.repository);
                        Mercurial.getInstance().changesetChanged(ImportDiffProgressSupport.this.repository);
                        logger.output(list);
                        return null;
                    }
                }, this.repository);
            }
            catch (HgException.HgCommandCanceledException ex) {
            }
            catch (HgException ex) {
                HgUtils.notifyException(ex);
            }
            finally {
                logger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_IMPORT_DONE"));
                logger.output("");
            }
        }

        private static boolean isUpdated(List<String> list) {
            boolean updated = false;
            for (String s : list) {
                if (!s.contains("getting ") && !s.startsWith("merging ")) continue;
                updated = true;
                break;
            }
            return updated;
        }

        static enum Kind {
            PATCH,
            BUNDLE;

        }
    }
}

