/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.log.Bundle;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessageChangedPath;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public class HgLogMessage {
    public static final char HgModStatus = 'M';
    public static final char HgAddStatus = 'A';
    public static final char HgDelStatus = 'D';
    public static final char HgCopyStatus = 'C';
    public static final char HgRenameStatus = 'R';
    private final List<HgLogMessageChangedPath> paths;
    private final List<HgLogMessageChangedPath> dummyPaths;
    private final HgRevision rev;
    private final String author;
    private final String username;
    private final String desc;
    private final String shortdesc;
    private final Date date;
    private String timeZoneOffset;
    private HgRevision parentOneRev;
    private HgRevision parentTwoRev;
    private final boolean bMerged;
    private final String rootURL;
    private OutputLogger logger;
    private final HashMap<VCSFileProxy, HgRevision> ancestors = new HashMap();
    private final String[] branches;
    private final String[] tags;
    private static final String MARK_ACTIVE_HEAD = "*";

    private void updatePaths(List<String> pathsStrings, String path, char status) {
        this.paths.add(new HgLogMessageChangedPath(path, null, status));
        if (pathsStrings != null) {
            pathsStrings.add(path);
        }
    }

    public HgLogMessage(String rootURL, List<String> filesShortPaths, String rev, String auth, String username, String desc, String date, String id, String parents, String fm, String fa, String fd, String fc, String branches, String tags) {
        String[] parentSplits;
        this.rootURL = rootURL;
        this.rev = new HgRevision(id, rev);
        this.author = auth;
        this.username = username;
        this.desc = desc;
        this.shortdesc = HgLogMessage.getFirstLine(desc);
        this.date = new Date(Long.parseLong(date.split(" ")[0]) * 1000L);
        String[] stringArray = parentSplits = parents != null ? parents.split(" ") : null;
        if (parentSplits != null && parentSplits.length == 2) {
            this.parentOneRev = this.createRevision(parentSplits[0]);
            this.parentTwoRev = this.createRevision(parentSplits[1]);
        }
        this.bMerged = this.parentOneRev != null && this.parentTwoRev != null && !this.parentOneRev.getRevisionNumber().equals("-1") && !this.parentTwoRev.getRevisionNumber().equals("-1");
        this.paths = new ArrayList<HgLogMessageChangedPath>();
        ArrayList<String> apathsStrings = new ArrayList<String>();
        ArrayList<String> dpathsStrings = new ArrayList<String>();
        ArrayList<String> cpathsStrings = new ArrayList<String>();
        if (fd != null && !fd.equals("")) {
            for (String s : fd.split("\t")) {
                this.updatePaths(dpathsStrings, s, 'D');
            }
        }
        if (fc != null && !fc.equals("")) {
            String[] copyPaths = fc.split("\t");
            for (int i = 0; i < copyPaths.length / 2; ++i) {
                String path = copyPaths[i * 2];
                String original = copyPaths[i * 2 + 1];
                cpathsStrings.add(path);
                if (dpathsStrings.contains(original)) {
                    ListIterator<HgLogMessageChangedPath> it = this.paths.listIterator();
                    while (it.hasNext()) {
                        HgLogMessageChangedPath msg = it.next();
                        if (!original.equals(msg.getPath())) continue;
                        it.remove();
                    }
                    this.paths.add(new HgLogMessageChangedPath(path, original, 'R'));
                    continue;
                }
                this.paths.add(new HgLogMessageChangedPath(path, original, 'C'));
            }
        }
        if (fa != null && !fa.equals("")) {
            for (String s : fa.split("\t")) {
                if (cpathsStrings.contains(s)) continue;
                this.updatePaths(apathsStrings, s, 'A');
            }
        }
        if (fm != null && !fm.equals("")) {
            for (String s : fm.split("\t")) {
                if (apathsStrings.contains(s) || dpathsStrings.contains(s) || cpathsStrings.contains(s)) continue;
                this.updatePaths(null, s, 'M');
            }
        }
        this.dummyPaths = new ArrayList<HgLogMessageChangedPath>(filesShortPaths.size());
        for (String fileSP : filesShortPaths) {
            this.dummyPaths.add(new HgLogMessageChangedPath(fileSP, null, '?'));
        }
        this.branches = branches.isEmpty() ? new String[0] : branches.split("\t");
        this.tags = tags.isEmpty() ? new String[0] : tags.split("\t");
    }

    public HgLogMessageChangedPath[] getChangedPaths() {
        return this.paths.toArray(new HgLogMessageChangedPath[this.paths.size()]);
    }

    HgLogMessageChangedPath[] getDummyChangedPaths() {
        return this.dummyPaths.toArray(new HgLogMessageChangedPath[this.dummyPaths.size()]);
    }

    public String getRevisionNumber() {
        return this.rev.getRevisionNumber();
    }

    public long getRevisionAsLong() {
        long revLong;
        try {
            revLong = Long.parseLong(this.rev.getRevisionNumber());
        }
        catch (NumberFormatException ex) {
            return 0L;
        }
        return revLong;
    }

    public HgRevision getHgRevision() {
        return this.rev;
    }

    public Date getDate() {
        return this.date;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getUsername() {
        return this.username;
    }

    public String getCSetShortID() {
        return this.rev.getChangesetId();
    }

    public boolean isMerge() {
        return this.bMerged;
    }

    public HgRevision getAncestor(VCSFileProxy file) {
        HgRevision ancestor = this.getAncestorFromMap(file);
        if (ancestor != null) {
            return ancestor;
        }
        if (this.bMerged) {
            try {
                ancestor = HgCommand.getCommonAncestor(file, this.rootURL, this.parentOneRev.getRevisionNumber(), this.parentTwoRev.getRevisionNumber(), this.getLogger());
            }
            catch (HgException ex) {
                Mercurial.LOG.log(ex instanceof HgException.HgCommandCanceledException ? Level.FINE : Level.INFO, null, ex);
                return HgRevision.EMPTY;
            }
        }
        try {
            ancestor = HgCommand.getParent(VCSFileProxySupport.getResource((VCSFileProxy)file, (String)this.rootURL), file, this.rev.getRevisionNumber());
        }
        catch (HgException ex) {
            Mercurial.LOG.log(ex instanceof HgException.HgCommandCanceledException ? Level.FINE : Level.INFO, null, ex);
            return HgRevision.EMPTY;
        }
        if (ancestor == null) {
            try {
                Integer.toString(Integer.parseInt(this.rev.getRevisionNumber()) - 1);
            }
            catch (NumberFormatException ex) {
                ancestor = HgRevision.EMPTY;
            }
        }
        this.addAncestorToMap(file, ancestor);
        return ancestor;
    }

    private OutputLogger getLogger() {
        if (this.logger == null) {
            this.logger = Mercurial.getInstance().getLogger(this.rootURL);
        }
        return this.logger;
    }

    public String getMessage() {
        return this.desc;
    }

    public String getShortMessage() {
        return this.shortdesc;
    }

    public String getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public void setTimeZoneOffset(String timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
    }

    public String[] getBranches() {
        return this.branches;
    }

    public String[] getTags() {
        return this.tags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("rev: ");
        sb.append(this.rev.getRevisionNumber());
        sb.append("\nauthor: ");
        sb.append(this.author);
        sb.append("\ndesc: ");
        sb.append(this.desc);
        sb.append("\ndate: ");
        sb.append(this.date);
        sb.append("\nid: ");
        sb.append(this.rev.getChangesetId());
        sb.append("\npaths: ");
        sb.append(this.paths);
        return sb.toString();
    }

    public VCSFileProxy getOriginalFile(VCSFileProxy root, VCSFileProxy file) {
        for (HgLogMessageChangedPath path : this.paths) {
            if (!file.equals((Object)VCSFileProxy.createFileProxy((VCSFileProxy)root, (String)path.getPath()))) continue;
            if (path.getCopySrcPath() == null) {
                return file;
            }
            return VCSFileProxy.createFileProxy((VCSFileProxy)root, (String)path.getCopySrcPath());
        }
        return null;
    }

    private void addAncestorToMap(VCSFileProxy file, HgRevision ancestor) {
        this.ancestors.put(file, ancestor);
    }

    private HgRevision getAncestorFromMap(VCSFileProxy file) {
        return this.ancestors.get(file);
    }

    private HgRevision createRevision(String revisionString) {
        String[] ps1 = revisionString.split(":");
        String revisionNumber = ps1.length >= 1 ? ps1[0] : null;
        String changesetId = ps1.length >= 2 ? ps1[1] : revisionNumber;
        return revisionNumber == null ? null : new HgRevision(changesetId, revisionNumber);
    }

    public void refreshChangedPaths(HgLogMessageChangedPath[] newPaths) {
        assert (this.getChangedPaths().length == 0) : "Why refreshing already loaded change paths??? length=" + this.getChangedPaths().length;
        this.paths.clear();
        this.dummyPaths.clear();
        this.paths.addAll(Arrays.asList(newPaths));
    }

    public String toAnnotatedString(String wcparentCSetId) {
        StringBuilder sb = new StringBuilder().append(this.getRevisionNumber());
        if (wcparentCSetId.equals(this.getCSetShortID())) {
            sb.append(MARK_ACTIVE_HEAD);
        }
        StringBuilder labels = new StringBuilder();
        for (String branch : this.getBranches()) {
            labels.append(branch).append(' ');
        }
        int i$ = 0;
        String[] arr$ = this.getTags();
        int len$ = arr$.length;
        if (i$ < len$) {
            String tag = arr$[i$];
            labels.append(tag).append(' ');
        }
        sb.append(" (").append((CharSequence)labels).append(labels.length() == 0 ? "" : "- ").append(this.getCSetShortID().substring(0, 7)).append(")");
        if (!this.getShortMessage().isEmpty()) {
            sb.append(" - ").append(this.getShortMessage());
        }
        return sb.toString();
    }

    private static String getFirstLine(String desc) {
        String firstLine = "";
        if (desc != null) {
            firstLine = desc.split("\n")[0];
        }
        return firstLine;
    }

    public static class HgRevision {
        private final String changesetId;
        private final String revisionNumber;
        public static final HgRevision EMPTY = new HgRevision("-1", "-1"){

            @Override
            public String toString() {
                return this.getChangesetId();
            }
        };
        public static final HgRevision BASE = new HgRevision(".", "BASE"){

            @Override
            public String toString() {
                return Bundle.MSG_HgRevision_name_BASE();
            }
        };
        public static final HgRevision CURRENT = new HgRevision("LOCAL", "LOCAL"){

            @Override
            public String toString() {
                return Bundle.MSG_HgRevision_name_LOCAL();
            }
        };
        public static final HgRevision QDIFF_BASE = new HgRevision("qtip~1", "qtip~1"){

            @Override
            public String toString() {
                return Bundle.MSG_HgRevision_name_QDIFFBASE();
            }
        };

        public HgRevision(String changesetId, String revisionNumber) {
            this.changesetId = changesetId;
            this.revisionNumber = revisionNumber;
        }

        public String getChangesetId() {
            return this.changesetId;
        }

        public String getRevisionNumber() {
            return this.revisionNumber;
        }

        public String toString() {
            return this.revisionNumber + " - " + this.changesetId;
        }
    }
}

