/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.queues;

import java.awt.EventQueue;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.diff.DiffAction;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.ui.queues.Bundle;
import org.netbeans.modules.mercurial.remote.ui.queues.QUtils;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class QDiffAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_QDiff";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        final VCSFileProxy[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        final VCSFileProxy root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        new HgProgressSupport(){

            @Override
            protected void perform() {
                if (!QUtils.isMQEnabledExtension(root)) {
                    return;
                }
                try {
                    List<HgLogMessage> parents = HgCommand.getParents(root, null, null);
                    if (parents.size() != 1 || !Arrays.asList(parents.get(0).getTags()).contains("qtip")) {
                        NotifyDescriptor.Message e = new NotifyDescriptor.Message((Object)NbBundle.getMessage(QDiffAction.class, (String)"MSG_DiffAction.error.notAtTip"), 0);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
                    } else {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((DiffAction)SystemAction.get(DiffAction.class)).diff(roots, HgLogMessage.HgRevision.QDIFF_BASE, HgLogMessage.HgRevision.CURRENT, Bundle.LBL_DiffView_name(roots.length == 1 ? roots[0].getName() : Bundle.LBL_DiffView_name_files(roots.length)), true, false);
                            }
                        });
                    }
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
            }
        }.start(Mercurial.getInstance().getRequestProcessor(root), root, NbBundle.getMessage(QDiffAction.class, (String)"LBL_DiffAction.progress"));
    }
}

