/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.rollback;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.remote.ui.merge.MergeAction;
import org.netbeans.modules.mercurial.remote.ui.rollback.Backout;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class BackoutAction
extends ContextAction {
    private static final String HG_BACKOUT_REVISION_REPLACE = "\\{revision}";
    static final String HG_BACKOUT_REVISION = "{revision}";

    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Backout";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        BackoutAction.backout(context);
    }

    public static void backout(VCSContext ctx) {
        BackoutAction.backout(ctx, null);
    }

    public static void backout(RepositoryRevision repoRev) {
        BackoutAction.backout(null, repoRev);
    }

    public static void backout(final VCSContext ctx, final RepositoryRevision repoRev) {
        VCSFileProxy root;
        if (repoRev != null) {
            root = repoRev.getRepositoryRoot();
            if (root == null || root.getPath().equals("")) {
                return;
            }
        } else {
            VCSFileProxy[] roots = HgUtils.getActionRoots(ctx);
            if (roots == null || roots.length == 0) {
                return;
            }
            root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        }
        if (root == null) {
            return;
        }
        Backout backout = new Backout(root, repoRev == null ? null : repoRev.getLog());
        if (!backout.showDialog()) {
            return;
        }
        final String rev = backout.getSelectionRevision();
        final String commitMsg = backout.getCommitMessage();
        boolean doMerge = false;
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                String revStr = rev;
                if (revStr == null) {
                    try {
                        revStr = HgCommand.getParent(root, null, null).getChangesetId();
                    }
                    catch (HgException ex) {
                        HgUtils.notifyException(ex);
                        return;
                    }
                }
                final String commitMsgStr = commitMsg.replaceAll(BackoutAction.HG_BACKOUT_REVISION_REPLACE, revStr);
                if (revStr == null) {
                    try {
                        revStr = HgCommand.getParent(root, null, null).getChangesetId();
                    }
                    catch (HgException ex) {
                        HgUtils.notifyException(ex);
                        return;
                    }
                }
                final OutputLogger logger = this.getLogger();
                try {
                    logger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_TITLE_SEP"));
                    logger.output(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_INFO_SEP", (Object)revStr, (Object)root.getPath()));
                    final String revision = revStr;
                    HgUtils.runWithoutIndexing(new Callable<Void>(){

                        @Override
                        public Void call() throws HgException {
                            List<String> list = HgCommand.doBackout(root, revision, false, commitMsgStr, logger);
                            if (list != null && !list.isEmpty()) {
                                boolean bMergeNeededDueToBackout = HgCommand.isBackoutMergeNeededMsg(list.get(list.size() - 1));
                                if (bMergeNeededDueToBackout) {
                                    list.remove(list.size() - 1);
                                    list.remove(list.size() - 1);
                                }
                                logger.output(list);
                                if (HgCommand.isUncommittedChangesBackout(list.get(0))) {
                                    logger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_UNCOMMITTED_CHANGES_BACKOUT"));
                                    return null;
                                }
                                if (HgCommand.isMergeChangesetBackout(list.get(0))) {
                                    logger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_MERGE_CSET_BACKOUT", (Object)revision));
                                    return null;
                                }
                                if (HgCommand.isNoRevStrip(list.get(0))) {
                                    logger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_NO_REV_BACKOUT", (Object)revision));
                                    return null;
                                }
                                boolean bConfirmMerge = false;
                                boolean warnMoreHeads = true;
                                if (bMergeNeededDueToBackout) {
                                    bConfirmMerge = HgUtils.confirmDialog(BackoutAction.class, "MSG_BACKOUT_MERGE_CONFIRM_TITLE", "MSG_BACKOUT_MERGE_CONFIRM_QUERY");
                                    warnMoreHeads = false;
                                }
                                if (bConfirmMerge) {
                                    logger.output("");
                                    logger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_MERGE_DO"));
                                    MergeAction.doMergeAction(root, null, logger);
                                } else {
                                    HgLogMessage[] heads = HgCommand.getHeadRevisionsInfo(root, false, OutputLogger.getLogger(null));
                                    Map<String, Collection<HgLogMessage>> branchHeads = HgUtils.sortByBranch(heads);
                                    if (!branchHeads.isEmpty()) {
                                        MergeAction.displayMergeWarning(branchHeads, logger, warnMoreHeads);
                                    }
                                }
                                if (ctx != null) {
                                    HgUtils.forceStatusRefreshProject(ctx);
                                } else if (repoRev != null) {
                                    HgUtils.forceStatusRefresh(root);
                                }
                            }
                            return null;
                        }
                    }, root);
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
                finally {
                    logger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_DONE"));
                    logger.output("");
                    Mercurial.getInstance().versionedFilesChanged();
                }
            }
        };
        support.start(rp, root, NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_PROGRESS"));
    }
}

