/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.rollback;

import java.util.List;
import java.util.concurrent.Callable;
import org.netbeans.modules.mercurial.remote.FileStatusCache;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.rollback.Strip;
import org.netbeans.modules.mercurial.remote.ui.update.ConflictResolvedAction;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class StripAction
extends ContextAction {
    private static final String HG_STIP_SAVE_BUNDLE = "saving bundle to ";

    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Strip";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        StripAction.strip(context);
    }

    public static void strip(final VCSContext ctx) {
        VCSFileProxy[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        final VCSFileProxy root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        Strip strip = new Strip(root);
        if (!strip.showDialog()) {
            return;
        }
        final boolean doBackup = strip.isBackupRequested();
        final String rev = strip.getSelectionRevision();
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                String revStr = rev;
                if (revStr == null) {
                    try {
                        revStr = HgCommand.getParent(root, null, null).getChangesetId();
                    }
                    catch (HgException ex) {
                        HgUtils.notifyException(ex);
                        return;
                    }
                }
                final OutputLogger logger = this.getLogger();
                try {
                    logger.outputInRed(NbBundle.getMessage(StripAction.class, (String)"MSG_STRIP_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(StripAction.class, (String)"MSG_STRIP_TITLE_SEP"));
                    logger.output(NbBundle.getMessage(StripAction.class, (String)"MSG_STRIP_INFO_SEP", (Object)revStr, (Object)root.getPath()));
                    final String revision = revStr;
                    List<String> list = HgUtils.runWithoutIndexing(new Callable<List<String>>(){

                        @Override
                        public List<String> call() throws HgException {
                            return HgCommand.doStrip(root, revision, false, doBackup, logger);
                        }
                    }, root);
                    if (list != null && !list.isEmpty()) {
                        logger.output(list);
                        if (HgCommand.isNoRevStrip(list.get(0))) {
                            logger.outputInRed(NbBundle.getMessage(StripAction.class, (String)"MSG_NO_REV_STRIP", (Object)revStr));
                        } else if (HgCommand.isLocalChangesStrip(list.get(0))) {
                            logger.outputInRed(NbBundle.getMessage(StripAction.class, (String)"MSG_LOCAL_CHANGES_STRIP"));
                        } else if (HgCommand.isMultipleHeadsStrip(list.get(0))) {
                            logger.outputInRed(NbBundle.getMessage(StripAction.class, (String)"MSG_MULTI_HEADS_STRIP"));
                        } else {
                            String savingTo;
                            VCSFileProxy savingFile;
                            HgUtils.notifyUpdatedFiles(root, list);
                            if (HgCommand.hasHistory(root).booleanValue()) {
                                FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
                                if (cache.listFiles(ctx, 64).length != 0) {
                                    ConflictResolvedAction.resolved(ctx);
                                }
                                HgUtils.forceStatusRefreshProject(ctx);
                                Mercurial.getInstance().historyChanged(root);
                                Mercurial.getInstance().changesetChanged(root);
                            }
                            if ((savingFile = VCSFileProxySupport.getResource((VCSFileProxy)root, (String)(savingTo = (savingTo = list.get(list.size() - 1)) != null ? savingTo.substring(StripAction.HG_STIP_SAVE_BUNDLE.length()) : null))) != null && savingFile.exists() && VCSFileProxySupport.canRead((VCSFileProxy)savingFile)) {
                                logger.outputInRed(NbBundle.getMessage(StripAction.class, (String)"MSG_STRIP_RESTORE_INFO"));
                                logger.output(NbBundle.getMessage(StripAction.class, (String)"MSG_STRIP_RESTORE_INFO2", (Object)savingFile));
                            }
                        }
                    }
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
                finally {
                    logger.outputInRed(NbBundle.getMessage(StripAction.class, (String)"MSG_STRIP_DONE"));
                    logger.output("");
                }
            }
        };
        support.start(rp, root, NbBundle.getMessage(StripAction.class, (String)"MSG_STRIP_PROGRESS"));
    }
}

