/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.status;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class OpenInEditorAction
extends AbstractAction {
    public OpenInEditorAction() {
        super(NbBundle.getBundle(OpenInEditorAction.class).getString("CTL_Synchronize_Popup_OpenInEditor"));
        this.setEnabled(this.isActionEnabled());
    }

    private boolean isActionEnabled() {
        for (VCSFileProxy file : HgUtils.getCurrentContext(null).getRootFiles()) {
            if (!VCSFileProxySupport.canRead((VCSFileProxy)file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (VCSFileProxy file : HgUtils.getCurrentContext(null).getRootFiles()) {
            FileObject fo = file.toFileObject();
            if (fo == null) continue;
            try {
                this.openDataObjectByCookie(DataObject.find((FileObject)fo));
            }
            catch (DataObjectNotFoundException ex) {}
        }
    }

    private boolean openDataObjectByCookie(DataObject dataObject) {
        Node.Cookie cookie = (Node.Cookie)dataObject.getLookup().lookup(EditorCookie.Observable.class);
        if (cookie != null) {
            return this.openByCookie(cookie, EditorCookie.Observable.class);
        }
        cookie = (Node.Cookie)dataObject.getLookup().lookup(EditorCookie.class);
        if (cookie != null) {
            return this.openByCookie(cookie, EditorCookie.class);
        }
        cookie = (Node.Cookie)dataObject.getLookup().lookup(OpenCookie.class);
        if (cookie != null) {
            return this.openByCookie(cookie, OpenCookie.class);
        }
        cookie = (Node.Cookie)dataObject.getLookup().lookup(EditCookie.class);
        if (cookie != null) {
            return this.openByCookie(cookie, EditCookie.class);
        }
        cookie = (Node.Cookie)dataObject.getLookup().lookup(ViewCookie.class);
        if (cookie != null) {
            return this.openByCookie(cookie, ViewCookie.class);
        }
        return false;
    }

    private boolean openByCookie(Node.Cookie cookie, Class cookieClass) {
        if (cookieClass == EditorCookie.class || cookieClass == EditorCookie.Observable.class) {
            ((EditorCookie)cookie).open();
        } else if (cookieClass == OpenCookie.class) {
            ((OpenCookie)cookie).open();
        } else if (cookieClass == EditCookie.class) {
            ((EditCookie)cookie).edit();
        } else if (cookieClass == ViewCookie.class) {
            ((ViewCookie)cookie).view();
        } else {
            throw new IllegalArgumentException("Reopen #58766: " + cookieClass);
        }
        return true;
    }
}

