/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.update;

import java.util.List;
import java.util.concurrent.Callable;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.ui.update.Update;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class UpdateAction
extends ContextAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/mercurial/remote/resources/icons/update.png";

    public UpdateAction() {
        super(ICON_RESOURCE);
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Update";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        this.update(HgUtils.getCurrentContext(nodes), null);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    public void update(VCSContext ctx, HgLogMessage rev) {
        VCSFileProxy[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        VCSFileProxy root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        this.update(root, rev);
    }

    public void update(final VCSFileProxy root, HgLogMessage rev) {
        Update update = new Update(root, rev);
        if (!update.showDialog()) {
            return;
        }
        final String revStr = update.getSelectionRevision();
        final boolean doForcedUpdate = update.isForcedUpdateRequested();
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                boolean bNoUpdates = true;
                OutputLogger logger = this.getLogger();
                try {
                    List<String> list;
                    logger.outputInRed(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_TITLE_SEP"));
                    logger.output(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_INFO_SEP", (Object)(revStr == null ? NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_REVISION_PARENT") : revStr), (Object)root.getPath()));
                    if (doForcedUpdate) {
                        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_CONFIRM_QUERY"));
                        descriptor.setTitle(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_CONFIRM"));
                        descriptor.setMessageType(2);
                        descriptor.setOptionType(0);
                        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                        if (res == NotifyDescriptor.NO_OPTION) {
                            logger.outputInRed(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_CANCELED", (Object)root.getPath()));
                            logger.output("");
                            return;
                        }
                        logger.output(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_FORCED", (Object)root.getPath()));
                    }
                    if ((list = HgUtils.runWithoutIndexing(new Callable<List<String>>(){

                        @Override
                        public List<String> call() throws HgException {
                            return HgCommand.doUpdateAll(root, doForcedUpdate, revStr);
                        }
                    }, root)) != null && !list.isEmpty()) {
                        bNoUpdates = HgCommand.isNoUpdates(list.get(0));
                        if (!bNoUpdates) {
                            HgUtils.notifyUpdatedFiles(root, list);
                            HgUtils.forceStatusRefresh(root);
                        }
                        logger.output(list);
                        logger.output("");
                    }
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
                logger.outputInRed(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_DONE"));
                logger.output("");
            }
        };
        support.start(rp, root, NbBundle.getMessage(UpdateAction.class, (String)"MSG_Update_Progress"));
    }
}

