/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.wizards;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.ui.wizards.CloneDestinationDirectoryWizardPanel;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class CloneDestinationDirectoryPanel
extends JPanel
implements ActionListener {
    private String message;
    private final CloneDestinationDirectoryWizardPanel wizardPanel;
    private JPanel destinationDirectoryPanel;
    private JButton directoryBrowseButton;
    final JTextField directoryField = new JTextField();
    private JLabel directoryLabel;
    private JLabel jLabel1;
    final JTextField nameField = new JTextField();
    private JLabel nameLabel;
    final JCheckBox scanForProjectsCheckBox = new JCheckBox();

    public CloneDestinationDirectoryPanel(CloneDestinationDirectoryWizardPanel wizardPanel) {
        this.wizardPanel = wizardPanel;
        this.initComponents();
        this.directoryBrowseButton.addActionListener(this);
        this.scanForProjectsCheckBox.addActionListener(this);
        this.directoryField.setText(this.defaultWorkingDirectory().getPath());
        this.scanForProjectsCheckBox.setSelected(HgModuleConfig.getDefault(wizardPanel.getRoot()).getShowCloneCompleted());
    }

    @Override
    public String getName() {
        if (this.destinationDirectoryPanel == null) {
            return null;
        }
        return this.destinationDirectoryPanel.getName();
    }

    public String getDirectory() {
        return this.directoryField.getText();
    }

    public String getCloneName() {
        return this.nameField.getText();
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isInputValid() {
        String dir = this.directoryField.getText();
        String name = this.nameField.getText();
        VCSFileProxy file = VCSFileProxySupport.getResource((VCSFileProxy)this.wizardPanel.getRoot(), (String)(dir + "/" + name));
        if (file.exists()) {
            this.message = NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"MSG_TARGET_EXISTS");
            return false;
        }
        this.message = "";
        return true;
    }

    private void initComponents() {
        this.destinationDirectoryPanel = new JPanel();
        this.directoryLabel = new JLabel();
        this.directoryBrowseButton = new JButton();
        this.nameLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.destinationDirectoryPanel.setName(NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"destinationDirectoryPanel.Name"));
        this.directoryLabel.setLabelFor(this.directoryField);
        Mnemonics.setLocalizedText((JLabel)this.directoryLabel, (String)NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"directoryLabel.Name"));
        this.directoryField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CloneDestinationDirectoryPanel.this.directoryFieldActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.directoryBrowseButton, (String)NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"directoryBrowseButton.Name"));
        this.nameLabel.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"nameLabel.Name"));
        this.scanForProjectsCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.scanForProjectsCheckBox, (String)NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"CTL_Scan_After_Clone"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"directoryTitleLabel.Name"));
        GroupLayout destinationDirectoryPanelLayout = new GroupLayout(this.destinationDirectoryPanel);
        this.destinationDirectoryPanel.setLayout(destinationDirectoryPanelLayout);
        destinationDirectoryPanelLayout.setHorizontalGroup(destinationDirectoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(destinationDirectoryPanelLayout.createSequentialGroup().addGroup(destinationDirectoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(destinationDirectoryPanelLayout.createSequentialGroup().addGroup(destinationDirectoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.nameLabel, -1, -1, Short.MAX_VALUE).addComponent(this.directoryLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(destinationDirectoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameField, -1, 424, Short.MAX_VALUE).addComponent(this.directoryField, -1, 424, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.directoryBrowseButton)).addComponent(this.scanForProjectsCheckBox).addComponent(this.jLabel1, -2, 597, -2)).addContainerGap()));
        destinationDirectoryPanelLayout.setVerticalGroup(destinationDirectoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(destinationDirectoryPanelLayout.createSequentialGroup().addComponent(this.jLabel1).addGap(20, 20, 20).addGroup(destinationDirectoryPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.directoryLabel, -1, -1, Short.MAX_VALUE).addComponent(this.directoryBrowseButton).addComponent(this.directoryField, -2, -1, -2)).addGap(28, 28, 28).addGroup(destinationDirectoryPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameField, -2, -1, -2).addComponent(this.nameLabel)).addGap(18, 18, 18).addComponent(this.scanForProjectsCheckBox, -2, 32, -2).addGap(75, 75, 75)));
        this.scanForProjectsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"ACSD_Scan_After_Clone"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.destinationDirectoryPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.destinationDirectoryPanel, -2, -1, -2).addContainerGap(62, Short.MAX_VALUE)));
    }

    private void directoryFieldActionPerformed(ActionEvent evt) {
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.directoryBrowseButton) {
            this.onBrowseClick();
        } else if (evt.getSource() == this.scanForProjectsCheckBox) {
            HgModuleConfig.getDefault(this.wizardPanel.getRoot()).setShowCloneCompleted(this.scanForProjectsCheckBox.isSelected());
        }
    }

    private void onBrowseClick() {
        VCSFileProxy oldFile = this.defaultWorkingDirectory();
        JFileChooser fileChooser = VCSFileProxySupport.createFileChooser((VCSFileProxy)oldFile);
        fileChooser.setDialogTitle(NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"Browse_title"));
        fileChooser.setMultiSelectionEnabled(false);
        FileFilter[] old = fileChooser.getChoosableFileFilters();
        for (int i = 0; i < old.length; ++i) {
            FileFilter fileFilter = old[i];
            fileChooser.removeChoosableFileFilter(fileFilter);
        }
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"Folders");
            }
        });
        fileChooser.setFileSelectionMode(1);
        fileChooser.showDialog(this, NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"OK_Button"));
        VCSFileProxy f = VCSFileProxySupport.getSelectedFile((JFileChooser)fileChooser);
        if (f != null) {
            this.directoryField.setText(f.getPath());
        }
    }

    private VCSFileProxy defaultWorkingDirectory() {
        String cloneDir;
        VCSFileProxy defaultDir = null;
        String current = this.directoryField.getText();
        if (current != null && !current.trim().equals("")) {
            VCSFileProxy currentFile;
            for (currentFile = VCSFileProxySupport.getResource((VCSFileProxy)this.wizardPanel.getRoot(), (String)current); currentFile != null && !currentFile.exists(); currentFile = currentFile.getParentFile()) {
            }
            if (currentFile != null) {
                defaultDir = currentFile.isFile() ? currentFile.getParentFile() : currentFile;
            }
        }
        if (defaultDir == null && (cloneDir = HgModuleConfig.getDefault(this.wizardPanel.getRoot()).getPreferences().get("cloneDestinationStep.cloneDirectory", null)) != null) {
            defaultDir = VCSFileProxySupport.getResource((VCSFileProxy)this.wizardPanel.getRoot(), (String)cloneDir);
        }
        if (defaultDir == null) {
            defaultDir = VCSFileProxySupport.getHome((VCSFileProxy)this.wizardPanel.getRoot());
        }
        return defaultDir;
    }
}

