/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.ui.Bundle;
import org.netbeans.modules.gsf.testrunner.ui.RootNodeChildren;
import org.netbeans.modules.gsf.testrunner.ui.api.TestsuiteNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.util.actions.SystemAction;

final class RootNode
extends AbstractNode {
    static final int ALL_PASSED_ABSENT = 0;
    static final int SOME_PASSED_ABSENT = 1;
    static final int ALL_PASSED_DISPLAYED = 2;
    private RootNodeChildren children;
    private volatile int filterMask;
    private volatile String message;
    private volatile int totalTests = 0;
    private volatile int failures = 0;
    private volatile int errors = 0;
    private volatile int pending = 0;
    private volatile int skipped = 0;
    private volatile int aborted = 0;
    private volatile long elapsedTimeMillis = 0L;
    private volatile int detectedPassedTests = 0;
    private boolean sessionFinished;
    private final TestSession session;
    private static final Logger LOGGER = Logger.getLogger(RootNode.class.getName());

    RootNode(TestSession session, int filterMask) {
        super(Children.LEAF);
        this.session = session;
        this.filterMask = filterMask;
        this.setName(Bundle.MSG_RunningTests());
        this.setIconBaseWithExtension("org/netbeans/modules/gsf/testrunner/resources/empty.gif");
    }

    private RootNodeChildren getRootNodeChildren() {
        if (this.children == null) {
            this.children = new RootNodeChildren(this.session, this.filterMask);
            this.setChildren(Children.create((ChildFactory)this.children, (boolean)true));
        }
        return this.children;
    }

    int getTotalTests() {
        return this.totalTests;
    }

    void displayMessage(String msg) {
        assert (EventQueue.isDispatchThread());
        this.message = msg;
        this.updateDisplayName();
    }

    void displayMessageSessionFinished(String msg) {
        this.sessionFinished = true;
        this.displayMessage(msg);
        this.getRootNodeChildren().notifyTestSuiteFinished();
    }

    void displaySuiteRunning(String suiteName) {
        assert (EventQueue.isDispatchThread());
        this.getRootNodeChildren().displaySuiteRunning(suiteName);
    }

    void displaySuiteRunning(TestSuite suite) {
        assert (EventQueue.isDispatchThread());
        this.getRootNodeChildren().displaySuiteRunning(suite);
    }

    public TestsuiteNode displayReport(Report report) {
        assert (EventQueue.isDispatchThread());
        TestsuiteNode suiteNode = this.getRootNodeChildren().displayReport(report);
        this.updateStatistics();
        this.updateDisplayName();
        return suiteNode;
    }

    void displayReports(Collection<Report> reports) {
        assert (EventQueue.isDispatchThread());
        this.getRootNodeChildren().displayReports(reports);
        this.updateStatistics();
        this.updateDisplayName();
    }

    private synchronized void updateStatistics() {
        this.totalTests = 0;
        this.failures = 0;
        this.errors = 0;
        this.pending = 0;
        this.skipped = 0;
        this.aborted = 0;
        this.detectedPassedTests = 0;
        this.elapsedTimeMillis = 0L;
        for (Report rep : this.getRootNodeChildren().getReports()) {
            this.totalTests += rep.getTotalTests();
            this.failures += rep.getFailures();
            this.errors += rep.getErrors();
            this.pending += rep.getPending();
            this.skipped += rep.getSkipped();
            this.aborted += rep.getAborted();
            this.detectedPassedTests += rep.getDetectedPassedTests();
            this.elapsedTimeMillis += rep.getElapsedTimeMillis();
        }
    }

    float getPassedPercentage() {
        return (float)this.detectedPassedTests / (float)this.totalTests * 100.0f;
    }

    float getSkippedPercentage() {
        return (float)this.skipped / (float)this.totalTests * 100.0f;
    }

    float getAbortedPercentage() {
        return (float)this.aborted / (float)this.totalTests * 100.0f;
    }

    void setFilterMask(int filterMask) {
        assert (EventQueue.isDispatchThread());
        if (filterMask == this.filterMask) {
            return;
        }
        this.filterMask = filterMask;
        this.getRootNodeChildren().setFilterMask(filterMask);
    }

    private void updateDisplayName() {
        String msg;
        assert (EventQueue.isDispatchThread());
        if (this.totalTests == 0) {
            msg = this.sessionFinished ? Bundle.MSG_TestsInfoNoTests() : null;
        } else if (this.failures == 0 && this.errors == 0 && this.pending == 0 && this.skipped == 0 && this.aborted == 0) {
            msg = Bundle.MSG_TestsInfoAllOK(this.totalTests);
        } else {
            String passedTestsInfo = Bundle.MSG_PassedTestsInfo(this.totalTests - this.failures - this.errors - this.pending - this.skipped - this.aborted);
            String pendingTestsInfo = this.pending == 0 ? null : Bundle.MSG_PendingTestsInfo(this.errors);
            String failedTestsInfo = this.failures == 0 ? null : Bundle.MSG_FailedTestsInfo(this.failures);
            String errorTestsInfo = this.errors == 0 ? null : Bundle.MSG_ErrorTestsInfo(this.errors);
            String skippedTestsInfo = this.skipped == 0 ? null : Bundle.MSG_SkippedTestsInfo(this.skipped);
            String abortedTestsInfo = this.aborted == 0 ? null : Bundle.MSG_AbortedTestsInfo(this.aborted);
            msg = this.constructMessage(passedTestsInfo, pendingTestsInfo, failedTestsInfo, errorTestsInfo, skippedTestsInfo, abortedTestsInfo);
        }
        if (this.totalTests != 0) {
            assert (msg != null);
            int successDisplayedLevel = this.getSuccessDisplayedLevel();
            switch (successDisplayedLevel) {
                case 1: {
                    msg = msg + ' ';
                    msg = msg + Bundle.MSG_SomePassedNotDisplayed();
                    break;
                }
                case 0: {
                    msg = msg + ' ';
                    msg = msg + Bundle.MSG_PassedNotDisplayed();
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        if (msg != null) {
            msg = msg + Bundle.MSG_TestSuiteElapsedTime((double)this.elapsedTimeMillis / 1000.0);
        }
        if (this.message != null) {
            msg = msg == null ? this.message : msg + ' ' + this.message;
        }
        LOGGER.log(Level.FINE, "Setting display name to: ''{0}''. Total tests run: {1}. Session finished: {2}", new Object[]{msg, this.totalTests, this.sessionFinished});
        this.setDisplayName(msg);
    }

    String constructMessage(String ... subMessages) {
        ArrayList<String> messageList = new ArrayList<String>();
        for (String msg : subMessages) {
            if (msg == null) continue;
            messageList.add(msg);
        }
        int size = messageList.size();
        switch (size) {
            case 2: {
                return Bundle.MSG_TestResultSummary1(messageList.get(0), messageList.get(1));
            }
            case 3: {
                return Bundle.MSG_TestResultSummary2(messageList.get(0), messageList.get(1), messageList.get(2));
            }
            case 4: {
                return Bundle.MSG_TestResultSummary3(messageList.get(0), messageList.get(1), messageList.get(2), messageList.get(3));
            }
            case 5: {
                return Bundle.MSG_TestResultSummary4(messageList.get(0), messageList.get(1), messageList.get(2), messageList.get(3), messageList.get(4));
            }
            case 6: {
                return Bundle.MSG_TestResultSummary5(messageList.get(0), messageList.get(1), messageList.get(2), messageList.get(3), messageList.get(4), messageList.get(5));
            }
        }
        throw new AssertionError(messageList);
    }

    int getSuccessDisplayedLevel() {
        int reportedPassedTestsCount = this.totalTests - this.failures - this.errors - this.skipped - this.aborted;
        if (this.detectedPassedTests >= reportedPassedTestsCount) {
            return 2;
        }
        if (this.detectedPassedTests == 0) {
            return 0;
        }
        return 1;
    }

    public SystemAction[] getActions(boolean context) {
        return new SystemAction[0];
    }
}

