/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support.clank;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankMacroMap;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankSystemMacroMap;
import org.netbeans.modules.cnd.apt.support.api.PPMacroMap;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public class ClankFileMacroMap
extends ClankMacroMap {
    private ClankSystemMacroMap sysMacros;

    public ClankFileMacroMap() {
        super(0L);
    }

    public ClankFileMacroMap(ClankSystemMacroMap sysMacroMap, List<String> userMacros) {
        super(userMacros);
        this.sysMacros = sysMacroMap;
    }

    @Override
    public long getCompilationUnitCRC() {
        if (this.sysMacros == null) {
            return super.getCompilationUnitCRC();
        }
        return super.getCompilationUnitCRC() ^ this.sysMacros.getCompilationUnitCRC();
    }

    @Override
    public PPMacroMap.State getState() {
        return new FileStateImpl(this);
    }

    @Override
    public void setState(PPMacroMap.State state) {
        ((FileStateImpl)state).restoreTo(this);
    }

    Collection<String> getSystemMacroDefinitions() {
        return this.sysMacros == null ? Collections.emptyList() : this.sysMacros.getMacros();
    }

    Collection<String> getUserMacroDefinitions() {
        return this.getMacros();
    }

    @Override
    public String toString() {
        StringBuilder retValue = new StringBuilder();
        retValue.append("Own Map:\n");
        retValue.append(super.toString());
        retValue.append("System Map:\n");
        retValue.append(this.sysMacros);
        return retValue.toString();
    }

    public static final class FileStateImpl
    extends ClankMacroMap.StateImpl {
        private final ClankSystemMacroMap sysMacros;

        private FileStateImpl(ClankFileMacroMap macroMap) {
            super(macroMap);
            this.sysMacros = macroMap.sysMacros;
        }

        private FileStateImpl(FileStateImpl other, boolean cleaned) {
            super(other, cleaned);
            this.sysMacros = other.sysMacros;
        }

        @Override
        public void write(RepositoryDataOutput output) throws IOException {
            super.write(output);
        }

        public FileStateImpl(RepositoryDataInput input) throws IOException {
            super(input);
            this.sysMacros = null;
        }

        protected void restoreTo(ClankFileMacroMap macroMap) {
            super.restoreTo(macroMap);
            if (this.sysMacros != null) {
                macroMap.sysMacros = this.sysMacros;
            }
        }

        @Override
        public PPMacroMap.State copyCleaned() {
            return this.cleaned ? this : new FileStateImpl(this, true);
        }

        @Override
        public String toString() {
            StringBuilder retValue = new StringBuilder();
            retValue.append("FileState\n");
            retValue.append("Parent\n");
            retValue.append(super.toString());
            retValue.append("\nSystem MacroMap\n");
            if (System.getProperty("cnd.apt.macro.trace") != null) {
                retValue.append(this.sysMacros);
            } else if (this.sysMacros == null) {
                retValue.append("null");
            } else {
                retValue.append(System.identityHashCode(this.sysMacros));
            }
            return retValue.toString();
        }
    }
}

