/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.apt.impl.support.APTHandlersSupportImpl;
import org.netbeans.modules.cnd.apt.impl.support.APTPreprocessorToken;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.structure.APTIncludeNext;
import org.netbeans.modules.cnd.apt.structure.APTPragma;
import org.netbeans.modules.cnd.apt.structure.APTUndefine;
import org.netbeans.modules.cnd.apt.support.APTConditionResolver;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTIncludeFake;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTIncludeResolver;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenStream;
import org.netbeans.modules.cnd.apt.support.APTWalker;
import org.netbeans.modules.cnd.apt.support.IncludeDirEntry;
import org.netbeans.modules.cnd.apt.support.PostIncludeData;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.support.api.PPIncludeHandler;
import org.netbeans.modules.cnd.apt.support.api.PPMacroMap;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.apt.utils.TokenBasedTokenStream;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.cache.TinyMaps;
import org.openide.filesystems.FileSystem;

public abstract class APTAbstractWalker
extends APTWalker {
    private final APTPreprocHandler preprocHandler;
    private final CharSequence startPath;
    private final FileSystem startFileSystem;
    private final APTFileCacheEntry cacheEntry;
    private final Map<APT, Map<Object, Object>> nodeProperties = new IdentityHashMap<APT, Map<Object, Object>>();

    protected APTAbstractWalker(APTFile apt, PreprocHandler preprocHandler, APTFileCacheEntry cacheEntry) {
        super(apt, preprocHandler == null ? null : (APTMacroMap)preprocHandler.getMacroMap());
        this.startPath = apt.getPath();
        this.startFileSystem = apt.getFileSystem();
        this.preprocHandler = (APTPreprocHandler)preprocHandler;
        this.cacheEntry = cacheEntry;
    }

    @Override
    protected void preInit() {
        APTIncludeHandler includeHandler;
        super.preInit();
        if (this.preprocHandler != null && APTHandlersSupportImpl.isFirstLevel(includeHandler = (APTIncludeHandler)this.preprocHandler.getIncludeHandler())) {
            Collection<IncludeDirEntry> extractIncludeFileEntries = APTHandlersSupportImpl.extractIncludeFileEntries(includeHandler);
            int index = 0 - extractIncludeFileEntries.size();
            for (IncludeDirEntry includeDirEntry : extractIncludeFileEntries) {
                APTIncludeFake fake = new APTIncludeFake(includeDirEntry.getAsSharedCharSequence().toString(), index++);
                this.onAPT(fake, false);
            }
        }
    }

    @Override
    protected void onInclude(APT apt) {
        super.onInclude(apt);
        if (this.getIncludeHandler() != null) {
            APTIncludeResolver resolver = this.getIncludeHandler().getResolver(this.startFileSystem, this.startPath);
            ResolvedPath resolvedPath = resolver.resolveInclude((APTInclude)apt, this.getMacroMap());
            if (resolvedPath == null) {
                if (DebugUtils.STANDALONE) {
                    if (APTUtils.LOG.getLevel().intValue() <= Level.SEVERE.intValue()) {
                        System.err.println("FAILED INCLUDE: from " + CndPathUtilities.getBaseName((String)this.startPath.toString()) + " for:\n\t" + apt);
                    }
                } else {
                    APTUtils.LOG.log(Level.WARNING, "failed resolving path from {0} for {1}", new Object[]{this.startPath, apt});
                }
            }
            this.includeImpl(resolvedPath, (APTInclude)apt);
        }
    }

    @Override
    protected void onIncludeNext(APT apt) {
        super.onIncludeNext(apt);
        if (this.getIncludeHandler() != null) {
            APTIncludeResolver resolver = this.getIncludeHandler().getResolver(this.startFileSystem, this.startPath);
            ResolvedPath resolvedPath = resolver.resolveIncludeNext((APTIncludeNext)apt, this.getMacroMap());
            if (resolvedPath == null) {
                if (DebugUtils.STANDALONE) {
                    if (APTUtils.LOG.getLevel().intValue() <= Level.SEVERE.intValue()) {
                        System.err.println("FAILED INCLUDE: from " + CndPathUtilities.getBaseName((String)this.startPath.toString()) + " for:\n\t" + apt);
                    }
                } else {
                    APTUtils.LOG.log(Level.WARNING, "failed resolving path from {0} for {1}", new Object[]{this.startPath, apt});
                }
            }
            this.includeImpl(resolvedPath, (APTInclude)apt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void includeImpl(ResolvedPath resolvedPath, APTInclude aptInclude) {
        block9: {
            PPIncludeHandler.IncludeState inclState = this.beforeIncludeImpl(aptInclude, resolvedPath);
            try {
                if (this.cacheEntry != null) {
                    Object lock;
                    if (!this.startPath.equals(this.cacheEntry.getFilePath())) {
                        System.err.println("using not expected entry " + this.cacheEntry + " when work with file " + this.startPath);
                    }
                    if (this.cacheEntry.isSerial()) {
                        this.serialIncludeImpl(aptInclude, resolvedPath, inclState);
                        break block9;
                    }
                    Object object = lock = this.cacheEntry.getIncludeLock(aptInclude);
                    synchronized (object) {
                        this.serialIncludeImpl(aptInclude, resolvedPath, inclState);
                        break block9;
                    }
                }
                this.include(resolvedPath, inclState, aptInclude, null);
            }
            finally {
                this.afterIncludeImpl(aptInclude, resolvedPath, inclState);
            }
        }
    }

    protected abstract boolean include(ResolvedPath var1, PPIncludeHandler.IncludeState var2, APTInclude var3, PostIncludeData var4);

    protected abstract boolean hasIncludeActionSideEffects();

    @Override
    protected void onDefine(APT apt) {
        APTDefine define = (APTDefine)apt;
        if (define.isValid()) {
            this.getMacroMap().define(this.getCurFile(), define, APTMacro.Kind.DEFINED);
        } else if (DebugUtils.STANDALONE) {
            if (APTUtils.LOG.getLevel().intValue() <= Level.SEVERE.intValue()) {
                System.err.println("INCORRECT #define directive: in " + CndPathUtilities.getBaseName((String)this.startPath.toString()) + " for:\n\t" + apt);
            }
        } else {
            APTUtils.LOG.log(Level.SEVERE, "INCORRECT #define directive: in {0} for:\n\t{1}", new Object[]{CndPathUtilities.getBaseName((String)this.startPath.toString()), apt});
        }
    }

    @Override
    protected void onPragmaNode(APT apt) {
        APTPragma pragma = (APTPragma)apt;
        APTToken name = pragma.getName();
        if (name != null && "once".contentEquals(name.getTextID())) {
            if (this.getMacroMap().isDefined(this.getFileOnceMacroName())) {
                super.stop();
            } else {
                APTDefine fileOnce = APTUtils.createAPTDefineOnce(this.getFileOnceMacroName());
                this.getMacroMap().define(this.getCurFile(), fileOnce, APTMacro.Kind.DEFINED);
            }
        }
    }

    protected final CharSequence getFileOnceMacroName() {
        return APTUtils.getFileOnceMacroName(this.getCurFile());
    }

    @Override
    protected void onUndef(APT apt) {
        APTUndefine undef = (APTUndefine)apt;
        this.getMacroMap().undef(this.getCurFile(), undef.getName());
    }

    @Override
    protected boolean onIf(APT apt) {
        return this.eval(apt);
    }

    @Override
    protected boolean onIfdef(APT apt) {
        return this.eval(apt);
    }

    @Override
    protected boolean onIfndef(APT apt) {
        return this.eval(apt);
    }

    @Override
    protected boolean onElif(APT apt, boolean wasInPrevBranch) {
        return !wasInPrevBranch && this.eval(apt);
    }

    @Override
    protected boolean onElse(APT apt, boolean wasInPrevBranch) {
        return !wasInPrevBranch;
    }

    @Override
    protected void onEndif(APT apt, boolean wasInBranch) {
    }

    protected void onEval(APT apt, boolean result) {
    }

    protected APTPreprocHandler getPreprocHandler() {
        return this.preprocHandler;
    }

    protected APTIncludeHandler getIncludeHandler() {
        return (APTIncludeHandler)(this.getPreprocHandler() == null ? null : this.getPreprocHandler().getIncludeHandler());
    }

    protected boolean needPPTokens() {
        return false;
    }

    private boolean eval(APT apt) {
        if (APTUtils.LOG.isLoggable(Level.FINE)) {
            APTUtils.LOG.log(Level.FINE, "eval condition for {0}", new Object[]{apt});
        }
        boolean res = false;
        try {
            Boolean cachedRes;
            Boolean bl = cachedRes = this.cacheEntry != null ? this.cacheEntry.getEvalResult(apt) : null;
            if (cachedRes != null) {
                res = cachedRes;
            } else {
                res = APTConditionResolver.evaluate(apt, this.getMacroMap());
                if (this.cacheEntry != null) {
                    this.cacheEntry.setEvalResult(apt, res);
                }
            }
        }
        catch (TokenStreamException ex) {
            APTUtils.LOG.log(Level.SEVERE, "error on evaluating condition node {0}\n{1}", new Object[]{apt, ex});
        }
        this.onEval(apt, res);
        return res;
    }

    private void serialIncludeImpl(APTInclude aptInclude, ResolvedPath resolvedPath, PPIncludeHandler.IncludeState inclState) {
        PostIncludeData postIncludeData = this.cacheEntry.getPostIncludeState(aptInclude);
        if (postIncludeData.hasPostIncludeMacroState() && !this.hasIncludeActionSideEffects()) {
            this.getPreprocHandler().getMacroMap().setState(postIncludeData.getPostIncludeMacroState());
            return;
        }
        if (this.include(resolvedPath, inclState, aptInclude, postIncludeData)) {
            PPMacroMap.State postIncludeMacroState = this.getPreprocHandler().getMacroMap().getState();
            PostIncludeData newData = new PostIncludeData(postIncludeMacroState, postIncludeData.getDeadBlocks());
            this.cacheEntry.setIncludeData(aptInclude, newData);
        } else if (!postIncludeData.hasPostIncludeMacroState()) {
            postIncludeData.setDeadBlocks(null);
        }
    }

    private PPIncludeHandler.IncludeState beforeIncludeImpl(APTInclude aptInclude, ResolvedPath resolvedPath) {
        PPIncludeHandler.IncludeState inclState = this.pushInclude(aptInclude, resolvedPath);
        if (this.isTokenProducer() && this.needPPTokens()) {
            this.pushTokenStream(new TokenBasedTokenStream(new APTPreprocessorToken(aptInclude, Boolean.TRUE, inclState, resolvedPath, this.nodeProperties)));
        }
        return inclState;
    }

    private void afterIncludeImpl(APTInclude aptInclude, ResolvedPath resolvedPath, PPIncludeHandler.IncludeState inclState) {
        if (this.isTokenProducer() && this.needPPTokens()) {
            APTPreprocessorToken afterInclToken = new APTPreprocessorToken(aptInclude, Boolean.FALSE, inclState, resolvedPath, this.nodeProperties);
            this.pushTokenStream(new AfterIncludeTokenStream(afterInclToken));
        } else {
            this.popInclude(aptInclude, resolvedPath, inclState);
        }
    }

    protected PPIncludeHandler.IncludeState pushInclude(APTInclude aptInclude, ResolvedPath resolvedPath) {
        APTIncludeHandler includeHandler;
        PPIncludeHandler.IncludeState pushIncludeState = PPIncludeHandler.IncludeState.Fail;
        if (resolvedPath != null && (includeHandler = this.getIncludeHandler()) != null) {
            pushIncludeState = includeHandler.pushInclude(resolvedPath.getFileSystem(), resolvedPath.getPath(), aptInclude.getToken().getLine(), aptInclude.getToken().getOffset(), resolvedPath.getIndex(), this.getCurIncludeDirectiveFileIndex());
        }
        return pushIncludeState;
    }

    protected void popInclude(APTInclude aptInclude, ResolvedPath resolvedPath, PPIncludeHandler.IncludeState pushState) {
        APTIncludeHandler includeHandler;
        if (pushState == PPIncludeHandler.IncludeState.Success && (includeHandler = this.getIncludeHandler()) != null) {
            includeHandler.popInclude();
        }
    }

    protected final void putNodeProperty(APT node, Object key, Object value) {
        Map props = this.nodeProperties.get(node);
        if (props == null) {
            props = TinyMaps.createMap((int)2);
            this.nodeProperties.put(node, props);
        } else {
            Map expanded = TinyMaps.expandForNextKey(props, (Object)node);
            if (expanded != props) {
                props = expanded;
                this.nodeProperties.put(node, props);
            }
        }
        props.put(key, value);
    }

    protected final Object getNodeProperty(APT node, Object key) {
        Map<Object, Object> props = this.nodeProperties.get(node);
        return props == null ? null : props.get(key);
    }

    protected final void includeStream(APTFile apt, APTWalker walker) {
        TokenStream incTS = walker.getTokenStream();
        this.pushTokenStream(incTS);
    }

    private final class AfterIncludeTokenStream
    implements TokenStream,
    APTTokenStream {
        private APTPreprocessorToken token;
        private boolean first;

        public AfterIncludeTokenStream(APTPreprocessorToken token) {
            if (token == null) {
                throw new NullPointerException("not possible to create token stream for null token");
            }
            this.token = token;
            this.first = true;
        }

        @Override
        public APTToken nextToken() {
            APTToken ret;
            if (this.first) {
                ret = this.token;
                this.first = false;
                this.invokePopInclude(this.token);
            } else {
                ret = APTUtils.EOF_TOKEN;
            }
            return ret;
        }

        public String toString() {
            String retValue = "PPIS " + this.token.toString();
            return retValue;
        }

        private void invokePopInclude(APTPreprocessorToken ppToken) {
            assert (ppToken.getProperty(Boolean.class) == Boolean.FALSE);
            PPIncludeHandler.IncludeState pushState = (PPIncludeHandler.IncludeState)((Object)ppToken.getProperty(PPIncludeHandler.IncludeState.class));
            APTInclude aptInclude = (APTInclude)ppToken.getProperty(APT.class);
            ResolvedPath resolvedPath = (ResolvedPath)ppToken.getProperty(ResolvedPath.class);
            APTAbstractWalker.this.popInclude(aptInclude, resolvedPath, pushState);
        }
    }
}

