/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.util.Collection;
import java.util.List;
import org.clang.tools.services.support.FileInfoCallback;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankDriverImpl;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.support.Interrupter;
import org.openide.util.CharSequences;

public final class ClankDriver {
    private ClankDriver() {
    }

    public static int extractFileIndex(PreprocHandler ppHandler) {
        return ClankDriverImpl.extractFileIndex(ppHandler);
    }

    public static ClankPreprocessorOutput extractPreprocessorOutput(PreprocHandler ppHandler) {
        return ClankDriverImpl.extractPreprocessorOutputImplementation(ppHandler);
    }

    public static TokenStream extractPreparedTokenStream(ClankFileInfo file) {
        ClankPreprocessorOutput ppOutput = ClankDriver.extractPreparedPreprocessorOutput(file);
        if (ppOutput != null) {
            return ppOutput.getTokenStream();
        }
        return null;
    }

    public static ClankPreprocessorOutput extractPreparedPreprocessorOutput(ClankFileInfo file) {
        ClankDriverImpl.ClankPreprocessorOutputImplementation ppOutputImpl = ClankDriverImpl.extractPreprocessorOutputImplementation(file);
        if (ppOutputImpl != null) {
            return ppOutputImpl.prepareCachesIfPossible();
        }
        return null;
    }

    public static ClankPreprocessorOutput extractPreparedPreprocessorOutput(PreprocHandler ppHandler) {
        ClankDriverImpl.ClankPreprocessorOutputImplementation cache = ClankDriverImpl.extractPreprocessorOutputImplementation(ppHandler);
        return cache.prepareCachesIfPossible();
    }

    public static void preparePreprocessorOutputIfPossible(ClankFileInfo fileInfo) {
        if (fileInfo instanceof ClankDriverImpl.ClankPreprocessorOutputImplementation) {
            ((ClankDriverImpl.ClankPreprocessorOutputImplementation)((Object)fileInfo)).prepareCachesIfPossible();
        }
    }

    public static boolean preprocess(APTFileBuffer buffer, PreprocHandler ppHandler, ClankPreprocessorCallback callback, Interrupter interrupter) {
        return ClankDriverImpl.preprocessImpl(buffer, ppHandler, callback, interrupter);
    }

    public static void invalidate(APTFileBuffer buffer) {
        if (APTTraceFlags.USE_CLANK) {
            ClankDriverImpl.invalidateImpl(buffer);
        }
    }

    public static void invalidateAll() {
        if (APTTraceFlags.USE_CLANK) {
            ClankDriverImpl.invalidateAllImpl();
        }
    }

    public static void close() {
        if (APTTraceFlags.USE_CLANK) {
            ClankDriver.invalidateAll();
        }
    }

    public static interface ClankFileInfo {
        public CharSequence getFilePath();

        public int getFileIndex();

        public ClankInclusionDirective getInclusionDirective();

        public int[] getSkippedRanges();
    }

    public static interface ClankPreprocessorCallback {
        public void onInclusionDirective(ClankFileInfo var1, ClankInclusionDirective var2);

        public boolean onEnter(ClankFileInfo var1, ClankFileInfo var2);

        public boolean onExit(ClankFileInfo var1, ClankFileInfo var2);

        public boolean needPPDirectives();

        public boolean needTokens();

        public boolean needSkippedRanges();

        public boolean needMacroExpansion();

        public boolean needComments();
    }

    public static interface ClankInclusionDirective
    extends ClankPreprocessorDirective {
        public ResolvedPath getResolvedPath();

        public CharSequence getSpellingName();

        public boolean isAngled();

        public boolean isRecursive();

        public int getIncludeDirectiveIndex();
    }

    public static interface ClankErrorDirective
    extends ClankPreprocessorDirective {
        public CharSequence getMessage();

        public PreprocHandler.State getStateWhenMetErrorDirective();
    }

    public static interface ClankMacroDirective
    extends ClankPreprocessorDirective {
        public static final CharSequence BUILD_IN_FILE = CharSequences.create((CharSequence)"BUILD_IN_FILE");

        public boolean isDefined();

        public int getMacroNameLocation();

        public CharSequence getFile();

        public CharSequence getMacroName();

        public int getMacroNameOffset();

        public List<CharSequence> getParameters();
    }

    public static interface ClankPreprocessorDirective {
        public void setAnnotation(Object var1);

        public Object getAnnotation();

        public int getDirectiveStartOffset();

        public int getDirectiveEndOffset();
    }

    public static final class FileGuard {
        private final int startOfset;
        private final int endOfset;

        public FileGuard(int start, int end) {
            this.startOfset = start;
            this.endOfset = end;
        }

        public int getStartOfset() {
            return this.startOfset;
        }

        public int getEndOfset() {
            return this.endOfset;
        }
    }

    public static final class MacroUsage {
        private final int startOfset;
        private final int endOfset;
        private final ClankMacroDirective referencedMacro;

        public MacroUsage(int startOfset, int endOfset, ClankMacroDirective referencedDirective) {
            this.startOfset = startOfset;
            this.endOfset = endOfset;
            this.referencedMacro = referencedDirective;
        }

        public int getStartOfset() {
            return this.startOfset;
        }

        public int getEndOfset() {
            return this.endOfset;
        }

        public ClankMacroDirective getReferencedMacro() {
            return this.referencedMacro;
        }
    }

    public static final class MacroExpansion {
        private final int startOfset;
        private final int endOfset;
        private final int macroNameLength;
        private final ClankMacroDirective referencedMacro;

        public MacroExpansion(FileInfoCallback.MacroExpansionInfo expansion, ClankMacroDirective referencedDirective) {
            this.startOfset = expansion.getStartOffset();
            this.endOfset = expansion.getEndOffset();
            this.macroNameLength = expansion.getMacroNameLength();
            this.referencedMacro = referencedDirective;
        }

        public int getStartOfset() {
            return this.startOfset;
        }

        public int getEndOfset() {
            return this.endOfset;
        }

        public int getMacroNameLength() {
            return this.macroNameLength;
        }

        public ClankMacroDirective getReferencedMacro() {
            return this.referencedMacro;
        }
    }

    public static interface ClankPreprocessorOutput {
        public int getFileIndex();

        public int[] getSkippedRanges();

        public TokenStream getTokenStream();

        public boolean hasTokenStream();

        public Collection<ClankPreprocessorDirective> getPreprocessorDirectives();

        public Collection<MacroExpansion> getMacroExpansions();

        public Collection<MacroUsage> getMacroUsages();

        public FileGuard getFileGuard();
    }
}

