/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.Refreshable;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.cookies.ErrorLocator;
import org.netbeans.modules.xml.multiview.cookies.LinkCookie;
import org.netbeans.modules.xml.multiview.ui.RefreshDialog;
import org.netbeans.modules.xml.multiview.ui.RefreshSaveDialog;
import org.netbeans.modules.xml.multiview.ui.SectionNodePanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.RequestProcessor;

public abstract class SectionInnerPanel
extends JPanel
implements LinkCookie,
ErrorLocator {
    private static final RequestProcessor RP = new RequestProcessor(SectionInnerPanel.class);
    private SectionView sectionView;
    private List refreshableList = new LinkedList();
    private boolean localFocusListenerInitialized = false;
    private FocusListener localFocusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent evt) {
            FocusListener[] focusListeners = SectionInnerPanel.this.getFocusListeners();
            for (int i = 0; i < focusListeners.length; ++i) {
                focusListeners[i].focusGained(evt);
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
            SectionInnerPanel.this.processFocusEvent(evt);
        }
    };
    private RequestProcessor.Task refreshTask = RP.create(new Runnable(){

        @Override
        public void run() {
            SectionInnerPanel.this.refreshView();
        }
    });
    private static final int REFRESH_DELAY = 50;
    private FlushFocusListener activeListener = null;
    private boolean closing = false;

    public SectionInnerPanel(SectionView sectionView) {
        this.sectionView = sectionView;
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        super.addFocusListener(l);
        if (!this.localFocusListenerInitialized) {
            this.localFocusListenerInitialized = true;
            SectionInnerPanel container = this;
            FocusListener focusListener = this.localFocusListener;
            this.addFocusListenerRecursively(container, focusListener);
        }
    }

    private void addFocusListenerRecursively(Container container, FocusListener focusListener) {
        Component[] components = container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component.isFocusable() && !(component instanceof JLabel)) {
                component.addFocusListener(focusListener);
            }
            if (!(component instanceof Container) || component instanceof SectionNodePanel) continue;
            this.addFocusListenerRecursively((Container)component, focusListener);
        }
    }

    public SectionView getSectionView() {
        return this.sectionView;
    }

    public abstract void setValue(JComponent var1, Object var2);

    public void documentChanged(JTextComponent source, String value) {
    }

    public void rollbackValue(JTextComponent source) {
    }

    public final void addModifier(JTextComponent tc) {
        tc.addFocusListener(new ModifyFocusListener(tc));
    }

    public final void addModifier(JTextComponent tc, boolean test) {
        tc.addFocusListener(new ModifyFocusListener(tc, test));
    }

    public final void addModifier(JComboBox comboBox) {
        comboBox.addFocusListener(new ComboBoxModifyFocusListener(comboBox));
    }

    public final void addModifier(JComboBox comboBox, boolean test) {
        comboBox.addFocusListener(new ComboBoxModifyFocusListener(comboBox, test));
    }

    public final void addModifier(JRadioButton radioButton) {
        radioButton.addFocusListener(new RadioButtonModifyFocusListener(radioButton));
    }

    public final void addModifier(JCheckBox checkBox) {
        checkBox.addFocusListener(new CheckBoxModifyFocusListener(checkBox));
    }

    public final void addImmediateModifier(JCheckBox checkBox) {
        checkBox.addActionListener(new CheckBoxActionListener(checkBox));
    }

    public final void addImmediateModifier(JRadioButton radioButton) {
        radioButton.addActionListener(new RadioButtonActionListener(radioButton));
    }

    public final void addImmediateModifier(JComboBox comboBox) {
        comboBox.addActionListener(new ComboBoxActionListener(comboBox));
    }

    public final void addImmediateModifier(JTextComponent tc) {
        tc.getDocument().addDocumentListener(new TextListener(tc, true));
    }

    public final void addValidatee(JTextComponent tc) {
        tc.getDocument().addDocumentListener(new TextListener(tc));
        tc.addFocusListener(new ValidateFocusListener(tc));
    }

    protected void scheduleRefreshView() {
        this.refreshTask.schedule(50);
    }

    public void refreshView() {
        Iterator it = this.refreshableList.iterator();
        while (it.hasNext()) {
            ((Refreshable)it.next()).refresh();
        }
    }

    protected void addRefreshable(Refreshable refreshable) {
        this.refreshableList.add(refreshable);
    }

    public void dataModelPropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        this.scheduleRefreshView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canClose() {
        this.closing = true;
        try {
            if (this.activeListener != null) {
                boolean bl = this.activeListener.flushData();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.closing = false;
        }
    }

    protected void signalUIChange() {
    }

    protected void startUIChange() {
    }

    protected void endUIChange() {
    }

    private class CheckBoxModifyFocusListener
    extends FlushFocusListener {
        private boolean orgValue;
        private final JCheckBox checkBox;

        public CheckBoxModifyFocusListener(JCheckBox checkBox) {
            this.checkBox = checkBox;
        }

        @Override
        public void focusGained(FocusEvent evt) {
            this.orgValue = this.checkBox.isSelected();
            SectionInnerPanel.this.activeListener = this;
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (!SectionInnerPanel.this.closing) {
                this.flushData();
                SectionInnerPanel.this.activeListener = null;
            }
        }

        @Override
        public boolean flushData() {
            if (this.checkBox.isSelected() != this.orgValue) {
                SectionInnerPanel.this.startUIChange();
                SectionInnerPanel.this.setValue(this.checkBox, this.checkBox.isSelected());
                SectionInnerPanel.this.signalUIChange();
                SectionInnerPanel.this.endUIChange();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean canClose() {
            SectionInnerPanel.this.closing = true;
            try {
                if (SectionInnerPanel.this.activeListener != null) {
                    boolean bl = SectionInnerPanel.this.activeListener.flushData();
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                SectionInnerPanel.this.closing = false;
            }
        }
    }

    private class RadioButtonActionListener
    extends FlushActionListener {
        private final JRadioButton radioButton;

        public RadioButtonActionListener(JRadioButton radioButton) {
            this.radioButton = radioButton;
        }

        @Override
        public void doSetValue(ActionEvent e) {
            SectionInnerPanel.this.setValue(this.radioButton, this.radioButton.isSelected());
        }
    }

    private class CheckBoxActionListener
    extends FlushActionListener {
        private final JCheckBox checkBox;

        public CheckBoxActionListener(JCheckBox checkBox) {
            this.checkBox = checkBox;
        }

        @Override
        public void doSetValue(ActionEvent e) {
            SectionInnerPanel.this.setValue(this.checkBox, this.checkBox.isSelected());
        }
    }

    private class ComboBoxActionListener
    extends FlushActionListener {
        private final JComboBox comboBox;

        public ComboBoxActionListener(JComboBox comboBox) {
            this.comboBox = comboBox;
        }

        @Override
        public void doSetValue(ActionEvent e) {
            SectionInnerPanel.this.setValue(this.comboBox, this.comboBox.getSelectedItem());
        }
    }

    private abstract class FlushActionListener
    implements ActionListener {
        private FlushActionListener() {
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            SectionInnerPanel.this.startUIChange();
            this.doSetValue(e);
            SectionInnerPanel.this.signalUIChange();
            SectionInnerPanel.this.endUIChange();
        }

        public abstract void doSetValue(ActionEvent var1);
    }

    private class RadioButtonModifyFocusListener
    extends FlushFocusListener {
        private boolean orgValue;
        private final JRadioButton radioButton;

        public RadioButtonModifyFocusListener(JRadioButton radioButton) {
            this.radioButton = radioButton;
        }

        @Override
        public void focusGained(FocusEvent evt) {
            this.orgValue = this.radioButton.isSelected();
            SectionInnerPanel.this.activeListener = this;
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (!SectionInnerPanel.this.closing) {
                this.flushData();
                SectionInnerPanel.this.activeListener = null;
            }
        }

        @Override
        public boolean flushData() {
            if (this.radioButton.isSelected() != this.orgValue) {
                SectionInnerPanel.this.startUIChange();
                SectionInnerPanel.this.setValue(this.radioButton, this.radioButton.isSelected());
                SectionInnerPanel.this.signalUIChange();
                SectionInnerPanel.this.endUIChange();
            }
            return true;
        }
    }

    private class ComboBoxModifyFocusListener
    extends FlushFocusListener {
        private Object orgValue;
        private final JComboBox comboBox;
        private boolean test;

        public ComboBoxModifyFocusListener(JComboBox comboBox) {
            this(comboBox, true);
        }

        public ComboBoxModifyFocusListener(JComboBox comboBox, boolean test) {
            this.comboBox = comboBox;
            this.test = test;
        }

        @Override
        public void focusGained(FocusEvent evt) {
            this.orgValue = this.comboBox.getSelectedItem();
            SectionInnerPanel.this.activeListener = this;
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (!SectionInnerPanel.this.closing) {
                this.flushData();
                SectionInnerPanel.this.activeListener = null;
            }
        }

        @Override
        public boolean flushData() {
            boolean newEqualsOld;
            Object newValue = this.comboBox.getSelectedItem();
            boolean bl = newValue == null ? this.orgValue == null : (newEqualsOld = newValue.equals(this.orgValue));
            if (!this.test || !newEqualsOld) {
                SectionInnerPanel.this.startUIChange();
                SectionInnerPanel.this.setValue(this.comboBox, this.comboBox.getSelectedItem());
                SectionInnerPanel.this.signalUIChange();
                SectionInnerPanel.this.endUIChange();
            }
            return true;
        }
    }

    private class ModifyFocusListener
    extends FlushFocusListener {
        private String orgValue;
        private final JTextComponent tc;
        private boolean test;

        public ModifyFocusListener(JTextComponent tc) {
            this(tc, true);
        }

        public ModifyFocusListener(JTextComponent tc, boolean test) {
            this.tc = tc;
            this.test = test;
        }

        @Override
        public void focusGained(FocusEvent evt) {
            this.orgValue = this.tc.getText();
            SectionInnerPanel.this.activeListener = this;
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (!SectionInnerPanel.this.closing) {
                this.flushData();
                SectionInnerPanel.this.activeListener = null;
            }
        }

        @Override
        public boolean flushData() {
            if (!this.test || !this.tc.getText().equals(this.orgValue)) {
                SectionInnerPanel.this.startUIChange();
                SectionInnerPanel.this.setValue(this.tc, this.tc.getText());
                SectionInnerPanel.this.signalUIChange();
                SectionInnerPanel.this.endUIChange();
            }
            return true;
        }
    }

    private class ValidateFocusListener
    extends FlushFocusListener {
        private String orgValue;
        private boolean viewIsBuggy;
        private final JTextComponent tc;
        private boolean disable;

        public ValidateFocusListener(JTextComponent tc) {
            this.tc = tc;
        }

        @Override
        public void focusGained(FocusEvent evt) {
            SectionInnerPanel.this.activeListener = this;
            this.orgValue = this.tc.getText();
            this.viewIsBuggy = SectionInnerPanel.this.sectionView.getErrorPanel().getError() != null;
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (!SectionInnerPanel.this.closing) {
                if (!this.flushData()) {
                    Utils.runInAwtDispatchThread(new Runnable(){

                        @Override
                        public void run() {
                            ValidateFocusListener.this.tc.requestFocus();
                        }
                    });
                } else {
                    this.disable = false;
                    SectionInnerPanel.this.activeListener = null;
                }
            }
        }

        @Override
        public boolean flushData() {
            Error error = SectionInnerPanel.this.sectionView.getErrorPanel().getError();
            if (error != null && error.isEditError() && this.tc == error.getFocusableComponent()) {
                if (1 == error.getSeverityLevel() && !this.disable) {
                    RefreshSaveDialog desc = new RefreshSaveDialog(SectionInnerPanel.this.sectionView.getErrorPanel());
                    Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)desc);
                    dialog.setVisible(true);
                    Integer opt = (Integer)desc.getValue();
                    if (opt.equals(RefreshSaveDialog.OPTION_FIX)) {
                        this.disable = true;
                        return false;
                    }
                    if (opt.equals(RefreshSaveDialog.OPTION_REFRESH)) {
                        SectionInnerPanel.this.rollbackValue(this.tc);
                        SectionInnerPanel.this.sectionView.checkValidity();
                    } else {
                        SectionInnerPanel.this.startUIChange();
                        SectionInnerPanel.this.setValue(this.tc, this.tc.getText());
                        SectionInnerPanel.this.signalUIChange();
                        SectionInnerPanel.this.endUIChange();
                        SectionInnerPanel.this.sectionView.checkValidity();
                    }
                } else if (!this.disable) {
                    RefreshDialog desc = new RefreshDialog(SectionInnerPanel.this.sectionView.getErrorPanel());
                    Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)desc);
                    dialog.setVisible(true);
                    Integer opt = (Integer)desc.getValue();
                    if (opt.equals(RefreshDialog.OPTION_FIX)) {
                        this.disable = true;
                        return false;
                    }
                    if (opt.equals(RefreshDialog.OPTION_REFRESH)) {
                        SectionInnerPanel.this.rollbackValue(this.tc);
                        SectionInnerPanel.this.sectionView.checkValidity();
                    }
                }
            } else if (!this.tc.getText().equals(this.orgValue)) {
                SectionInnerPanel.this.startUIChange();
                SectionInnerPanel.this.setValue(this.tc, this.tc.getText());
                SectionInnerPanel.this.signalUIChange();
                SectionInnerPanel.this.endUIChange();
                SectionInnerPanel.this.sectionView.checkValidity();
            } else if (this.viewIsBuggy) {
                SectionInnerPanel.this.sectionView.checkValidity();
            }
            this.disable = false;
            return true;
        }
    }

    private abstract class FlushFocusListener
    extends FocusAdapter {
        private FlushFocusListener() {
        }

        public abstract boolean flushData();
    }

    private class TextListener
    implements DocumentListener {
        private JTextComponent tc;
        private boolean setValue = false;

        TextListener(JTextComponent tc) {
            this(tc, false);
        }

        TextListener(JTextComponent tc, boolean setValue) {
            this.tc = tc;
            this.setValue = setValue;
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
            this.update(evt);
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            this.update(evt);
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            this.update(evt);
        }

        private void update(DocumentEvent evt) {
            if (this.setValue) {
                SectionInnerPanel.this.startUIChange();
                SectionInnerPanel.this.setValue(this.tc, this.tc.getText());
                SectionInnerPanel.this.signalUIChange();
                SectionInnerPanel.this.endUIChange();
            } else {
                SectionInnerPanel.this.documentChanged(this.tc, this.tc.getText());
            }
        }
    }
}

