/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.TwoStateHoverProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.animator.AnimatorEvent;
import org.netbeans.api.visual.animator.AnimatorListener;
import org.netbeans.api.visual.export.SceneExporter;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.GraphLayoutFactory;
import org.netbeans.api.visual.graph.layout.GraphLayoutSupport;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.maven.api.CommonArtifactActions;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.graph.ArtifactGraphEdge;
import org.netbeans.modules.maven.graph.ArtifactGraphNode;
import org.netbeans.modules.maven.graph.ArtifactWidget;
import org.netbeans.modules.maven.graph.Bundle;
import org.netbeans.modules.maven.graph.CenteredZoomAnimator;
import org.netbeans.modules.maven.graph.DependencyGraphTopComponent;
import org.netbeans.modules.maven.graph.EdgeWidget;
import org.netbeans.modules.maven.graph.FixVersionConflictPanel;
import org.netbeans.modules.maven.graph.FruchtermanReingoldLayout;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.Exclusion;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Profile;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DependencyGraphScene
extends GraphScene<ArtifactGraphNode, ArtifactGraphEdge>
implements Runnable {
    private static final RequestProcessor RP = new RequestProcessor(DependencyGraphScene.class);
    private static final Logger LOG = Logger.getLogger(DependencyGraphScene.class.getName());
    private LayerWidget mainLayer;
    private final LayerWidget connectionLayer;
    private ArtifactGraphNode rootNode;
    private final AllActionsProvider allActionsP = new AllActionsProvider();
    private final WidgetAction moveAction = ActionFactory.createMoveAction(null, (MoveProvider)this.allActionsP);
    private final WidgetAction popupMenuAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)this.allActionsP);
    private final WidgetAction zoomAction = ActionFactory.createMouseCenteredZoomAction((double)1.1);
    private final WidgetAction panAction = ActionFactory.createPanAction();
    private final WidgetAction editAction = ActionFactory.createEditAction((EditProvider)this.allActionsP);
    WidgetAction hoverAction = ActionFactory.createHoverAction((TwoStateHoverProvider)new HoverController());
    Action sceneZoomToFitAction = new SceneZoomToFitAction();
    Action highlitedZoomToFitAction = new HighlightedZoomToFitAction();
    private FruchtermanReingoldLayout layout;
    private int maxDepth = 0;
    private final MavenProject project;
    private final Project nbProject;
    private final DependencyGraphTopComponent tc;
    private FitToViewLayout fitViewL;
    private static final Set<ArtifactGraphNode> EMPTY_SELECTION = new HashSet<ArtifactGraphNode>();
    private final POMModel model;
    private final Map<Artifact, Icon> projectIcons;
    private JScrollPane pane;
    private AtomicBoolean animated = new AtomicBoolean(false);

    DependencyGraphScene(MavenProject prj, Project nbProj, DependencyGraphTopComponent tc, POMModel model) {
        this.project = prj;
        this.nbProject = nbProj;
        this.tc = tc;
        this.model = model;
        this.mainLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.mainLayer);
        this.connectionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.connectionLayer);
        LayerWidget glasspane = new LayerWidget((Scene)this){

            protected void paintChildren() {
                if (this.isCheckClipping()) {
                    Rectangle clipBounds = DependencyGraphScene.this.getGraphics().getClipBounds();
                    for (Widget child : DependencyGraphScene.this.mainLayer.getChildren()) {
                        Point location = child.getLocation();
                        Rectangle bounds = child.getBounds();
                        bounds.translate(location.x, location.y);
                        if (clipBounds != null && !bounds.intersects(clipBounds)) continue;
                        child.paint();
                    }
                } else {
                    for (Widget child : DependencyGraphScene.this.mainLayer.getChildren()) {
                        child.paint();
                    }
                }
            }
        };
        this.addChild((Widget)glasspane);
        this.getActions().addAction(this.hoverAction);
        this.getActions().addAction(ActionFactory.createSelectAction((SelectProvider)this.allActionsP));
        this.getActions().addAction(this.zoomAction);
        this.getActions().addAction(this.panAction);
        this.getActions().addAction(this.editAction);
        this.getActions().addAction(this.popupMenuAction);
        this.projectIcons = this.getIconsForOpenProjects();
    }

    private Map<Artifact, Icon> getIconsForOpenProjects() {
        Project[] openProjects;
        HashMap<Artifact, Icon> result = new HashMap<Artifact, Icon>();
        for (Project project : openProjects = OpenProjects.getDefault().getOpenProjects()) {
            NbMavenProject mavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
            if (null == mavenProject) continue;
            Artifact artifact = mavenProject.getMavenProject().getArtifact();
            Icon icon = ProjectUtils.getInformation((Project)project).getIcon();
            if (null == icon) continue;
            result.put(artifact, icon);
        }
        return result;
    }

    void setMyZoomFactor(double zoom) {
        this.setZoomFactor(zoom);
        ArrayList arr = new ArrayList();
        arr.addAll(this.mainLayer.getChildren());
        arr.addAll(this.connectionLayer.getChildren());
        for (Widget wid : arr) {
            if (wid instanceof ArtifactWidget) {
                ((ArtifactWidget)wid).updateReadableZoom();
            }
            if (!(wid instanceof EdgeWidget)) continue;
            ((EdgeWidget)wid).updateReadableZoom();
        }
    }

    void initialLayout() {
        this.layout = new FruchtermanReingoldLayout(this, this.pane);
        this.layout.invokeLayout();
        this.addSceneListener(new Scene.SceneListener(){

            public void sceneRepaint() {
            }

            public void sceneValidating() {
            }

            public void sceneValidated() {
                if (DependencyGraphScene.this.animated.compareAndSet(false, true)) {
                    new SceneZoomToFitAction().actionPerformed(null);
                }
            }
        });
    }

    void setSurroundingScrollPane(JScrollPane pane) {
        this.pane = pane;
    }

    ArtifactGraphNode getRootGraphNode() {
        return this.rootNode;
    }

    int getMaxNodeDepth() {
        return this.maxDepth;
    }

    Project getNbProject() {
        return this.nbProject;
    }

    MavenProject getMavenProject() {
        return this.project;
    }

    boolean isAnimated() {
        return this.animated.get();
    }

    @CheckForNull
    ArtifactGraphNode getGraphNodeRepresentant(DependencyNode node) {
        for (ArtifactGraphNode grnode : this.getNodes()) {
            if (!grnode.represents(node)) continue;
            return grnode;
        }
        return null;
    }

    protected Widget attachNodeWidget(ArtifactGraphNode node) {
        if (this.rootNode == null) {
            this.rootNode = node;
        }
        if (node.getPrimaryLevel() > this.maxDepth) {
            this.maxDepth = node.getPrimaryLevel();
        }
        Artifact artifact = node.getArtifact().getArtifact();
        Icon icon = this.projectIcons.get(artifact);
        ArtifactWidget root = new ArtifactWidget(this, node, icon);
        this.mainLayer.addChild((Widget)root);
        node.setWidget(root);
        root.setOpaque(true);
        root.getActions().addAction(this.createObjectHoverAction());
        root.getActions().addAction(this.createSelectAction());
        root.getActions().addAction(this.moveAction);
        root.getActions().addAction(this.editAction);
        root.getActions().addAction(this.popupMenuAction);
        return root;
    }

    protected Widget attachEdgeWidget(ArtifactGraphEdge edge) {
        EdgeWidget connectionWidget = new EdgeWidget(this, edge);
        this.connectionLayer.addChild((Widget)connectionWidget);
        return connectionWidget;
    }

    protected void attachEdgeSourceAnchor(ArtifactGraphEdge edge, ArtifactGraphNode oldsource, ArtifactGraphNode source) {
        ((ConnectionWidget)this.findWidget(edge)).setSourceAnchor(AnchorFactory.createRectangularAnchor((Widget)this.findWidget(source)));
    }

    protected void attachEdgeTargetAnchor(ArtifactGraphEdge edge, ArtifactGraphNode oldtarget, ArtifactGraphNode target) {
        ArtifactWidget wid = (ArtifactWidget)this.findWidget(target);
        ((ConnectionWidget)this.findWidget(edge)).setTargetAnchor(AnchorFactory.createRectangularAnchor((Widget)wid));
    }

    void highlightRelated(ArtifactGraphNode node) {
        ArrayList<ArtifactGraphNode> importantNodes = new ArrayList<ArtifactGraphNode>();
        ArrayList<ArtifactGraphEdge> otherPathsEdges = new ArrayList<ArtifactGraphEdge>();
        ArrayList<ArtifactGraphEdge> primaryPathEdges = new ArrayList<ArtifactGraphEdge>();
        ArrayList<ArtifactGraphNode> childrenNodes = new ArrayList<ArtifactGraphNode>();
        ArrayList childrenEdges = new ArrayList();
        importantNodes.add(node);
        List children = node.getArtifact().getChildren();
        for (DependencyNode n : children) {
            ArtifactGraphNode child = this.getGraphNodeRepresentant(n);
            if (child == null) continue;
            childrenNodes.add(child);
        }
        childrenEdges.addAll(this.findNodeEdges(node, true, false));
        this.addPathToRoot(node, primaryPathEdges, importantNodes);
        ArrayList<DependencyNode> representants = new ArrayList<DependencyNode>(node.getDuplicatesOrConflicts());
        for (DependencyNode curRep : representants) {
            this.addPathToRoot(curRep, curRep.getParent(), otherPathsEdges, importantNodes);
        }
        for (ArtifactGraphEdge curE : this.getEdges()) {
            EdgeWidget ew = (EdgeWidget)this.findWidget(curE);
            if (primaryPathEdges.contains(curE)) {
                ew.setState(4);
                continue;
            }
            if (otherPathsEdges.contains(curE)) {
                ew.setState(3);
                continue;
            }
            if (childrenEdges.contains(curE)) {
                ew.setState(1);
                continue;
            }
            ew.setState(0);
        }
        for (ArtifactGraphNode curN : this.getNodes()) {
            ArtifactWidget aw = (ArtifactWidget)this.findWidget(curN);
            if (importantNodes.contains(curN)) {
                aw.setPaintState(2);
                aw.setReadable(true);
                continue;
            }
            if (childrenNodes.contains(curN)) {
                aw.setPaintState(2);
                aw.setReadable(true);
                continue;
            }
            aw.setPaintState(0);
            aw.setReadable(false);
        }
    }

    private void addPathToRoot(ArtifactGraphNode node, List<ArtifactGraphEdge> edges, List<ArtifactGraphNode> nodes) {
        DependencyNode parentDepN = node.getArtifactParent();
        this.addPathToRoot(node.getArtifact(), parentDepN, edges, nodes);
    }

    private void addPathToRoot(DependencyNode depN, DependencyNode parentDepN, List<ArtifactGraphEdge> edges, List<ArtifactGraphNode> nodes) {
        while (parentDepN != null) {
            ArtifactGraphNode grNode = this.getGraphNodeRepresentant(parentDepN);
            if (grNode == null) {
                return;
            }
            ArtifactGraphNode targetNode = this.getGraphNodeRepresentant(depN);
            if (targetNode == null) {
                return;
            }
            edges.addAll(this.findEdgesBetween(grNode, targetNode));
            nodes.add(grNode);
            depN = parentDepN;
            parentDepN = grNode.getArtifactParent();
        }
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        super.notifyStateChanged(previousState, state);
        if (!previousState.isSelected() && state.isSelected()) {
            this.tc.depthHighlight();
        }
    }

    private FitToViewLayout getFitToViewLayout() {
        if (this.fitViewL == null) {
            this.fitViewL = new FitToViewLayout(this);
        }
        return this.fitViewL;
    }

    boolean isEditable() {
        return this.model != null;
    }

    static boolean isFixCandidate(ArtifactGraphNode node) {
        Set<DependencyNode> conf = node.getDuplicatesOrConflicts();
        DefaultArtifactVersion nodeV = new DefaultArtifactVersion(node.getArtifact().getArtifact().getVersion());
        for (DependencyNode dn : conf) {
            if (dn.getState() != 2 || nodeV.compareTo((Object)new DefaultArtifactVersion(dn.getArtifact().getVersion())) >= 0) continue;
            return true;
        }
        return false;
    }

    static ArtifactVersion findNewest(ArtifactGraphNode node, boolean all) {
        Set<DependencyNode> conf = node.getDuplicatesOrConflicts();
        DefaultArtifactVersion result = new DefaultArtifactVersion(node.getArtifact().getArtifact().getVersion());
        DefaultArtifactVersion curV = null;
        for (DependencyNode dn : conf) {
            if (!all && dn.getState() != 2 || result.compareTo((Object)(curV = new DefaultArtifactVersion(dn.getArtifact().getVersion()))) >= 0) continue;
            result = curV;
        }
        return result;
    }

    void invokeFixConflict(ArtifactGraphNode node) {
        new FixVersionConflictAction(node).actionPerformed(null);
    }

    private void excludeDepFromModel(ArtifactGraphNode node, Set<Artifact> exclTargets) {
        assert (this.model.isIntransaction()) : "Must be called inside transaction";
        Artifact nodeArtif = node.getArtifact().getArtifact();
        for (Artifact eTarget : exclTargets) {
            Exclusion ex;
            Dependency dep = this.model.getProject().findDependencyById(eTarget.getGroupId(), eTarget.getArtifactId(), null);
            if (dep == null) {
                ArrayList<String> profileNames = new ArrayList<String>();
                NbMavenProject nbMavproject = (NbMavenProject)this.nbProject.getLookup().lookup(NbMavenProject.class);
                for (org.apache.maven.model.Profile prof : nbMavproject.getMavenProject().getActiveProfiles()) {
                    profileNames.add(prof.getId());
                }
                for (String profileId : profileNames) {
                    Profile modProf = this.model.getProject().findProfileById(profileId);
                    if (modProf == null || (dep = modProf.findDependencyById(eTarget.getGroupId(), eTarget.getArtifactId(), null)) == null) continue;
                    break;
                }
            }
            if (dep == null) {
                dep = this.model.getFactory().createDependency();
                dep.setGroupId(eTarget.getGroupId());
                dep.setArtifactId(eTarget.getArtifactId());
                dep.setType(eTarget.getType());
                dep.setVersion(eTarget.getVersion());
                this.model.getProject().addDependency(dep);
            }
            if ((ex = dep.findExclusionById(nodeArtif.getGroupId(), nodeArtif.getArtifactId())) != null) continue;
            ex = this.model.getFactory().createExclusion();
            ex.setGroupId(nodeArtif.getGroupId());
            ex.setArtifactId(nodeArtif.getArtifactId());
            dep.addExclusion(ex);
        }
    }

    private void updateGraphAfterExclusion(ArtifactGraphNode node, Set<Artifact> exclTargets, Set<DependencyNode> exclParents) {
        boolean shouldValidate = false;
        HashSet<DependencyNode> toExclude = new HashSet<DependencyNode>();
        block0: for (DependencyNode dn : node.getDuplicatesOrConflicts()) {
            if (dn.getState() != 2) continue;
            for (DependencyNode curDn = dn.getParent(); curDn != null; curDn = curDn.getParent()) {
                if (!exclTargets.contains(curDn.getArtifact())) continue;
                toExclude.add(dn);
                continue block0;
            }
        }
        ArrayList<ArtifactGraphEdge> edges2Exclude = new ArrayList<ArtifactGraphEdge>();
        Collection incoming = this.findNodeEdges(node, false, true);
        ArtifactGraphNode sourceNode = null;
        boolean primaryExcluded = false;
        block2: for (ArtifactGraphEdge age : incoming) {
            sourceNode = (ArtifactGraphNode)this.getEdgeSource(age);
            if (sourceNode == null) continue;
            for (DependencyNode dn : exclParents) {
                if (sourceNode.getArtifact().equals((Object)dn)) {
                    primaryExcluded = true;
                }
                if (!sourceNode.represents(dn)) continue;
                edges2Exclude.add(age);
                continue block2;
            }
        }
        node.getDuplicatesOrConflicts().removeAll(toExclude);
        for (ArtifactGraphEdge age : edges2Exclude) {
            this.removeEdge(age);
            age.getSource().removeChild(age.getTarget());
            shouldValidate = true;
        }
        incoming = this.findNodeEdges(node, false, true);
        if (primaryExcluded) {
            ArtifactVersion newVersion = DependencyGraphScene.findNewest(node, true);
            node.getArtifact().getArtifact().setVersion(newVersion.toString());
            for (ArtifactGraphEdge age : incoming) {
                EdgeWidget curEw = (EdgeWidget)this.findWidget(age);
                if (curEw == null) continue;
                curEw.modelChanged();
            }
        }
        if (incoming.isEmpty()) {
            this.removeSubGraph(node);
            shouldValidate = true;
        } else {
            node.getWidget().modelChanged();
        }
        if (shouldValidate) {
            this.validate();
        }
    }

    private void removeSubGraph(ArtifactGraphNode node) {
        if (!this.isNode(node)) {
            return;
        }
        Collection incoming = this.findNodeEdges(node, false, true);
        if (!incoming.isEmpty()) {
            return;
        }
        Collection outgoing = this.findNodeEdges(node, true, false);
        ArrayList<ArtifactGraphNode> children = new ArrayList<ArtifactGraphNode>();
        DependencyNode dn = null;
        ArtifactGraphNode childNode = null;
        for (ArtifactGraphEdge artifactGraphEdge : outgoing) {
            dn = artifactGraphEdge.getTarget();
            childNode = this.getGraphNodeRepresentant(dn);
            if (childNode == null) continue;
            children.add(childNode);
            this.removeEdge(artifactGraphEdge);
            artifactGraphEdge.getSource().removeChild(dn);
            childNode.getDuplicatesOrConflicts().remove(dn);
        }
        for (ArtifactGraphNode artifactGraphNode : children) {
            this.removeSubGraph(artifactGraphNode);
        }
        this.removeNode(node);
    }

    @Override
    public void run() {
        try {
            this.tc.saveChanges(this.model);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void fitToZoomAfterLayout() {
        this.getSceneAnimator().getPreferredLocationAnimator().addAnimatorListener(new AnimatorListener(){

            public void animatorStarted(AnimatorEvent event) {
            }

            public void animatorReset(AnimatorEvent event) {
            }

            public void animatorFinished(AnimatorEvent event) {
                DependencyGraphScene.this.getSceneAnimator().getPreferredLocationAnimator().removeAnimatorListener((AnimatorListener)this);
                new SceneZoomToFitAction().actionPerformed(null);
            }

            public void animatorPreTick(AnimatorEvent event) {
            }

            public void animatorPostTick(AnimatorEvent event) {
            }
        });
    }

    private class FruchtermanReingoldLayoutAction
    extends AbstractAction {
        FruchtermanReingoldLayoutAction() {
            this.putValue("Name", Bundle.ACT_Layout_FruchtermanReingoldLayout());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DependencyGraphScene.this.layout.invokeLayout();
            DependencyGraphScene.this.fitToZoomAfterLayout();
        }
    }

    private class TreeGraphLayoutHorizontalAction
    extends AbstractAction {
        TreeGraphLayoutHorizontalAction() {
            this.putValue("Name", Bundle.ACT_Layout_TreeGraphLayoutHorizontal());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphLayout layout = GraphLayoutFactory.createTreeGraphLayout((int)10, (int)10, (int)50, (int)50, (boolean)false);
            GraphLayoutSupport.setTreeGraphLayoutRootNode((GraphLayout)layout, (Object)DependencyGraphScene.this.rootNode);
            layout.layoutGraph((GraphScene)DependencyGraphScene.this);
            DependencyGraphScene.this.fitToZoomAfterLayout();
        }
    }

    private class TreeGraphLayoutVerticalAction
    extends AbstractAction {
        TreeGraphLayoutVerticalAction() {
            this.putValue("Name", Bundle.ACT_Layout_TreeGraphLayoutVertical());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphLayout layout = GraphLayoutFactory.createTreeGraphLayout((int)10, (int)10, (int)50, (int)50, (boolean)true);
            GraphLayoutSupport.setTreeGraphLayoutRootNode((GraphLayout)layout, (Object)DependencyGraphScene.this.rootNode);
            layout.layoutGraph((GraphScene)DependencyGraphScene.this);
            DependencyGraphScene.this.fitToZoomAfterLayout();
        }
    }

    private class HierarchicalGraphLayoutAction
    extends AbstractAction {
        HierarchicalGraphLayoutAction() {
            this.putValue("Name", Bundle.ACT_Layout_HierarchicalGraphLayout());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphLayout layout = GraphLayoutFactory.createHierarchicalGraphLayout((GraphScene)DependencyGraphScene.this, (boolean)DependencyGraphScene.this.isAnimated(), (boolean)false);
            layout.layoutGraph((GraphScene)DependencyGraphScene.this);
            DependencyGraphScene.this.fitToZoomAfterLayout();
        }
    }

    private static class HoverController
    implements TwoStateHoverProvider {
        private HoverController() {
        }

        public void unsetHovering(Widget widget) {
            ArtifactWidget aw = this.findArtifactW(widget);
            if (widget != null) {
                aw.bulbUnhovered();
            }
        }

        public void setHovering(Widget widget) {
            ArtifactWidget aw = this.findArtifactW(widget);
            if (aw != null) {
                aw.bulbHovered();
            }
        }

        private ArtifactWidget findArtifactW(Widget w) {
            while (w != null && !(w instanceof ArtifactWidget)) {
                w = w.getParentWidget();
            }
            return (ArtifactWidget)w;
        }
    }

    private class FixVersionConflictAction
    extends AbstractAction {
        private final ArtifactGraphNode node;
        private final Artifact nodeArtif;

        FixVersionConflictAction(ArtifactGraphNode node) {
            this.node = node;
            this.nodeArtif = node.getArtifact().getArtifact();
            this.putValue("Name", Bundle.ACT_FixVersionConflict());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FixVersionConflictPanel fixPanel = new FixVersionConflictPanel(DependencyGraphScene.this, this.node);
            DialogDescriptor dd = new DialogDescriptor((Object)fixPanel, Bundle.TIT_FixConflict());
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (ret == DialogDescriptor.OK_OPTION) {
                FixVersionConflictPanel.FixDescription res = fixPanel.getResult();
                this.fixDependency(res);
                this.updateGraph(res);
                RP.post((Runnable)DependencyGraphScene.this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fixDependency(FixVersionConflictPanel.FixDescription fixContent) {
            if (!DependencyGraphScene.this.model.startTransaction()) {
                return;
            }
            if (DependencyGraphScene.this.model.getProject() == null) {
                LOG.warning("#238748 we got a graph, but the model turned invalid for some reason. if you have steps to reproduce, please reopen the issue.");
                return;
            }
            try {
                if (fixContent.isSet && fixContent.version2Set != null) {
                    Dependency dep = ModelUtils.checkModelDependency((POMModel)DependencyGraphScene.this.model, (String)this.nodeArtif.getGroupId(), (String)this.nodeArtif.getArtifactId(), (boolean)true);
                    dep.setVersion(fixContent.version2Set.toString());
                }
                if (fixContent.isExclude) {
                    DependencyGraphScene.this.excludeDepFromModel(this.node, fixContent.exclusionTargets);
                }
            }
            finally {
                DependencyGraphScene.this.model.endTransaction();
            }
        }

        private void updateGraph(FixVersionConflictPanel.FixDescription fixContent) {
            if (fixContent.isSet) {
                this.node.getArtifact().getArtifact().setVersion(fixContent.version2Set.toString());
                Collection incoming = DependencyGraphScene.this.findNodeEdges(this.node, false, true);
                for (ArtifactGraphEdge age : incoming) {
                    EdgeWidget curEw = (EdgeWidget)DependencyGraphScene.this.findWidget(age);
                    if (curEw == null) continue;
                    curEw.modelChanged();
                }
                this.node.getWidget().modelChanged();
                if (DependencyGraphScene.this.findEdgesBetween(DependencyGraphScene.this.rootNode, this.node).isEmpty()) {
                    ArtifactGraphEdge ed = new ArtifactGraphEdge(DependencyGraphScene.this.rootNode.getArtifact(), this.node.getArtifact());
                    ed.setLevel(1);
                    ed.setPrimaryPath(true);
                    DependencyGraphScene.this.addEdge(ed);
                    DependencyGraphScene.this.setEdgeTarget(ed, this.node);
                    DependencyGraphScene.this.setEdgeSource(ed, DependencyGraphScene.this.rootNode);
                    this.node.setPrimaryLevel(1);
                    this.node.setArtifactParent(DependencyGraphScene.this.rootNode.getArtifact());
                    DependencyGraphScene.this.rootNode.getArtifact().addChild(this.node.getArtifact());
                    DependencyGraphScene.this.validate();
                }
            }
            if (fixContent.isExclude) {
                DependencyGraphScene.this.updateGraphAfterExclusion(this.node, fixContent.exclusionTargets, fixContent.conflictParents);
            }
        }
    }

    private class ExcludeDepAction
    extends AbstractAction {
        private ArtifactGraphNode node;

        ExcludeDepAction(ArtifactGraphNode node) {
            this.node = node;
            this.putValue("Name", Bundle.ACT_ExcludeDep());
            this.putValue("ShortDescription", Bundle.TIP_ExcludeDep());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            FixVersionConflictPanel.ExclusionTargets et = new FixVersionConflictPanel.ExclusionTargets(this.node, DependencyGraphScene.findNewest(this.node, true));
            Set<Artifact> exclTargets = et.getAll();
            if (!DependencyGraphScene.this.model.startTransaction()) {
                return;
            }
            try {
                DependencyGraphScene.this.excludeDepFromModel(this.node, exclTargets);
            }
            finally {
                try {
                    DependencyGraphScene.this.model.endTransaction();
                }
                catch (IllegalStateException ex) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DependencyGraphScene.class, (String)"ERR_UpdateModel", (Object)Exceptions.findLocalizedMessage((Throwable)ex)), 700);
                    return;
                }
            }
            HashSet<DependencyNode> conflictParents = new HashSet<DependencyNode>();
            for (Artifact artif : exclTargets) {
                conflictParents.addAll(et.getConflictParents(artif));
            }
            DependencyGraphScene.this.updateGraphAfterExclusion(this.node, exclTargets, conflictParents);
            RP.post((Runnable)DependencyGraphScene.this);
        }
    }

    private class HighlightedZoomToFitAction
    extends AbstractAction {
        HighlightedZoomToFitAction() {
            this.putValue("Name", Bundle.ACT_ZoomToFit());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Collection grNodes = DependencyGraphScene.this.getNodes();
            ArrayList<ArtifactWidget> aws = new ArrayList<ArtifactWidget>();
            ArtifactWidget aw = null;
            for (ArtifactGraphNode grNode : grNodes) {
                aw = grNode.getWidget();
                int paintState = aw.getPaintState();
                if (paintState == 0 || paintState == 1) continue;
                aws.add(aw);
            }
            DependencyGraphScene.this.getFitToViewLayout().fitToView(aws);
        }
    }

    private class SceneZoomToFitAction
    extends AbstractAction {
        SceneZoomToFitAction() {
            this.putValue("Name", Bundle.ACT_ZoomToFit());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DependencyGraphScene.this.getFitToViewLayout().fitToView(null);
        }
    }

    private static class FitToViewLayout
    extends SceneLayout {
        private final DependencyGraphScene depScene;
        private List<? extends Widget> widgets;

        FitToViewLayout(DependencyGraphScene scene) {
            super((Scene)scene);
            this.depScene = scene;
        }

        protected void fitToView(@NullAllowed List<? extends Widget> widgets) {
            this.widgets = widgets;
            this.invokeLayout();
        }

        protected void performLayout() {
            List toFit;
            Rectangle rectangle = null;
            List list = toFit = this.widgets != null ? this.widgets : this.depScene.getChildren();
            if (toFit == null) {
                return;
            }
            for (Widget widget : toFit) {
                Rectangle bounds = widget.getBounds();
                if (bounds == null) continue;
                if (rectangle == null) {
                    rectangle = widget.convertLocalToScene(bounds);
                    continue;
                }
                rectangle = rectangle.union(widget.convertLocalToScene(bounds));
            }
            if (this.widgets == null) {
                rectangle.grow(5, 5);
            } else {
                rectangle.grow(25, 25);
            }
            Dimension dim = rectangle.getSize();
            Dimension viewDim = this.depScene.tc.getScrollPane().getViewportBorderBounds().getSize();
            double zf = Math.min((double)viewDim.width / (double)dim.width, (double)viewDim.height / (double)dim.height);
            if (this.depScene.isAnimated()) {
                if (this.widgets == null) {
                    this.depScene.getSceneAnimator().animateZoomFactor(zf);
                } else {
                    CenteredZoomAnimator cza = new CenteredZoomAnimator(this.depScene.getSceneAnimator());
                    cza.setZoomFactor(zf, new Point((int)rectangle.getCenterX(), (int)rectangle.getCenterY()));
                }
            } else {
                this.depScene.setMyZoomFactor(zf);
            }
        }
    }

    private class AllActionsProvider
    implements PopupMenuProvider,
    MoveProvider,
    EditProvider,
    SelectProvider {
        private Point moveStart;

        private AllActionsProvider() {
        }

        public JPopupMenu getPopupMenu(Widget widget, Point localLocation) {
            JPopupMenu popupMenu = new JPopupMenu();
            if (widget == DependencyGraphScene.this) {
                popupMenu.add(DependencyGraphScene.this.sceneZoomToFitAction);
                JMenu layoutMenu = new JMenu(Bundle.ACT_LayoutSubMenu());
                popupMenu.add(layoutMenu);
                layoutMenu.add(new FruchtermanReingoldLayoutAction());
                layoutMenu.add(new JSeparator());
                layoutMenu.add(new HierarchicalGraphLayoutAction());
                layoutMenu.add(new TreeGraphLayoutVerticalAction());
                layoutMenu.add(new TreeGraphLayoutHorizontalAction());
                popupMenu.add(new AbstractAction(Bundle.ACT_Export_As_Image()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        File file = new FileChooserBuilder("DependencyGraphScene-ExportDir").setTitle(Bundle.ACT_Export_As_Image_Title()).setAcceptAllFileFilterUsed(false).addFileFilter((FileFilter)new FileNameExtensionFilter("PNG file", "png")).showSaveDialog();
                        if (file != null) {
                            try {
                                DependencyGraphScene theScene = DependencyGraphScene.this;
                                SceneExporter.createImage((Scene)theScene, (File)file, (SceneExporter.ImageType)SceneExporter.ImageType.PNG, (SceneExporter.ZoomType)SceneExporter.ZoomType.CURRENT_ZOOM_LEVEL, (boolean)false, (boolean)false, (int)-1, (int)-1, (int)-1);
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                });
            } else {
                ArtifactGraphNode node = (ArtifactGraphNode)DependencyGraphScene.this.findObject(widget);
                if (DependencyGraphScene.this.isEditable()) {
                    boolean addSeparator = false;
                    if (DependencyGraphScene.isFixCandidate(node)) {
                        popupMenu.add(new FixVersionConflictAction(node));
                        addSeparator = true;
                    }
                    if (node.getPrimaryLevel() > 1) {
                        popupMenu.add(new ExcludeDepAction(node));
                        addSeparator = true;
                    }
                    if (addSeparator) {
                        popupMenu.add(new JSeparator());
                    }
                }
                popupMenu.add(DependencyGraphScene.this.highlitedZoomToFitAction);
                if (!node.isRoot()) {
                    Action a = CommonArtifactActions.createViewArtifactDetails((Artifact)node.getArtifact().getArtifact(), (List)DependencyGraphScene.this.project.getRemoteArtifactRepositories());
                    a.putValue("PANEL_HINT", "grf");
                    a.putValue("Name", Bundle.ACT_Show_Graph());
                    popupMenu.add(a);
                }
            }
            return popupMenu;
        }

        public void movementStarted(Widget widget) {
            widget.bringToFront();
            this.moveStart = widget.getLocation();
        }

        public void movementFinished(Widget widget) {
            Object obj;
            Point moveEnd = widget.getLocation();
            if (this.moveStart.distance(moveEnd) < 5.0 && (obj = DependencyGraphScene.this.findObject(widget)) instanceof ArtifactGraphNode) {
                DependencyGraphScene.this.highlightRelated((ArtifactGraphNode)obj);
            }
        }

        public Point getOriginalLocation(Widget widget) {
            return widget.getPreferredLocation();
        }

        public void setNewLocation(Widget widget, Point location) {
            widget.setPreferredLocation(location);
        }

        public void edit(Widget widget) {
            if (DependencyGraphScene.this == widget) {
                DependencyGraphScene.this.sceneZoomToFitAction.actionPerformed(null);
            } else {
                DependencyGraphScene.this.highlitedZoomToFitAction.actionPerformed(null);
            }
        }

        public boolean isAimingAllowed(Widget widget, Point localLocation, boolean invertSelection) {
            return false;
        }

        public boolean isSelectionAllowed(Widget widget, Point localLocation, boolean invertSelection) {
            return true;
        }

        public void select(Widget widget, Point localLocation, boolean invertSelection) {
            DependencyGraphScene.this.setSelectedObjects(EMPTY_SELECTION);
            DependencyGraphScene.this.tc.depthHighlight();
        }
    }
}

