/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.ServiceProvidersTablePanel;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.proprietary.service.STSConfiguration;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.openide.util.NbBundle;

public class STSConfigServicePanel
extends JPanel {
    private Binding binding;
    private Project project;
    private boolean inSync = false;
    private DefaultFormatterFactory lifeTimeDff = null;
    private ConfigVersion cfgVersion = null;
    private JButton contractButton;
    private JLabel contractLabel;
    private JTextField contractTextField;
    private JCheckBox encryptKeyChBox;
    private JCheckBox encryptTokenChBox;
    private JTextField issuerField;
    private JLabel issuerLabel;
    private JLabel lifeTimeLabel;
    private JFormattedTextField lifeTimeTextField;
    private JPanel serviceProvidersPanel;

    public STSConfigServicePanel(Project p, Binding binding, ConfigVersion cfgVersion) {
        this.project = p;
        this.binding = binding;
        this.cfgVersion = cfgVersion;
        this.lifeTimeDff = new DefaultFormatterFactory();
        NumberFormat lifetimeFormat = NumberFormat.getIntegerInstance();
        lifetimeFormat.setGroupingUsed(false);
        lifetimeFormat.setParseIntegerOnly(true);
        lifetimeFormat.setMaximumFractionDigits(0);
        NumberFormatter lifetimeFormatter = new NumberFormatter(lifetimeFormat);
        lifetimeFormatter.setCommitsOnValidEdit(true);
        lifetimeFormatter.setMinimum(Integer.valueOf(0));
        this.lifeTimeDff.setDefaultFormatter(lifetimeFormatter);
        this.initComponents();
        this.inSync = true;
        ServiceProvidersTablePanel.ServiceProvidersTableModel tablemodel = new ServiceProvidersTablePanel.ServiceProvidersTableModel();
        this.remove(this.serviceProvidersPanel);
        STSConfiguration stsConfig = ProprietarySecurityPolicyModelHelper.getSTSConfiguration(binding);
        if (stsConfig == null) {
            stsConfig = ProprietarySecurityPolicyModelHelper.createSTSConfiguration(binding);
        }
        this.serviceProvidersPanel = new ServiceProvidersTablePanel(tablemodel, stsConfig, cfgVersion);
        ((ServiceProvidersTablePanel)((Object)this.serviceProvidersPanel)).populateModel();
        this.inSync = false;
        this.sync();
    }

    private void sync() {
        String cclass;
        this.inSync = true;
        String lifeTime = ProprietarySecurityPolicyModelHelper.getSTSLifeTime(this.binding);
        if (lifeTime == null) {
            this.setLifeTime("300000");
            ProprietarySecurityPolicyModelHelper.setSTSLifeTime(this.binding, "300000");
        } else {
            this.setLifeTime(lifeTime);
        }
        boolean encryptKey = ProprietarySecurityPolicyModelHelper.getSTSEncryptKey(this.binding);
        this.setChBox(this.encryptKeyChBox, encryptKey);
        boolean encryptToken = ProprietarySecurityPolicyModelHelper.getSTSEncryptToken(this.binding);
        this.setChBox(this.encryptTokenChBox, encryptToken);
        String issuer = ProprietarySecurityPolicyModelHelper.getSTSIssuer(this.binding);
        if (issuer != null) {
            this.setIssuer(issuer);
        }
        if ((cclass = ProprietarySecurityPolicyModelHelper.getSTSContractClass(this.binding)) == null) {
            this.setContractClass("com.sun.xml.ws.security.trust.impl.IssueSamlTokenContractImpl");
            ProprietarySecurityPolicyModelHelper.setSTSContractClass(this.binding, "com.sun.xml.ws.security.trust.impl.IssueSamlTokenContractImpl");
        } else {
            this.setContractClass(cclass);
        }
        this.refreshPanels();
        this.inSync = false;
    }

    private void setLifeTime(String time) {
        this.lifeTimeTextField.setText(time);
    }

    private void setIssuer(String issuer) {
        this.issuerField.setText(issuer);
    }

    private void setChBox(JCheckBox chBox, Boolean enable) {
        if (enable == null) {
            chBox.setSelected(false);
        } else {
            chBox.setSelected(enable);
        }
    }

    private void setContractClass(String classname) {
        this.contractTextField.setText(classname);
    }

    private void refreshPanels() {
        this.updateLayout();
    }

    private void updateLayout() {
        GroupLayout layout = (GroupLayout)this.getLayout();
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serviceProvidersPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.lifeTimeLabel)).addComponent(this.contractLabel).addComponent(this.issuerLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lifeTimeTextField, -2, 90, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contractTextField, -1, 353, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contractButton)).addComponent(this.issuerField, -1, 438, Short.MAX_VALUE)).addGap(10, 10, 10)).addGroup(layout.createSequentialGroup().addComponent(this.encryptKeyChBox).addContainerGap(493, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.encryptTokenChBox).addContainerGap(483, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.issuerLabel).addComponent(this.issuerField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.contractLabel).addComponent(this.contractButton).addComponent(this.contractTextField, -2, -1, -2)).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lifeTimeLabel).addComponent(this.lifeTimeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.encryptKeyChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.encryptTokenChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serviceProvidersPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void initComponents() {
        this.serviceProvidersPanel = new JPanel();
        this.lifeTimeLabel = new JLabel();
        this.contractLabel = new JLabel();
        this.contractTextField = new JTextField();
        this.contractButton = new JButton();
        this.issuerLabel = new JLabel();
        this.issuerField = new JTextField();
        this.encryptKeyChBox = new JCheckBox();
        this.encryptTokenChBox = new JCheckBox();
        this.lifeTimeTextField = new JFormattedTextField();
        this.serviceProvidersPanel.setAutoscrolls(true);
        GroupLayout serviceProvidersPanelLayout = new GroupLayout(this.serviceProvidersPanel);
        this.serviceProvidersPanel.setLayout(serviceProvidersPanelLayout);
        serviceProvidersPanelLayout.setHorizontalGroup(serviceProvidersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 708, Short.MAX_VALUE));
        serviceProvidersPanelLayout.setVerticalGroup(serviceProvidersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 90, Short.MAX_VALUE));
        this.lifeTimeLabel.setText(NbBundle.getMessage(STSConfigServicePanel.class, (String)"LBL_STSConfig_Lifetime"));
        this.contractLabel.setText(NbBundle.getMessage(STSConfigServicePanel.class, (String)"LBL_STSConfig_Contract"));
        this.contractTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                STSConfigServicePanel.this.contractTextFieldKeyReleased(evt);
            }
        });
        this.contractButton.setText(NbBundle.getMessage(STSConfigServicePanel.class, (String)"LBL_STSConfig_Browse"));
        this.contractButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                STSConfigServicePanel.this.contractButtonActionPerformed(evt);
            }
        });
        this.issuerLabel.setText(NbBundle.getMessage(STSConfigServicePanel.class, (String)"LBL_STSConfig_Issuer"));
        this.issuerField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                STSConfigServicePanel.this.issuerFieldKeyReleased(evt);
            }
        });
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/wsitconf/ui/service/subpanels/Bundle");
        this.encryptKeyChBox.setText(bundle.getString("LBL_STSConfig_EncryptKey"));
        this.encryptKeyChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.encryptKeyChBox.setMargin(new Insets(0, 0, 0, 0));
        this.encryptKeyChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                STSConfigServicePanel.this.encryptKeyChBoxActionPerformed(evt);
            }
        });
        this.encryptTokenChBox.setText(bundle.getString("LBL_STSConfig_EncryptToken"));
        this.encryptTokenChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.encryptTokenChBox.setMargin(new Insets(0, 0, 0, 0));
        this.encryptTokenChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                STSConfigServicePanel.this.encryptTokenChBoxActionPerformed(evt);
            }
        });
        this.lifeTimeTextField.setFormatterFactory(this.lifeTimeDff);
        this.lifeTimeTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                STSConfigServicePanel.this.lifeTimeTextFieldKeyReleased(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serviceProvidersPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.lifeTimeLabel)).addComponent(this.contractLabel).addComponent(this.issuerLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.issuerField, -1, 458, Short.MAX_VALUE).addComponent(this.lifeTimeTextField, -2, 95, -2).addGroup(layout.createSequentialGroup().addComponent(this.contractTextField, -1, 353, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contractButton))).addGap(10, 10, 10)).addGroup(layout.createSequentialGroup().addComponent(this.encryptKeyChBox).addContainerGap(554, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.encryptTokenChBox).addContainerGap(535, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.issuerLabel).addComponent(this.issuerField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.contractLabel).addComponent(this.contractButton).addComponent(this.contractTextField, -2, -1, -2)).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lifeTimeLabel).addComponent(this.lifeTimeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.encryptKeyChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.encryptTokenChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serviceProvidersPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void lifeTimeTextFieldKeyReleased(KeyEvent evt) {
        Object o = this.lifeTimeTextField.getValue();
        if (o instanceof Integer) {
            String ltime = o.toString();
            ProprietarySecurityPolicyModelHelper.setSTSLifeTime(this.binding, ltime);
        }
    }

    private void encryptTokenChBoxActionPerformed(ActionEvent evt) {
        ProprietarySecurityPolicyModelHelper.setSTSEncryptToken(this.binding, this.encryptTokenChBox.isSelected());
    }

    private void encryptKeyChBoxActionPerformed(ActionEvent evt) {
        ProprietarySecurityPolicyModelHelper.setSTSEncryptKey(this.binding, this.encryptKeyChBox.isSelected());
    }

    private void contractTextFieldKeyReleased(KeyEvent evt) {
        String c = this.contractTextField.getText();
        ProprietarySecurityPolicyModelHelper.setSTSContractClass(this.binding, c);
    }

    private void issuerFieldKeyReleased(KeyEvent evt) {
        String issuer = this.issuerField.getText();
        ProprietarySecurityPolicyModelHelper.setSTSIssuer(this.binding, issuer);
    }

    private void contractButtonActionPerformed(ActionEvent evt) {
        block1: {
            Set<String> selectedClasses;
            Iterator<String> i$;
            if (this.project == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.project, "com.sun.xml.ws.trust.WSTrustContract");
            classDialog.show();
            if (classDialog.okButtonPressed() && (i$ = (selectedClasses = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String selectedClass = i$.next();
                this.setContractClass(selectedClass);
                ProprietarySecurityPolicyModelHelper.setSTSContractClass(this.binding, selectedClass);
            }
        }
    }
}

