/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wizard;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wizard.FinishableProxyWizardPanel;
import org.netbeans.modules.websvc.wsitconf.wizard.STSVersionPanel;
import org.netbeans.modules.websvc.wsitconf.wizard.STSWizardCreator;
import org.netbeans.modules.websvc.wsitconf.wizard.WsdlServiceHandler;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class STSWizard
implements TemplateWizard.Iterator {
    private Project project;
    private static final Logger logger = Logger.getLogger(STSWizard.class.getName());
    private static final String SERVICENAME_TAG = "__SERVICENAME__";
    private WsdlModeler wsdlModeler;
    private WsdlModel wsdlModel;
    private WsdlService service;
    private WsdlPort port;
    private transient int index;
    private transient WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private transient TemplateWizard wiz;
    private transient STSVersionPanel versionPanel = null;

    public static STSWizard create() {
        return new STSWizard();
    }

    public Set<DataObject> instantiate(final TemplateWizard wiz) throws IOException {
        File tempFolder = new File(System.getProperty("netbeans.user"));
        DataObject folderDO = DataObject.find((FileObject)FileUtil.toFileObject((File)tempFolder));
        final String fileName = ConfigVersion.CONFIG_1_0.equals(wiz.getProperty("cfgVersion")) ? "sts" : "sts13";
        String userDir = System.getProperty("netbeans.user") + File.separator + "config" + File.separator + "WebServices" + File.separator;
        final File userDirF = new File(userDir);
        logger.log(Level.FINE, "USERDIR: " + userDir);
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    FileUtil.createFolder((File)userDirF);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OutputStream schemaos = null;
                InputStream schemaIS = null;
                try {
                    FileObject wsdlFolder = FileUtil.toFileObject((File)userDirF);
                    schemaIS = this.getClass().getClassLoader().getResourceAsStream("org/netbeans/modules/websvc/wsitconf/resources/templates/sts_schema.template");
                    FileObject schema = null;
                    try {
                        schema = wsdlFolder.createData("sts_schema.xsd");
                    }
                    catch (IOException ex) {
                        logger.log(Level.FINE, null, ex);
                        logger.log(Level.FINE, "schema: " + schema);
                        schema = wsdlFolder.getFileObject("sts_schema.xsd");
                    }
                    schemaos = schema.getOutputStream();
                    FileUtil.copy((InputStream)schemaIS, (OutputStream)schemaos);
                }
                catch (FileNotFoundException ex) {
                    logger.log(Level.INFO, null, ex);
                }
                catch (IOException ex) {
                    logger.log(Level.INFO, null, ex);
                }
                finally {
                    if (schemaos != null) {
                        try {
                            schemaos.close();
                        }
                        catch (IOException ex) {
                            logger.log(Level.INFO, null, ex);
                        }
                    }
                    if (schemaIS != null) {
                        try {
                            schemaIS.close();
                        }
                        catch (IOException ex) {
                            logger.log(Level.INFO, null, ex);
                        }
                    }
                }
            }
        });
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String serviceName = Templates.getTargetName((WizardDescriptor)wiz);
                FileObject wsdlFolder = FileUtil.toFileObject((File)userDirF);
                FileObject wsdlFO = null;
                try {
                    OutputStream wsdlos = null;
                    InputStream wsdlIS = null;
                    try {
                        wsdlIS = this.getClass().getClassLoader().getResourceAsStream("org/netbeans/modules/websvc/wsitconf/resources/templates/" + fileName + ".template");
                        try {
                            wsdlFO = wsdlFolder.createData(fileName, "wsdl");
                        }
                        catch (IOException ex) {
                            logger.log(Level.FINE, null, ex);
                            logger.log(Level.FINE, "wsdl: " + wsdlFO);
                            wsdlFO = wsdlFolder.getFileObject(fileName, "wsdl");
                        }
                        wsdlos = wsdlFO.getOutputStream();
                        FileUtil.copy((InputStream)wsdlIS, (OutputStream)wsdlos);
                    }
                    catch (FileNotFoundException ex) {
                        logger.log(Level.INFO, null, ex);
                    }
                    catch (IOException ex) {
                        logger.log(Level.INFO, null, ex);
                    }
                    finally {
                        if (wsdlos != null) {
                            try {
                                wsdlos.close();
                            }
                            catch (IOException ex) {
                                logger.log(Level.INFO, null, ex);
                            }
                        }
                        if (wsdlIS != null) {
                            try {
                                wsdlIS.close();
                            }
                            catch (IOException ex) {
                                logger.log(Level.INFO, null, ex);
                            }
                        }
                    }
                    String newName = serviceName;
                    FileObject newFO = null;
                    InputStream fi = null;
                    OutputStream fo = null;
                    try {
                        File f = new File(FileUtil.toFile((FileObject)wsdlFolder).getAbsolutePath(), newName + ".wsdl");
                        f.createNewFile();
                        fo = new FileOutputStream(f);
                        fi = wsdlFO.getInputStream();
                        FileUtil.copy((InputStream)fi, (OutputStream)fo);
                        newFO = FileUtil.toFileObject((File)f);
                    }
                    catch (FileNotFoundException ex) {
                        logger.log(Level.INFO, null, ex);
                    }
                    catch (IOException ex) {
                        logger.log(Level.INFO, null, ex);
                    }
                    finally {
                        try {
                            if (fi != null) {
                                fi.close();
                            }
                            if (fo != null) {
                                fo.close();
                            }
                        }
                        catch (IOException ex) {
                            logger.log(Level.INFO, null, ex);
                        }
                    }
                    File newFile = FileUtil.toFile(newFO);
                    final URL wsdlURL = newFile.toURI().toURL();
                    wiz.putProperty("wsdlFilePath", (Object)newFile.getPath());
                    BufferedWriter writer = null;
                    try {
                        List lines = wsdlFO.asLines();
                        writer = new BufferedWriter(new FileWriter(newFile));
                        for (String line : lines) {
                            if ((STSWizard.this.index = line.indexOf(STSWizard.SERVICENAME_TAG)) != -1) {
                                line = line.replaceAll(STSWizard.SERVICENAME_TAG, serviceName);
                            }
                            writer.write(line);
                            writer.newLine();
                        }
                    }
                    catch (FileNotFoundException ex) {
                        logger.log(Level.INFO, null, ex);
                    }
                    catch (IOException ex) {
                        logger.log(Level.INFO, null, ex);
                    }
                    finally {
                        try {
                            if (writer != null) {
                                writer.flush();
                                writer.close();
                            }
                        }
                        catch (IOException ex) {
                            logger.log(Level.INFO, null, ex);
                        }
                    }
                    STSWizard.this.wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(wsdlURL);
                    STSWizard.this.wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                        public void modelCreated(WsdlModel model) {
                            STSWizard.this.wsdlModel = model;
                            if (STSWizard.this.wsdlModel == null) {
                                try {
                                    WsdlServiceHandler.parse(wsdlURL.toExternalForm());
                                }
                                catch (ParserConfigurationException ex) {
                                    logger.log(Level.FINE, null, ex);
                                }
                                catch (SAXException ex) {
                                    logger.log(Level.FINE, null, ex);
                                }
                                catch (IOException ex) {
                                    logger.log(Level.FINE, null, ex);
                                }
                            } else {
                                List services = STSWizard.this.wsdlModel.getServices();
                                if (services != null && !services.isEmpty()) {
                                    STSWizard.this.service = (WsdlService)services.get(0);
                                    List ports = STSWizard.this.service.getPorts();
                                    if (ports != null && !ports.isEmpty()) {
                                        STSWizard.this.port = (WsdlPort)ports.get(0);
                                    }
                                }
                            }
                        }
                    });
                    int timeout = 10000;
                    while (STSWizard.this.service == null && timeout > 0) {
                        try {
                            Thread.sleep(200L);
                            timeout -= 200;
                        }
                        catch (InterruptedException ex) {}
                    }
                    if (STSWizard.this.service != null) {
                        wiz.putProperty("wsdlService", (Object)STSWizard.this.service);
                        wiz.putProperty("wsdlPort", (Object)STSWizard.this.port);
                        wiz.putProperty("wsdlModeler", (Object)STSWizard.this.wsdlModeler);
                        new STSWizardCreator(STSWizard.this.project, (WizardDescriptor)wiz).createSTS();
                    }
                }
                catch (MalformedURLException ex) {
                    logger.log(Level.INFO, null, ex);
                }
            }
        });
        return Collections.singleton(folderDO);
    }

    public void initialize(TemplateWizard wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.project = Templates.getProject((WizardDescriptor)wiz);
        WebModule wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        boolean wizardEnabled = Util.isJavaEE5orHigher(this.project) && ServerUtils.isGlassfish(this.project) && wm != null && JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory()) != null;
        this.versionPanel = new STSVersionPanel((WizardDescriptor)wiz);
        SourceGroup[] sourceGroups = Util.getJavaSourceGroups(this.project);
        FinishableProxyWizardPanel firstPanel = sourceGroups.length == 0 ? new FinishableProxyWizardPanel(Templates.createSimpleTargetChooser((Project)this.project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)this.versionPanel), wizardEnabled) : new FinishableProxyWizardPanel(JavaTemplates.createPackageChooser((Project)this.project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)this.versionPanel), wizardEnabled);
        JComponent comp = (JComponent)firstPanel.getComponent();
        Util.changeLabelInComponent(comp, NbBundle.getMessage(STSWizard.class, (String)"LBL_JavaTargetChooserPanelGUI_ClassName_Label"), NbBundle.getMessage(STSWizard.class, (String)"LBL_Webservice_Name"));
        Util.hideLabelAndLabelFor(comp, NbBundle.getMessage(STSWizard.class, (String)"LBL_JavaTargetChooserPanelGUI_CreatedFile_Label"));
        this.panels = new WizardDescriptor.Panel[]{firstPanel};
        Object prop = this.wiz.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        if (this.wiz != null) {
            this.wiz.putProperty("webServiceType", null);
        }
        this.versionPanel = null;
        this.panels = null;
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(STSWizard.class, (String)"LBL_WizardStepsCount"), Integer.valueOf(this.index + 1).toString(), Integer.valueOf(this.panels.length).toString());
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }
}

