/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import java.util.HashMap;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.websvc.wsitmodelext.policy.All;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.tx.ATAlwaysCapability;
import org.netbeans.modules.websvc.wsitmodelext.tx.ATAssertion;
import org.netbeans.modules.websvc.wsitmodelext.tx.TxQName;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Model;
import org.openide.nodes.Node;

public class TxModelHelper {
    private static HashMap<ConfigVersion, TxModelHelper> instances = new HashMap();
    private ConfigVersion configVersion = ConfigVersion.getDefault();

    private TxModelHelper(ConfigVersion configVersion) {
        this.configVersion = configVersion;
    }

    public static final synchronized TxModelHelper getInstance(ConfigVersion configVersion) {
        TxModelHelper instance = instances.get(configVersion);
        if (instance == null) {
            instance = new TxModelHelper(configVersion);
            instances.put(configVersion, instance);
        }
        return instance;
    }

    private static ATAssertion getATAssertion(Policy p) {
        return (ATAssertion)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, ATAssertion.class, false);
    }

    private static ATAlwaysCapability getATAlwaysAssertion(Policy p) {
        return (ATAlwaysCapability)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, ATAlwaysCapability.class, false);
    }

    public void setTx(BindingOperation bop, Node node, String txValue) {
        this.setTxInConfig(bop, txValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTxInConfig(BindingOperation bop, String txValue) {
        WSDLModel model = bop.getModel();
        Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)bop);
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            ATAssertion tx = TxModelHelper.getATAssertion(p);
            ATAlwaysCapability txAlways = TxModelHelper.getATAlwaysAssertion(p);
            if (tx != null) {
                ((WSDLComponent)tx.getParent()).removeExtensibilityElement((ExtensibilityElement)tx);
            }
            if (txAlways != null) {
                ((WSDLComponent)txAlways.getParent()).removeExtensibilityElement((ExtensibilityElement)txAlways);
            }
            WSDLComponentFactory wcf = model.getFactory();
            PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
            All all = pmh.createPolicy((WSDLComponent)bop, false);
            if (ComboConstants.TX_NEVER.equals(txValue) || ComboConstants.TX_NOTSUPPORTED.equals(txValue)) {
                PolicyModelHelper.cleanPolicies((WSDLComponent)bop);
                return;
            }
            if (ComboConstants.TX_MANDATORY.equals(txValue)) {
                tx = (ATAssertion)wcf.create((WSDLComponent)all, TxQName.ATASSERTION.getQName());
                all.addExtensibilityElement((ExtensibilityElement)tx);
            }
            if (ComboConstants.TX_REQUIRED.equals(txValue)) {
                tx = (ATAssertion)wcf.create((WSDLComponent)all, TxQName.ATASSERTION.getQName());
                tx.setOptional(true, this.configVersion);
                all.addExtensibilityElement((ExtensibilityElement)tx);
                txAlways = (ATAlwaysCapability)wcf.create((WSDLComponent)all, TxQName.ATALWAYSCAPABILITY.getQName());
                all.addExtensibilityElement((ExtensibilityElement)txAlways);
            }
            if (ComboConstants.TX_REQUIRESNEW.equals(txValue)) {
                txAlways = (ATAlwaysCapability)wcf.create((WSDLComponent)all, TxQName.ATALWAYSCAPABILITY.getQName());
                all.addExtensibilityElement((ExtensibilityElement)txAlways);
            }
            if (ComboConstants.TX_SUPPORTED.equals(txValue)) {
                tx = (ATAssertion)wcf.create((WSDLComponent)all, TxQName.ATASSERTION.getQName());
                tx.setOptional(true, this.configVersion);
                all.addExtensibilityElement((ExtensibilityElement)tx);
            }
        }
        finally {
            if (!isTransaction) {
                WSITModelSupport.doEndTransaction((Model)model);
            }
        }
    }

    public static String getTx(BindingOperation bop, Node node) {
        String tx = TxModelHelper.getTxFromConfig(bop);
        return tx;
    }

    private static String getTxFromConfig(BindingOperation bop) {
        Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)bop);
        ATAssertion tx = TxModelHelper.getATAssertion(p);
        ATAlwaysCapability txAlways = TxModelHelper.getATAlwaysAssertion(p);
        if (tx != null && txAlways == null) {
            if (tx.isOptional()) {
                return ComboConstants.TX_SUPPORTED;
            }
            return ComboConstants.TX_MANDATORY;
        }
        if (tx != null && txAlways != null) {
            return ComboConstants.TX_REQUIRED;
        }
        if (tx == null && txAlways != null) {
            return ComboConstants.TX_REQUIRESNEW;
        }
        return ComboConstants.TX_NOTSUPPORTED;
    }
}

