/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import java.util.Set;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.web.portlet.HandlerExceptionResolver;
import org.springframework.web.portlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHandlerExceptionResolver
implements HandlerExceptionResolver,
Ordered {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    private Set<?> mappedHandlers;
    private Class[] mappedHandlerClasses;
    private Log warnLogger;
    private boolean renderWhenMinimized = false;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setMappedHandlers(Set<?> mappedHandlers) {
        this.mappedHandlers = mappedHandlers;
    }

    public void setMappedHandlerClasses(Class[] mappedHandlerClasses) {
        this.mappedHandlerClasses = mappedHandlerClasses;
    }

    public void setWarnLogCategory(String loggerName) {
        this.warnLogger = LogFactory.getLog((String)loggerName);
    }

    public void setRenderWhenMinimized(boolean renderWhenMinimized) {
        this.renderWhenMinimized = renderWhenMinimized;
    }

    @Override
    public ModelAndView resolveException(RenderRequest request, RenderResponse response, Object handler, Exception ex) {
        if (this.shouldApplyTo((PortletRequest)request, handler)) {
            return this.doResolveException((PortletRequest)request, (MimeResponse)response, handler, ex);
        }
        return null;
    }

    @Override
    public ModelAndView resolveException(ResourceRequest request, ResourceResponse response, Object handler, Exception ex) {
        if (this.shouldApplyTo((PortletRequest)request, handler)) {
            return this.doResolveException((PortletRequest)request, (MimeResponse)response, handler, ex);
        }
        return null;
    }

    protected boolean shouldApplyTo(PortletRequest request, Object handler) {
        if (WindowState.MINIMIZED.equals((Object)request.getWindowState()) && !this.renderWhenMinimized) {
            return false;
        }
        if (handler != null) {
            if (this.mappedHandlers != null && this.mappedHandlers.contains(handler)) {
                return true;
            }
            if (this.mappedHandlerClasses != null) {
                for (Class mappedClass : this.mappedHandlerClasses) {
                    if (!mappedClass.isInstance(handler)) continue;
                    return true;
                }
            }
        }
        return this.mappedHandlers == null && this.mappedHandlerClasses == null;
    }

    protected void logException(Exception ex, PortletRequest request) {
        if (this.warnLogger != null && this.warnLogger.isWarnEnabled()) {
            this.warnLogger.warn((Object)this.buildLogMessage(ex, request), (Throwable)ex);
        }
    }

    protected String buildLogMessage(Exception ex, PortletRequest request) {
        return "Handler execution resulted in exception";
    }

    protected abstract ModelAndView doResolveException(PortletRequest var1, MimeResponse var2, Object var3, Exception var4);
}

