/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.javascript2.debug.breakpoints.JSBreakpointsInfo;
import org.netbeans.modules.web.javascript.debugger.MiscEditorUtil;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

public class WebBreakpointsActiveService
implements JSBreakpointsInfo {
    private volatile boolean active = true;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public WebBreakpointsActiveService() {
        SessionActiveListener sal = new SessionActiveListener();
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentSession", (DebuggerManagerListener)sal);
    }

    public boolean areBreakpointsActivated() {
        return this.active;
    }

    private void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.pcs.firePropertyChange("breakpointsActive", !active, active);
        }
    }

    public boolean isDefault() {
        Node node = (Node)Utilities.actionsGlobalContext().lookup(Node.class);
        if (node != null) {
            return false;
        }
        FileObject mostRecentFile = EditorContextDispatcher.getDefault().getMostRecentFile();
        if (mostRecentFile == null) {
            return false;
        }
        String mimeType = mostRecentFile.getMIMEType();
        return MiscEditorUtil.isJSOrWrapperMIMEType(mimeType);
    }

    public boolean isAnnotatable(FileObject fo) {
        String mimeType = fo.getMIMEType();
        return MiscEditorUtil.isJSOrWrapperMIMEType(mimeType);
    }

    public boolean isTransientURL(URL url) {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private class SessionActiveListener
    extends DebuggerManagerAdapter {
        private Debugger currentDebugger = this.getCurrentDebugger();

        public SessionActiveListener() {
            if (this.currentDebugger != null) {
                WebBreakpointsActiveService.this.active = this.currentDebugger.areBreakpointsActive();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("currentSession".equals(propertyName)) {
                Debugger newDebugger = this.getCurrentDebugger();
                SessionActiveListener sessionActiveListener = this;
                synchronized (sessionActiveListener) {
                    if (this.currentDebugger != null) {
                        this.currentDebugger.removePropertyChangeListener((PropertyChangeListener)((Object)this));
                    }
                    this.currentDebugger = newDebugger;
                }
                if (newDebugger != null) {
                    WebBreakpointsActiveService.this.setActive(newDebugger.areBreakpointsActive());
                } else {
                    WebBreakpointsActiveService.this.setActive(true);
                }
            }
            if ("breakpointsActive".equals(propertyName)) {
                WebBreakpointsActiveService.this.setActive(((Debugger)evt.getSource()).areBreakpointsActive());
            }
        }

        private Debugger getCurrentDebugger() {
            Session s = DebuggerManager.getDebuggerManager().getCurrentSession();
            if (s != null) {
                Debugger debugger = (Debugger)s.lookupFirst(null, Debugger.class);
                if (debugger != null) {
                    debugger.addPropertyChangeListener((PropertyChangeListener)((Object)this));
                }
                return debugger;
            }
            return null;
        }
    }
}

