/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.spi.framework.PhpModuleExtender;
import org.netbeans.modules.php.symfony2.Bundle;
import org.netbeans.modules.php.symfony2.Symfony2PhpFrameworkProvider;
import org.netbeans.modules.php.symfony2.commands.InstallerExecutable;
import org.netbeans.modules.php.symfony2.options.Symfony2Options;
import org.netbeans.modules.php.symfony2.ui.wizards.NewProjectConfigurationPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;

public class Symfony2PhpModuleExtender
extends PhpModuleExtender {
    private static final Logger LOGGER = Logger.getLogger(Symfony2PhpModuleExtender.class.getName());
    static final String SYMFONY_ZIP_ENTRY_PREFIX = "Symfony/";
    private NewProjectConfigurationPanel panel = null;

    public void addChangeListener(ChangeListener listener) {
        this.getPanel().addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getPanel().removeChangeListener(listener);
    }

    public JComponent getComponent() {
        return this.getPanel();
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        return this.getErrorMessage() == null;
    }

    public String getErrorMessage() {
        return this.getPanel().getErrorMessage();
    }

    public String getWarningMessage() {
        return null;
    }

    public Set<FileObject> extend(PhpModule phpModule) throws PhpModuleExtender.ExtendingException {
        if (Symfony2Options.getInstance().isUseInstaller()) {
            InstallerExecutable installer = InstallerExecutable.getDefault(phpModule, false);
            assert (installer != null);
            Future<Integer> task = installer.run(this.getPanel().isUseLts());
            try {
                task.get(30L, TimeUnit.MINUTES);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException | TimeoutException ex) {
                LOGGER.log(Level.INFO, "Symfony installer failed.", ex);
                throw new PhpModuleExtender.ExtendingException(Bundle.MSG_NotExtended(), (Throwable)ex);
            }
            File sf2Directory = installer.getSymfony2Dir();
            LOGGER.log(Level.INFO, "Using Symfony2 files from {0}", sf2Directory);
            FileObject sf2Dir = FileUtil.toFileObject((File)sf2Directory);
            assert (sf2Dir != null) : sf2Directory + "[exists: " + sf2Directory.exists() + ", isDir: " + sf2Directory.isDirectory() + ", children: " + Arrays.toString(sf2Directory.list());
            FileObject sourceDirectory = phpModule.getSourceDirectory();
            assert (sourceDirectory != null) : phpModule.getProjectDirectory();
            try {
                this.copyFiles(sf2Dir, sourceDirectory);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "Moving Symfony files failed.", ex);
                throw new PhpModuleExtender.ExtendingException(Bundle.MSG_NotExtended(), (Throwable)ex);
            }
            finally {
                sourceDirectory.refresh();
            }
        }
        try {
            this.unpackSandbox(phpModule);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Cannot unpack Symfony Sandbox.", ex);
            throw new PhpModuleExtender.ExtendingException(Bundle.MSG_NotExtended(), (Throwable)ex);
        }
        Symfony2PhpFrameworkProvider.getInstance().getFrameworkCommandSupport(phpModule).refreshFrameworkCommandsLater(null);
        return this.getInitialFiles(phpModule);
    }

    private void copyFiles(FileObject source, FileObject destination) throws IOException {
        for (FileObject child : source.getChildren()) {
            if (child.isFolder()) {
                this.copyFiles(child, FileUtil.createFolder((FileObject)destination, (String)child.getName()));
                continue;
            }
            assert (child.isData()) : child;
            assert (destination.isFolder()) : destination;
            FileUtil.copyFile((FileObject)child, (FileObject)destination, (String)child.getName());
        }
    }

    private void unpackSandbox(PhpModule phpModule) throws IOException {
        String sandbox = Symfony2Options.getInstance().getSandbox();
        File sourceDir = FileUtil.toFile((FileObject)phpModule.getSourceDirectory());
        FileUtils.unzip((String)sandbox, (File)sourceDir, (FileUtils.ZipEntryFilter)new FileUtils.ZipEntryFilter(){

            public boolean accept(ZipEntry zipEntry) {
                return !Symfony2PhpModuleExtender.SYMFONY_ZIP_ENTRY_PREFIX.equals(zipEntry.getName());
            }

            public String getName(ZipEntry zipEntry) {
                String entryName = zipEntry.getName();
                if (entryName.startsWith(Symfony2PhpModuleExtender.SYMFONY_ZIP_ENTRY_PREFIX)) {
                    entryName = entryName.replaceFirst(Symfony2PhpModuleExtender.SYMFONY_ZIP_ENTRY_PREFIX, "");
                }
                return entryName;
            }
        });
    }

    private Set<FileObject> getInitialFiles(PhpModule phpModule) {
        HashSet<FileObject> files = new HashSet<FileObject>();
        this.addSourceFile(files, phpModule, "app/config/parameters.ini");
        this.addSourceFile(files, phpModule, "src/Acme/DemoBundle/Controller/DemoController.php");
        this.addSourceFile(files, phpModule, "src/Acme/DemoBundle/Resources/views/Demo/index.html.twig");
        if (files.isEmpty()) {
            this.addSourceFile(files, phpModule, "web/app_dev");
        }
        return files;
    }

    private void addSourceFile(Set<FileObject> files, PhpModule phpModule, String relativePath) {
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        if (sourceDirectory == null) {
            assert (false) : "Module extender for no sources of: " + phpModule.getName();
            return;
        }
        FileObject fileObject = sourceDirectory.getFileObject(relativePath);
        if (fileObject != null) {
            files.add(fileObject);
        }
    }

    private synchronized NewProjectConfigurationPanel getPanel() {
        if (this.panel == null) {
            this.panel = new NewProjectConfigurationPanel();
        }
        return this.panel;
    }
}

