/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.options;

import java.io.File;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.symfony2.options.Bundle;
import org.netbeans.modules.php.symfony2.options.Symfony2Options;

public final class Symfony2OptionsValidator {
    private final ValidationResult result = new ValidationResult();

    public Symfony2OptionsValidator validate() {
        if (Symfony2Options.getInstance().isUseInstaller()) {
            this.validateInstaller();
        } else {
            this.validateSandbox();
        }
        return this;
    }

    public Symfony2OptionsValidator validate(boolean useInstaller, String installer, String sandbox) {
        if (useInstaller) {
            return this.validateInstaller(installer);
        }
        return this.validateSandbox(sandbox);
    }

    public Symfony2OptionsValidator validateInstaller() {
        return this.validateInstaller(Symfony2Options.getInstance().getInstaller());
    }

    public Symfony2OptionsValidator validateInstaller(String installer) {
        String warning = PhpExecutableValidator.validateCommand((String)installer, (String)Bundle.Symfony2OptionsValidator_installer());
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"installer", warning));
        }
        return this;
    }

    public Symfony2OptionsValidator validateSandbox() {
        return this.validateSandbox(Symfony2Options.getInstance().getSandbox());
    }

    public Symfony2OptionsValidator validateSandbox(@NullAllowed String sandbox) {
        String warning = FileUtils.validateFile((String)Bundle.Symfony2OptionsValidator_sandbox(), (String)sandbox, (boolean)false);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"sandbox", warning));
        } else if (!new File(sandbox).getName().toLowerCase().endsWith(".zip")) {
            this.result.addWarning(new ValidationResult.Message((Object)"sandbox", Bundle.Symfony2OptionsValidator_sandbox_notZip()));
        }
        return this;
    }

    public ValidationResult getResult() {
        return this.result;
    }
}

