/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.hqleditor.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import org.hibernate.HibernateException;
import org.hibernate.QueryException;
import org.hibernate.SessionFactory;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.hql.internal.ast.QuerySyntaxException;
import org.hibernate.hql.spi.QueryTranslator;
import org.hibernate.internal.SessionFactoryImpl;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.hqleditor.HQLEditorController;
import org.netbeans.modules.hibernate.hqleditor.HQLResult;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public final class HQLEditorTopComponent
extends TopComponent {
    static final String ICON_PATH = "org/netbeans/modules/hibernate/hqleditor/ui/resources/queryEditor16X16.png";
    private Logger logger = Logger.getLogger(HQLEditorTopComponent.class.getName());
    private HashMap<String, FileObject> hibernateConfigMap = new HashMap();
    private static List<Integer> windowCounts = new ArrayList<Integer>();
    private Integer thisWindowCount = new Integer(0);
    private HQLEditorController controller = null;
    private HibernateEnvironment env = null;
    private ProgressHandle ph = null;
    private RequestProcessor requestProcessor;
    private RequestProcessor.Task hqlParserTask;
    private boolean isSqlTranslationProcessDone = false;
    private JPanel containerPanel;
    private JTextArea errorTextArea;
    private JPanel executionPanel;
    private JComboBox hibernateConfigurationComboBox;
    private JEditorPane hqlEditor;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JPanel resultContainerPanel;
    private JToggleButton resultToggleButton;
    private JPanel resultsOrErrorPanel;
    private JTable resultsTable;
    private JButton runHQLButton;
    private JLabel sessionLabel;
    private JComboBox setMaxRowCountComboBox;
    private JLabel setMaxRowCountLabel;
    private JPanel setMaxRowCountPanel;
    private JPanel spacerPanel1;
    private JPanel spacerPanel2;
    private JSplitPane splitPane;
    private JTextPane sqlEditorPane;
    private JToggleButton sqlToggleButton;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JToolBar toolBar;
    private JToolBar toolBar2;
    private JToolBar.Separator toolbarSeparator;
    private JToolBar.Separator toolbarSeparator1;

    private static int getNextWindowCount() {
        int count = 0;
        while (windowCounts.contains(count)) {
            ++count;
        }
        windowCounts.add(count);
        return count;
    }

    public static HQLEditorTopComponent getInstance() {
        return new HQLEditorTopComponent(null);
    }

    public HQLEditorTopComponent(HQLEditorController controller) {
        this.controller = controller;
        this.initComponents();
        this.thisWindowCount = HQLEditorTopComponent.getNextWindowCount();
        this.setName(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"CTL_HQLEditorTopComponent") + this.thisWindowCount);
        this.setToolTipText(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"HINT_HQLEditorTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.sqlToggleButton.setSelected(true);
        this.hqlEditor.getDocument().addDocumentListener(new HQLDocumentListener());
        this.hqlEditor.addMouseListener((MouseListener)((Object)new HQLEditorPopupMouseAdapter()));
    }

    public void setFocusToEditor() {
        this.hqlEditor.requestFocus();
    }

    private void showSQL(String sql) {
        this.sqlEditorPane.setText(sql);
        this.switchToSQLView();
    }

    private void showSQLError(String errorResourceKey) {
        this.sqlEditorPane.setText(NbBundle.getMessage(HQLEditorTopComponent.class, (String)errorResourceKey));
        this.switchToSQLView();
    }

    protected void componentActivated() {
        super.componentActivated();
        this.requestProcessor = new RequestProcessor("hql-parser", 1, true);
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        this.requestProcessor.stop();
    }

    public void fillHibernateConfigurations(Node[] activatedNodes) {
        Node node = activatedNodes[0];
        DataObject dO = (DataObject)node.getCookie(DataObject.class);
        if (dO instanceof HibernateCfgDataObject) {
            dO.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("valid".equals(evt.getPropertyName()) && Boolean.FALSE.equals(evt.getNewValue())) {
                        if (SwingUtilities.isEventDispatchThread()) {
                            HQLEditorTopComponent.this.close();
                        } else {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    HQLEditorTopComponent.this.close();
                                }
                            });
                        }
                    }
                }
            });
            Project enclosingProject = FileOwnerQuery.getOwner((FileObject)dO.getPrimaryFile());
            this.env = (HibernateEnvironment)enclosingProject.getLookup().lookup(HibernateEnvironment.class);
            if (this.env == null) {
                this.logger.warning("HiberEnv is not found in enclosing project.");
                return;
            }
            List<FileObject> configFileObjects = this.env.getAllHibernateConfigFileObjects();
            for (FileObject configFileObject : configFileObjects) {
                try {
                    HibernateCfgDataObject hibernateCfgDataObject = (HibernateCfgDataObject)DataObject.find((FileObject)configFileObject);
                    String configName = hibernateCfgDataObject.getHibernateConfiguration().getSessionFactory().getAttributeValue("name");
                    if (configName == null || configName.equals("")) {
                        configName = configFileObject.getName();
                    }
                    this.hibernateConfigMap.put(configName, configFileObject);
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.hibernateConfigurationComboBox.setModel(new DefaultComboBoxModel<Object>(this.hibernateConfigMap.keySet().toArray()));
            HibernateConfiguration config = ((HibernateCfgDataObject)dO).getHibernateConfiguration();
            String selectedConfigName = config.getSessionFactory().getAttributeValue("name");
            if (selectedConfigName == null || selectedConfigName.equals("")) {
                selectedConfigName = dO.getPrimaryFile().getName();
            }
            this.hibernateConfigurationComboBox.setSelectedItem(selectedConfigName);
        }
    }

    public void setResult(HQLResult result, ClassLoader ccl) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ccl);
        if (result.getExceptions().isEmpty()) {
            this.switchToResultView();
            StringBuilder strBuffer = new StringBuilder();
            String space = " ";
            String separator = "; ";
            strBuffer.append(result.getUpdateOrDeleteResult());
            strBuffer.append(space);
            strBuffer.append(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"queryUpdatedOrDeleted"));
            strBuffer.append(separator);
            strBuffer.append(space);
            strBuffer.append(result.getQueryResults().size());
            strBuffer.append(space);
            strBuffer.append(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"rowsSelected"));
            this.setStatus(strBuffer.toString());
            Vector<String> tableHeaders = new Vector<String>();
            Vector<Vector> tableData = new Vector<Vector>();
            if (result.getQueryResults().size() != 0) {
                Object firstObject = result.getQueryResults().get(0);
                if (firstObject instanceof Object[]) {
                    for (Object oneObject : (Object[])firstObject) {
                        this.createTableHeaders(tableHeaders, oneObject);
                    }
                    for (Object row : result.getQueryResults()) {
                        this.createTableData(tableData, (Object[])row);
                    }
                } else {
                    this.createTableHeaders(tableHeaders, firstObject);
                    for (Object oneObject : result.getQueryResults()) {
                        this.createTableData(tableData, oneObject);
                    }
                }
            }
            this.resultsTable.clearSelection();
            this.resultsTable.setModel(new HQLEditorResultTableModel(tableData, tableHeaders));
        } else {
            this.logger.info("HQL query execution resulted in following " + result.getExceptions().size() + " errors.");
            this.switchToErrorView();
            this.setStatus(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"queryExecutionError"));
            this.errorTextArea.setText("");
            for (Throwable t : result.getExceptions()) {
                StringWriter sWriter = new StringWriter();
                PrintWriter pWriter = new PrintWriter(sWriter);
                t.printStackTrace(pWriter);
                this.errorTextArea.append(this.removeHibernateModuleCodelines(sWriter.toString()));
            }
        }
        this.ph.progress(99);
        this.ph.setDisplayName(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"queryExecutionDone"));
        this.runHQLButton.setEnabled(true);
        this.ph.finish();
        Thread.currentThread().setContextClassLoader(oldClassLoader);
    }

    private void createTableHeaders(Vector<String> tableHeaders, Object oneObject) {
        if (oneObject == null || oneObject.getClass().getName().startsWith("java.lang")) {
            tableHeaders.add(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"queryResultDefaultColumnName") + " " + (tableHeaders.size() + 1));
        } else {
            for (Method m : oneObject.getClass().getDeclaredMethods()) {
                String methodName = m.getName();
                if (!methodName.startsWith("get") || tableHeaders.contains(methodName)) continue;
                tableHeaders.add(m.getName().substring(3));
            }
        }
    }

    private void createTableData(Vector<Vector> tableData, Object ... rowObject) {
        Vector<String> oneRow = new Vector<String>();
        for (Object oneObject : rowObject) {
            if (oneObject == null || oneObject.getClass().getName().startsWith("java.lang")) {
                oneRow.add(oneObject.toString());
                continue;
            }
            for (Method m : oneObject.getClass().getDeclaredMethods()) {
                String methodName = m.getName();
                if (!methodName.startsWith("get")) continue;
                try {
                    Object methodReturnValue = m.invoke(oneObject, new Object[0]);
                    if (methodReturnValue == null) {
                        oneRow.add("NULL");
                        continue;
                    }
                    if (methodReturnValue instanceof Collection) {
                        oneRow.add(methodReturnValue.toString());
                        continue;
                    }
                    oneRow.add(methodReturnValue.toString());
                }
                catch (IllegalAccessException ex) {
                }
                catch (IllegalArgumentException ex) {
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        tableData.add(oneRow);
    }

    private void setStatus(String message) {
        this.statusLabel.setText(message);
    }

    private String removeHibernateModuleCodelines(String exceptionTrace) {
        StringTokenizer tokenizer = new StringTokenizer(exceptionTrace, "\n");
        StringBuilder filteredExceptionTrace = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.contains("org.netbeans.modules.hibernate")) continue;
            filteredExceptionTrace.append(token).append("\n");
        }
        return filteredExceptionTrace.toString();
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.sessionLabel = new JLabel();
        this.hibernateConfigurationComboBox = new JComboBox();
        this.toolbarSeparator = new JToolBar.Separator();
        this.runHQLButton = new JButton();
        this.toolbarSeparator1 = new JToolBar.Separator();
        this.splitPane = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.hqlEditor = new JEditorPane();
        this.containerPanel = new JPanel();
        this.toolBar2 = new JToolBar();
        this.resultToggleButton = new JToggleButton();
        this.sqlToggleButton = new JToggleButton();
        this.spacerPanel1 = new JPanel();
        this.spacerPanel2 = new JPanel();
        this.setMaxRowCountPanel = new JPanel();
        this.setMaxRowCountLabel = new JLabel();
        this.setMaxRowCountComboBox = new JComboBox();
        this.executionPanel = new JPanel();
        this.resultContainerPanel = new JPanel();
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.resultsOrErrorPanel = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.errorTextArea = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.resultsTable = new JTable(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension size = super.getPreferredScrollableViewportSize();
                return new Dimension(Math.min(this.getPreferredSize().width, size.width), size.height);
            }
        };
        this.jScrollPane2 = new JScrollPane();
        this.sqlEditorPane = new JTextPane();
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        Mnemonics.setLocalizedText((JLabel)this.sessionLabel, (String)NbBundle.getMessage(HQLEditorTopComponent.class, (String)"HQLEditorTopComponent.sessionLabel.text"));
        this.toolBar.add(this.sessionLabel);
        this.toolBar.add(this.hibernateConfigurationComboBox);
        this.toolBar.add(this.toolbarSeparator);
        this.runHQLButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/netbeans/modules/hibernate/hqleditor/ui/resources/run_hql_query_16.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.runHQLButton, (String)NbBundle.getMessage(HQLEditorTopComponent.class, (String)"HQLEditorTopComponent.runHQLButton.text"));
        this.runHQLButton.setToolTipText(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"runHQLQueryButtonToolTip"));
        this.runHQLButton.setFocusable(false);
        this.runHQLButton.setHorizontalTextPosition(0);
        this.runHQLButton.setVerticalTextPosition(3);
        this.runHQLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HQLEditorTopComponent.this.runHQLButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.runHQLButton);
        this.toolbarSeparator1.setSeparatorSize(new Dimension(300, 10));
        this.toolBar.add(this.toolbarSeparator1);
        this.splitPane.setBorder(null);
        this.splitPane.setDividerLocation(180);
        this.splitPane.setDividerSize(7);
        this.splitPane.setOrientation(0);
        this.hqlEditor.setContentType("text/x-hql");
        this.jScrollPane1.setViewportView(this.hqlEditor);
        this.splitPane.setTopComponent(this.jScrollPane1);
        this.toolBar2.setFloatable(false);
        this.toolBar2.setRollover(true);
        Mnemonics.setLocalizedText((AbstractButton)this.resultToggleButton, (String)NbBundle.getMessage(HQLEditorTopComponent.class, (String)"HQLEditorTopComponent.resultToggleButton.text"));
        this.resultToggleButton.setToolTipText(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"showResultTooltipText"));
        this.resultToggleButton.setFocusable(false);
        this.resultToggleButton.setHorizontalTextPosition(0);
        this.resultToggleButton.setVerticalTextPosition(3);
        this.resultToggleButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                HQLEditorTopComponent.this.resultToggleButtonItemStateChanged(evt);
            }
        });
        this.toolBar2.add(this.resultToggleButton);
        Mnemonics.setLocalizedText((AbstractButton)this.sqlToggleButton, (String)NbBundle.getMessage(HQLEditorTopComponent.class, (String)"HQLEditorTopComponent.sqlToggleButton.text"));
        this.sqlToggleButton.setToolTipText(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"showSQLTooltipText"));
        this.sqlToggleButton.setHorizontalTextPosition(0);
        this.sqlToggleButton.setVerticalTextPosition(3);
        this.sqlToggleButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                HQLEditorTopComponent.this.sqlToggleButtonItemStateChanged(evt);
            }
        });
        this.toolBar2.add(this.sqlToggleButton);
        GroupLayout spacerPanel1Layout = new GroupLayout(this.spacerPanel1);
        this.spacerPanel1.setLayout(spacerPanel1Layout);
        spacerPanel1Layout.setHorizontalGroup(spacerPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 172, Short.MAX_VALUE));
        spacerPanel1Layout.setVerticalGroup(spacerPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 27, Short.MAX_VALUE));
        this.toolBar2.add(this.spacerPanel1);
        GroupLayout spacerPanel2Layout = new GroupLayout(this.spacerPanel2);
        this.spacerPanel2.setLayout(spacerPanel2Layout);
        spacerPanel2Layout.setHorizontalGroup(spacerPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 98, Short.MAX_VALUE));
        spacerPanel2Layout.setVerticalGroup(spacerPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 27, Short.MAX_VALUE));
        this.toolBar2.add(this.spacerPanel2);
        Mnemonics.setLocalizedText((JLabel)this.setMaxRowCountLabel, (String)NbBundle.getMessage(HQLEditorTopComponent.class, (String)"HQLEditorTopComponent.setMaxRowCountLabel.text"));
        this.setMaxRowCountComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"100", "1000", "10000", "100000"}));
        this.setMaxRowCountComboBox.setToolTipText(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"setMaxRowToolTip"));
        GroupLayout setMaxRowCountPanelLayout = new GroupLayout(this.setMaxRowCountPanel);
        this.setMaxRowCountPanel.setLayout(setMaxRowCountPanelLayout);
        setMaxRowCountPanelLayout.setHorizontalGroup(setMaxRowCountPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(setMaxRowCountPanelLayout.createSequentialGroup().addComponent(this.setMaxRowCountLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.setMaxRowCountComboBox, -2, -1, -2)));
        setMaxRowCountPanelLayout.setVerticalGroup(setMaxRowCountPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(setMaxRowCountPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.setMaxRowCountLabel).addComponent(this.setMaxRowCountComboBox, -2, -1, -2)));
        this.toolBar2.add(this.setMaxRowCountPanel);
        this.executionPanel.setLayout(new CardLayout());
        this.resultContainerPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.statusLabel, (String)NbBundle.getMessage(HQLEditorTopComponent.class, (String)"HQLEditorTopComponent.statusLabel.text"));
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 607, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addGap(0, 303, Short.MAX_VALUE).addComponent(this.statusLabel).addGap(0, 304, Short.MAX_VALUE))));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.statusLabel).addGap(0, 0, Short.MAX_VALUE))));
        this.resultContainerPanel.add((Component)this.statusPanel, "North");
        this.resultsOrErrorPanel.setLayout(new CardLayout());
        this.errorTextArea.setColumns(20);
        this.errorTextArea.setEditable(false);
        this.errorTextArea.setForeground(new Color(255, 102, 102));
        this.errorTextArea.setRows(5);
        this.jScrollPane4.setViewportView(this.errorTextArea);
        this.resultsOrErrorPanel.add((Component)this.jScrollPane4, "card2");
        this.resultsTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.resultsTable.setAutoResizeMode(0);
        this.jScrollPane3.setViewportView(this.resultsTable);
        this.resultsOrErrorPanel.add((Component)this.jScrollPane3, "card3");
        this.resultContainerPanel.add((Component)this.resultsOrErrorPanel, "Center");
        this.executionPanel.add((Component)this.resultContainerPanel, "card2");
        this.sqlEditorPane.setEditable(false);
        this.jScrollPane2.setViewportView(this.sqlEditorPane);
        this.executionPanel.add((Component)this.jScrollPane2, "card1");
        GroupLayout containerPanelLayout = new GroupLayout(this.containerPanel);
        this.containerPanel.setLayout(containerPanelLayout);
        containerPanelLayout.setHorizontalGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBar2, -1, 607, Short.MAX_VALUE).addComponent(this.executionPanel, -1, 607, Short.MAX_VALUE));
        containerPanelLayout.setVerticalGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(containerPanelLayout.createSequentialGroup().addComponent(this.toolBar2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.executionPanel, -1, 284, Short.MAX_VALUE)));
        this.splitPane.setRightComponent(this.containerPanel);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBar, -1, 607, Short.MAX_VALUE).addComponent(this.splitPane, -1, 607, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.toolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.splitPane, -1, 508, Short.MAX_VALUE)));
    }

    private int getMaxRowCount() {
        String selectedMaxCount = this.setMaxRowCountComboBox.getSelectedItem().toString();
        try {
            return Integer.parseInt(selectedMaxCount);
        }
        catch (NumberFormatException e) {
            this.logger.warning("Number Format Error during parsing the max. row count");
            return 1000;
        }
    }

    private void resultToggleButtonItemStateChanged(ItemEvent evt) {
        if (this.resultToggleButton.isSelected()) {
            ((CardLayout)this.executionPanel.getLayout()).first(this.executionPanel);
            this.sqlToggleButton.setSelected(false);
        }
    }

    private void sqlToggleButtonItemStateChanged(ItemEvent evt) {
        if (this.sqlToggleButton.isSelected()) {
            ((CardLayout)this.executionPanel.getLayout()).last(this.executionPanel);
            this.resultToggleButton.setSelected(false);
        }
    }

    private void runHQLButtonActionPerformed(ActionEvent evt) {
        if (this.hqlEditor.getText().trim().equals("")) {
            this.switchToResultView();
            this.setStatus(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"emptyQuery"));
            return;
        }
        if (this.hibernateConfigurationComboBox.getSelectedItem() == null) {
            this.logger.info("hibernate configuration combo box is empty.");
            this.switchToResultView();
            this.setStatus(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"emptyConfiguration"));
            return;
        }
        this.runHQLButton.setEnabled(false);
        try {
            this.ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(HQLEditorTopComponent.class, (String)"progressTaskname"));
            FileObject selectedConfigFile = this.hibernateConfigMap.get(this.hibernateConfigurationComboBox.getSelectedItem());
            this.ph.start(100);
            this.controller.executeHQLQuery(this.hqlEditor.getText(), selectedConfigFile, this.getMaxRowCount(), this.ph);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentClosed() {
        windowCounts.remove(this.thisWindowCount);
    }

    private void switchToResultView() {
        this.resultToggleButton.setSelected(true);
        ((CardLayout)this.resultsOrErrorPanel.getLayout()).last(this.resultsOrErrorPanel);
    }

    private void switchToSQLView() {
        this.sqlToggleButton.setSelected(true);
    }

    private void switchToErrorView() {
        this.resultToggleButton.setSelected(true);
        ((CardLayout)this.resultsOrErrorPanel.getLayout()).first(this.resultsOrErrorPanel);
    }

    private class HQLEditorResultTableModel
    extends DefaultTableModel {
        public HQLEditorResultTableModel(Vector<Vector> tableData, Vector<String> tableHeaders) {
            super(tableData, tableHeaders);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    private class HQLDocumentListener
    implements DocumentListener {
        private HQLDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.process();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.process();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.process();
        }

        private void process() {
            if (HQLEditorTopComponent.this.hqlParserTask != null && !HQLEditorTopComponent.this.hqlParserTask.isFinished() && HQLEditorTopComponent.this.hqlParserTask.getDelay() != 0) {
                HQLEditorTopComponent.this.hqlParserTask.cancel();
            } else if (!HQLEditorTopComponent.this.requestProcessor.isShutdown()) {
                HQLEditorTopComponent.this.hqlParserTask = HQLEditorTopComponent.this.requestProcessor.post((Runnable)new ParseHQL(), 1000);
                HQLEditorTopComponent.this.isSqlTranslationProcessDone = false;
            }
        }
    }

    private class ParseHQL
    extends Thread {
        private ParseHQL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!HQLEditorTopComponent.this.isSqlTranslationProcessDone) {
                if (HQLEditorTopComponent.this.hqlEditor.getText().trim().equals("")) {
                    return;
                }
                if (HQLEditorTopComponent.this.hibernateConfigurationComboBox.getSelectedItem() == null) {
                    HQLEditorTopComponent.this.logger.info("hibernate configuration combo box is empty.");
                    return;
                }
                FileObject selectedConfigObject = (FileObject)HQLEditorTopComponent.this.hibernateConfigMap.get(HQLEditorTopComponent.this.hibernateConfigurationComboBox.getSelectedItem().toString());
                if (Thread.interrupted() || HQLEditorTopComponent.this.isSqlTranslationProcessDone) {
                    return;
                }
                if (selectedConfigObject == null) continue;
                Project enclosingProject = FileOwnerQuery.getOwner((FileObject)selectedConfigObject);
                HQLEditorTopComponent.this.env = (HibernateEnvironment)enclosingProject.getLookup().lookup(HibernateEnvironment.class);
                if (HQLEditorTopComponent.this.env == null) {
                    HQLEditorTopComponent.this.logger.warning("HiberEnv is not found in enclosing project.");
                    return;
                }
                if (Thread.interrupted() || HQLEditorTopComponent.this.isSqlTranslationProcessDone) {
                    return;
                }
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    QueryTranslator[] queryTranslators;
                    ArrayList<URL> localResourcesURLList = new ArrayList<URL>();
                    localResourcesURLList.addAll(HQLEditorTopComponent.this.env.getProjectClassPath(selectedConfigObject));
                    for (FileObject mappingFO : HQLEditorTopComponent.this.env.getAllHibernateMappingFileObjects()) {
                        localResourcesURLList.add(mappingFO.getURL());
                    }
                    HibernateCfgDataObject hibernateCfgDataObject = null;
                    try {
                        hibernateCfgDataObject = (HibernateCfgDataObject)DataObject.find((FileObject)selectedConfigObject);
                    }
                    catch (DataObjectNotFoundException ex) {
                        // empty catch block
                    }
                    if (hibernateCfgDataObject != null) {
                        JDBCDriver jdbcDriver;
                        HibernateConfiguration hCfg = hibernateCfgDataObject.getHibernateConfiguration();
                        DatabaseConnection dbConnection = null;
                        try {
                            dbConnection = HibernateUtil.getDBConnection(hCfg);
                        }
                        catch (DatabaseException ex) {
                            // empty catch block
                        }
                        if (dbConnection != null && (jdbcDriver = dbConnection.getJDBCDriver()) != null) {
                            localResourcesURLList.addAll(Arrays.asList(jdbcDriver.getURLs()));
                        }
                    }
                    ClassLoader ccl = HQLEditorTopComponent.this.env.getProjectClassLoader(localResourcesURLList.toArray(new URL[0]));
                    Thread.currentThread().setContextClassLoader(ccl);
                    SessionFactory sessionFactory = HQLEditorTopComponent.this.controller.processAndConstructSessionFactory(HQLEditorTopComponent.this.hqlEditor.getText(), selectedConfigObject, ccl, enclosingProject);
                    if (Thread.interrupted() || HQLEditorTopComponent.this.isSqlTranslationProcessDone) {
                        return;
                    }
                    SessionFactoryImpl sessionFactoryImpl = (SessionFactoryImpl)sessionFactory;
                    if (Thread.interrupted() || HQLEditorTopComponent.this.isSqlTranslationProcessDone) {
                        return;
                    }
                    StringBuilder stringBuff = new StringBuilder();
                    HQLQueryPlan queryPlan = sessionFactoryImpl.getQueryPlanCache().getHQLQueryPlan(HQLEditorTopComponent.this.hqlEditor.getText(), true, Collections.EMPTY_MAP);
                    for (QueryTranslator t : queryTranslators = queryPlan.getTranslators()) {
                        HQLEditorTopComponent.this.logger.info("SQL String = " + t.getSQLString());
                        stringBuff.append(t.getSQLString() + "\n");
                    }
                    if (Thread.interrupted() || HQLEditorTopComponent.this.isSqlTranslationProcessDone) {
                        return;
                    }
                    HQLEditorTopComponent.this.showSQL(stringBuff.toString());
                }
                catch (QuerySyntaxException qe) {
                    HQLEditorTopComponent.this.logger.log(Level.INFO, "", qe);
                    HQLEditorTopComponent.this.showSQLError("MalformedQuery");
                }
                catch (QueryException qe) {
                    HQLEditorTopComponent.this.logger.log(Level.INFO, "", qe);
                    HQLEditorTopComponent.this.showSQLError("MalformedQuery");
                }
                catch (IllegalArgumentException ie) {
                    HQLEditorTopComponent.this.logger.log(Level.INFO, "", ie);
                    HQLEditorTopComponent.this.showSQLError("MalformedQuery");
                }
                catch (HibernateException se) {
                    HQLEditorTopComponent.this.logger.log(Level.INFO, "", se);
                    HQLEditorTopComponent.this.showSQLError("DbError");
                }
                catch (Exception e) {
                    HQLEditorTopComponent.this.logger.log(Level.INFO, "", e);
                    HQLEditorTopComponent.this.showSQLError("GeneralError");
                }
                finally {
                    HQLEditorTopComponent.this.isSqlTranslationProcessDone = true;
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
            }
        }
    }

    private class HQLEditorPopupMouseAdapter
    extends MouseUtils.PopupMouseAdapter {
        private JPopupMenu popupMenu;
        private JMenuItem runHQLMenuItem;
        private JMenuItem cutMenuItem;
        private JMenuItem copyMenuItem;
        private JMenuItem pasteMenuItem;
        private JMenuItem selectAllMenuItem;
        private final String RUN_HQL_COMMAND = NbBundle.getMessage(HQLEditorTopComponent.class, (String)"CTL_RUN_HQL_COMMAND");
        private final String CUT_COMMAND = NbBundle.getMessage(HQLEditorTopComponent.class, (String)"CTL_CUT_COMMAND");
        private final String COPY_COMMAND = NbBundle.getMessage(HQLEditorTopComponent.class, (String)"CTL_COPY_COMMAND");
        private final String PASTE_COMMAND = NbBundle.getMessage(HQLEditorTopComponent.class, (String)"CTL_PASTE_COMMAND");
        private final String SELECT_ALL_COMMAND = NbBundle.getMessage(HQLEditorTopComponent.class, (String)"CTL_SELECT_ALL_COMMAND");
        private Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();

        public HQLEditorPopupMouseAdapter() {
            this.popupMenu = new JPopupMenu();
            PopupActionListener actionListener = new PopupActionListener();
            this.runHQLMenuItem = this.popupMenu.add(this.RUN_HQL_COMMAND);
            this.runHQLMenuItem.setMnemonic('Q');
            this.runHQLMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, 9, false));
            this.runHQLMenuItem.addActionListener(actionListener);
            this.popupMenu.addSeparator();
            this.cutMenuItem = this.popupMenu.add(this.CUT_COMMAND);
            this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2, true));
            this.cutMenuItem.setMnemonic('t');
            this.cutMenuItem.addActionListener(actionListener);
            this.copyMenuItem = this.popupMenu.add(this.COPY_COMMAND);
            this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2, true));
            this.copyMenuItem.setMnemonic('y');
            this.copyMenuItem.addActionListener(actionListener);
            this.pasteMenuItem = this.popupMenu.add(this.PASTE_COMMAND);
            this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2, true));
            this.pasteMenuItem.setMnemonic('P');
            this.pasteMenuItem.addActionListener(actionListener);
            this.popupMenu.addSeparator();
            this.selectAllMenuItem = this.popupMenu.add(this.SELECT_ALL_COMMAND);
            this.selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2, true));
            this.selectAllMenuItem.setMnemonic('A');
            this.selectAllMenuItem.addActionListener(actionListener);
        }

        protected void showPopup(MouseEvent evt) {
            if (HQLEditorTopComponent.this.hqlEditor.getText().trim().equals("")) {
                this.runHQLMenuItem.setEnabled(false);
                this.selectAllMenuItem.setEnabled(false);
            } else {
                this.runHQLMenuItem.setEnabled(true);
                this.selectAllMenuItem.setEnabled(true);
            }
            if (HQLEditorTopComponent.this.hqlEditor.getSelectedText() == null || HQLEditorTopComponent.this.hqlEditor.getSelectedText().trim().equals("")) {
                this.cutMenuItem.setEnabled(false);
                this.copyMenuItem.setEnabled(false);
            } else {
                this.cutMenuItem.setEnabled(true);
                this.copyMenuItem.setEnabled(true);
            }
            Transferable transferable = this.systemClipboard.getContents(null);
            if (transferable.getTransferDataFlavors().length == 0) {
                this.pasteMenuItem.setEnabled(false);
            } else {
                this.pasteMenuItem.setEnabled(true);
            }
            this.popupMenu.show(HQLEditorTopComponent.this.hqlEditor, evt.getX(), evt.getY());
        }

        private class PopupActionListener
        implements ActionListener {
            private PopupActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(HQLEditorPopupMouseAdapter.this.RUN_HQL_COMMAND)) {
                    HQLEditorTopComponent.this.runHQLButtonActionPerformed(e);
                } else if (e.getActionCommand().equals(HQLEditorPopupMouseAdapter.this.SELECT_ALL_COMMAND)) {
                    HQLEditorTopComponent.this.hqlEditor.selectAll();
                } else if (e.getActionCommand().equals(HQLEditorPopupMouseAdapter.this.CUT_COMMAND)) {
                    StringSelection stringSelection = new StringSelection(HQLEditorTopComponent.this.hqlEditor.getSelectedText());
                    HQLEditorPopupMouseAdapter.this.systemClipboard.setContents(stringSelection, stringSelection);
                    HQLEditorTopComponent.this.hqlEditor.setText(HQLEditorTopComponent.this.hqlEditor.getText().substring(0, HQLEditorTopComponent.this.hqlEditor.getSelectionStart()) + HQLEditorTopComponent.this.hqlEditor.getText().substring(HQLEditorTopComponent.this.hqlEditor.getSelectionEnd()));
                } else if (e.getActionCommand().equals(HQLEditorPopupMouseAdapter.this.COPY_COMMAND)) {
                    StringSelection stringSelection = new StringSelection(HQLEditorTopComponent.this.hqlEditor.getSelectedText());
                    HQLEditorPopupMouseAdapter.this.systemClipboard.setContents(stringSelection, stringSelection);
                } else if (e.getActionCommand().equals(HQLEditorPopupMouseAdapter.this.PASTE_COMMAND)) {
                    Transferable transferable = HQLEditorPopupMouseAdapter.this.systemClipboard.getContents(null);
                    String clipboardContents = "";
                    try {
                        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            clipboardContents = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        } else if (transferable.isDataFlavorSupported(DataFlavor.getTextPlainUnicodeFlavor())) {
                            clipboardContents = (String)transferable.getTransferData(DataFlavor.getTextPlainUnicodeFlavor());
                        }
                    }
                    catch (UnsupportedFlavorException ex) {
                        HQLEditorTopComponent.this.logger.log(Level.INFO, "Unsupported transfer flavor", ex);
                    }
                    catch (IOException ex) {
                        HQLEditorTopComponent.this.logger.log(Level.INFO, "IOException during paste operation", ex);
                    }
                    if (!clipboardContents.equals("")) {
                        if (HQLEditorTopComponent.this.hqlEditor.getSelectedText() != null) {
                            HQLEditorTopComponent.this.hqlEditor.replaceSelection(clipboardContents);
                        } else {
                            HQLEditorTopComponent.this.hqlEditor.setText(HQLEditorTopComponent.this.hqlEditor.getText().substring(0, HQLEditorTopComponent.this.hqlEditor.getCaretPosition()) + clipboardContents + HQLEditorTopComponent.this.hqlEditor.getText().substring(HQLEditorTopComponent.this.hqlEditor.getCaretPosition()));
                        }
                    }
                }
            }
        }
    }
}

