/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.util;

import java.awt.EventQueue;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.karma.preferences.KarmaPreferences;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.api.WebBrowsers;
import org.netbeans.modules.web.clientproject.api.network.NetworkSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class KarmaUtils {
    private static final Logger LOGGER = Logger.getLogger(KarmaUtils.class.getName());
    private static final FilenameFilter KARMA_CONFIG_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith("karma") && name.endsWith(".conf.js");
        }
    };
    private static final FilenameFilter JS_FILES_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".js");
        }
    };

    private KarmaUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public static String readContent(URL url) {
        block7: {
            String string;
            assert (!EventQueue.isDispatchThread());
            Path tmpFile = Files.createTempFile("nb-karma-url-", ".html", new FileAttribute[0]);
            try {
                NetworkSupport.download((String)url.toExternalForm(), (File)tmpFile.toFile());
                string = new String(Files.readAllBytes(tmpFile), StandardCharsets.UTF_8);
            }
            catch (Throwable throwable) {
                try {
                    Files.delete(tmpFile);
                    throw throwable;
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    break block7;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            Files.delete(tmpFile);
            return string;
        }
        return null;
    }

    public static List<WebBrowser> getDebugBrowsers() {
        ArrayList<WebBrowser> browsers = new ArrayList<WebBrowser>();
        for (WebBrowser browser : WebBrowsers.getInstance().getAll(false, false, false, true)) {
            if (browser.isEmbedded() || browser.getBrowserFamily().isMobile() || !browser.hasNetBeansIntegration()) continue;
            browsers.add(browser);
        }
        return browsers;
    }

    @CheckForNull
    public static WebBrowser getPreferredDebugBrowser() {
        Iterator<WebBrowser> i$ = KarmaUtils.getDebugBrowsers().iterator();
        if (i$.hasNext()) {
            WebBrowser browser = i$.next();
            return browser;
        }
        return null;
    }

    public static File getKarmaConfigDir(Project project) {
        File karmaConfigFile;
        String karmaConfig = KarmaPreferences.getConfig(project);
        if (karmaConfig != null && (karmaConfigFile = new File(karmaConfig)).isFile()) {
            return karmaConfigFile.getParentFile();
        }
        return FileUtil.toFile((FileObject)project.getProjectDirectory());
    }

    public static List<File> findJsFiles(File dir) {
        assert (dir != null);
        if (!dir.isDirectory()) {
            return Collections.emptyList();
        }
        File[] jsFiles = dir.listFiles(JS_FILES_FILTER);
        if (jsFiles == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(jsFiles);
    }

    public static List<File> findKarmaConfigs(File configDir) {
        assert (configDir != null);
        if (!configDir.isDirectory()) {
            return Collections.emptyList();
        }
        File[] configs = configDir.listFiles(KARMA_CONFIG_FILTER);
        if (configs == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(configs);
    }

    @CheckForNull
    public static File findKarmaConfig(File configDir) {
        List<File> karmaConfigs = KarmaUtils.findKarmaConfigs(configDir);
        int indexOf = karmaConfigs.indexOf(new File(configDir, "karma.conf.js"));
        if (indexOf != -1) {
            return karmaConfigs.get(indexOf);
        }
        File firstConfig = null;
        for (File config : karmaConfigs) {
            String configName;
            if (firstConfig == null) {
                firstConfig = config;
            }
            if ((configName = config.getName().toLowerCase()).contains("share") || configName.contains("common")) continue;
            return config;
        }
        return firstConfig;
    }
}

