/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.openide.util.Lookup;

public abstract class DiscoveryProviderFactory {
    public static DiscoveryProvider findProvider(String providerID) {
        Lookup.Result res = Lookup.getDefault().lookupResult(DiscoveryProviderFactory.class);
        for (DiscoveryProviderFactory factory : res.allInstances()) {
            DiscoveryProvider provider = factory.createProvider(providerID);
            if (provider == null) continue;
            return provider;
        }
        return null;
    }

    public static Collection<DiscoveryProvider> findAllProviders() {
        Lookup.Result res = Lookup.getDefault().lookupResult(DiscoveryProviderFactory.class);
        ArrayList<DiscoveryProvider> list = new ArrayList<DiscoveryProvider>();
        for (DiscoveryProviderFactory factory : res.allInstances()) {
            list.addAll(factory.getAllProviders());
        }
        return list;
    }

    public abstract DiscoveryProvider createProvider(String var1);

    public abstract Collection<DiscoveryProvider> getAllProviders();
}

