/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.tree;

import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.cnd.discovery.wizard.api.FileConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.api.FolderConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.tree.FileConfigurationImpl;
import org.netbeans.modules.cnd.discovery.wizard.tree.FileConfigurationNode;
import org.netbeans.modules.cnd.discovery.wizard.tree.FolderConfigurationImpl;

public class FolderConfigurationNode
extends DefaultMutableTreeNode {
    private final FolderConfigurationImpl folder;

    public FolderConfigurationNode(FolderConfigurationImpl folder) {
        super(folder);
        this.folder = folder;
        this.addChild(folder);
    }

    private void addChild(FolderConfiguration root) {
        TreeMap<String, FolderConfiguration> sorted = new TreeMap<String, FolderConfiguration>();
        for (FolderConfiguration child : root.getFolders()) {
            sorted.put(child.getFolderName(), child);
        }
        for (FolderConfiguration child : sorted.values()) {
            this.add(new FolderConfigurationNode((FolderConfigurationImpl)child));
        }
        TreeMap<String, FileConfiguration> sorted2 = new TreeMap<String, FileConfiguration>();
        for (FileConfiguration file : root.getFiles()) {
            sorted2.put(file.getFileName(), file);
        }
        for (FileConfiguration file : sorted2.values()) {
            this.add(new FileConfigurationNode((FileConfigurationImpl)file));
        }
    }

    @Override
    public String toString() {
        return this.folder.getFolderName();
    }

    public FolderConfigurationImpl getFolder() {
        return this.folder;
    }

    public boolean isCheckedInclude() {
        return !this.folder.overrideIncludes();
    }

    public void setCheckedInclude(boolean checkedInclude) {
        this.folder.setOverrideIncludes(!checkedInclude);
    }

    public boolean isCheckedMacro() {
        return !this.folder.overrideMacros();
    }

    public void setCheckedMacro(boolean checkedMacro) {
        this.folder.setOverrideMacros(!checkedMacro);
    }
}

