/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.openide.util.lookup.Lookups;

public class CndTodoScanner
extends PushTaskScanner {
    private final RequestProcessor RP = new RequestProcessor("CND todo scanner", 1);
    private final RequestProcessor.Task scanTask;
    private final FileTaskScanner todoScanner;
    private final AtomicReference<ScanJob> jobRef = new AtomicReference();

    public CndTodoScanner() {
        super(NbBundle.getMessage(CndTodoScanner.class, (String)"CndTodoTasks"), NbBundle.getMessage(CndTodoScanner.class, (String)"CndTodoTasksDesc"), null);
        this.todoScanner = this.getTodoScanner();
        this.scanTask = this.RP.create(new Runnable(){

            @Override
            public void run() {
                ScanJob job = CndTodoScanner.this.jobRef.getAndSet(null);
                if (job == null) {
                    return;
                }
                for (FileObject fileObject : job.files) {
                    if (CndTodoScanner.this.jobRef.get() != null) {
                        return;
                    }
                    List newTasks = CndTodoScanner.this.todoScanner.scan(fileObject);
                    if (newTasks == null) continue;
                    job.callback.setTasks(fileObject, newTasks);
                }
            }
        });
    }

    private FileTaskScanner getTodoScanner() {
        Lookup lkp = Lookups.forPath((String)"TaskList/Scanners");
        Collection scanners = lkp.lookupAll(FileTaskScanner.class);
        for (FileTaskScanner fileTaskScanner : scanners) {
            if (!fileTaskScanner.getClass().getName().equals("org.netbeans.modules.tasklist.todo.TodoTaskScanner")) continue;
            return fileTaskScanner;
        }
        assert (false) : "TodoTaskScanner not found";
        return null;
    }

    public void setScope(TaskScanningScope scope, PushTaskScanner.Callback callback) {
        Project prj;
        if (scope == null || callback == null) {
            return;
        }
        WeakSet files = new WeakSet();
        for (FileObject file : scope.getLookup().lookupAll(FileObject.class)) {
            prj = FileOwnerQuery.getOwner((FileObject)file);
            if (prj == null || prj.getLookup().lookup(NativeProject.class) == null) continue;
            files.add(file);
        }
        for (Project p : scope.getLookup().lookupAll(Project.class)) {
            prj = (NativeProject)p.getLookup().lookup(NativeProject.class);
            if (prj == null) continue;
            for (NativeFileItem nativeFileItem : prj.getAllFiles()) {
                files.add(nativeFileItem.getFileObject());
            }
        }
        this.jobRef.set(new ScanJob((Set<FileObject>)files, callback));
        this.scanTask.schedule(0);
    }

    private static class ScanJob {
        private final Set<FileObject> files;
        private final PushTaskScanner.Callback callback;

        public ScanJob(Set<FileObject> files, PushTaskScanner.Callback callback) {
            this.files = files;
            this.callback = callback;
        }
    }
}

