/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.security;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FunctionsXmlService {
    private static final String LEVEL_TAG_NAME = "level";
    private static final String[] LEVEL_TAG_ATTRIBUTES = new String[]{"value"};
    private static final String CATEGORY_TAG_NAME = "category";
    private static final String[] CATEGORY_TAG_ATTRIBUTES = new String[]{"name"};
    private static final String FUNCTION_TAG_NAME = "function";
    private static final String[] FUNCTION_TAG_ATTRIBUTES = new String[]{"name", "header"};
    private static final String ALTERNATIVE_TAG_NAME = "alt";
    public static final String ROOT_FOLDER = "CND";
    public static final String CHECKS_FOLDER = "SecurityChecks";
    private static volatile FunctionsXmlService instance;
    private final Map<Level, List<Category>> functions = new HashMap<Level, List<Category>>();
    private int counter = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FunctionsXmlService getInstance() {
        if (instance == null) {
            Class<FunctionsXmlService> clazz = FunctionsXmlService.class;
            synchronized (FunctionsXmlService.class) {
                if (instance != null) return instance;
                instance = new FunctionsXmlService();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }
        if (instance.getChecksCount() != 0) return instance;
        Class<FunctionsXmlService> clazz = FunctionsXmlService.class;
        synchronized (FunctionsXmlService.class) {
            if (instance.getChecksCount() != 0) return instance;
            instance.parseXml();
            // ** MonitorExit[var0_1] (shouldn't be in output)
            return instance;
        }
    }

    public List<Category> getCategories(Level level) {
        return this.functions.get((Object)level);
    }

    public int getChecksCount() {
        return this.counter;
    }

    private FunctionsXmlService() {
        for (Level l : Level.values()) {
            this.functions.put(l, new LinkedList());
        }
        this.parseXml();
    }

    private void parseXml() {
        try {
            FileObject folder = FileUtil.getConfigFile((String)"CND/SecurityChecks");
            if (folder != null && folder.isFolder()) {
                for (FileObject file : folder.getChildren()) {
                    Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file.getInputStream());
                    NodeList levelNodes = doc.getElementsByTagName(LEVEL_TAG_NAME);
                    int ilimit = levelNodes.getLength();
                    for (int i = 0; i < ilimit; ++i) {
                        Node levelNode = levelNodes.item(i);
                        if (levelNode.getNodeType() != 1) continue;
                        NodeList categoryNodes = levelNode.getChildNodes();
                        int jlimit = categoryNodes.getLength();
                        for (int j = 0; j < jlimit; ++j) {
                            Node categoryNode = categoryNodes.item(j);
                            if (!categoryNode.getNodeName().equals(CATEGORY_TAG_NAME) || categoryNode.getNodeType() != 1) continue;
                            String categoryName = ((Element)categoryNode).getAttribute(CATEGORY_TAG_ATTRIBUTES[0]);
                            Category category = new Category(categoryName);
                            NodeList funcNodes = categoryNode.getChildNodes();
                            int klimit = funcNodes.getLength();
                            for (int k = 0; k < klimit; ++k) {
                                Node funcNode = funcNodes.item(k);
                                if (!funcNode.getNodeName().equals(FUNCTION_TAG_NAME) || funcNode.getNodeType() != 1) continue;
                                String fnName = ((Element)funcNode).getAttribute(FUNCTION_TAG_ATTRIBUTES[0]);
                                String header = ((Element)funcNode).getAttribute(FUNCTION_TAG_ATTRIBUTES[1]);
                                RvsdFunction func = new RvsdFunction(fnName, header);
                                ++this.counter;
                                NodeList alternatives = funcNode.getChildNodes();
                                int limit = alternatives.getLength();
                                for (int l = 0; l < limit; ++l) {
                                    Node altNode = alternatives.item(l);
                                    if (!altNode.getNodeName().equals(ALTERNATIVE_TAG_NAME) || altNode.getNodeType() != 1) continue;
                                    if (altNode.getFirstChild().getNodeType() == 4) {
                                        func.addAlternative(altNode.getFirstChild().getNodeValue().trim());
                                        continue;
                                    }
                                    func.addAlternative(altNode.getFirstChild().getNodeValue());
                                }
                                category.addFunction(func);
                            }
                            Level value = this.toLevel(((Element)levelNode).getAttribute(LEVEL_TAG_ATTRIBUTES[0]));
                            this.functions.get((Object)value).add(category);
                        }
                    }
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Level toLevel(String level) {
        if (level.equals(Level.UNSAFE.name().toLowerCase(Locale.getDefault()))) {
            return Level.UNSAFE;
        }
        if (level.equals(Level.AVOID.name().toLowerCase(Locale.getDefault()))) {
            return Level.AVOID;
        }
        return Level.CAUTION;
    }

    public static class RvsdFunction {
        private final String name;
        private final String header;
        private final List<String> alternatives;
        private final StringBuilder text;

        private RvsdFunction(String name, String header) {
            this.name = name;
            this.header = header;
            this.alternatives = new LinkedList<String>();
            this.text = new StringBuilder();
        }

        private void addAlternative(String alternative) {
            this.alternatives.add(alternative);
            if (this.text.length() != 0) {
                this.text.append(" ");
            }
            this.text.append(alternative).append(";");
        }

        public String getName() {
            return this.name;
        }

        public String getHeader() {
            return this.header;
        }

        public String getAlternativesString() {
            return this.text.toString();
        }
    }

    public static class Category {
        private final String name;
        private final List<RvsdFunction> functions;

        private Category(String name) {
            this.name = name;
            this.functions = new LinkedList<RvsdFunction>();
        }

        private void addFunction(RvsdFunction function) {
            this.functions.add(function);
        }

        public String getName() {
            return this.name;
        }

        public List<RvsdFunction> getFunctions() {
            return Collections.unmodifiableList(this.functions);
        }
    }

    public static enum Level {
        UNSAFE(0),
        AVOID(1),
        CAUTION(2);

        private final int level;

        private Level(int level) {
            this.level = level;
        }

        public String getLevel() {
            return Integer.toString(this.level);
        }
    }
}

