/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagAttribute;
import org.netbeans.modules.javascript2.editor.Bundle;
import org.netbeans.modules.javascript2.editor.JsKeyWords;
import org.netbeans.modules.javascript2.editor.Utils;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.api.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.index.IndexedElement;
import org.netbeans.modules.javascript2.editor.model.JsElement;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.model.impl.ModelUtils;
import org.netbeans.modules.javascript2.editor.model.impl.TypeUsageImpl;
import org.netbeans.modules.javascript2.editor.options.OptionsUtils;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.javascript2.editor.spi.CompletionContext;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;

public class JsCompletionItem
implements CompletionProposal {
    protected final CompletionRequest request;
    protected final ElementHandle element;
    private static ImageIcon priviligedIcon = null;

    JsCompletionItem(ElementHandle element, CompletionRequest request) {
        this.element = element;
        this.request = request;
    }

    public int getAnchorOffset() {
        return LexUtilities.getLexerOffset((JsParserResult)this.request.info, this.request.anchor);
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public String getInsertPrefix() {
        return this.element.getName();
    }

    public String getSortText() {
        StringBuilder sb = new StringBuilder();
        if (this.element != null) {
            FileObject sourceFo = this.request.result.getSnapshot().getSource().getFileObject();
            FileObject elementFo = this.element.getFileObject();
            if (elementFo != null && sourceFo != null && sourceFo.equals(elementFo)) {
                sb.append("1");
            } else if (OffsetRange.NONE.equals((Object)this.element.getOffsetRange((ParserResult)this.request.result))) {
                sb.append("8");
            } else {
                sb.append("9");
            }
        }
        sb.append(this.getName());
        return sb.toString();
    }

    protected boolean isDeprecated() {
        return this.element.getModifiers().contains(Modifier.DEPRECATED);
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        this.formatName(formatter);
        return formatter.getText();
    }

    protected void formatName(HtmlFormatter formatter) {
        if (this.isDeprecated()) {
            formatter.deprecated(true);
            formatter.appendText(this.getName());
            formatter.deprecated(false);
        } else {
            formatter.appendText(this.getName());
        }
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        String location = null;
        if (this.element instanceof JsElement) {
            JsElement jsElement = (JsElement)this.element;
            if (jsElement.isPlatform()) {
                location = Bundle.JsCompletionItem_lbl_js_platform();
            } else if (jsElement.getSourceLabel() != null) {
                location = jsElement.getSourceLabel();
            }
        }
        if (location == null) {
            location = this.getFileNameURL();
        }
        if (location == null) {
            return null;
        }
        formatter.reset();
        boolean isgues = OffsetRange.NONE.equals((Object)this.element.getOffsetRange((ParserResult)this.request.result));
        if (isgues) {
            formatter.appendHtml("<font color=#999999>");
        }
        formatter.appendText(location);
        if (isgues) {
            formatter.appendHtml("</font>");
        }
        return formatter.getText();
    }

    public ElementKind getKind() {
        return this.element.getKind();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public Set<Modifier> getModifiers() {
        EnumSet<Modifier> modifiers;
        EnumSet<Modifier> enumSet = modifiers = this.getElement() == null || this.getElement().getModifiers().isEmpty() ? Collections.EMPTY_SET : EnumSet.copyOf(this.getElement().getModifiers());
        if (modifiers.contains(Modifier.PRIVATE) && (modifiers.contains(Modifier.PUBLIC) || modifiers.contains(Modifier.PROTECTED))) {
            modifiers.remove(Modifier.PUBLIC);
            modifiers.remove(Modifier.PROTECTED);
        }
        return modifiers;
    }

    public boolean isSmart() {
        return false;
    }

    public int getSortPrioOverride() {
        int order = 100;
        if (this.element != null && this.element instanceof JsElement) {
            if (((JsElement)this.element).isPlatform()) {
                order = "prototype".equals(this.element.getName()) ? 1 : 0;
            }
            if (OffsetRange.NONE.equals((Object)this.element.getOffsetRange((ParserResult)this.request.result))) {
                order = 120;
            }
        }
        return order;
    }

    public String getCustomInsertTemplate() {
        return null;
    }

    @CheckForNull
    public final String getFileNameURL() {
        ElementHandle elem = this.getElement();
        if (elem == null) {
            return null;
        }
        FileObject fo = elem.getFileObject();
        if (fo != null) {
            return fo.getNameExt();
        }
        return this.getName();
    }

    public static abstract class SimpleDocElement
    implements ElementHandle {
        private final String name;
        private final ElementKind kind;

        public SimpleDocElement(String name, ElementKind kind) {
            this.name = name;
            this.kind = kind;
        }

        public FileObject getFileObject() {
            return null;
        }

        public String getMimeType() {
            return "";
        }

        public String getName() {
            return this.name;
        }

        public String getIn() {
            return "";
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean signatureEquals(ElementHandle handle) {
            return false;
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }

        public abstract String getDocumentation();
    }

    public static class Factory {
        /*
         * WARNING - void declaration
         */
        public static void create(Map<String, List<JsElement>> items, CompletionRequest request, List<CompletionProposal> result) {
            HashMap resolvedTypes = new HashMap();
            for (Map.Entry<String, List<JsElement>> entry : items.entrySet()) {
                HashMap<String, JsCompletionItem> signatures = new HashMap<String, JsCompletionItem>();
                block5: for (JsElement element : entry.getValue()) {
                    JsCompletionItem item;
                    String signature;
                    switch (element.getJSKind()) {
                        case CONSTRUCTOR: 
                        case FUNCTION: 
                        case METHOD: {
                            Set<String> resolvedType;
                            HashSet<String> returnTypes = new HashSet<String>();
                            LinkedHashMap<String, Set<String>> allParameters = new LinkedHashMap<String, Set<String>>();
                            if (element instanceof JsFunction) {
                                Collection<TypeUsage> resolveTypes = ModelUtils.resolveTypes(((JsFunction)element).getReturnTypes(), (JsParserResult)request.info, OptionsUtils.forLanguage(JsTokenId.javascriptLanguage()).autoCompletionTypeResolution(), false);
                                returnTypes.addAll(Utils.getDisplayNames(resolveTypes));
                                for (JsObject jsObject : ((JsFunction)element).getParameters()) {
                                    HashSet paramTypes = new HashSet();
                                    for (TypeUsage typeUsage : jsObject.getAssignmentForOffset(jsObject.getOffset() + 1)) {
                                        resolvedType = (Set)resolvedTypes.get(typeUsage.getType());
                                        if (resolvedType == null) {
                                            resolvedType = new HashSet(1);
                                            String displayName = Utils.getDisplayName(typeUsage);
                                            if (!displayName.isEmpty()) {
                                                resolvedType.add(displayName);
                                            }
                                            resolvedTypes.put(typeUsage.getType(), resolvedType);
                                        }
                                        paramTypes.addAll(resolvedType);
                                    }
                                    allParameters.put(jsObject.getName(), paramTypes);
                                }
                            } else if (element instanceof IndexedElement.FunctionIndexedElement) {
                                HashSet<TypeUsageImpl> returnTypeUsages = new HashSet<TypeUsageImpl>();
                                for (String string : ((IndexedElement.FunctionIndexedElement)element).getReturnTypes()) {
                                    returnTypeUsages.add(new TypeUsageImpl(string, -1, false));
                                }
                                Collection<TypeUsage> resolveTypes = ModelUtils.resolveTypes(returnTypeUsages, (JsParserResult)request.info, OptionsUtils.forLanguage(JsTokenId.javascriptLanguage()).autoCompletionTypeResolution(), false);
                                returnTypes.addAll(Utils.getDisplayNames(resolveTypes));
                                LinkedHashMap<String, Collection<String>> linkedHashMap = ((IndexedElement.FunctionIndexedElement)element).getParameters();
                                for (Map.Entry<String, Collection<String>> paramEntry : linkedHashMap.entrySet()) {
                                    HashSet hashSet = new HashSet();
                                    for (String type : paramEntry.getValue()) {
                                        HashSet<String> resolvedType2 = (HashSet<String>)resolvedTypes.get(type);
                                        if (resolvedType2 == null) {
                                            resolvedType2 = new HashSet<String>(1);
                                            String displayName = ModelUtils.getDisplayName(type);
                                            if (!displayName.isEmpty()) {
                                                resolvedType2.add(displayName);
                                            }
                                            resolvedTypes.put(type, resolvedType2);
                                        }
                                        hashSet.addAll(resolvedType2);
                                    }
                                    allParameters.put(paramEntry.getKey(), hashSet);
                                }
                            }
                            if (signatures.containsKey(signature = Factory.createFnSignature(entry.getKey(), allParameters, returnTypes))) continue block5;
                            JsFunctionCompletionItem item2 = new JsFunctionCompletionItem(element, request, returnTypes, allParameters);
                            signatures.put(signature, item2);
                            continue block5;
                        }
                        case PARAMETER: 
                        case PROPERTY: 
                        case PROPERTY_GETTER: 
                        case PROPERTY_SETTER: 
                        case FIELD: 
                        case VARIABLE: {
                            void var13_21;
                            Set<String> resolvedType;
                            HashSet<String> typesToDisplay = new HashSet<String>();
                            Object var13_18 = null;
                            if (element instanceof JsObject) {
                                JsObject jsObject = (JsObject)element;
                                Collection<? extends TypeUsage> collection = jsObject.getAssignments();
                            } else if (element instanceof IndexedElement) {
                                IndexedElement iElement = (IndexedElement)element;
                                Collection<TypeUsage> collection = iElement.getAssignments();
                            }
                            if (var13_21 != null && !var13_21.isEmpty()) {
                                HashSet<TypeUsage> toResolve = new HashSet<TypeUsage>();
                                for (TypeUsage typeUsage : var13_21) {
                                    if (typeUsage.isResolved()) {
                                        if ("undefined".equals(typeUsage.getType())) continue;
                                        typesToDisplay.add(Utils.getDisplayName(typeUsage));
                                        continue;
                                    }
                                    resolvedType = (HashSet)resolvedTypes.get(typeUsage.getType());
                                    if (resolvedType == null) {
                                        toResolve.clear();
                                        toResolve.add(typeUsage);
                                        resolvedType = new HashSet(1);
                                        Collection<TypeUsage> resolved = ModelUtils.resolveTypes(toResolve, request.result, OptionsUtils.forLanguage(JsTokenId.javascriptLanguage()).autoCompletionTypeResolution(), false);
                                        for (TypeUsage rType : resolved) {
                                            String displayName = Utils.getDisplayName(rType);
                                            if (displayName.isEmpty()) continue;
                                            resolvedType.add(displayName);
                                        }
                                        resolvedTypes.put(typeUsage.getType(), resolvedType);
                                    }
                                    typesToDisplay.addAll((Collection<String>)resolvedType);
                                }
                            }
                            if (signatures.containsKey(signature = element.getName() + ":" + Factory.createTypeSignature(typesToDisplay))) continue block5;
                            item = new JsPropertyCompletionItem(element, request, typesToDisplay);
                            signatures.put(signature, item);
                            continue block5;
                        }
                    }
                    signature = element.getName();
                    if (signatures.containsKey(signature)) continue;
                    item = new JsCompletionItem(element, request);
                    signatures.put(signature, item);
                }
                for (JsCompletionItem item : signatures.values()) {
                    result.add(item);
                }
            }
        }

        private static String createFnSignature(String name, HashMap<String, Set<String>> params, Set<String> returnTypes) {
            StringBuilder sb = new StringBuilder();
            sb.append(name).append('(');
            for (Map.Entry<String, Set<String>> entry : params.entrySet()) {
                sb.append(entry.getKey()).append(':');
                sb.append(Factory.createTypeSignature(entry.getValue()));
                sb.append(',');
            }
            sb.append(')');
            sb.append(Factory.createTypeSignature(returnTypes));
            return sb.toString();
        }

        private static String createTypeSignature(Set<String> types) {
            StringBuilder sb = new StringBuilder();
            for (String name : types) {
                sb.append(name).append('|');
            }
            return sb.toString();
        }
    }

    public static class JsPropertyCompletionItem
    extends JsCompletionItem {
        private final Set<String> resolvedTypes;

        JsPropertyCompletionItem(ElementHandle element, CompletionRequest request, Set<String> resolvedTypes) {
            super(element, request);
            this.resolvedTypes = resolvedTypes != null ? resolvedTypes : Collections.EMPTY_SET;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            this.formatName(formatter);
            if (!this.resolvedTypes.isEmpty()) {
                formatter.type(true);
                formatter.appendText(": ");
                Iterator<String> it = this.resolvedTypes.iterator();
                while (it.hasNext()) {
                    formatter.appendText(it.next());
                    if (!it.hasNext()) continue;
                    formatter.appendText("|");
                }
                formatter.type(false);
            }
            return formatter.getText();
        }

        @Override
        public String getCustomInsertTemplate() {
            if (this.request.completionContext == CompletionContext.OBJECT_PROPERTY_NAME) {
                return this.getName() + ": ${cursor}";
            }
            return super.getCustomInsertTemplate();
        }
    }

    public static class JsHtmlAttributeItem
    extends JsCompletionItem {
        private final HtmlTagAttribute attr;

        public JsHtmlAttributeItem(HtmlTagAttribute attr, CompletionRequest request) {
            super(new HtmlAttrElement(attr), request);
            this.attr = attr;
        }

        @Override
        public String getName() {
            return this.attr.getName();
        }

        @Override
        public String getInsertPrefix() {
            return this.getName();
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.reset();
            formatter.appendText(this.getName());
            return formatter.getText();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.ATTRIBUTE;
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            formatter.reset();
            formatter.appendHtml("<font color=#999999>");
            formatter.appendText(Bundle.JsCompletionItem_lbl_html_attribute());
            formatter.appendHtml("</font>");
            return formatter.getText();
        }

        private static class HtmlAttrElement
        extends SimpleDocElement {
            private final HtmlTagAttribute attribute;

            public HtmlAttrElement(HtmlTagAttribute attribute) {
                super(attribute.getName(), ElementKind.ATTRIBUTE);
                this.attribute = attribute;
            }

            @Override
            public String getDocumentation() {
                String content = this.attribute.getHelp().getHelpContent();
                if (content == null && this.attribute.getHelp().getHelpResolver() != null && this.attribute.getHelp().getHelpURL() != null) {
                    content = this.attribute.getHelp().getHelpResolver().getHelpContent(this.attribute.getHelp().getHelpURL());
                }
                return content;
            }
        }
    }

    static class CssCompletionItem
    extends JsCompletionItem {
        private static ImageIcon cssIcon = null;
        private final String name;

        public CssCompletionItem(String name, CompletionRequest request) {
            super(null, request);
            this.name = name;
        }

        @Override
        public ImageIcon getIcon() {
            if (cssIcon == null) {
                cssIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/javascript2/jquery/resources/style_sheet_16.png"));
            }
            return cssIcon;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getInsertPrefix() {
            return this.getName();
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.reset();
            formatter.appendText(this.getName());
            return formatter.getText();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.RULE;
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            return null;
        }
    }

    static class KeywordItem
    extends JsCompletionItem {
        private static ImageIcon keywordIcon = null;
        private String keyword = null;

        public KeywordItem(String keyword, CompletionRequest request) {
            super(null, request);
            this.keyword = keyword;
        }

        @Override
        public String getName() {
            return this.keyword;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.name(this.getKind(), true);
            formatter.appendText(this.getName());
            formatter.name(this.getKind(), false);
            return formatter.getText();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            return null;
        }

        @Override
        public ImageIcon getIcon() {
            if (keywordIcon == null) {
                keywordIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/javascript2/editor/resources/javascript.png"));
            }
            return keywordIcon;
        }

        @Override
        public String getInsertPrefix() {
            return this.getName();
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder builder = new StringBuilder();
            JsKeyWords.CompletionType type = JsKeyWords.KEYWORDS.get(this.getName());
            if (type == null) {
                return this.getName();
            }
            switch (type) {
                case SIMPLE: {
                    builder.append(this.getName());
                    break;
                }
                case ENDS_WITH_SPACE: {
                    builder.append(this.getName());
                    builder.append(" ${cursor}");
                    break;
                }
                case CURSOR_INSIDE_BRACKETS: {
                    builder.append(this.getName());
                    builder.append("(${cursor})");
                    break;
                }
                case ENDS_WITH_CURLY_BRACKETS: {
                    builder.append(this.getName());
                    builder.append(" {${cursor}}");
                    break;
                }
                case ENDS_WITH_SEMICOLON: {
                    builder.append(this.getName());
                    CharSequence text = this.request.info.getSnapshot().getText();
                    int index = this.request.anchor + this.request.prefix.length();
                    if (index != text.length() && ';' == text.charAt(index)) break;
                    builder.append(";");
                    break;
                }
                case ENDS_WITH_COLON: {
                    builder.append(this.getName());
                    builder.append(" ${cursor}:");
                    break;
                }
                case ENDS_WITH_DOT: {
                    builder.append(this.getName());
                    builder.append(".${cursor}");
                    break;
                }
                default: {
                    assert (false) : type.toString();
                    break;
                }
            }
            return builder.toString();
        }

        @Override
        public int getSortPrioOverride() {
            return 130;
        }
    }

    public static class JsCallbackCompletionItem
    extends JsCompletionItem {
        private static ImageIcon callbackIcon = null;
        private IndexedElement.FunctionIndexedElement function;

        public JsCallbackCompletionItem(IndexedElement.FunctionIndexedElement element, CompletionRequest request) {
            super(element, request);
            this.function = element;
        }

        @Override
        public ImageIcon getIcon() {
            if (callbackIcon == null) {
                callbackIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/javascript2/editor/resources/methodCallback.png"));
            }
            return callbackIcon;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.setMaxLength(OptionsUtils.forLanguage(JsTokenId.javascriptLanguage()).getCodeCompletionItemSignatureWidth());
            formatter.name(ElementKind.KEYWORD, true);
            formatter.appendText("function");
            formatter.name(ElementKind.KEYWORD, false);
            formatter.appendText(" (");
            this.appendParamsStr(formatter);
            formatter.appendText(")");
            return formatter.getText();
        }

        @Override
        public int getSortPrioOverride() {
            return 90;
        }

        private void appendParamsStr(HtmlFormatter formatter) {
            Iterator<Map.Entry<String, Collection<String>>> it = this.function.getParameters().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Collection<String>> entry = it.next();
                formatter.parameters(true);
                formatter.appendText(entry.getKey());
                formatter.parameters(false);
                Collection<String> types = entry.getValue();
                if (!types.isEmpty()) {
                    formatter.type(true);
                    formatter.appendText(": ");
                    Iterator<String> itTypes = types.iterator();
                    while (itTypes.hasNext()) {
                        formatter.appendText(itTypes.next());
                        if (!itTypes.hasNext()) continue;
                        formatter.appendText("|");
                    }
                    formatter.type(false);
                }
                if (!it.hasNext()) continue;
                formatter.appendText(", ");
            }
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder template = new StringBuilder();
            template.append(" \n /** ");
            for (Map.Entry<String, Collection<String>> entry : this.function.getParameters().entrySet()) {
                Collection<String> types = entry.getValue();
                template.append("\n * @param {");
                if (!types.isEmpty()) {
                    Iterator<String> itTypes = types.iterator();
                    while (itTypes.hasNext()) {
                        template.append(itTypes.next());
                        if (!itTypes.hasNext()) continue;
                        template.append("|");
                    }
                } else {
                    template.append("Object");
                }
                template.append("} ");
                template.append(entry.getKey());
            }
            template.append("\n */");
            template.append("\nfunction (");
            Iterator<Map.Entry<String, Collection<String>>> it = this.function.getParameters().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Collection<String>> entry;
                entry = it.next();
                template.append(entry.getKey());
                if (!it.hasNext()) continue;
                template.append(", ");
            }
            template.append(") {\n ${cursor}\n}");
            return template.toString();
        }

        @Override
        public String getName() {
            return "function";
        }
    }

    public static class JsFunctionCompletionItem
    extends JsCompletionItem {
        private final Set<String> returnTypes;
        private final Map<String, Set<String>> parametersTypes;

        JsFunctionCompletionItem(ElementHandle element, CompletionRequest request, Set<String> resolvedReturnTypes, Map<String, Set<String>> parametersTypes) {
            super(element, request);
            this.returnTypes = resolvedReturnTypes != null ? resolvedReturnTypes : Collections.EMPTY_SET;
            this.parametersTypes = parametersTypes != null ? parametersTypes : Collections.EMPTY_MAP;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.setMaxLength(OptionsUtils.forLanguage(JsTokenId.javascriptLanguage()).getCodeCompletionItemSignatureWidth());
            formatter.emphasis(true);
            this.formatName(formatter);
            formatter.emphasis(false);
            if (!this.asObject()) {
                formatter.appendText("(");
                this.appendParamsStr(formatter);
                formatter.appendText(")");
                this.appendReturnTypes(formatter);
            }
            return formatter.getText();
        }

        private void appendParamsStr(HtmlFormatter formatter) {
            Iterator<Map.Entry<String, Set<String>>> it = this.parametersTypes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Set<String>> entry = it.next();
                formatter.parameters(true);
                formatter.appendText(entry.getKey());
                formatter.parameters(false);
                Collection types = entry.getValue();
                if (!types.isEmpty()) {
                    formatter.type(true);
                    formatter.appendText(": ");
                    Iterator itTypes = types.iterator();
                    while (itTypes.hasNext()) {
                        formatter.appendText((String)itTypes.next());
                        if (!itTypes.hasNext()) continue;
                        formatter.appendText("|");
                    }
                    formatter.type(false);
                }
                if (!it.hasNext()) continue;
                formatter.appendText(", ");
            }
        }

        private void appendReturnTypes(HtmlFormatter formatter) {
            if (!this.returnTypes.isEmpty()) {
                formatter.appendText(": ");
                formatter.type(true);
                Iterator<String> it = this.returnTypes.iterator();
                while (it.hasNext()) {
                    formatter.appendText(it.next());
                    if (!it.hasNext()) continue;
                    formatter.appendText("|");
                }
                formatter.type(false);
            }
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder template = new StringBuilder();
            template.append(this.getName());
            if (!this.asObject()) {
                if (this.parametersTypes.isEmpty()) {
                    template.append("()${cursor}");
                } else {
                    template.append("(${cursor})");
                }
            } else {
                template.append("${cursor}");
            }
            return template.toString();
        }

        @Override
        public ImageIcon getIcon() {
            if (this.getModifiers().contains(Modifier.PROTECTED)) {
                if (priviligedIcon == null) {
                    priviligedIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/javascript2/editor/resources/methodPriviliged.png"));
                }
                return priviligedIcon;
            }
            return super.getIcon();
        }

        private boolean isAfterNewKeyword() {
            int offset;
            boolean isAfterNew = false;
            Snapshot snapshot = this.request.result.getSnapshot();
            TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence(snapshot, snapshot.getOriginalOffset(offset = this.request.anchor));
            if (ts != null) {
                Token<? extends JsTokenId> token;
                ts.move(offset);
                if (ts.moveNext() && (token = LexUtilities.findPrevious(ts, Arrays.asList(JsTokenId.IDENTIFIER, JsTokenId.OPERATOR_DOT, JsTokenId.BLOCK_COMMENT, JsTokenId.WHITESPACE, JsTokenId.LINE_COMMENT, JsTokenId.EOL))).id() == JsTokenId.KEYWORD_NEW) {
                    isAfterNew = true;
                }
            }
            return isAfterNew;
        }

        private boolean asObject() {
            boolean isAfterNew;
            boolean result = false;
            char firstChar = this.getName().charAt(0);
            JsElement.Kind jsKind = null;
            if (this.element instanceof JsElement) {
                jsKind = ((JsElement)this.element).getJSKind();
            }
            if ((jsKind != null && jsKind == JsElement.Kind.CONSTRUCTOR || Character.isUpperCase(firstChar)) && !(isAfterNew = this.isAfterNewKeyword())) {
                String type;
                for (String type2 : this.returnTypes) {
                    if (!type2.endsWith(this.element.getName())) continue;
                    return true;
                }
                if (this.returnTypes.isEmpty()) {
                    result = true;
                } else if (!(this.returnTypes.size() != 1 || !Character.isUpperCase(firstChar = (type = this.returnTypes.iterator().next()).charAt(0)) || "Number".equals(type) || "Boolean".equals(type) || "String".equals(type) || "Array".equals(type))) {
                    result = true;
                }
            }
            return result;
        }
    }

    public static class CompletionRequest {
        public int anchor;
        public JsParserResult result;
        public ParserResult info;
        public String prefix;
        public CompletionContext completionContext;
        public boolean addHtmlTagAttributes;
        public CancelSupport cancelSupport;
    }
}

