/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.jsdoc.model;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.javascript2.editor.doc.spi.DocParameter;
import org.netbeans.modules.javascript2.editor.jsdoc.model.JsDocElementType;
import org.netbeans.modules.javascript2.editor.jsdoc.model.JsDocElementUtils;
import org.netbeans.modules.javascript2.editor.jsdoc.model.ParameterElement;
import org.netbeans.modules.javascript2.editor.model.Identifier;
import org.netbeans.modules.javascript2.editor.model.Type;
import org.netbeans.modules.javascript2.editor.model.impl.IdentifierImpl;

public class NamedParameterElement
extends ParameterElement
implements DocParameter {
    private final Identifier paramName;
    private final boolean optional;
    private final String defaultValue;

    private NamedParameterElement(JsDocElementType type, Identifier paramName, List<Type> paramTypes, String paramDescription, boolean optional, String defaultValue) {
        super(type, paramTypes, paramDescription);
        this.paramName = paramName;
        this.optional = optional;
        this.defaultValue = defaultValue;
    }

    public static NamedParameterElement create(JsDocElementType type, Identifier paramName, List<Type> paramTypes, String paramDescription, boolean optional, String defaultValue) {
        return new NamedParameterElement(type, paramName, paramTypes, paramDescription, optional, defaultValue);
    }

    public static NamedParameterElement create(JsDocElementType type, Identifier paramName, List<Type> paramTypes, String paramDescription, boolean optional) {
        return new NamedParameterElement(type, paramName, paramTypes, paramDescription, optional, null);
    }

    public static NamedParameterElement create(JsDocElementType type, Identifier paramName, List<Type> paramTypes, String paramDescription) {
        return new NamedParameterElement(type, paramName, paramTypes, paramDescription, false, null);
    }

    public static NamedParameterElement createWithDiagnostics(JsDocElementType type, Identifier paramName, List<Type> paramTypes, String paramDescription) {
        int nameStartOffset = paramName.getOffsetRange().getStart();
        String name = paramName.getName();
        if (name.indexOf(126) > 0) {
            name = name.replace('~', '.');
        }
        boolean optional = name.matches("\\[.*\\]");
        String defaultValue = null;
        ArrayList<Type> correctedTypes = new ArrayList<Type>();
        if (optional) {
            ++nameStartOffset;
            int indexOfEqual = (name = name.substring(1, name.length() - 1)).indexOf("=");
            if (indexOfEqual != -1) {
                defaultValue = name.substring(indexOfEqual + 1);
                name = name.substring(0, indexOfEqual);
            }
            correctedTypes.addAll(paramTypes);
        } else {
            for (Type paramType : paramTypes) {
                boolean changed = false;
                String paramTypeName = paramType.getType();
                if (paramTypeName.indexOf(126) > 0) {
                    paramTypeName = paramTypeName.replace('~', '.');
                    changed = true;
                }
                if (JsDocElementUtils.GoogleCompilerSytax.canBeThisSyntax(paramType.getType()) && JsDocElementUtils.GoogleCompilerSytax.isMarkedAsOptional(paramTypeName)) {
                    optional = true;
                    changed = true;
                    paramTypeName = JsDocElementUtils.GoogleCompilerSytax.removeSyntax(paramTypeName);
                }
                if (changed) {
                    correctedTypes.add(JsDocElementUtils.createTypeUsage(paramTypeName, paramType.getOffset()));
                    continue;
                }
                correctedTypes.add(paramType);
            }
        }
        return new NamedParameterElement(type, new IdentifierImpl(name, nameStartOffset), correctedTypes, paramDescription, optional, defaultValue);
    }

    @Override
    public Identifier getParamName() {
        return this.paramName;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }
}

