/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.ProjectProblems;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.SearchInfoUtils;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.web.browser.api.BrowserUISupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.clientproject.Bundle;
import org.netbeans.modules.web.clientproject.ClassPathProviderImpl;
import org.netbeans.modules.web.clientproject.ClientSideProjectBrowserProvider;
import org.netbeans.modules.web.clientproject.ClientSideProjectSources;
import org.netbeans.modules.web.clientproject.CreateFromTemplateAttributesImpl;
import org.netbeans.modules.web.clientproject.FileEncodingQueryImpl;
import org.netbeans.modules.web.clientproject.PageInspectorCustomizerImpl;
import org.netbeans.modules.web.clientproject.ProjectUpgrader;
import org.netbeans.modules.web.clientproject.ServerURLMappingImpl;
import org.netbeans.modules.web.clientproject.SharabilityQueryImpl;
import org.netbeans.modules.web.clientproject.api.ClientSideModule;
import org.netbeans.modules.web.clientproject.api.CustomizerPanel;
import org.netbeans.modules.web.clientproject.api.ProjectDirectoriesProvider;
import org.netbeans.modules.web.clientproject.api.jstesting.CoverageProviderImpl;
import org.netbeans.modules.web.clientproject.api.jstesting.JsTestingProvider;
import org.netbeans.modules.web.clientproject.api.jstesting.JsTestingProviders;
import org.netbeans.modules.web.clientproject.api.platform.PlatformProvider;
import org.netbeans.modules.web.clientproject.api.platform.PlatformProviders;
import org.netbeans.modules.web.clientproject.api.platform.PlatformProvidersListener;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.netbeans.modules.web.clientproject.env.CommonProjectHelper;
import org.netbeans.modules.web.clientproject.env.Env;
import org.netbeans.modules.web.clientproject.env.References;
import org.netbeans.modules.web.clientproject.env.Values;
import org.netbeans.modules.web.clientproject.problems.ProjectPropertiesProblemProvider;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectEnhancedBrowserImplementation;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectEnhancedBrowserProvider;
import org.netbeans.modules.web.clientproject.spi.platform.RefreshOnSaveListener;
import org.netbeans.modules.web.clientproject.ui.ClientSideProjectLogicalView;
import org.netbeans.modules.web.clientproject.ui.action.ClientSideProjectActionProvider;
import org.netbeans.modules.web.clientproject.ui.action.ProjectOperations;
import org.netbeans.modules.web.clientproject.ui.customizer.ClientSideProjectProperties;
import org.netbeans.modules.web.clientproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.modules.web.common.api.CssPreprocessor;
import org.netbeans.modules.web.common.api.CssPreprocessors;
import org.netbeans.modules.web.common.api.CssPreprocessorsListener;
import org.netbeans.modules.web.common.api.UsageLogger;
import org.netbeans.modules.web.common.spi.ProjectWebRootProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ClientSideProject
implements Project {
    static final Logger LOGGER = Logger.getLogger(ClientSideProject.class.getName());
    public static final String HTML5_PROJECT_ICON = "org/netbeans/modules/web/clientproject/ui/resources/html5-project.png";
    static final RequestProcessor RP = new RequestProcessor(ClientSideProject.class);
    final UsageLogger projectBrowserUsageLogger = UsageLogger.projectBrowserUsageLogger((String)"org.netbeans.ui.metrics.web.clientproject");
    public final Env is;
    final CommonProjectHelper projectHelper;
    private final References referenceHelper;
    private final Values eval;
    private final Lookup lookup;
    private final CallbackImpl callbackImpl = new CallbackImpl();
    private final ClientSideProjectBrowserProvider projectBrowserProvider;
    volatile String name;
    private volatile ClassPath sourcePath;
    volatile ClassPathProviderImpl.PathImpl pathImpl;
    ClientProjectEnhancedBrowserImplementation projectEnhancedBrowserImpl;
    WebBrowser projectWebBrowser;
    final PlatformProvidersListener platformProvidersListener = new PlatformProvidersListenerImpl();
    final CssPreprocessorsListener cssPreprocessorsListener = new CssPreprocessorsListener(){

        public void preprocessorsChanged() {
        }

        public void optionsChanged(CssPreprocessor cssPreprocessor) {
            ClientSideProject.this.recompileSources(cssPreprocessor);
        }

        public void customizerChanged(Project project, CssPreprocessor cssPreprocessor) {
            if (project.equals(ClientSideProject.this)) {
                ClientSideProject.this.recompileSources(cssPreprocessor);
            }
        }

        public void processingErrorOccured(Project project, CssPreprocessor cssPreprocessor, String error) {
        }
    };
    private final WindowSystemListener windowSystemListener = new WindowSystemListener(){

        public void beforeLoad(WindowSystemEvent event) {
        }

        public void afterLoad(WindowSystemEvent event) {
        }

        public void beforeSave(WindowSystemEvent event) {
            ClientProjectEnhancedBrowserImplementation enhancedBrowserImpl = ClientSideProject.this.getEnhancedBrowserImpl();
            if (enhancedBrowserImpl != null) {
                enhancedBrowserImpl.close();
            }
        }

        public void afterSave(WindowSystemEvent event) {
        }
    };

    public ClientSideProject(CommonProjectHelper helper, Env is) {
        this.projectHelper = helper;
        this.is = is;
        AuxiliaryConfiguration configuration = helper.createAuxiliaryConfiguration();
        this.eval = is.createEvaluator(helper, this.getProjectDirectory());
        this.referenceHelper = is.newReferenceHelper(helper, configuration, this.eval);
        this.projectBrowserProvider = new ClientSideProjectBrowserProvider(this);
        this.lookup = this.createLookup(configuration, helper.getXmlSavedHook());
        this.eval.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                assert (ProjectManager.mutex().isWriteAccess() || ProjectManager.mutex().isReadAccess());
                if ("browser".equals(evt.getPropertyName())) {
                    ClientSideProject.this.projectBrowserUsageLogger.reset();
                    ClientSideProject clientSideProject = ClientSideProject.this;
                    synchronized (clientSideProject) {
                        ClientProjectEnhancedBrowserImplementation ebi = ClientSideProject.this.projectEnhancedBrowserImpl;
                        if (ebi != null) {
                            ebi.deactivate();
                        }
                        ClientSideProject.this.projectEnhancedBrowserImpl = null;
                        ClientSideProject.this.projectWebBrowser = null;
                    }
                    ClientSideProject.this.projectBrowserProvider.activeBrowserHasChanged();
                }
            }
        });
        this.projectHelper.registerCallback(this.callbackImpl);
        WindowManager windowManager = WindowManager.getDefault();
        windowManager.addWindowSystemListener((WindowSystemListener)WeakListeners.create(WindowSystemListener.class, (EventListener)this.windowSystemListener, (Object)windowManager));
    }

    public String toString() {
        return "ClientSideProject{projectDirectory=" + this.projectHelper.getProjectDirectory() + '}';
    }

    public void logBrowserUsage() {
        WebBrowser webBrowser = this.getProjectWebBrowser();
        this.projectBrowserUsageLogger.log(new Object[]{"org.netbeans.modules.web.clientproject", webBrowser.getId(), webBrowser.getBrowserFamily().name()});
    }

    public ClientProjectEnhancedBrowserImplementation getEnhancedBrowserImpl() {
        return (ClientProjectEnhancedBrowserImplementation)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<ClientProjectEnhancedBrowserImplementation>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ClientProjectEnhancedBrowserImplementation run() {
                ClientSideProject clientSideProject = ClientSideProject.this;
                synchronized (clientSideProject) {
                    if (ClientSideProject.this.projectEnhancedBrowserImpl == null) {
                        ClientSideProject.this.projectEnhancedBrowserImpl = ClientSideProject.createEnhancedBrowserImpl(ClientSideProject.this, ClientSideProject.this.getProjectWebBrowser());
                    }
                    return ClientSideProject.this.projectEnhancedBrowserImpl;
                }
            }
        });
    }

    public static ClientProjectEnhancedBrowserImplementation createEnhancedBrowserImpl(Project p, WebBrowser wb) {
        for (ClientProjectEnhancedBrowserProvider provider : p.getLookup().lookupAll(ClientProjectEnhancedBrowserProvider.class)) {
            ClientProjectEnhancedBrowserImplementation impl = provider.getEnhancedBrowser(wb);
            if (impl == null) continue;
            return impl;
        }
        return null;
    }

    public WebBrowser getProjectWebBrowser() {
        return (WebBrowser)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<WebBrowser>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public WebBrowser run() {
                ClientSideProject clientSideProject = ClientSideProject.this;
                synchronized (clientSideProject) {
                    if (ClientSideProject.this.projectWebBrowser == null) {
                        String id = ClientSideProject.this.getSelectedBrowser();
                        if (id != null) {
                            ClientSideProject.this.projectWebBrowser = BrowserUISupport.getBrowser((String)id);
                        }
                        if (ClientSideProject.this.projectWebBrowser == null) {
                            ClientSideProject.this.projectWebBrowser = BrowserUISupport.getDefaultBrowserChoice((boolean)false);
                        }
                    }
                    return ClientSideProject.this.projectWebBrowser;
                }
            }
        });
    }

    private RefreshOnSaveListener getRefreshOnSaveListener() {
        ClientProjectEnhancedBrowserImplementation ebi = this.getEnhancedBrowserImpl();
        if (ebi != null) {
            return ebi.getRefreshOnSaveListener();
        }
        return null;
    }

    public boolean isUsingEmbeddedServer() {
        return !ClientSideProjectProperties.ProjectServer.EXTERNAL.name().equalsIgnoreCase(this.getEvaluator().getProperty("server"));
    }

    public boolean isBroken(boolean showCustomizer) {
        boolean broken;
        boolean bl = broken = this.getSourcesFolder() == null && this.getSiteRootFolder() == null;
        if (broken && showCustomizer) {
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)Bundle.ClientSideProject_error_broken(this.getName()), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            ProjectProblems.showCustomizer((Project)this);
        }
        return broken;
    }

    public boolean isJsLibrary() {
        return this.getEvaluator().getProperty("site.root.folder") == null;
    }

    public boolean isHtml5Project() {
        return !this.isJsLibrary();
    }

    @CheckForNull
    public FileObject getSourcesFolder() {
        String sourceFolder = this.getEvaluator().getProperty("source.folder");
        if (sourceFolder == null) {
            return null;
        }
        if (sourceFolder.isEmpty()) {
            return this.getProjectDirectory();
        }
        return this.projectHelper.resolveFileObject(sourceFolder);
    }

    @CheckForNull
    public FileObject getSiteRootFolder() {
        String siteRootFolder = this.getEvaluator().getProperty("site.root.folder");
        if (siteRootFolder == null) {
            return null;
        }
        if (siteRootFolder.isEmpty()) {
            return this.getProjectDirectory();
        }
        return this.projectHelper.resolveFileObject(siteRootFolder);
    }

    @CheckForNull
    public FileObject getTestsFolder(boolean showFileChooser) {
        String tests = this.getEvaluator().getProperty("test.folder");
        if (tests == null || tests.trim().length() == 0) {
            File folder;
            if (showFileChooser && (folder = new FileChooserBuilder(ClientSideProject.class).setTitle(Bundle.ClientSideProject_chooser_tests_title(ProjectUtils.getInformation((Project)this).getDisplayName())).setDirectoriesOnly(true).setDefaultWorkingDirectory(FileUtil.toFile((FileObject)this.getProjectDirectory())).forceUseOfDefaultWorkingDirectory(true).showOpenDialog()) != null) {
                BaseProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ClientSideProjectProperties projectProperties = new ClientSideProjectProperties(ClientSideProject.this);
                        projectProperties.setTestFolder(folder.getAbsolutePath());
                        projectProperties.save();
                    }
                }, (String)Bundle.ClientSideProject_props_saving(), (AtomicBoolean)new AtomicBoolean(), (boolean)false);
                FileObject fo = FileUtil.toFileObject((File)folder);
                assert (fo != null) : "FileObject should be found for " + folder;
                return fo;
            }
            return null;
        }
        return this.getProjectDirectory().getFileObject(tests);
    }

    @CheckForNull
    public FileObject getTestsSeleniumFolder(boolean showFileChooser) {
        String tests = this.getEvaluator().getProperty("test.selenium.folder");
        if (tests == null || tests.trim().length() == 0) {
            File folder;
            if (showFileChooser && (folder = new FileChooserBuilder(ClientSideProject.class).setTitle(Bundle.ClientSideProject_chooser_tests_selenium_title(ProjectUtils.getInformation((Project)this).getDisplayName())).setDirectoriesOnly(true).setDefaultWorkingDirectory(FileUtil.toFile((FileObject)this.getProjectDirectory())).forceUseOfDefaultWorkingDirectory(true).showOpenDialog()) != null) {
                BaseProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ClientSideProjectProperties projectProperties = new ClientSideProjectProperties(ClientSideProject.this);
                        projectProperties.setTestSeleniumFolder(folder.getAbsolutePath());
                        projectProperties.save();
                    }
                }, (String)Bundle.ClientSideProject_props_saving(), (AtomicBoolean)new AtomicBoolean(), (boolean)false);
                FileObject fo = FileUtil.toFileObject((File)folder);
                assert (fo != null) : "FileObject should be found for " + folder;
                return fo;
            }
            return null;
        }
        return this.getProjectDirectory().getFileObject(tests);
    }

    public String getStartFile() {
        String startFile = this.getEvaluator().getProperty("start.file");
        if (startFile == null) {
            startFile = "index.html";
        }
        return startFile;
    }

    public String getSelectedBrowser() {
        String s = this.getEvaluator().getProperty("browser");
        return s;
    }

    public String getWebContextRoot() {
        String ctx = this.getEvaluator().getProperty("web.context.root");
        if (ctx == null) {
            ctx = "/" + this.getProjectDirectory().getName();
        }
        if (!ctx.startsWith("/")) {
            ctx = "/" + ctx;
        }
        return ctx;
    }

    @CheckForNull
    public String getRunAs() {
        return this.getEvaluator().getProperty("run.as");
    }

    public boolean isRunBrowser() {
        String property = this.getEvaluator().getProperty("browser.run");
        if (property == null) {
            return true;
        }
        return Boolean.parseBoolean(property);
    }

    public CommonProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public FileObject getProjectDirectory() {
        return this.getProjectHelper().getProjectDirectory();
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public Values getEvaluator() {
        return this.eval;
    }

    public References getReferenceHelper() {
        return this.referenceHelper;
    }

    @CheckForNull
    public JsTestingProvider getJsTestingProvider(boolean showSelectionPanel) {
        return JsTestingProviders.getDefault().getJsTestingProvider((Project)this, showSelectionPanel);
    }

    public List<PlatformProvider> getPlatformProviders() {
        List allProviders = PlatformProviders.getDefault().getPlatformProviders();
        ArrayList<PlatformProvider> enabledProviders = new ArrayList<PlatformProvider>(allProviders.size());
        for (PlatformProvider provider : allProviders) {
            if (!provider.isEnabled((Project)this)) continue;
            enabledProviders.add(provider);
        }
        return enabledProviders;
    }

    public String getName() {
        if (this.name == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    Element data = ClientSideProject.this.projectHelper.getPrimaryConfigurationData(true);
                    NodeList nameList = data.getElementsByTagNameNS("http://www.netbeans.org/ns/clientside-project/1", "name");
                    if (nameList.getLength() == 1 && (nameList = nameList.item(0).getChildNodes()).getLength() == 1 && nameList.item(0).getNodeType() == 3) {
                        ClientSideProject.this.name = ((Text)nameList.item(0)).getNodeValue();
                    }
                    if (ClientSideProject.this.name == null) {
                        ClientSideProject.this.name = ClientSideProject.this.getProjectDirectory().getNameExt();
                    }
                    return null;
                }
            });
        }
        assert (this.name != null);
        return this.name;
    }

    public void setName(String name) {
        ClientSideProjectUtilities.setProjectName(this.projectHelper, name, true);
    }

    private Lookup createLookup(AuxiliaryConfiguration configuration, Object xmlSavedHook) {
        FileEncodingQueryImpl fileEncodingQuery = new FileEncodingQueryImpl(this.getEvaluator(), "files.encoding");
        Lookup base = Lookups.fixed((Object[])new Object[]{this, new Info(), xmlSavedHook, new ProjectOperations(this), ProjectSearchInfo.create(this), fileEncodingQuery, new ServerURLMappingImpl(this), configuration, this.projectHelper.createCacheDirectoryProvider(), this.projectHelper.createAuxiliaryProperties(), new ClientSideProjectLogicalView(this), new RecommendedAndPrivilegedTemplatesImpl(), new ClientSideProjectActionProvider(this), new OpenHookImpl(this), new CustomizerProviderImpl(this), new ClassPathProviderImpl(this), new PageInspectorCustomizerImpl(this), new ProjectWebRootProviderImpl(), new ClientSideProjectSources(this, this.projectHelper, this.eval), new ClientSideModuleImpl(this), ProjectPropertiesProblemProvider.createForProject(this), CssPreprocessors.getDefault().createProjectProblemsProvider((Project)this), UILookupMergerSupport.createProjectProblemsProviderMerger(), new CreateFromTemplateAttributesImpl(this.projectHelper, fileEncodingQuery), SharabilityQueryImpl.create(this.projectHelper, this.eval, "site.root.folder", "test.folder"), LookupProviderSupport.createSharabilityQueryMerger(), this.projectBrowserProvider, new ProjectDirectoriesProviderImpl(), new CoverageProviderImpl((Project)this)});
        return LookupProviderSupport.createCompositeLookup((Lookup)base, (String)"Projects/org-netbeans-modules-web-clientproject/Lookup");
    }

    void recompileSources(CssPreprocessor cssPreprocessor) {
        assert (cssPreprocessor != null);
        FileObject siteRootFolder = this.getSiteRootFolder();
        if (siteRootFolder == null) {
            return;
        }
        CssPreprocessors.getDefault().process(cssPreprocessor, (Project)this, siteRootFolder);
    }

    ClassPath getSourceClassPath() {
        if (this.sourcePath == null) {
            this.pathImpl = new ClassPathProviderImpl.PathImpl(this);
            this.sourcePath = ClassPathProviderImpl.createProjectClasspath((PathResourceImplementation)this.pathImpl);
        }
        return this.sourcePath;
    }

    private final class PlatformProvidersListenerImpl
    implements PlatformProvidersListener {
        private PlatformProvidersListenerImpl() {
        }

        public void platformProvidersChanged() {
        }

        public void propertyChanged(Project project, PlatformProvider platformProvider, PropertyChangeEvent event) {
            if (ClientSideProject.this.equals(project)) {
                LOGGER.log(Level.FINE, "Processing platform provider event {0}", event);
                String propertyName = event.getPropertyName();
                if (propertyName == null) {
                    assert (false) : "No property name given";
                    return;
                }
                switch (propertyName) {
                    case "ENABLED": {
                        this.providerChanged(platformProvider, (Boolean)event.getNewValue());
                        break;
                    }
                    case "SOURCE_ROOTS": {
                        this.sourceRootsChanged();
                        break;
                    }
                    case "RUN_CONFIGURATION": {
                        this.runConfigurationChanged((String)event.getNewValue());
                        break;
                    }
                    case "PROJECT_NAME": {
                        this.projectNameChanged(platformProvider, (String)event.getNewValue());
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled property change: " + propertyName;
                        break;
                    }
                }
            }
        }

        private void providerChanged(PlatformProvider platformProvider, boolean enabled) {
            Info info = (Info)ClientSideProject.this.getLookup().lookup(Info.class);
            assert (info != null);
            info.firePropertyChange("icon");
            this.sourceRootsChanged();
            if (!enabled) {
                this.verifyRunAs(platformProvider);
            }
        }

        private void sourceRootsChanged() {
            if (ClientSideProject.this.pathImpl != null) {
                ClientSideProject.this.pathImpl.fireRootsChanged();
            }
        }

        private void runConfigurationChanged(String runAs) {
            this.saveRunProperties(runAs, null);
        }

        private void verifyRunAs(PlatformProvider platformProvider) {
            String currentRunAs = ClientSideProject.this.getRunAs();
            if (currentRunAs == null) {
                return;
            }
            for (CustomizerPanel customizerPanel : platformProvider.getRunCustomizerPanels((Project)ClientSideProject.this)) {
                if (!currentRunAs.equals(customizerPanel.getIdentifier())) continue;
                this.saveRunProperties(null, true);
                return;
            }
        }

        private void projectNameChanged(PlatformProvider platformProvider, String newName) {
            if (StringUtilities.hasText((String)newName) && !ClientSideProject.this.getName().equals(newName)) {
                ClientSideProject.this.setName(newName);
                NotificationDisplayer.getDefault().notify(Bundle.PlatformProvidersListenerImpl_sync_title(platformProvider.getDisplayName(), newName), NotificationDisplayer.Priority.LOW.getIcon(), Bundle.PlatformProvidersListenerImpl_sync_name(newName), null, NotificationDisplayer.Priority.LOW);
            }
        }

        private void saveRunProperties(final String runAs, final Boolean runBrowser) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    ClientSideProjectProperties properties = new ClientSideProjectProperties(ClientSideProject.this);
                    properties.setRunAs(runAs);
                    properties.setProjectServer(runAs != null ? ClientSideProjectProperties.ProjectServer.EXTERNAL : ClientSideProjectProperties.ProjectServer.INTERNAL);
                    if (runBrowser != null) {
                        properties.setRunBrowser(runBrowser);
                    }
                    properties.save();
                }
            });
        }
    }

    private final class ProjectDirectoriesProviderImpl
    implements ProjectDirectoriesProvider {
        private ProjectDirectoriesProviderImpl() {
        }

        public FileObject getTestDirectory(boolean showFileChooser) {
            return ClientSideProject.this.getTestsFolder(showFileChooser);
        }

        public FileObject getTestSeleniumDirectory(boolean showFileChooser) {
            return ClientSideProject.this.getTestsSeleniumFolder(showFileChooser);
        }
    }

    private final class CallbackImpl
    implements CommonProjectHelper.Callback {
        private CallbackImpl() {
        }

        @Override
        public void projectXmlSaved() throws IOException {
            Info info = (Info)ClientSideProject.this.getLookup().lookup(Info.class);
            assert (info != null);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }

        @Override
        public void configurationXmlChanged() {
            final String oldName = ClientSideProject.this.getName();
            ClientSideProject.this.name = null;
            final String newName = ClientSideProject.this.getName();
            if (!Objects.equals(oldName, newName)) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        PlatformProviders.getDefault().notifyPropertyChanged((Project)ClientSideProject.this, new PropertyChangeEvent(ClientSideProject.this, "PROJECT_NAME", oldName, newName));
                    }
                });
            }
        }

        @Override
        public void propertiesChanged() {
        }
    }

    private static final class ClientSideModuleImpl
    implements ClientSideModule {
        private final ClientSideProject project;

        public ClientSideModuleImpl(ClientSideProject project) {
            this.project = project;
        }

        public ClientSideModule.Properties getProperties() {
            return new PropertiesImpl();
        }

        private final class PropertiesImpl
        implements ClientSideModule.Properties {
            private PropertiesImpl() {
            }

            public FileObject getStartFile() {
                File startFile = this.getProjectProperties().getResolvedStartFile();
                if (startFile == null) {
                    return null;
                }
                return FileUtil.toFileObject((File)startFile);
            }

            public String getWebContextRoot() {
                return this.getProjectProperties().getWebRoot();
            }

            private ClientSideProjectProperties getProjectProperties() {
                return new ClientSideProjectProperties(ClientSideModuleImpl.this.project);
            }
        }
    }

    private static final class ProjectSearchInfo
    extends SearchInfoDefinition {
        private static final Set<String> WATCHED_PROPERTIES = new HashSet<String>(Arrays.asList("site.root.folder", "test.folder"));
        private final ClientSideProject project;
        private SearchInfo delegate = null;

        public ProjectSearchInfo(ClientSideProject project) {
            this.project = project;
        }

        public static SearchInfoDefinition create(ClientSideProject project) {
            final ProjectSearchInfo searchInfo = new ProjectSearchInfo(project);
            project.getEvaluator().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (WATCHED_PROPERTIES.contains(evt.getPropertyName())) {
                        searchInfo.resetDelegate();
                    }
                }
            });
            return searchInfo;
        }

        public boolean canSearch() {
            return true;
        }

        public Iterator<FileObject> filesToSearch(SearchScopeOptions options, SearchListener listener, AtomicBoolean terminated) {
            return this.getDelegate().getFilesToSearch(options, listener, terminated).iterator();
        }

        public List<SearchRoot> getSearchRoots() {
            return this.getDelegate().getSearchRoots();
        }

        private synchronized SearchInfo getDelegate() {
            assert (Thread.holdsLock((Object)this));
            if (this.delegate == null) {
                this.delegate = this.createDelegate();
            }
            return this.delegate;
        }

        private SearchInfo createDelegate() {
            return SearchInfoUtils.createSearchInfoForRoots((FileObject[])this.getRoots(), (boolean)true, (SearchFilterDefinition[])new SearchFilterDefinition[0]);
        }

        synchronized void resetDelegate() {
            assert (Thread.holdsLock((Object)this));
            this.delegate = null;
        }

        private FileObject[] getRoots() {
            ArrayList<FileObject> roots = new ArrayList<FileObject>();
            FileObject projectDir = this.project.getProjectDirectory();
            roots.add(projectDir);
            this.addRoots(roots, projectDir, this.project.getSourcesFolder(), this.project.getSiteRootFolder(), this.project.getTestsFolder(false), this.project.getTestsSeleniumFolder(false));
            return roots.toArray(new FileObject[roots.size()]);
        }

        private void addRoots(List<FileObject> result, FileObject projectDir, FileObject ... roots) {
            for (FileObject root : roots) {
                if (root == null || FileUtil.isParentOf((FileObject)projectDir, (FileObject)root)) continue;
                result.add(root);
            }
        }
    }

    private final class ProjectWebRootProviderImpl
    implements ProjectWebRootProvider {
        private ProjectWebRootProviderImpl() {
        }

        public FileObject getWebRoot(FileObject file) {
            FileObject siteRoot = ClientSideProject.this.getSiteRootFolder();
            if (siteRoot == null) {
                return null;
            }
            if (siteRoot.equals(file) || FileUtil.isParentOf((FileObject)siteRoot, (FileObject)file)) {
                return siteRoot;
            }
            return null;
        }

        public Collection<FileObject> getWebRoots() {
            FileObject siteRoot = ClientSideProject.this.getSiteRootFolder();
            if (siteRoot == null) {
                return Collections.emptyList();
            }
            return Collections.singleton(siteRoot);
        }
    }

    private static class SiteRootFolderListener
    implements FileChangeListener {
        private final ClientSideProject p;
        private final FileObject siteRootFolder;

        SiteRootFolderListener(ClientSideProject p) {
            this.p = p;
            this.siteRootFolder = p.getSiteRootFolder();
        }

        public void fileFolderCreated(FileEvent fe) {
            this.checkPreprocessors(fe.getFile());
        }

        public void fileDataCreated(FileEvent fe) {
            this.checkPreprocessors(fe.getFile());
        }

        public void fileChanged(FileEvent fe) {
            RefreshOnSaveListener r = this.p.getRefreshOnSaveListener();
            if (r != null) {
                r.fileChanged(fe.getFile());
            }
            this.checkPreprocessors(fe.getFile());
        }

        public void fileDeleted(FileEvent fe) {
            RefreshOnSaveListener r = this.p.getRefreshOnSaveListener();
            if (r != null) {
                r.fileDeleted(fe.getFile());
            }
            this.checkPreprocessors(fe.getFile());
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.checkPreprocessors(fe.getFile(), fe.getName(), fe.getExt());
            if (fe.getFile().equals(this.siteRootFolder)) {
                ClientSideProjectProperties projectProperties = new ClientSideProjectProperties(this.p);
                projectProperties.setSiteRootFolder(this.siteRootFolder.getNameExt());
                projectProperties.save();
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        private void checkPreprocessors(FileObject fileObject) {
            CssPreprocessors.getDefault().process((Project)this.p, fileObject);
        }

        private void checkPreprocessors(FileObject fileObject, String originalName, String originalExtension) {
            CssPreprocessors.getDefault().process((Project)this.p, fileObject, originalName, originalExtension);
        }
    }

    private static class OpenHookImpl
    extends ProjectOpenedHook
    implements PropertyChangeListener {
        private final ClientSideProject project;
        private FileChangeListener siteRootChangesListener;
        private File siteRootFolder;

        public OpenHookImpl(ClientSideProject project) {
            this.project = project;
        }

        protected void projectOpened() {
            new ProjectUpgrader(this.project).upgrade();
            this.project.getEvaluator().addPropertyChangeListener(this);
            this.addSiteRootListener();
            GlobalPathRegistry.getDefault().register("classpath/html5", new ClassPath[]{this.project.getSourceClassPath()});
            String browserId = "";
            WebBrowser wb = this.project.getProjectWebBrowser();
            if (wb != null) {
                browserId = wb.getId();
            }
            CssPreprocessors.getDefault().addCssPreprocessorsListener(this.project.cssPreprocessorsListener);
            JsTestingProvider jsTestingProvider = this.project.getJsTestingProvider(false);
            if (jsTestingProvider != null) {
                jsTestingProvider.projectOpened((Project)this.project);
            }
            PlatformProviders.getDefault().addPlatformProvidersListener(this.project.platformProvidersListener);
            PlatformProviders.getDefault().projectOpened((Project)this.project);
            FileObject projectDirectory = this.project.getProjectDirectory();
            this.checkAutoconfigured();
            FileObject testsFolder = this.project.getTestsFolder(false);
            FileObject testsSeleniumFolder = this.project.getTestsSeleniumFolder(false);
            boolean hasGrunt = projectDirectory.getFileObject("Gruntfile.js") != null;
            boolean hasBower = projectDirectory.getFileObject("bower.json") != null;
            boolean hasPackage = projectDirectory.getFileObject("package.json") != null;
            boolean hasGulp = projectDirectory.getFileObject("gulpfile.js") != null;
            ClientSideProjectUtilities.logUsage(ClientSideProject.class, "USG_PROJECT_HTML5_OPEN", new Object[]{browserId, testsFolder != null && testsFolder.getChildren().length > 0 ? "YES" : "NO", ClientSideProjectUtilities.isCordovaProject(this.project) ? "YES" : "NO", hasGrunt ? "YES" : "NO", hasBower ? "YES" : "NO", hasPackage ? "YES" : "NO", hasGulp ? "YES" : "NO", testsSeleniumFolder != null && testsSeleniumFolder.getChildren().length > 0 ? "YES" : "NO", StringUtilities.implode(this.getPlatformProviderNames(), (String)"|")});
        }

        private List<String> getPlatformProviderNames() {
            List<PlatformProvider> platformProviders = this.project.getPlatformProviders();
            if (platformProviders.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> names = new ArrayList<String>(platformProviders.size());
            for (PlatformProvider platformProvider : platformProviders) {
                names.add(platformProvider.getIdentifier());
            }
            return names;
        }

        protected void projectClosed() {
            this.project.getEvaluator().removePropertyChangeListener(this);
            this.removeSiteRootListener();
            GlobalPathRegistry.getDefault().unregister("classpath/html5", new ClassPath[]{this.project.getSourceClassPath()});
            CssPreprocessors.getDefault().removeCssPreprocessorsListener(this.project.cssPreprocessorsListener);
            JsTestingProvider jsTestingProvider = this.project.getJsTestingProvider(false);
            if (jsTestingProvider != null) {
                jsTestingProvider.projectClosed((Project)this.project);
            }
            PlatformProviders.getDefault().projectClosed((Project)this.project);
            PlatformProviders.getDefault().removePlatformProvidersListener(this.project.platformProvidersListener);
            ClientProjectEnhancedBrowserImplementation enhancedBrowserImpl = this.project.getEnhancedBrowserImpl();
            if (enhancedBrowserImpl != null) {
                enhancedBrowserImpl.close();
            }
        }

        private synchronized void addSiteRootListener() {
            assert (this.siteRootFolder == null) : "Should not be listening to " + this.siteRootFolder;
            FileObject siteRoot = this.project.getSiteRootFolder();
            if (siteRoot == null) {
                return;
            }
            this.siteRootFolder = FileUtil.toFile((FileObject)siteRoot);
            if (this.siteRootFolder == null) {
                LOGGER.log(Level.WARNING, "File not found for FileObject: {0}", siteRoot);
                return;
            }
            this.siteRootChangesListener = new SiteRootFolderListener(this.project);
            FileUtil.addRecursiveListener((FileChangeListener)this.siteRootChangesListener, (File)this.siteRootFolder);
        }

        private synchronized void removeSiteRootListener() {
            if (this.siteRootFolder == null) {
                return;
            }
            try {
                FileUtil.removeRecursiveListener((FileChangeListener)this.siteRootChangesListener, (File)this.siteRootFolder);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            this.siteRootFolder = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("site.root.folder".equals(evt.getPropertyName())) {
                OpenHookImpl openHookImpl = this;
                synchronized (openHookImpl) {
                    this.removeSiteRootListener();
                    this.addSiteRootListener();
                }
            }
        }

        private void checkAutoconfigured() {
            ClientSideProjectProperties projectProperties = new ClientSideProjectProperties(this.project);
            if (projectProperties.isAutoconfigured()) {
                NotificationDisplayer.getDefault().notify(Bundle.OpenHookImpl_notification_autoconfigured_title(ProjectUtils.getInformation((Project)this.project).getDisplayName()), NotificationDisplayer.Priority.LOW.getIcon(), Bundle.OpenHookImpl_notification_autoconfigured_details(), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((CustomizerProviderImpl)OpenHookImpl.this.project.getLookup().lookup(CustomizerProviderImpl.class)).showCustomizer("SOURCES");
                    }
                }, NotificationDisplayer.Priority.LOW);
                projectProperties.setAutoconfigured(false);
                projectProperties.save();
            }
        }
    }

    private static final class RecommendedAndPrivilegedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private RecommendedAndPrivilegedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            return new String[]{"html5", "html5-test", "selenium-types", "XML", "simple-files"};
        }

        public String[] getPrivilegedTemplates() {
            return new String[]{"Templates/ClientSide/html.html", "Templates/ClientSide/javascript.js", "Templates/ClientSide/css.css", "Templates/ClientSide/style.scss", "Templates/ClientSide/style.less", "Templates/ClientSide/json.json", "Templates/Other/org-netbeans-modules-project-ui-NewFileIterator-folderIterator"};
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        private Info() {
        }

        public String getName() {
            return ClientSideProject.this.is.getUsablePropertyName(this.getDisplayName());
        }

        public String getDisplayName() {
            return ClientSideProject.this.getName();
        }

        public Icon getIcon() {
            return new ImageIcon(ImageUtilities.loadImage((String)ClientSideProject.HTML5_PROJECT_ICON));
        }

        public Project getProject() {
            return ClientSideProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        void firePropertyChange(String prop) {
            this.propertyChangeSupport.firePropertyChange(prop, null, null);
        }
    }
}

