/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phing.options;

import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.phing.exec.PhingExecutable;
import org.openide.util.NbPreferences;

public final class PhingOptions {
    private static final String PHING_PATH = "phing.path";
    private static final String PREFERENCES_PATH = "phing";
    private static final PhingOptions INSTANCE = new PhingOptions();
    private final Preferences preferences = NbPreferences.forModule(PhingOptions.class).node("phing");
    private volatile boolean phingSearched = false;

    private PhingOptions() {
    }

    public static PhingOptions getInstance() {
        return INSTANCE;
    }

    @CheckForNull
    public String getPhing() {
        String path = this.preferences.get(PHING_PATH, null);
        if (path == null && !this.phingSearched) {
            this.phingSearched = true;
            List files = FileUtils.findFileOnUsersPath((String[])PhingExecutable.PHING_NAMES);
            if (!files.isEmpty()) {
                path = (String)files.get(0);
                this.setPhing(path);
            }
        }
        return path;
    }

    public void setPhing(String phing) {
        this.preferences.put(PHING_PATH, phing);
    }
}

