/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.grunt.ui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.grunt.GruntBuildTool;
import org.netbeans.modules.javascript.grunt.exec.GruntExecutable;
import org.netbeans.modules.javascript.grunt.file.GruntTasks;
import org.netbeans.modules.javascript.grunt.ui.actions.Bundle;
import org.netbeans.modules.javascript.grunt.util.GruntUtils;
import org.netbeans.modules.web.clientproject.api.build.BuildTools;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;

public final class RunGruntTaskAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Popup {
    static final Logger LOGGER = Logger.getLogger(RunGruntTaskAction.class.getName());
    private final Project project;

    public RunGruntTaskAction() {
        this((Project)null);
    }

    public RunGruntTaskAction(Project project) {
        this.project = project;
        this.setEnabled(project != null);
        this.putValue("hideWhenDisabled", true);
        this.putValue("Name", null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup context) {
        DataObject dataObject;
        Project contextProject = (Project)context.lookup(Project.class);
        if (contextProject != null) {
            return this.createAction(contextProject);
        }
        FileObject file = (FileObject)context.lookup(FileObject.class);
        if (file == null && (dataObject = (DataObject)context.lookup(DataObject.class)) != null) {
            file = dataObject.getPrimaryFile();
        }
        if (file == null) {
            return this;
        }
        contextProject = FileOwnerQuery.getOwner((FileObject)file);
        if (contextProject == null) {
            return null;
        }
        if (!contextProject.getProjectDirectory().equals(file.getParent())) {
            return this;
        }
        return this.createAction(contextProject);
    }

    private Action createAction(Project contextProject) {
        assert (contextProject != null);
        GruntBuildTool gruntBuildTool = GruntBuildTool.inProject(contextProject);
        if (gruntBuildTool == null) {
            return this;
        }
        if (!gruntBuildTool.getGruntfile().exists()) {
            return this;
        }
        return new RunGruntTaskAction(contextProject);
    }

    public JMenuItem getPopupPresenter() {
        if (this.project == null) {
            return new Actions.MenuItem((Action)this, false);
        }
        return BuildTools.getDefault().createTasksMenu((BuildTools.TasksMenuSupport)new TasksMenuSupportImpl(this.project));
    }

    private static final class TasksFuture
    implements Future<List<String>> {
        private final GruntTasks gruntTasks;

        public TasksFuture(GruntTasks gruntTasks) {
            assert (gruntTasks != null);
            this.gruntTasks = gruntTasks;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.gruntTasks.getTasks() != null;
        }

        @Override
        public List<String> get() throws InterruptedException, ExecutionException {
            try {
                return this.gruntTasks.loadTasks(null, null);
            }
            catch (TimeoutException ex) {
                assert (false);
                return null;
            }
        }

        @Override
        public List<String> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.gruntTasks.loadTasks(timeout, unit);
        }
    }

    private static final class TasksMenuSupportImpl
    implements BuildTools.TasksMenuSupport {
        private final Project project;
        private final GruntTasks gruntTasks;

        public TasksMenuSupportImpl(Project project) {
            assert (project != null);
            this.project = project;
            this.gruntTasks = GruntBuildTool.forProject(project).getGruntTasks();
        }

        public Project getProject() {
            return this.project;
        }

        public String getIdentifier() {
            return "Grunt";
        }

        public String getTitle(BuildTools.TasksMenuSupport.Title title) {
            switch (title) {
                case MENU: {
                    return Bundle.RunGruntTaskAction_name();
                }
                case LOADING_TASKS: {
                    return Bundle.TasksMenuSupportImpl_tasks_loading();
                }
                case RELOAD_TASKS: {
                    return Bundle.TasksMenuSupportImpl_tasks_reload();
                }
                case CONFIGURE_TOOL: {
                    return Bundle.TasksMenuSupportImpl_grunt_configure();
                }
                case RUN_ADVANCED: {
                    return Bundle.TasksMenuSupportImpl_tasks_run_advanced();
                }
                case TASKS_LABEL: {
                    return Bundle.TasksMenuSupportImpl_tasks_label();
                }
                case BUILD_TOOL_EXEC: {
                    return GruntExecutable.GRUNT_NAME;
                }
            }
            assert (false) : "Unknown title: " + title;
            return null;
        }

        public String getDefaultTaskName() {
            return "default";
        }

        public Future<List<String>> getTasks() {
            return new TasksFuture(this.gruntTasks);
        }

        public void runTask(String ... args) {
            assert (!EventQueue.isDispatchThread());
            GruntExecutable grunt = GruntExecutable.getDefault(this.project, true);
            if (grunt != null) {
                GruntUtils.logUsageGruntBuild();
                grunt.run(args);
            }
        }

        public void reloadTasks() {
            assert (!EventQueue.isDispatchThread());
            this.gruntTasks.reset();
            try {
                this.gruntTasks.loadTasks(null, null);
            }
            catch (ExecutionException | TimeoutException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }

        public void configure() {
            OptionsDisplayer.getDefault().open("Html5/Grunt");
        }
    }
}

