/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacroParameter;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmParameterList;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public class ParameterListImpl<T, K extends CsmNamedElement>
extends OffsetableBase
implements CsmParameterList<K> {
    private final Collection<CsmParameter> parameters;

    protected ParameterListImpl(CsmFile file, int start, int end, Collection<CsmParameter> parameters) {
        super(file, start, end);
        this.parameters = parameters == null || parameters.isEmpty() ? null : parameters;
    }

    public final Collection<K> getParameters() {
        return this._getParameters();
    }

    public final boolean isEmpty() {
        return this.parameters == null || this.parameters.isEmpty();
    }

    public final int getNrParameters() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private Collection<K> _getParameters() {
        if (this.parameters == null) {
            return Collections.emptyList();
        }
        Collection<CsmParameter> collection = this.parameters;
        return Collections.unmodifiableCollection(collection);
    }

    @Override
    public String toString() {
        return "ParamList " + super.toString();
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeParameters(this.parameters, output);
    }

    public ParameterListImpl(RepositoryDataInput input, CsmScope scope) throws IOException {
        super(input);
        this.parameters = PersistentUtils.readParameters(input, scope);
    }

    public static ParameterListImpl<CsmParameterList<CsmMacroParameter>, CsmMacroParameter> create(CsmFile file, APTMacro macro) {
        return ParameterListImpl.create(file, macro.getName(), macro.getParams());
    }

    public static ParameterListImpl<CsmParameterList<CsmMacroParameter>, CsmMacroParameter> create(CsmFile file, APTDefine define) {
        return ParameterListImpl.create(file, define.getName(), define.getParams());
    }

    private static ParameterListImpl<CsmParameterList<CsmMacroParameter>, CsmMacroParameter> create(CsmFile file, APTToken name, Collection<APTToken> params) {
        return null;
    }
}

