/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LazyOffsPositionImpl;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.repository.spi.Key;

public class PositionManager {
    private static final Impl IMPL = Impl.trivial;
    private static final ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, TreeMap<Integer, Integer>>> map = new ConcurrentHashMap();

    private PositionManager() {
    }

    public static CsmOffsetable.Position getPosition(CsmUID<CsmFile> uid, int posID) {
        CsmFile file = UIDCsmConverter.UIDtoFile(uid);
        if (file instanceof FileImpl) {
            return new LazyOffsPositionImpl((FileImpl)file, PositionManager.getOffset(uid, posID));
        }
        return new PositionImpl(posID);
    }

    public static int getOffset(CsmUID<CsmFile> uid, int posID) {
        if (IMPL == Impl.trivial) {
            return posID;
        }
        Key key = RepositoryUtils.UIDtoKey(uid);
        TreeMap<Integer, Integer> fileMap = PositionManager.getFileMap(key);
        return (Integer)fileMap.get(posID);
    }

    public static int createPositionID(CsmUID<CsmFile> uid, int offset, Position.Bias bias) {
        if (IMPL == Impl.trivial) {
            return offset;
        }
        Key key = RepositoryUtils.UIDtoKey(uid);
        int maxPositionId = 0;
        TreeMap<Integer, Integer> fileMap = PositionManager.getFileMap(key);
        if (fileMap.isEmpty()) {
            maxPositionId = 1;
        } else {
            Integer lastKey = fileMap.lastKey();
            maxPositionId = lastKey + 1;
        }
        fileMap.put(maxPositionId, offset);
        return maxPositionId;
    }

    private static TreeMap<Integer, Integer> getFileMap(Key key) {
        TreeMap<Integer, Integer> fileMap;
        int unit = key.getUnitId();
        int file = KeyUtilities.getProjectFileIndex(key);
        ConcurrentHashMap<Integer, TreeMap<Integer, Integer>> unitMap = map.get(unit);
        if (unitMap == null) {
            unitMap = new ConcurrentHashMap();
            ConcurrentHashMap<Integer, TreeMap<Integer, Integer>> old = map.putIfAbsent(unit, unitMap);
            if (old != null) {
                unitMap = old;
            }
        }
        if ((fileMap = unitMap.get(file)) == null) {
            fileMap = new TreeMap();
            TreeMap<Integer, Integer> old = unitMap.putIfAbsent(file, fileMap);
            if (old != null) {
                fileMap = old;
            }
        }
        return fileMap;
    }

    private static class PositionImpl
    implements CsmOffsetable.Position {
        private final int offset;

        public PositionImpl(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLine() {
            return -1;
        }

        public int getColumn() {
            return -1;
        }

        public String toString() {
            return "offset=" + this.offset;
        }
    }

    public static interface Position {
        public int getOffset();

        public int getLine();

        public int getColumn();

        public static enum Bias {
            FOWARD,
            BACKWARD;

        }
    }

    private static enum Impl {
        trivial,
        optimistic,
        full,
        map;

    }
}

