/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.textcache.DefaultCache;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.filesystems.FileObject;

public class SourceRootContainer {
    private final Map<CharSequence, Integer> projectRoots = new ConcurrentHashMap<CharSequence, Integer>();
    private final boolean isFixedRoots;

    public SourceRootContainer(boolean isFixedRoots) {
        this.isFixedRoots = isFixedRoots;
    }

    public boolean isMySource(CharSequence includePath) {
        Integer val;
        if (this.projectRoots.size() < 10) {
            boolean check = false;
            for (Map.Entry<CharSequence, Integer> entry : this.projectRoots.entrySet()) {
                if (!CharSequenceUtils.startsWith((CharSequence)includePath, (CharSequence)entry.getKey())) continue;
                if (includePath.length() == entry.getKey().length()) {
                    return true;
                }
                check = true;
                break;
            }
            if (!check) {
                return false;
            }
        } else if (this.projectRoots.containsKey(DefaultCache.getManager().getString(includePath))) {
            return true;
        }
        do {
            int i;
            if ((i = CharSequenceUtils.lastIndexOf((CharSequence)includePath, (int)92)) <= 0) {
                i = CharSequenceUtils.lastIndexOf((CharSequence)includePath, (int)47);
            }
            if (i <= 0) {
                return false;
            }
            includePath = includePath.subSequence(0, i);
        } while ((val = this.projectRoots.get(DefaultCache.getManager().getString(includePath))) == null || !(this.isFixedRoots ? val > 0x1FFFFFFF : val > 0));
        return true;
    }

    public void fixFolder(CharSequence path) {
        if (path != null) {
            this.projectRoots.put(FilePathCache.getManager().getString(path), 0x3FFFFFFF);
        }
    }

    public void addSources(Collection<NativeFileItem> items) {
        for (NativeFileItem nativeFileItem : items) {
            this.addFileItemBasedPath(nativeFileItem);
        }
    }

    private void addFileItemBasedPath(NativeFileItem nativeFileItem) {
        FileObject fo = nativeFileItem.getFileObject();
        FileObject parent = fo.getParent();
        String path = CndFileUtils.normalizePath((FileObject)parent);
        this.addPath(path);
        try {
            String canonicalPath = CndFileUtils.getCanonicalPath((FileObject)parent);
            if (!path.equals(canonicalPath)) {
                this.addPath(canonicalPath);
            }
        }
        catch (IOException ex) {
            DiagnosticExceptoins.register(ex);
        }
    }

    private CharSequence findParent(CharSequence path) {
        Integer val;
        while ((val = this.projectRoots.get(DefaultCache.getManager().getString(path))) == null || val <= 0x1FFFFFFF) {
            int i = CharSequenceUtils.lastIndexOf((CharSequence)path, (int)92);
            if (i <= 0) {
                i = CharSequenceUtils.lastIndexOf((CharSequence)path, (int)47);
            }
            if (i <= 0) {
                return null;
            }
            path = path.subSequence(0, i);
        }
        return path;
    }

    private void addPath(CharSequence path) {
        CharSequence added;
        Integer integer;
        CharSequence parent = this.findParent(path);
        if (parent != null) {
            path = parent;
        }
        if ((integer = this.projectRoots.get(added = FilePathCache.getManager().getString(path))) == null) {
            this.projectRoots.put(added, 1);
        } else {
            this.projectRoots.put(added, integer + 1);
        }
    }

    void clear() {
        this.projectRoots.clear();
    }
}

