/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ExpressionBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.DefaultCache;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public class ExpandedExpressionBase
extends ExpressionBase {
    private static final Logger LOG = Logger.getLogger(ExpandedExpressionBase.class.getSimpleName());
    private static final String SKIPPED_STUB = "\"skipped\"";
    private static final int MAX_EXPANDING_LENGTH = 512;
    private final CharSequence expandedText;

    ExpandedExpressionBase(AST ast, CsmFile file, CsmScope scope) {
        super(ast, file, scope);
        ASTTokensFilteringStringizer stringizer = new ASTTokensFilteringStringizer();
        AstUtil.visitAST(stringizer, ast);
        String expanded = stringizer.getText();
        if (expanded.length() > 512) {
            LOG.log(Level.FINE, "Too large expression ({0} symbols) defined inside macros: {1}:{2}", new Object[]{expanded.length(), file, this.getStartPosition()});
            expanded = SKIPPED_STUB;
        }
        this.expandedText = stringizer.getNumberOfStringizedTokens() > 1 ? CharSequences.create((CharSequence)expanded) : DefaultCache.getManager().getString((CharSequence)expanded);
    }

    @Override
    public CharSequence getExpandedText() {
        return this.expandedText;
    }

    public static boolean hasExpandedTokens(AST ast) {
        AstUtil.ASTExpandedTokensChecker checker = new AstUtil.ASTExpandedTokensChecker();
        AstUtil.visitAST(checker, ast);
        return checker.HasExpanded();
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeUTF(this.expandedText, output);
    }

    public ExpandedExpressionBase(RepositoryDataInput input) throws IOException {
        super(input);
        this.expandedText = PersistentUtils.readUTF(input, DefaultCache.getManager());
    }

    private static class ASTTokensFilteringStringizer
    extends AstUtil.ASTTokensStringizer {
        private ASTTokensFilteringStringizer() {
        }

        @Override
        public AstUtil.ASTTokenVisitor.Action visit(AST token) {
            if (token.getType() == 79) {
                this.sb.append(ExpandedExpressionBase.SKIPPED_STUB);
                ++this.numStringizedTokens;
                return AstUtil.ASTTokenVisitor.Action.CONTINUE;
            }
            return super.visit(token);
        }
    }
}

