/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.modelimpl.content.project.GraphContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.dlight.libs.common.PathUtilities;

public final class IncludeResolverImpl
extends CsmIncludeResolver {
    private final Set<String> standardHeaders = new HashSet<String>();

    public IncludeResolverImpl() {
        this.standardHeaders.add("algorithm");
        this.standardHeaders.add("bitset");
        this.standardHeaders.add("complex");
        this.standardHeaders.add("deque");
        this.standardHeaders.add("exception");
        this.standardHeaders.add("fstream");
        this.standardHeaders.add("functional");
        this.standardHeaders.add("iomanip");
        this.standardHeaders.add("ios");
        this.standardHeaders.add("iosfwd");
        this.standardHeaders.add("iostream");
        this.standardHeaders.add("iterator");
        this.standardHeaders.add("limits");
        this.standardHeaders.add("list");
        this.standardHeaders.add("locale");
        this.standardHeaders.add("map");
        this.standardHeaders.add("memory");
        this.standardHeaders.add("new");
        this.standardHeaders.add("numeric");
        this.standardHeaders.add("queue");
        this.standardHeaders.add("set");
        this.standardHeaders.add("sstream");
        this.standardHeaders.add("stack");
        this.standardHeaders.add("stdexcept");
        this.standardHeaders.add("streambuf");
        this.standardHeaders.add("string");
        this.standardHeaders.add("typeinfo");
        this.standardHeaders.add("utility");
        this.standardHeaders.add("valarray");
        this.standardHeaders.add("vector");
        this.standardHeaders.add("cassert");
        this.standardHeaders.add("cctype");
        this.standardHeaders.add("cerrno");
        this.standardHeaders.add("cfloat");
        this.standardHeaders.add("ciso646");
        this.standardHeaders.add("climits");
        this.standardHeaders.add("clocale");
        this.standardHeaders.add("cmath");
        this.standardHeaders.add("csetjmp");
        this.standardHeaders.add("csignal");
        this.standardHeaders.add("cstdarg");
        this.standardHeaders.add("cstddef");
        this.standardHeaders.add("cstdio");
        this.standardHeaders.add("cstdlib");
        this.standardHeaders.add("cstring");
        this.standardHeaders.add("ctime");
        this.standardHeaders.add("cwchar");
        this.standardHeaders.add("cwctype");
        this.standardHeaders.add("assert.h");
        this.standardHeaders.add("ctype.h");
        this.standardHeaders.add("errno.h");
        this.standardHeaders.add("float.h");
        this.standardHeaders.add("iso646.h");
        this.standardHeaders.add("limits.h");
        this.standardHeaders.add("locale.h");
        this.standardHeaders.add("math.h");
        this.standardHeaders.add("setjmp.h");
        this.standardHeaders.add("signal.h");
        this.standardHeaders.add("stdarg.h");
        this.standardHeaders.add("stddef.h");
        this.standardHeaders.add("stdio.h");
        this.standardHeaders.add("stdlib.h");
        this.standardHeaders.add("string.h");
        this.standardHeaders.add("time.h");
        this.standardHeaders.add("wchar.h");
        this.standardHeaders.add("wctype.h");
    }

    public String getIncludeDirective(CsmFile currentFile, CsmObject item) {
        if (CsmKindUtilities.isOffsetable((Object)item)) {
            CsmFile file = ((CsmOffsetable)item).getContainingFile();
            if (file != null) {
                Collection decls;
                if (file.equals(currentFile) || file.isHeaderFile()) {
                    return this.getIncludeDirectiveByFile(currentFile, item).replace('\\', '/');
                }
                if (file.isSourceFile() && CsmKindUtilities.isGlobalVariable((CsmObject)item) && !(decls = file.getProject().findDeclarations((CharSequence)(((CsmVariable)item).getUniqueName() + " (EXTERN)"))).isEmpty()) {
                    return this.getIncludeDirectiveByFile(currentFile, (CsmObject)decls.iterator().next()).replace('\\', '/');
                }
            } else {
                System.err.println("can not find for item " + item);
            }
        } else if (!CsmKindUtilities.isNamespace((Object)item)) {
            System.err.println("not yet handled object " + item);
        }
        return "";
    }

    private boolean isStandardHeader(List<FSPath> sysIncsPaths, CsmFile header) {
        String path = header.getAbsolutePath().toString();
        String bestSystemPath = this.getRelativePath(sysIncsPaths, path);
        return this.standardHeaders.contains(path.substring(bestSystemPath.length() + 1));
    }

    private CsmFile getStandardHeaderIfExists(CsmFile currentFile, List<FSPath> sysIncsPaths, CsmFile file, HashSet<CsmFile> scannedFiles) {
        if (!file.isValid() || scannedFiles.contains(file) || !this.isSystemHeader(currentFile, file)) {
            return null;
        }
        scannedFiles.add(file);
        if (this.isStandardHeader(sysIncsPaths, file)) {
            return file;
        }
        CsmIncludeHierarchyResolver ihr = CsmIncludeHierarchyResolver.getDefault();
        Collection files = ihr.getFiles(file);
        for (CsmFile f : files) {
            CsmFile stdHeader = this.getStandardHeaderIfExists(currentFile, sysIncsPaths, f, scannedFiles);
            if (stdHeader == null) continue;
            return stdHeader;
        }
        return null;
    }

    private String getIncludeDirectiveByFile(CsmFile currentFile, CsmObject item) {
        if (CsmKindUtilities.isOffsetable((Object)item)) {
            if (currentFile instanceof FileImpl) {
                NativeFileItem nativeFile = ((FileImpl)currentFile).getNativeFileItem();
                CsmFile incFile = ((CsmOffsetable)item).getContainingFile();
                String incFilePath = incFile.getAbsolutePath().toString();
                StringBuilder includeDirective = new StringBuilder("#include ");
                if (nativeFile != null) {
                    if (this.isSystemHeader(currentFile, ((CsmOffsetable)item).getContainingFile())) {
                        String bestSystemPath;
                        HashSet<CsmFile> scannedFiles = new HashSet<CsmFile>();
                        CsmFile stdHeader = this.getStandardHeaderIfExists(currentFile, nativeFile.getSystemIncludePaths(), ((CsmOffsetable)item).getContainingFile(), scannedFiles);
                        if (stdHeader != null) {
                            incFilePath = stdHeader.getAbsolutePath().toString();
                        }
                        if (!(bestSystemPath = this.getRelativePath(nativeFile.getSystemIncludePaths(), incFilePath)).equals("")) {
                            includeDirective.append("<");
                            includeDirective.append(CndPathUtilities.toRelativePath((String)bestSystemPath, (String)incFilePath));
                            includeDirective.append(">");
                            return includeDirective.toString();
                        }
                    } else {
                        String bestUserPath;
                        includeDirective.append("\"");
                        String projectPath = currentFile.getAbsolutePath().toString().substring(0, currentFile.getAbsolutePath().length() - currentFile.getName().length() - 1);
                        if (!incFilePath.startsWith(projectPath)) {
                            projectPath = "";
                        }
                        if ((bestUserPath = this.getRelativePath(nativeFile.getUserIncludePaths(), incFilePath)).length() < projectPath.length()) {
                            includeDirective.append(CndPathUtilities.toRelativePath((String)projectPath, (String)incFilePath));
                        } else {
                            includeDirective.append(CndPathUtilities.toRelativePath((String)bestUserPath, (String)incFilePath));
                        }
                        if (!bestUserPath.equals("") || !projectPath.equals("")) {
                            includeDirective.append("\"");
                            return includeDirective.toString();
                        }
                    }
                } else {
                    String projectPath = currentFile.getAbsolutePath().toString().substring(0, currentFile.getAbsolutePath().length() - currentFile.getName().length());
                    if (incFilePath.startsWith(projectPath)) {
                        includeDirective.append("\"");
                        includeDirective.append(incFilePath.substring(projectPath.length()));
                        includeDirective.append("\"");
                        return includeDirective.toString();
                    }
                }
            } else {
                System.err.println("not handled file instance " + currentFile);
            }
        } else if (!CsmKindUtilities.isNamespace((Object)item)) {
            System.err.println("not yet handled object " + item);
        }
        return "";
    }

    public String getLocalIncludeDerectiveByFilePath(FSPath path, CsmObject item) {
        if (CsmKindUtilities.isOffsetable((Object)item)) {
            CsmFile incFile = ((CsmOffsetable)item).getContainingFile();
            if (incFile != null) {
                if (incFile.isHeaderFile()) {
                    return this.getLocalIncludeDerectiveByHeaderFilePath(path, item).replace('\\', '/');
                }
                if (incFile.isSourceFile() && CsmKindUtilities.isGlobalVariable((CsmObject)item)) {
                    Collection decls = incFile.getProject().findDeclarations((CharSequence)(((CsmVariable)item).getUniqueName() + " (EXTERN)"));
                    if (!decls.isEmpty()) {
                        return this.getLocalIncludeDerectiveByHeaderFilePath(path, (CsmObject)decls.iterator().next()).replace('\\', '/');
                    }
                } else if (incFile.isSourceFile() && CsmKindUtilities.isFunctionDefinition((CsmObject)item)) {
                    return this.getLocalIncludeDerectiveByHeaderFilePath(path, (CsmObject)((CsmFunction)item).getDeclaration()).replace('\\', '/');
                }
            } else {
                System.err.println("can not find for item " + item);
            }
        } else if (!CsmKindUtilities.isNamespace((Object)item)) {
            System.err.println("not yet handled object " + item);
        }
        return "";
    }

    private String getLocalIncludeDerectiveByHeaderFilePath(FSPath path, CsmObject item) {
        CsmFile incFile = ((CsmOffsetable)item).getContainingFile();
        if (incFile.isHeaderFile()) {
            String incFilePath = incFile.getAbsolutePath().toString();
            StringBuilder includeDirective = new StringBuilder("#include ");
            includeDirective.append("\"");
            String projectPath = path.getPath();
            if (!incFilePath.startsWith(projectPath)) {
                projectPath = "";
            }
            includeDirective.append(CndPathUtilities.toRelativePath((String)projectPath, (String)incFilePath));
            if (!projectPath.equals("")) {
                includeDirective.append("\"");
                return includeDirective.toString();
            }
        }
        return "";
    }

    private String getRelativePath(List<FSPath> paths, String filePath) {
        String goodPath = "";
        for (FSPath fsPath : paths) {
            String path = fsPath.getPath();
            if (!filePath.startsWith(path) || goodPath.length() >= path.length()) continue;
            goodPath = path;
        }
        return goodPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isObjectVisible(CsmFile currentFile, CsmObject item) {
        if (CsmKindUtilities.isOffsetable((Object)item)) {
            CsmFile file = ((CsmOffsetable)item).getContainingFile();
            if (file == null) return false;
            if (file.equals(currentFile)) return true;
            if (file.isHeaderFile()) {
                if (!((ProjectBase)currentFile.getProject()).getGraphStorage().isFileIncluded(currentFile, file)) return false;
                return true;
            }
            if (!file.isSourceFile() || !CsmKindUtilities.isGlobalVariable((CsmObject)item)) return false;
            HashSet<CsmProject> scannedprojects = new HashSet<CsmProject>();
            if (!this.isVariableVisible(currentFile, file.getProject(), (CsmVariable)item, scannedprojects)) return false;
            return true;
        }
        if (CsmKindUtilities.isFile((CsmObject)item)) {
            CsmFile file = (CsmFile)item;
            if (file.equals(currentFile)) return true;
            if (!file.isHeaderFile() || !((ProjectBase)currentFile.getProject()).getGraphStorage().isFileIncluded(currentFile, file)) return false;
            return true;
        }
        if (CsmKindUtilities.isNamespace((Object)item)) return false;
        System.err.println("not yet handled object " + item);
        return false;
    }

    public CsmFile getCloseTopParentFile(CsmFile file) {
        if (file.isHeaderFile()) {
            String name = file.getName().toString();
            if (name.indexOf(46) > 0) {
                name = name.substring(0, name.lastIndexOf(46));
            }
            GraphContainer.ParentFiles topParentFiles = ((ProjectBase)file.getProject()).getGraphStorage().getTopParentFiles(file);
            for (CsmUID<CsmFile> uid : topParentFiles.getCompilationUnitsUids()) {
                String aName = PathUtilities.getBaseName((String)UIDUtilities.getName(uid).toString());
                if (aName.indexOf(46) > 0) {
                    aName = aName.substring(0, aName.lastIndexOf(46));
                }
                if (!name.equals(aName)) continue;
                return UIDCsmConverter.UIDtoFile(uid);
            }
        }
        return null;
    }

    private boolean isVariableVisible(CsmFile currentFile, CsmProject project, CsmVariable var, HashSet<CsmProject> scannedProjects) {
        if (scannedProjects.contains(project)) {
            return false;
        }
        scannedProjects.add(project);
        if (this.isVariableDeclarationsVisible(currentFile, project.findDeclarations((CharSequence)(var.getUniqueName() + " (EXTERN)")))) {
            return true;
        }
        if (this.isVariableDeclarationsVisible(currentFile, project.findDeclarations(var.getUniqueName()))) {
            return true;
        }
        for (CsmProject lib : project.getLibraries()) {
            if (!this.isVariableVisible(currentFile, lib, var, scannedProjects)) continue;
            return true;
        }
        return false;
    }

    private boolean isVariableDeclarationsVisible(CsmFile currentFile, Collection<CsmOffsetableDeclaration> decls) {
        for (CsmOffsetableDeclaration decl : decls) {
            if (decl.getContainingFile().equals(currentFile)) {
                return true;
            }
            if (!((ProjectBase)currentFile.getProject()).getGraphStorage().isFileIncluded(currentFile, decl.getContainingFile())) continue;
            return true;
        }
        return false;
    }

    private boolean isSystemHeader(CsmFile currentFile, CsmFile header) {
        return !currentFile.getProject().equals(header.getProject());
    }
}

