/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageSupport;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.modelimpl.parser.FortranParserEx;
import org.netbeans.modules.cnd.modelimpl.parser.FortranToken;

public class FortranTokenStream
extends CommonTokenStream {
    public TokenSource lexer;
    public int needIdent;
    public int parserBacktracking;
    public boolean matchFailed;
    private List currLine;
    private int lineLength;
    private ArrayList<Token> packedList;
    private ArrayList<Token> newTokensList;

    public FortranTokenStream(TokenSource lexer) {
        super(lexer);
        this.lexer = lexer;
        this.needIdent = 0;
        this.parserBacktracking = 0;
        this.matchFailed = false;
        this.currLine = null;
        this.lineLength = 0;
        this.packedList = null;
        this.newTokensList = new ArrayList();
    }

    public void fixupFixedFormat() {
        ArrayList<Token> tmpArrayList = null;
        List tmpList = null;
        int i = 0;
        tmpList = super.getTokens();
        tmpArrayList = new ArrayList<Token>(tmpList.size());
        for (i = 0; i < tmpList.size(); ++i) {
            try {
                tmpArrayList.add((Token)tmpList.get(i));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < tmpArrayList.size(); ++i) {
            Token tmpToken = (Token)tmpArrayList.get(i);
            if (tmpToken.getCharPositionInLine() != 5 || tmpToken.getType() == FortranLexer.WS || tmpToken.getType() == FortranLexer.T_EOS && (tmpToken.getType() != FortranLexer.T_EOS || tmpToken.getText().charAt(0) != ';')) continue;
            if (tmpToken.getText().length() > 1) {
                System.err.println("TODO: handle this continuation type!");
                continue;
            }
            Token prevToken = null;
            tmpToken.setType(FortranLexer.CONTINUE_CHAR);
            tmpToken.setChannel(99);
            tmpArrayList.set(i, tmpToken);
            int j = i - 1;
            do {
                prevToken = (Token)tmpArrayList.get(j);
            } while (--j >= 0 && (prevToken.getType() == FortranLexer.WS || prevToken.getType() == FortranLexer.LINE_COMMENT || prevToken.getType() == FortranLexer.T_EOS));
            for (int k = j + 2; k < i; ++k) {
                tmpToken = (Token)tmpArrayList.get(k);
                if (tmpToken.getType() != FortranLexer.T_EOS || tmpToken.getText().charAt(0) == ';') continue;
                tmpToken.setChannel(99);
                tmpArrayList.set(k, tmpToken);
            }
        }
        this.tokens = tmpArrayList;
    }

    private void createPackedList() {
        Token tmpToken = null;
        int i = 0;
        this.packedList = new ArrayList(this.lineLength + 1);
        for (i = 0; i < this.currLine.size(); ++i) {
            tmpToken = this.getTokenFromCurrLine(i);
            try {
                this.packedList.add(tmpToken);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.fixupContinuedLine(this.packedList);
        this.dropIgnoredTokens(this.packedList);
    }

    private boolean possiblySplitToken(ArrayList<Token> packedList, int firstContCharOffset, int currOffset) {
        int i = 0;
        for (i = firstContCharOffset + 1; i < currOffset; ++i) {
            if (packedList.get(i).getType() == FortranLexer.WS || packedList.get(i).getType() == FortranLexer.T_EOS) continue;
            return false;
        }
        return true;
    }

    private void fixupContinuedLine(ArrayList<Token> packedList) {
        int firstContCharOffset = -1;
        int secondContCharOffset = -1;
        for (int i = 0; i < packedList.size(); ++i) {
            if (packedList.get(i).getType() != FortranLexer.CONTINUE_CHAR) continue;
            if (firstContCharOffset == -1) {
                firstContCharOffset = i;
                continue;
            }
            if (this.possiblySplitToken(packedList, firstContCharOffset, i)) {
                Token token;
                StringBuffer buffer = new StringBuffer();
                int tokenCount = 0;
                for (int j = firstContCharOffset - 1; j <= i; ++j) {
                    packedList.get(j).setChannel(99);
                }
                buffer = buffer.append(packedList.get(firstContCharOffset - 1).getText());
                buffer = buffer.append(packedList.get(i + 1).getText());
                TokenStream ts = APTTokenStreamBuilder.buildTokenStream((String)buffer.toString().toUpperCase(), (String)"Fortran Language");
                ts = new APTCommentsFilter(ts);
                ts = APTLanguageSupport.getInstance().getFilter("Fortran Language").getFilteredStream(ts);
                FortranParserEx.MyTokenSource myLexer = new FortranParserEx.MyTokenSource(ts);
                packedList.get(i + 1).setChannel(99);
                do {
                    token = myLexer.nextToken();
                    if (++tokenCount == 1) {
                        token.setLine(packedList.get(firstContCharOffset - 1).getLine());
                        token.setCharPositionInLine(packedList.get(firstContCharOffset - 1).getCharPositionInLine());
                    } else {
                        token.setLine(packedList.get(i + 1).getLine());
                        token.setCharPositionInLine(packedList.get(i + 1).getCharPositionInLine());
                    }
                    if (token.getType() < 0) continue;
                    token.setText(token.getText().toLowerCase());
                    try {
                        packedList.add(i, token);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++i;
                } while (token.getType() >= 0);
                firstContCharOffset = -1;
                continue;
            }
            packedList.get(firstContCharOffset).setChannel(99);
            firstContCharOffset = i;
        }
    }

    private void dropIgnoredTokens(ArrayList<Token> packedList) {
        ArrayList<Token> tmpList = packedList;
        Token tmpToken = null;
        this.packedList = new ArrayList(this.packedList.size());
        for (int i = 0; i < tmpList.size(); ++i) {
            tmpToken = tmpList.get(i);
            if (tmpToken == null || tmpToken.getChannel() == 99) continue;
            try {
                this.packedList.add(tmpToken);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String lineToString(int lineStart, int lineEnd) {
        int i = 0;
        StringBuffer lineText = new StringBuffer();
        for (i = lineStart; i < this.packedList.size() - 1; ++i) {
            lineText.append(this.packedList.get(i).getText());
        }
        return lineText.toString();
    }

    public List getTokens(int start, int stop) {
        return super.getTokens(start, stop);
    }

    public int getCurrLineLength() {
        return this.packedList.size();
    }

    public int getRawLineLength() {
        return this.currLine.size();
    }

    public int getLineLength(int start) {
        Token token;
        int lineLength = 0;
        do {
            token = super.get(start + lineLength);
        } while (start + ++lineLength < this.tokens.size() && (token.getChannel() == 99 || token.getType() != FortranLexer.T_EOS && token.getType() != FortranLexer.EOF));
        return lineLength;
    }

    public int findTokenInPackedList(int start, int desiredToken) {
        Token tmpToken;
        if (start >= this.packedList.size()) {
            return -1;
        }
        do {
            tmpToken = this.packedList.get(start);
        } while (++start < this.packedList.size() && tmpToken.getType() != desiredToken);
        if (tmpToken.getType() == desiredToken) {
            return start - 1;
        }
        return -1;
    }

    public Token getToken(int pos) {
        if (pos >= this.packedList.size() || pos < 0) {
            System.out.println("pos is out of range!");
            System.out.println("pos: " + pos + " packedListSize: " + this.packedList.size());
            return null;
        }
        return this.packedList.get(pos);
    }

    public Token getToken(int start, int desiredToken) {
        int index = this.findToken(start, desiredToken);
        if (index != -1) {
            return this.packedList.get(index);
        }
        return null;
    }

    public int findToken(int start, int desiredToken) {
        Token tmpToken;
        if (start >= this.packedList.size()) {
            System.out.println("start is out of range!");
            System.out.println("start: " + start + " packedListSize: " + this.packedList.size());
            return -1;
        }
        do {
            tmpToken = this.packedList.get(start);
        } while (++start < this.packedList.size() && tmpToken.getType() != desiredToken);
        if (tmpToken.getType() == desiredToken) {
            return start - 1;
        }
        return -1;
    }

    public int findTokenInCurrLine(int start, int desiredToken) {
        Token tmpToken;
        int size = this.currLine.size();
        if (start >= size) {
            return -1;
        }
        do {
            tmpToken = (Token)this.currLine.get(start);
        } while (++start < size && tmpToken.getType() != desiredToken);
        if (tmpToken.getType() == desiredToken) {
            return start;
        }
        return -1;
    }

    public Token getNextNonWSToken(int pos) {
        Token tmpToken = this.packedList.get(pos + 1);
        return tmpToken;
    }

    public int getNextNonWSTokenPos(int pos) {
        Token tmpToken = this.getNextNonWSToken(pos);
        pos = this.findTokenInCurrLine(pos, tmpToken.getType());
        return pos;
    }

    public Token getTokenFromCurrLine(int pos) {
        if (pos >= this.currLine.size() || pos < 0) {
            return null;
        }
        return (Token)this.currLine.get(pos);
    }

    public void setCurrLine(int lineStart) {
        this.lineLength = this.getLineLength(lineStart);
        this.currLine = this.getTokens(lineStart, lineStart + this.lineLength - 1);
        if (this.currLine != null) {
            this.createPackedList();
        } else {
            System.err.println("currLine is null!!!!");
        }
    }

    public int findTokenInSuper(int lineStart, int desiredToken) {
        int tmpToken;
        int lookAhead = 0;
        if (super.LA(1) == FortranLexer.LINE_COMMENT) {
            return -1;
        }
        while ((tmpToken = super.LA(++lookAhead)) != FortranLexer.EOF && tmpToken != FortranLexer.T_EOS && tmpToken != desiredToken) {
        }
        if (tmpToken == desiredToken) {
            return lookAhead;
        }
        return -1;
    }

    public void printCurrLine() {
        System.out.println("=================================");
        System.out.println("currLine.size() is: " + this.currLine.size());
        System.out.println(this.currLine.toString());
        System.out.println("=================================");
    }

    public void printPackedList() {
        System.out.println("*********************************");
        System.out.println("packedListSize is: " + this.packedList.size());
        System.out.println(this.packedList.toString());
        System.out.println("*********************************");
    }

    public int currLineLA(int lookAhead) {
        Token tmpToken = null;
        try {
            if (lookAhead <= this.packedList.size()) {
                tmpToken = this.packedList.get(lookAhead - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tmpToken != null ? tmpToken.getType() : FortranLexer.EOF;
    }

    public boolean lookForToken(int desiredToken) {
        int tmpToken;
        int lookAhead = 1;
        do {
            tmpToken = this.LA(lookAhead);
            ++lookAhead;
        } while (tmpToken != FortranLexer.T_EOS && tmpToken != FortranLexer.EOF && tmpToken != desiredToken);
        return tmpToken == desiredToken;
    }

    public boolean appendToken(int tokenType, String tokenText) {
        FortranToken newToken = new FortranToken(tokenType);
        newToken.setText(tokenText);
        return this.packedList.add((Token)newToken);
    }

    public void addToken(Token token) {
        this.packedList.add(token);
    }

    public void addToken(int index, int tokenType, String tokenText) {
        try {
            this.packedList.add(index, (Token)new FortranToken(tokenType, tokenText));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void set(int index, Token token) {
        this.packedList.set(index, token);
    }

    public void add(int index, Token token) {
        this.packedList.add(index, token);
    }

    public void removeToken(int index) {
        this.packedList.remove(index);
    }

    public void clearTokensList() {
        this.packedList.clear();
    }

    public ArrayList<Token> getTokensList() {
        return this.packedList;
    }

    public void setTokensList(ArrayList<Token> newList) {
        this.packedList = newList;
    }

    public int getTokensListSize() {
        return this.packedList.size();
    }

    public Token createToken(int type, String text, int line, int col) {
        FortranToken token = new FortranToken(type, text);
        token.setLine(line);
        token.setCharPositionInLine(col);
        return token;
    }

    public void addTokenToNewList(Token token) {
        if (!this.newTokensList.add(token)) {
            System.err.println("Couldn't add to newTokensList!");
        }
    }

    public void finalizeLine() {
        if (!this.newTokensList.addAll(this.packedList)) {
            System.err.println("Couldn't add to newTokensList!");
        }
    }

    public void finalizeTokenStream() {
        this.tokens = this.newTokensList;
    }

    private static class FortranLexer {
        public static int EOF = -1;
        public static int T_EOS = 287;
        public static int WS = -2;
        public static int LINE_COMMENT = -2;
        public static int CONTINUE_CHAR = 442;

        private FortranLexer() {
        }
    }
}

