/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.clank;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.parser.clank.ClankTokenStreamProducer;
import org.netbeans.modules.cnd.support.Interrupter;
import org.openide.util.Exceptions;

public class ClankFileInfoQuerySupport {
    public static List<CsmReference> getMacroUsages(FileImpl fileImpl, Interrupter interrupter) {
        ArrayList<Object> out = new ArrayList<CsmReference>();
        if (APTTraceFlags.DEFERRED_MACRO_USAGES) {
            Collection<PreprocHandler> handlers = fileImpl.getPreprocHandlersForParse(interrupter);
            if (interrupter.cancelled()) {
                return out;
            }
            if (handlers.isEmpty()) {
                DiagnosticExceptoins.register(new IllegalStateException("Empty preprocessor handlers for " + fileImpl.getAbsolutePath()));
            } else if (handlers.size() == 1) {
                PreprocHandler handler = handlers.iterator().next();
                out.addAll(ClankTokenStreamProducer.getMacroUsages(fileImpl, handler, interrupter));
            } else {
                TreeSet<CsmReference> result = new TreeSet<CsmReference>(CsmOffsetable.OFFSET_COMPARATOR);
                for (PreprocHandler handler : handlers) {
                    if (interrupter.cancelled()) break;
                    result.addAll(ClankTokenStreamProducer.getMacroUsages(fileImpl, handler, interrupter));
                }
                out = new ArrayList(result);
            }
        } else {
            for (CsmReference reference : fileImpl.getReferences()) {
                if (interrupter.cancelled()) {
                    return out;
                }
                CsmObject referencedObject = reference.getReferencedObject();
                if (!CsmKindUtilities.isMacro((CsmObject)referencedObject)) continue;
                out.add(reference);
            }
        }
        return out;
    }

    public static CsmOffsetable getGuardOffset(FileImpl fileImpl) {
        assert (APTTraceFlags.USE_CLANK);
        return fileImpl.getFileGuard();
    }

    public static boolean hasGuardBlock(FileImpl fileImpl) {
        assert (APTTraceFlags.USE_CLANK);
        return fileImpl.hasFileGuard();
    }

    public static String expand(FileImpl fileImpl, String code, PreprocHandler handler, ProjectBase base, int offset) {
        assert (APTTraceFlags.USE_CLANK);
        TokenStream ts = fileImpl.getTokenStreamForMacroExpansion(offset, offset, code, true);
        if (ts == null) {
            return null;
        }
        ts = new APTCommentsFilter(ts);
        StringBuilder sb = new StringBuilder("");
        try {
            APTToken t = (APTToken)ts.nextToken();
            while (t != null && !APTUtils.isEOF((Token)t)) {
                sb.append(t.getTextID());
                t = (APTToken)ts.nextToken();
            }
        }
        catch (TokenStreamException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return sb.toString();
    }
}

