/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.symtab;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.cnd.modelimpl.parser.symtab.SymTabEntry;

public final class SymTab {
    private final Map<CharSequence, SymTabEntry> entries = new TreeMap<CharSequence, SymTabEntry>();
    private final List<SymTab> imported = new ArrayList<SymTab>();
    private boolean lookupMark;
    private final int nestingLevel;
    private final CharSequence name;

    SymTab(int nestingLevel, CharSequence name) {
        this.nestingLevel = nestingLevel;
        this.name = name;
    }

    public CharSequence getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SymTabEntry lookup(CharSequence entry) {
        SymTabEntry out = this.entries.get(entry);
        if (out == null && !this.lookupMark) {
            this.lookupMark = true;
            try {
                ListIterator<SymTab> iter = this.imported.listIterator(this.imported.size());
                while (out == null && iter.hasPrevious()) {
                    out = iter.previous().lookup(entry);
                }
            }
            finally {
                this.lookupMark = false;
            }
        }
        return out;
    }

    SymTabEntry enter(CharSequence entry) {
        SymTabEntry newEntry = new SymTabEntry(entry, this);
        this.entries.put(entry, newEntry);
        return newEntry;
    }

    void importSymTab(SymTab symTab) {
        this.imported.add(symTab);
    }

    int getNestingLevel() {
        return this.nestingLevel;
    }

    public String toString() {
        return "SymTab{name=" + this.name + ", nestingLevel=" + this.nestingLevel + ", entries=" + this.entries + ", imported=" + this.imported + '}';
    }
}

