/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectRegistry;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.repository.api.UnitDescriptor;
import org.netbeans.modules.cnd.repository.impl.spi.LayerDescriptor;
import org.netbeans.modules.cnd.repository.impl.spi.LayerDescriptorProvider;
import org.netbeans.modules.cnd.spi.project.NativeProjectLayerDescriptorProvider;
import org.openide.modules.Places;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class LayerDescriptorProviderImpl
implements LayerDescriptorProvider {
    public List<LayerDescriptor> getLayerDescriptors(UnitDescriptor unitDescriptor) {
        Collection projects = NativeProjectRegistry.getDefault().getOpenProjects();
        NativeProject np = this.findProjectsByDescriptor(projects, unitDescriptor);
        ArrayList<LayerDescriptor> res = new ArrayList<LayerDescriptor>();
        for (NativeProjectLayerDescriptorProvider provider : Lookup.getDefault().lookupAll(NativeProjectLayerDescriptorProvider.class)) {
            List uriList = provider.getLayerDescriptors(np);
            if (uriList == null) continue;
            for (URI uri : uriList) {
                res.add(new LayerDescriptor(uri));
            }
        }
        if (res.isEmpty()) {
            res.add(this.getDefault());
        }
        return res;
    }

    private NativeProject findProjectsByDescriptor(Collection<NativeProject> projects, UnitDescriptor unitDescriptor) {
        for (NativeProject np : projects) {
            UnitDescriptor currDescriptor = KeyUtilities.createUnitDescriptor(np);
            if (!currDescriptor.equals((Object)unitDescriptor)) continue;
            return np;
        }
        return null;
    }

    public LayerDescriptor getDefault() {
        File file = Places.getCacheSubdirectory((String)"cnd/model");
        URI uri = Utilities.toURI((File)file);
        LayerDescriptor layerDescriptor = new LayerDescriptor(uri);
        return layerDescriptor;
    }
}

