/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmStandaloneFileProvider;
import org.netbeans.modules.cnd.api.model.util.CsmTracer;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.debug.CndDiagnosticProvider;
import org.netbeans.modules.cnd.modelimpl.content.file.ReferencesIndex;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmStandaloneFileProviderImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileSnapshot;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.trace.ASTFrameEx;
import org.netbeans.modules.cnd.modelimpl.trace.Bundle;
import org.netbeans.modules.cnd.modelimpl.trace.OffsetToPositionFrame;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.windows.OutputWriter;

public final class CodeModelDiagnostic {
    public static void dumpProjectContainers(PrintStream ps, CsmProject prj, boolean dumpFiles) {
        ProjectBase.dumpProjectContainers(ps, prj, dumpFiles);
    }

    public static void dumpFileContainer(CsmProject project, OutputWriter out) {
        ProjectBase.dumpFileContainer(project, (PrintWriter)out);
    }

    public static void dumpProjectGrapthContainer(CsmProject project, OutputWriter out) {
        ProjectBase.dumpProjectGrapthContainer(project, (PrintWriter)out);
    }

    public static final class OffsetToPositionProvider
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return Bundle.OffsetToPositionProvider_displayName();
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            Collection allFiles = context.lookupAll(CsmFile.class);
            for (CsmFile csmFile : allFiles) {
                if (!(csmFile instanceof FileImpl)) continue;
                OffsetToPositionFrame frame = new OffsetToPositionFrame((FileImpl)csmFile);
                frame.setVisible(true);
            }
        }
    }

    public static final class ProjectReferencesTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return Bundle.ProjectReferencesTrace_displayName();
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            CsmProject project;
            CsmFile file;
            ArrayList<CsmProject> projects = new ArrayList<CsmProject>(context.lookupAll(CsmProject.class));
            if (projects.isEmpty() && (file = (CsmFile)context.lookup(CsmFile.class)) != null && (project = file.getProject()) != null) {
                projects.add(project);
            }
            printOut.println("References:");
            for (CsmProject prj : projects) {
                printOut.print(prj.getName() + " : ");
                int refsNumber = 0;
                for (CsmFile file2 : prj.getAllFiles()) {
                    refsNumber += ((FileImpl)file2).getReferences().size();
                }
                printOut.println(refsNumber);
            }
        }
    }

    public static final class ModelTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return Bundle.ModelTrace_displayName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dumpInfo(Lookup context, PrintWriter printOut) throws IOException {
            CsmProject project;
            CsmFile file;
            ArrayList<CsmProject> projects = new ArrayList<CsmProject>(context.lookupAll(CsmProject.class));
            if (projects.isEmpty() && (file = (CsmFile)context.lookup(CsmFile.class)) != null && (project = file.getProject()) != null) {
                projects.add(project);
            }
            CsmCacheManager.enter();
            try {
                for (CsmProject prj : projects) {
                    new CsmTracer((Writer)printOut).dumpModel(prj);
                }
            }
            finally {
                CsmCacheManager.leave();
            }
        }
    }

    public static final class ProjectDeclarationsTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return Bundle.ProjectReferencesTrace_displayName();
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) throws IOException {
            CsmProject project;
            CsmFile file;
            ArrayList<CsmProject> projects = new ArrayList<CsmProject>(context.lookupAll(CsmProject.class));
            if (projects.isEmpty() && (file = (CsmFile)context.lookup(CsmFile.class)) != null && (project = file.getProject()) instanceof ProjectBase) {
                projects.add(project);
            }
            PrintStream ps = CsmTracer.toPrintStream((Writer)printOut);
            for (CsmProject prj : projects) {
                if (!(prj instanceof ProjectBase)) continue;
                CodeModelDiagnostic.dumpProjectContainers(ps, prj, false);
            }
        }
    }

    public static final class FileImplASTTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return Bundle.FileImplASTTrace_displayName();
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            Collection allFiles = context.lookupAll(CsmFile.class);
            for (CsmFile csmFile : allFiles) {
                if (!(csmFile instanceof FileImpl)) continue;
                ASTFrameEx frame = new ASTFrameEx(csmFile.getName().toString(), ((FileImpl)csmFile).debugParse());
                frame.setVisible(true);
            }
        }
    }

    public static final class FileImplModelTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return Bundle.FileImplModelTrace_displayName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dumpInfo(Lookup context, PrintWriter printOut) throws IOException {
            CsmCacheManager.enter();
            try {
                Collection allFiles = context.lookupAll(CsmFile.class);
                for (CsmFile csmFile : allFiles) {
                    new CsmTracer((Writer)printOut).dumpModel(csmFile);
                }
            }
            finally {
                CsmCacheManager.leave();
            }
        }
    }

    public static final class ModelFileIndex
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return Bundle.ModelTrace_displayName();
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            printOut.printf("====File Indices:%n", new Object[0]);
            Collection allFiles = context.lookupAll(CsmFile.class);
            for (CsmFile csmFile : allFiles) {
                if (csmFile instanceof FileImpl) {
                    ((FileImpl)csmFile).dumpIndex(printOut);
                    continue;
                }
                if (csmFile instanceof FileSnapshot) {
                    ((FileSnapshot)csmFile).dumpIndex(printOut);
                    continue;
                }
                printOut.printf("UNKNOWN FOR ME [%s] %s%n", csmFile.getClass().getName(), csmFile.toString());
            }
        }
    }

    public static final class ModelProjectsIndex
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return Bundle.ModelProjectsIndex_displayName();
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            printOut.printf("====Model Projects Index:%n", new Object[0]);
            ReferencesIndex.dumpInfo(printOut);
        }
    }

    public static final class ModelProjectsContainers
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return Bundle.ModelProjectsContainers_displayName();
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            printOut.printf("====ModelImpl:%n", new Object[0]);
            ModelImpl.instance().dumpInfo(printOut, true);
            printOut.printf("====Libraries:%n", new Object[0]);
            LibraryManager.dumpInfo(printOut, true);
        }
    }

    public static final class ModelProjectsTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return Bundle.ModelProjectsTrace_displayName();
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            printOut.printf("====ModelImpl:%n", new Object[0]);
            ModelImpl.instance().dumpInfo(printOut, false);
            printOut.printf("====Libraries:%n", new Object[0]);
            LibraryManager.dumpInfo(printOut, false);
            printOut.printf("====Files count size summary:%n", new Object[0]);
            this.dumpProjectFilesInfo(printOut);
        }

        private void dumpProjectFilesInfo(PrintWriter printOut) {
            Collection projects = CsmModelAccessor.getModel().projects();
            for (CsmProject project : projects) {
                this.dumpProjectFilesInfo(project, printOut, false);
                for (CsmProject lib : project.getLibraries()) {
                    this.dumpProjectFilesInfo(lib, printOut, false);
                }
            }
        }

        private void dumpProjectFilesInfo(CsmProject project, PrintWriter printOut, boolean printList) {
            FileObject fo;
            Collection sourceFiles = project.getSourceFiles();
            Collection headerFiles = project.getHeaderFiles();
            printOut.printf("%s%n", project.getDisplayName());
            printOut.printf("   %,d source files; %,d header files; %,d total files%n", sourceFiles.size(), headerFiles.size(), sourceFiles.size() + headerFiles.size());
            long totalSize = 0L;
            long maxSize = 0L;
            for (CsmFile file : sourceFiles) {
                if (printList) {
                    printOut.printf("\t%s%n", file.getAbsolutePath());
                }
                if ((fo = file.getFileObject()) == null || !fo.isValid()) continue;
                totalSize += fo.getSize();
                maxSize = Math.max(maxSize, fo.getSize());
            }
            for (CsmFile file : headerFiles) {
                if (printList) {
                    printOut.printf("\t%s%n", file.getAbsolutePath());
                }
                if ((fo = file.getFileObject()) == null || !fo.isValid()) continue;
                totalSize += fo.getSize();
                maxSize = Math.max(maxSize, fo.getSize());
            }
            printOut.printf("   total files size: %,d KBytes;  max file size: %,d KBytes%n", ModelProjectsTrace.kilobytes(totalSize), ModelProjectsTrace.kilobytes(maxSize));
        }

        private static long kilobytes(long num) {
            return num % 1024L < 512L ? num / 1024L : num / 1024L + 1L;
        }
    }

    public static final class IncludePPStatesTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return Bundle.IncludePPStatesTrace_displayName();
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            printOut.printf("====Files info:%nGlobal ParseCount=%d%n", FileImpl.getLongParseCount());
            Collection allFiles = context.lookupAll(CsmFile.class);
            for (CsmFile csmFile : allFiles) {
                if (csmFile instanceof FileImpl) {
                    ((FileImpl)csmFile).dumpIncludePPStates(printOut);
                    continue;
                }
                printOut.printf("UNKOWN FOR ME [%s] %s%n", csmFile.getClass().getName(), csmFile.toString());
            }
        }
    }

    public static final class PPStatesTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return Bundle.PPStatesTrace_displayName();
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            printOut.printf("====Files info:%nGlobal ParseCount=%d%n", FileImpl.getLongParseCount());
            Collection allFiles = context.lookupAll(CsmFile.class);
            for (CsmFile csmFile : allFiles) {
                if (csmFile instanceof FileImpl) {
                    ((FileImpl)csmFile).dumpPPStates(printOut);
                    continue;
                }
                printOut.printf("UNKNOWN FOR ME [%s] %s%n", csmFile.getClass().getName(), csmFile.toString());
            }
        }
    }

    public static final class FileTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return Bundle.FileTrace_displayName();
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            printOut.printf("====Files info:%nGlobal ParseCount=%d%n", FileImpl.getLongParseCount());
            Collection allFiles = context.lookupAll(CsmFile.class);
            for (CsmFile csmFile : allFiles) {
                if (csmFile instanceof FileImpl) {
                    ((FileImpl)csmFile).dumpInfo(printOut);
                    continue;
                }
                if (csmFile instanceof FileSnapshot) {
                    ((FileSnapshot)csmFile).dumpInfo(printOut);
                    continue;
                }
                printOut.printf("UNKNOWN FOR ME [%s] %s%n", csmFile.getClass().getName(), csmFile.toString());
            }
            Collection dobs = context.lookupAll(DataObject.class);
            if (!dobs.isEmpty()) {
                boolean foundItem = false;
                for (DataObject dob : dobs) {
                    NativeFileItemSet nfis = (NativeFileItemSet)dob.getLookup().lookup(NativeFileItemSet.class);
                    if (nfis == null) continue;
                    foundItem = true;
                    printOut.printf("NativeFileItemSet has %d elements%n", nfis.getItems().size());
                    int ind = 0;
                    for (NativeFileItem item : nfis.getItems()) {
                        FileObject valid;
                        String msg;
                        printOut.printf("[%d] NativeFileItem %s of class %s%n", ++ind, item.getAbsolutePath(), item.getClass().getName());
                        NativeProject nativeProject = item.getNativeProject();
                        printOut.printf(" from project %s [%s]%n", nativeProject.getProjectDisplayName(), nativeProject.getProjectRoot());
                        printOut.printf("\tLang=%s Flavor=%s excluded=%s%n", item.getLanguage(), item.getLanguageFlavor(), item.isExcluded());
                        printOut.print("\tUser Include Paths:\n");
                        for (Object path : item.getUserIncludePaths()) {
                            msg = CndFileUtils.isLocalFileSystem((FileSystem)path.getFileSystem()) ? path.getPath() : path.getURL().toString();
                            valid = path.getFileObject();
                            if (valid != null && !valid.isValid()) {
                                valid = null;
                            }
                            printOut.printf("\t\t%s%s%n", msg, valid == null ? "[invalid]" : "");
                        }
                        if (!item.getIncludeFiles().isEmpty()) {
                            printOut.print("\tUser Include Files:\n");
                            for (Object path : item.getIncludeFiles()) {
                                msg = path;
                                printOut.printf("\t\t%s%s%n", msg, "");
                            }
                        }
                        printOut.print("\tUser Macros:\n");
                        for (String macro : item.getUserMacroDefinitions()) {
                            printOut.printf("\t\t%s%n", macro);
                        }
                        printOut.print("\tSystem Include Paths:\n");
                        for (Object path : item.getSystemIncludePaths()) {
                            msg = CndFileUtils.isLocalFileSystem((FileSystem)path.getFileSystem()) ? path.getPath() : path.getURL().toString();
                            valid = path.getFileObject();
                            if (valid != null && !valid.isValid()) {
                                valid = null;
                            }
                            printOut.printf("\t\t%s%s%n", msg, valid == null ? "[invalid]" : "");
                        }
                        printOut.print("\tSystem Macros:\n");
                        for (String macro : item.getSystemMacroDefinitions()) {
                            printOut.printf("\t\t%s%n", macro);
                        }
                    }
                }
                if (!foundItem) {
                    printOut.printf("no NativeFileItemSet in %s%n", context);
                }
            } else {
                printOut.printf("no file object in lookup%n", new Object[0]);
            }
        }
    }

    public static final class StandAloneProviderTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return Bundle.StandAloneProviderTrace_displayName();
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            printOut.printf("====CsmStandaloneFileProviders info:%n", new Object[0]);
            for (CsmStandaloneFileProvider sap : Lookup.getDefault().lookupAll(CsmStandaloneFileProvider.class)) {
                if (sap instanceof CsmStandaloneFileProviderImpl) {
                    ((CsmStandaloneFileProviderImpl)sap).dumpInfo(printOut);
                    continue;
                }
                printOut.printf("UNKNOWN FOR ME [%s] %s%n", sap.getClass().getName(), sap.toString());
            }
        }
    }
}

