/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.lucene;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Version;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.parsing.lucene.AllFieldsSelector;
import org.netbeans.modules.parsing.lucene.BitSetCollector;
import org.netbeans.modules.parsing.lucene.Convertors;
import org.netbeans.modules.parsing.lucene.Evictable;
import org.netbeans.modules.parsing.lucene.IndexCacheFactory;
import org.netbeans.modules.parsing.lucene.RecordOwnerLockFactory;
import org.netbeans.modules.parsing.lucene.TermCollector;
import org.netbeans.modules.parsing.lucene.support.Convertor;
import org.netbeans.modules.parsing.lucene.support.Index;
import org.netbeans.modules.parsing.lucene.support.IndexReaderInjection;
import org.netbeans.modules.parsing.lucene.support.LowMemoryWatcher;
import org.netbeans.modules.parsing.lucene.support.StoppableConvertor;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class LuceneIndex
implements Index.Transactional,
Index.WithTermFrequencies,
Runnable {
    private static final String PROP_INDEX_POLICY = "java.index.useMemCache";
    private static final String PROP_DIR_TYPE = "java.index.dir";
    private static final String DIR_TYPE_MMAP = "mmap";
    private static final String DIR_TYPE_NIO = "nio";
    private static final String DIR_TYPE_IO = "io";
    private static final CachePolicy DEFAULT_CACHE_POLICY = CachePolicy.DYNAMIC;
    private static final CachePolicy cachePolicy = LuceneIndex.getCachePolicy();
    private static final Logger LOGGER = Logger.getLogger(LuceneIndex.class.getName());
    private final DirCache dirCache;

    public static LuceneIndex create(File cacheRoot, Analyzer analyzer) throws IOException {
        return new LuceneIndex(cacheRoot, analyzer);
    }

    static boolean awaitPendingEvictors() throws InterruptedException {
        try {
            return (Boolean)DirCache.EVICTOR_RP.submit(new Runnable(){

                @Override
                public void run() {
                }
            }, (Object)Boolean.TRUE).get();
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    private LuceneIndex(File refCacheRoot, Analyzer analyzer) throws IOException {
        assert (refCacheRoot != null);
        assert (analyzer != null);
        this.dirCache = new DirCache(refCacheRoot, cachePolicy, analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void query(@NonNull Collection<? super T> result, @NonNull Convertor<? super Document, T> convertor, @NullAllowed FieldSelector selector, @NullAllowed AtomicBoolean cancel, Query ... queries) throws IOException, InterruptedException {
        Parameters.notNull((CharSequence)"queries", (Object)queries);
        Parameters.notNull((CharSequence)"convertor", convertor);
        Parameters.notNull((CharSequence)"result", result);
        if (selector == null) {
            selector = AllFieldsSelector.INSTANCE;
        }
        IndexReader in = null;
        try {
            in = this.dirCache.acquireReader();
            if (in == null) {
                LOGGER.log(Level.FINE, "{0} is invalid!", this);
                return;
            }
            BitSet bs = new BitSet(in.maxDoc());
            BitSetCollector c = new BitSetCollector(bs);
            try (IndexSearcher searcher = new IndexSearcher(in);){
                for (Query q : queries) {
                    if (cancel != null && cancel.get()) {
                        throw new InterruptedException();
                    }
                    searcher.search(q, (Collector)c);
                }
            }
            if (convertor instanceof IndexReaderInjection) {
                ((IndexReaderInjection)((Object)convertor)).setIndexReader(in);
            }
            try {
                int docNum = bs.nextSetBit(0);
                while (docNum >= 0) {
                    if (cancel != null && cancel.get()) {
                        throw new InterruptedException();
                    }
                    Document doc = in.document(docNum, selector);
                    T value = convertor.convert((Document)doc);
                    if (value != null) {
                        result.add(value);
                    }
                    docNum = bs.nextSetBit(docNum + 1);
                }
            }
            finally {
                if (convertor instanceof IndexReaderInjection) {
                    ((IndexReaderInjection)((Object)convertor)).setIndexReader(null);
                }
            }
        }
        finally {
            this.dirCache.releaseReader(in);
        }
    }

    @Override
    public <T> void queryTerms(@NonNull Collection<? super T> result, @NullAllowed Term seekTo, @NonNull StoppableConvertor<Term, T> filter, @NullAllowed AtomicBoolean cancel) throws IOException, InterruptedException {
        this.queryTermsImpl(result, seekTo, Convertors.newTermEnumToTermConvertor(filter), cancel);
    }

    @Override
    public <T> void queryTermFrequencies(@NonNull Collection<? super T> result, @NullAllowed Term seekTo, @NonNull StoppableConvertor<Index.WithTermFrequencies.TermFreq, T> filter, @NullAllowed AtomicBoolean cancel) throws IOException, InterruptedException {
        this.queryTermsImpl(result, seekTo, Convertors.newTermEnumToFreqConvertor(filter), cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private <T> void queryTermsImpl(@NonNull Collection<? super T> result, @NullAllowed Term seekTo, @NonNull StoppableConvertor<TermEnum, T> adapter, @NullAllowed AtomicBoolean cancel) throws IOException, InterruptedException {
        block18: {
            IndexReader in = null;
            try {
                in = this.dirCache.acquireReader();
                if (in == null) {
                    LOGGER.log(Level.FINE, "{0} is invalid!", this);
                    return;
                }
                try (TermEnum terms = seekTo == null ? in.terms() : in.terms(seekTo);){
                    if (adapter instanceof IndexReaderInjection) {
                        ((IndexReaderInjection)((Object)adapter)).setIndexReader(in);
                    }
                    try {
                        do {
                            if (cancel != null && cancel.get()) {
                                throw new InterruptedException();
                            }
                            T vote = adapter.convert(terms);
                            if (vote == null) continue;
                            result.add(vote);
                        } while (terms.next());
                    }
                    catch (StoppableConvertor.Stop stop) {
                        if (adapter instanceof IndexReaderInjection) {
                            ((IndexReaderInjection)((Object)adapter)).setIndexReader(null);
                        }
                        break block18;
                        catch (Throwable throwable) {
                            if (adapter instanceof IndexReaderInjection) {
                                ((IndexReaderInjection)((Object)adapter)).setIndexReader(null);
                            }
                            throw throwable;
                        }
                    }
                    if (adapter instanceof IndexReaderInjection) {
                        ((IndexReaderInjection)((Object)adapter)).setIndexReader(null);
                    }
                }
            }
            finally {
                this.dirCache.releaseReader(in);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, T> void queryDocTerms(@NonNull Map<? super T, Set<S>> result, @NonNull Convertor<? super Document, T> convertor, @NonNull Convertor<? super Term, S> termConvertor, @NullAllowed FieldSelector selector, @NullAllowed AtomicBoolean cancel, Query ... queries) throws IOException, InterruptedException {
        Parameters.notNull((CharSequence)"queries", (Object)queries);
        Parameters.notNull((CharSequence)"slector", (Object)selector);
        Parameters.notNull((CharSequence)"convertor", convertor);
        Parameters.notNull((CharSequence)"termConvertor", termConvertor);
        Parameters.notNull((CharSequence)"result", result);
        if (selector == null) {
            selector = AllFieldsSelector.INSTANCE;
        }
        IndexReader in = null;
        try {
            in = this.dirCache.acquireReader();
            if (in == null) {
                LOGGER.log(Level.FINE, "{0} is invalid!", this);
                return;
            }
            BitSet bs = new BitSet(in.maxDoc());
            BitSetCollector c = new BitSetCollector(bs);
            TermCollector termCollector = new TermCollector(c);
            try (IndexSearcher searcher = new IndexSearcher(in);){
                for (Query q : queries) {
                    if (cancel != null && cancel.get()) {
                        throw new InterruptedException();
                    }
                    if (!(q instanceof TermCollector.TermCollecting)) {
                        throw new IllegalArgumentException(String.format("Query: %s does not implement TermCollecting", q.getClass().getName()));
                    }
                    ((TermCollector.TermCollecting)q).attach(termCollector);
                    searcher.search(q, (Collector)termCollector);
                }
            }
            boolean logged = false;
            if (convertor instanceof IndexReaderInjection) {
                ((IndexReaderInjection)((Object)convertor)).setIndexReader(in);
            }
            try {
                if (termConvertor instanceof IndexReaderInjection) {
                    ((IndexReaderInjection)((Object)termConvertor)).setIndexReader(in);
                }
                try {
                    int docNum = bs.nextSetBit(0);
                    while (docNum >= 0) {
                        if (cancel != null && cancel.get()) {
                            throw new InterruptedException();
                        }
                        Document doc = in.document(docNum, selector);
                        T value = convertor.convert((Document)doc);
                        if (value != null) {
                            Set<Term> terms = termCollector.get(docNum);
                            if (terms != null) {
                                result.put(value, LuceneIndex.convertTerms(termConvertor, terms));
                            } else {
                                if (!logged) {
                                    LOGGER.log(Level.WARNING, "Index info [maxDoc: {0} numDoc: {1} docs: {2}]", new Object[]{in.maxDoc(), in.numDocs(), termCollector.docs()});
                                    logged = true;
                                }
                                LOGGER.log(Level.WARNING, "No terms found for doc: {0}", docNum);
                            }
                        }
                        docNum = bs.nextSetBit(docNum + 1);
                    }
                }
                finally {
                    if (termConvertor instanceof IndexReaderInjection) {
                        ((IndexReaderInjection)((Object)termConvertor)).setIndexReader(null);
                    }
                }
            }
            finally {
                if (convertor instanceof IndexReaderInjection) {
                    ((IndexReaderInjection)((Object)convertor)).setIndexReader(null);
                }
            }
        }
        finally {
            this.dirCache.releaseReader(in);
        }
    }

    private static <T> Set<T> convertTerms(Convertor<? super Term, T> convertor, Set<? extends Term> terms) {
        HashSet<T> result = new HashSet<T>(terms.size());
        for (Term term : terms) {
            result.add(convertor.convert(term));
        }
        return result;
    }

    @Override
    public void run() {
        this.dirCache.beginTrans();
    }

    @Override
    public void commit() throws IOException {
        this.dirCache.closeTxWriter();
    }

    @Override
    public void rollback() throws IOException {
        this.dirCache.rollbackTxWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, T> void txStore(Collection<T> toAdd, Collection<S> toDelete, Convertor<? super T, ? extends Document> docConvertor, Convertor<? super S, ? extends Query> queryConvertor) throws IOException {
        IndexWriter wr = this.dirCache.acquireWriter();
        try {
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Storing in TX {0}: {1} added, {2} deleted", new Object[]{this, toAdd.size(), toDelete.size()});
                }
                this._doStore(toAdd, toDelete, docConvertor, queryConvertor, wr);
            }
            finally {
                boolean ok = false;
                try {
                    ((FlushIndexWriter)wr).callFlush(false, true);
                    ok = true;
                }
                finally {
                    if (!ok) {
                        this.dirCache.rollbackTxWriter();
                    }
                }
            }
        }
        finally {
            this.dirCache.releaseWriter(wr);
        }
    }

    private <S, T> void _doStore(@NonNull Collection<T> data, @NonNull Collection<S> toDelete, @NonNull Convertor<? super T, ? extends Document> docConvertor, @NonNull Convertor<? super S, ? extends Query> queryConvertor, @NonNull IndexWriter out) throws IOException {
        try {
            if (this.dirCache.exists()) {
                for (S td : toDelete) {
                    out.deleteDocuments(queryConvertor.convert(td));
                }
            }
            if (data.isEmpty()) {
                return;
            }
            LowMemoryWatcher lmListener = LowMemoryWatcher.getInstance();
            RAMDirectory memDir = null;
            IndexWriter activeOut = null;
            if (lmListener.isLowMemory()) {
                activeOut = out;
            } else {
                memDir = new RAMDirectory();
                activeOut = new IndexWriter((Directory)memDir, new IndexWriterConfig(Version.LUCENE_35, this.dirCache.getAnalyzer()));
            }
            Iterator<T> it = LuceneIndex.fastRemoveIterable(data).iterator();
            while (it.hasNext()) {
                T entry = it.next();
                it.remove();
                Document doc = docConvertor.convert(entry);
                activeOut.addDocument(doc);
                if (memDir == null || !lmListener.isLowMemory()) continue;
                activeOut.close();
                out.addIndexes(new Directory[]{memDir});
                memDir = new RAMDirectory();
                activeOut = new IndexWriter((Directory)memDir, new IndexWriterConfig(Version.LUCENE_35, this.dirCache.getAnalyzer()));
            }
            data.clear();
            if (memDir != null) {
                activeOut.close();
                out.addIndexes(new Directory[]{memDir});
                activeOut = null;
                memDir = null;
            }
        }
        catch (RuntimeException e) {
            throw (RuntimeException)Exceptions.attachMessage((Throwable)e, (String)("Lucene Index Folder: " + this.dirCache.folder.getAbsolutePath()));
        }
        catch (IOException e) {
            throw (IOException)Exceptions.attachMessage((Throwable)e, (String)("Lucene Index Folder: " + this.dirCache.folder.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, T> void store(@NonNull Collection<T> data, @NonNull Collection<S> toDelete, @NonNull Convertor<? super T, ? extends Document> docConvertor, @NonNull Convertor<? super S, ? extends Query> queryConvertor, boolean optimize) throws IOException {
        IndexWriter wr = this.dirCache.acquireWriter();
        this.dirCache.storeCloseSynchronizer.enter();
        try {
            try {
                try {
                    this._doStore(data, toDelete, docConvertor, queryConvertor, wr);
                }
                finally {
                    LOGGER.log(Level.FINE, "Committing {0}", this);
                    this.dirCache.releaseWriter(wr);
                }
            }
            finally {
                this.dirCache.close(wr);
            }
        }
        finally {
            this.dirCache.storeCloseSynchronizer.exit();
        }
    }

    @Override
    public Index.Status getStatus(boolean force) throws IOException {
        return this.dirCache.getStatus(force);
    }

    @Override
    public void clear() throws IOException {
        this.dirCache.clear();
    }

    @Override
    public void close() throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Closing index: {0} {1}", new Object[]{this.dirCache.toString(), Thread.currentThread().getStackTrace()});
        }
        this.dirCache.close(true);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.dirCache.toString() + "]";
    }

    private static CachePolicy getCachePolicy() {
        String value = System.getProperty(PROP_INDEX_POLICY);
        if (Boolean.TRUE.toString().equals(value) || CachePolicy.ALL.getSystemName().equals(value)) {
            return CachePolicy.ALL;
        }
        if (Boolean.FALSE.toString().equals(value) || CachePolicy.NONE.getSystemName().equals(value)) {
            return CachePolicy.NONE;
        }
        if (CachePolicy.DYNAMIC.getSystemName().equals(value)) {
            return CachePolicy.DYNAMIC;
        }
        return DEFAULT_CACHE_POLICY;
    }

    private static <T> Iterable<T> fastRemoveIterable(final Collection<T> c) {
        return c instanceof ArrayList ? new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private final ListIterator<T> delegate;
                    {
                        this.delegate = ((List)c).listIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegate.hasNext();
                    }

                    @Override
                    public T next() {
                        return this.delegate.next();
                    }

                    @Override
                    public void remove() {
                        this.delegate.set(null);
                    }
                };
            }
        } : c;
    }

    private static final class Folder
    extends File {
        private static final InvalidPathException IPE = new InvalidPathException("", ""){

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        };

        Folder(@NonNull File folder) {
            super(folder.getAbsolutePath());
        }

        @Override
        public File getAbsoluteFile() {
            assert (this.isAbsolute());
            return this;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public boolean isFile() {
            return !this.isDirectory();
        }

        @Override
        public Path toPath() {
            throw IPE;
        }
    }

    private static final class StoreCloseSynchronizer {
        private ThreadLocal<Boolean> isWriterThread = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        private int depth;

        StoreCloseSynchronizer() {
        }

        synchronized void enter() {
            ++this.depth;
            this.isWriterThread.set(Boolean.TRUE);
        }

        synchronized void exit() {
            assert (this.depth > 0);
            --this.depth;
            this.isWriterThread.remove();
            if (this.depth == 0) {
                this.notifyAll();
            }
        }

        synchronized Future<Void> getSync() {
            if (this.depth == 0 || this.isWriterThread.get() == Boolean.TRUE) {
                return null;
            }
            return new Future<Void>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean isDone() {
                    StoreCloseSynchronizer storeCloseSynchronizer = StoreCloseSynchronizer.this;
                    synchronized (storeCloseSynchronizer) {
                        return StoreCloseSynchronizer.this.depth == 0;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void get() throws InterruptedException, ExecutionException {
                    StoreCloseSynchronizer storeCloseSynchronizer = StoreCloseSynchronizer.this;
                    synchronized (storeCloseSynchronizer) {
                        while (StoreCloseSynchronizer.this.depth > 0) {
                            StoreCloseSynchronizer.this.wait();
                        }
                    }
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    if (unit != TimeUnit.MILLISECONDS) {
                        throw new UnsupportedOperationException();
                    }
                    StoreCloseSynchronizer storeCloseSynchronizer = StoreCloseSynchronizer.this;
                    synchronized (storeCloseSynchronizer) {
                        while (StoreCloseSynchronizer.this.depth > 0) {
                            StoreCloseSynchronizer.this.wait(timeout);
                        }
                    }
                    return null;
                }
            };
        }
    }

    private static class FlushIndexWriter
    extends IndexWriter {
        public FlushIndexWriter(@NonNull Directory d, @NonNull IndexWriterConfig conf) throws CorruptIndexException, LockObtainFailedException, IOException {
            super(d, conf);
        }

        void callFlush(boolean triggerMerges, boolean flushDeletes) throws IOException {
            super.flush(triggerMerges, true, flushDeletes);
        }
    }

    private static final class DirCache
    implements Evictable {
        private static final RequestProcessor EVICTOR_RP = new RequestProcessor(DirCache.class.getName(), 1);
        private final File folder;
        private final RecordOwnerLockFactory lockFactory;
        private final CachePolicy cachePolicy;
        private final Analyzer analyzer;
        private final StoreCloseSynchronizer storeCloseSynchronizer;
        private volatile FSDirectory fsDir;
        private RAMDirectory memDir;
        private CleanReference ref;
        private IndexReader reader;
        private volatile boolean closed;
        private volatile Throwable closeStackTrace;
        private volatile Index.Status validCache;
        private final IndexWriterReference indexWriterRef = new IndexWriterReference();
        private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

        private DirCache(@NonNull File folder, @NonNull CachePolicy cachePolicy, @NonNull Analyzer analyzer) throws IOException {
            assert (folder != null);
            assert (cachePolicy != null);
            assert (analyzer != null);
            this.folder = new Folder(folder);
            this.lockFactory = new RecordOwnerLockFactory();
            this.fsDir = DirCache.createFSDirectory(this.folder, this.lockFactory);
            this.cachePolicy = cachePolicy;
            this.analyzer = analyzer;
            this.storeCloseSynchronizer = new StoreCloseSynchronizer();
        }

        Analyzer getAnalyzer() {
            return this.analyzer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() throws IOException {
            while (true) {
                Future<Void> sync;
                this.rwLock.writeLock().lock();
                try {
                    sync = this.storeCloseSynchronizer.getSync();
                    if (sync == null) {
                        this.doClear();
                        break;
                    }
                }
                finally {
                    this.rwLock.writeLock().unlock();
                }
                try {
                    sync.get();
                    continue;
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void doClear() throws IOException {
            this.checkPreconditions();
            this.doClose(false, true);
            try {
                File cacheDir;
                File[] children;
                this.lockFactory.forceClearLocks();
                String[] content = this.fsDir.listAll();
                boolean dirty = false;
                if (content != null) {
                    for (String file : content) {
                        try {
                            this.fsDir.deleteFile(file);
                        }
                        catch (IOException e) {
                            if (!this.fsDir.fileExists(file)) continue;
                            dirty = true;
                        }
                    }
                }
                if (dirty && (children = (cacheDir = this.fsDir.getDirectory()).listFiles()) != null) {
                    for (File child : children) {
                        if (child.delete()) continue;
                        throw RecordOwnerLockFactory.annotateException(new IOException("Cannot delete: " + child.getAbsolutePath()), this.folder, Thread.getAllStackTraces());
                    }
                }
            }
            finally {
                this.fsDir.close();
                this.fsDir = DirCache.createFSDirectory(this.folder, this.lockFactory);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void close(IndexWriter writer) throws IOException {
            if (writer == null) {
                return;
            }
            boolean success = false;
            try {
                writer.close();
                success = true;
                LOGGER.log(Level.FINE, "TX writer cleared for {0}", this);
                this.indexWriterRef.release();
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.FINE, "TX writer cleared for {0}", this);
                this.indexWriterRef.release();
                try {
                    if (success || !IndexWriter.isLocked((Directory)this.fsDir)) throw throwable;
                    IndexWriter.unlock((Directory)this.fsDir);
                    throw throwable;
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, "Cannot unlock index {0} while recovering, {1}.", new Object[]{this.folder.getAbsolutePath(), ioe.getMessage()});
                    throw throwable;
                }
                finally {
                    this.refreshReader();
                }
            }
            try {
                if (success || !IndexWriter.isLocked((Directory)this.fsDir)) return;
                IndexWriter.unlock((Directory)this.fsDir);
                return;
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Cannot unlock index {0} while recovering, {1}.", new Object[]{this.folder.getAbsolutePath(), ioe.getMessage()});
                return;
            }
            finally {
                this.refreshReader();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(boolean closeFSDir) throws IOException {
            while (true) {
                Future<Void> sync;
                this.rwLock.writeLock().lock();
                try {
                    sync = this.storeCloseSynchronizer.getSync();
                    if (sync == null) {
                        this.doClose(closeFSDir, false);
                        break;
                    }
                }
                finally {
                    this.rwLock.writeLock().unlock();
                }
                try {
                    sync.get();
                    continue;
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void doClose(boolean closeFSDir, boolean ensureClosed) throws IOException {
            block11: {
                try {
                    this.rollbackTxWriter();
                    if (this.reader == null) break block11;
                    this.reader.close();
                    if (ensureClosed) {
                        try {
                            while (this.reader.getRefCount() > 0) {
                                this.reader.decRef();
                            }
                        }
                        catch (IllegalStateException e) {
                            // empty catch block
                        }
                    }
                    this.reader = null;
                }
                finally {
                    if (this.memDir != null) {
                        assert (this.cachePolicy.hasMemCache());
                        if (this.ref != null) {
                            this.ref.clear();
                        }
                        RAMDirectory tmpDir = this.memDir;
                        this.memDir = null;
                        tmpDir.close();
                    }
                    if (closeFSDir) {
                        this.closeStackTrace = new Throwable();
                        this.closed = true;
                        this.fsDir.close();
                    }
                }
            }
        }

        boolean exists() {
            try {
                return IndexReader.indexExists((Directory)this.fsDir);
            }
            catch (IOException e) {
                return false;
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.INFO, "Broken index: " + this.folder.getAbsolutePath(), e);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Index.Status getStatus(boolean force) throws IOException {
            this.checkPreconditions();
            Index.Status valid = this.validCache;
            if (force || valid == null) {
                this.rwLock.writeLock().lock();
                try {
                    Index.Status res = Index.Status.INVALID;
                    if (this.lockFactory.hasLocks()) {
                        if (this.indexWriterRef.get() != null) {
                            res = Index.Status.WRITING;
                        } else {
                            LOGGER.log(Level.WARNING, "Locked index folder: {0}", this.folder.getAbsolutePath());
                            if (force) {
                                this.clear();
                            }
                        }
                    } else if (!this.exists()) {
                        res = Index.Status.EMPTY;
                    } else if (force) {
                        try {
                            this.getReader();
                            res = Index.Status.VALID;
                        }
                        catch (IOException e) {
                            this.clear();
                        }
                        catch (RuntimeException e) {
                            this.clear();
                        }
                    } else {
                        res = Index.Status.VALID;
                    }
                    this.validCache = valid = res;
                }
                finally {
                    this.rwLock.writeLock().unlock();
                }
            }
            return valid;
        }

        boolean closeTxWriter() throws IOException {
            IndexWriter writer = this.indexWriterRef.get();
            if (writer != null) {
                LOGGER.log(Level.FINE, "Committing {0}", this);
                this.close(writer);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean rollbackTxWriter() throws IOException {
            IndexWriter writer = this.indexWriterRef.get();
            if (writer != null) {
                try {
                    writer.rollback();
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.indexWriterRef.release();
                }
            }
            return false;
        }

        void beginTrans() {
            this.indexWriterRef.beginTrans();
        }

        IndexWriter acquireWriter() throws IOException {
            this.checkPreconditions();
            this.hit();
            boolean ok = false;
            this.rwLock.readLock().lock();
            try {
                IndexWriter writer = this.indexWriterRef.acquire(new Callable<IndexWriter>(){

                    @Override
                    @NonNull
                    public IndexWriter call() throws IOException {
                        IndexWriterConfig iwc = new IndexWriterConfig(Version.LUCENE_35, DirCache.this.analyzer);
                        TieredMergePolicy mergePolicy = new TieredMergePolicy();
                        mergePolicy.setNoCFSRatio(1.0);
                        iwc.setMergePolicy((MergePolicy)mergePolicy);
                        return new FlushIndexWriter((Directory)DirCache.this.fsDir, iwc);
                    }
                });
                ok = true;
                IndexWriter indexWriter = writer;
                return indexWriter;
            }
            catch (LockObtainFailedException lf) {
                throw lf;
            }
            catch (IOException ioe) {
                throw RecordOwnerLockFactory.annotateException(ioe, this.folder, null);
            }
            finally {
                if (!ok) {
                    this.rwLock.readLock().unlock();
                }
            }
        }

        void releaseWriter(@NonNull IndexWriter w) {
            assert (this.indexWriterRef.get() == w || this.indexWriterRef.get() == null);
            this.rwLock.readLock().unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IndexReader acquireReader() throws IOException {
            this.rwLock.readLock().lock();
            IndexReader r = null;
            try {
                IndexReader indexReader = r = this.getReader();
                return indexReader;
            }
            finally {
                if (r == null) {
                    this.rwLock.readLock().unlock();
                }
            }
        }

        void releaseReader(IndexReader r) {
            if (r == null) {
                return;
            }
            assert (r == this.reader);
            this.rwLock.readLock().unlock();
        }

        private synchronized IndexReader getReader() throws IOException {
            this.checkPreconditions();
            this.hit();
            if (this.reader == null) {
                if (this.validCache != Index.Status.VALID && this.validCache != Index.Status.WRITING && this.validCache != null) {
                    return null;
                }
                try {
                    FSDirectory source;
                    if (this.cachePolicy.hasMemCache() && DirCache.fitsIntoMem((Directory)this.fsDir)) {
                        this.memDir = new RAMDirectory((Directory)this.fsDir);
                        if (this.cachePolicy == CachePolicy.DYNAMIC) {
                            this.ref = new CleanReference(new RAMDirectory[]{this.memDir});
                        }
                        source = this.memDir;
                    } else {
                        source = this.fsDir;
                    }
                    assert (source != null);
                    this.reader = IndexReader.open((Directory)source, (boolean)true);
                }
                catch (FileNotFoundException | InterruptedIOException | ClosedByInterruptException e) {
                }
                catch (IOException ioe) {
                    if (this.validCache == null) {
                        return null;
                    }
                    throw RecordOwnerLockFactory.annotateException(ioe, this.folder, Thread.getAllStackTraces());
                }
            }
            this.hit();
            return this.reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void refreshReader() throws IOException {
            block11: {
                try {
                    if (this.cachePolicy.hasMemCache()) {
                        this.close(false);
                        break block11;
                    }
                    this.rwLock.writeLock().lock();
                    try {
                        DirCache dirCache = this;
                        synchronized (dirCache) {
                            IndexReader newReader;
                            if (this.reader != null && (newReader = IndexReader.openIfChanged((IndexReader)this.reader)) != null) {
                                this.reader.close();
                                this.reader = newReader;
                            }
                        }
                    }
                    finally {
                        this.rwLock.writeLock().unlock();
                    }
                }
                finally {
                    this.validCache = Index.Status.VALID;
                }
            }
        }

        public String toString() {
            return this.folder.getAbsolutePath();
        }

        @Override
        public void evicted() {
            EVICTOR_RP.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean needsClose = true;
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        if (DirCache.this.memDir != null) {
                            if (DirCache.this.ref != null) {
                                DirCache.this.ref.clearHRef();
                            }
                            needsClose = false;
                        }
                    }
                    if (needsClose) {
                        try {
                            DirCache.this.close(false);
                            LOGGER.log(Level.FINE, "Evicted index: {0}", DirCache.this.folder.getAbsolutePath());
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            });
        }

        private synchronized void hit() {
            if (this.reader != null) {
                URI uri = BaseUtilities.toURI((File)this.folder);
                if (this.memDir != null) {
                    IndexCacheFactory.getDefault().getRAMCache().put(uri, this);
                    if (this.ref != null) {
                        this.ref.get();
                    }
                } else {
                    IndexCacheFactory.getDefault().getNIOCache().put(uri, this);
                }
            }
        }

        private void checkPreconditions() throws Index.IndexClosedException {
            if (this.closed) {
                throw (Index.IndexClosedException)new Index.IndexClosedException().initCause(this.closeStackTrace);
            }
        }

        private static FSDirectory createFSDirectory(File indexFolder, LockFactory lockFactory) throws IOException {
            assert (indexFolder != null);
            assert (lockFactory != null);
            String dirType = System.getProperty(LuceneIndex.PROP_DIR_TYPE);
            Object directory = LuceneIndex.DIR_TYPE_MMAP.equals(dirType) ? new MMapDirectory(indexFolder, lockFactory) : (LuceneIndex.DIR_TYPE_NIO.equals(dirType) ? new NIOFSDirectory(indexFolder, lockFactory) : (LuceneIndex.DIR_TYPE_IO.equals(dirType) ? new SimpleFSDirectory(indexFolder, lockFactory) : FSDirectory.open((File)indexFolder, (LockFactory)lockFactory)));
            return directory;
        }

        private static boolean fitsIntoMem(@NonNull Directory dir) {
            try {
                long size = 0L;
                for (String path : dir.listAll()) {
                    size += dir.fileLength(path);
                }
                return IndexCacheFactory.getDefault().getRAMController().shouldLoad(size);
            }
            catch (IOException ioe) {
                return false;
            }
        }

        private final class CleanReference
        extends SoftReference<RAMDirectory[]>
        implements Runnable {
            private volatile Directory[] hardRef;
            private final AtomicLong size;

            private CleanReference(RAMDirectory[] dir) {
                boolean doHardRef;
                super(dir, BaseUtilities.activeReferenceQueue());
                this.size = new AtomicLong();
                IndexCacheFactory.RAMController c = IndexCacheFactory.getDefault().getRAMController();
                boolean bl = doHardRef = !c.isFull();
                if (doHardRef) {
                    this.hardRef = dir;
                    long _size = dir[0].sizeInBytes();
                    this.size.set(_size);
                    c.acquire(_size);
                }
                LOGGER.log(Level.FINEST, "Caching index: {0} cache policy: {1}", new Object[]{DirCache.this.folder.getAbsolutePath(), DirCache.this.cachePolicy.getSystemName()});
            }

            @Override
            public void run() {
                try {
                    LOGGER.log(Level.FINEST, "Dropping cache index: {0} cache policy: {1}", new Object[]{DirCache.this.folder.getAbsolutePath(), DirCache.this.cachePolicy.getSystemName()});
                    DirCache.this.close(false);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }

            @Override
            public void clear() {
                this.clearHRef();
                super.clear();
            }

            void clearHRef() {
                this.hardRef = null;
                IndexCacheFactory.getDefault().getRAMController().release(this.size.getAndSet(0L));
            }
        }

        private static final class IndexWriterReference {
            private Pair<Thread, Pair<Long, Exception>> openThread;
            private Pair<Thread, Pair<Long, Exception>> txThread;
            private IndexWriter indexWriter;
            private boolean modified;

            private IndexWriterReference() {
            }

            synchronized void beginTrans() {
                this.assertNoModifiedWriter();
                this.modified = false;
                this.txThread = IndexWriterReference.trace();
            }

            @NonNull
            synchronized IndexWriter acquire(@NonNull Callable<IndexWriter> indexWriterFactory) throws IOException {
                if (this.indexWriter != null) {
                    assert (this.openThread != null);
                    this.assertSingleThreadWriter();
                } else {
                    try {
                        assert (this.openThread == null);
                        this.indexWriter = indexWriterFactory.call();
                        this.openThread = IndexWriterReference.trace();
                        this.modified = true;
                    }
                    catch (IOException | RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.indexWriter;
            }

            @CheckForNull
            synchronized IndexWriter get() {
                return this.indexWriter;
            }

            synchronized void release() {
                this.openThread = null;
                this.txThread = null;
                this.indexWriter = null;
                this.modified = false;
            }

            private void assertSingleThreadWriter() {
                assert (Thread.holdsLock(this));
                if (this.openThread.first() != Thread.currentThread()) {
                    IllegalStateException e = new IllegalStateException(String.format("Other thread using opened writer, old owner Thread %s(%d), new owner Thread %s(%d).", this.openThread.first(), ((Thread)this.openThread.first()).getId(), Thread.currentThread(), Thread.currentThread().getId()), (Throwable)((Pair)this.openThread.second()).second());
                    throw e;
                }
            }

            private void assertNoModifiedWriter() {
                assert (Thread.holdsLock(this));
                if (IndexWriterReference.assertsEnabled() && this.txThread != null && this.modified) {
                    Throwable t = new Throwable(String.format("Using stale writer, possibly forgotten call to store, old owner Thread %s(%d) enter time: %d, new owner Thread %s(%d) enter time: %d.", this.txThread.first(), ((Thread)this.txThread.first()).getId(), ((Pair)this.txThread.second()).first(), Thread.currentThread(), Thread.currentThread().getId(), System.currentTimeMillis()), (Throwable)((Pair)this.txThread.second()).second());
                    LOGGER.log(Level.WARNING, "Using stale writer", t);
                }
            }

            @NonNull
            private static Pair<Thread, Pair<Long, Exception>> trace() {
                return Pair.of((Object)Thread.currentThread(), IndexWriterReference.assertsEnabled() ? Pair.of((Object)System.currentTimeMillis(), (Object)new Exception("Owner stack")) : null);
            }

            private static boolean assertsEnabled() {
                boolean ae = false;
                if (!$assertionsDisabled) {
                    ae = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                return ae;
            }
        }
    }

    private static final class CachePolicy
    extends Enum<CachePolicy> {
        public static final /* enum */ CachePolicy NONE = new CachePolicy("none", false);
        public static final /* enum */ CachePolicy DYNAMIC = new CachePolicy("dynamic", true);
        public static final /* enum */ CachePolicy ALL = new CachePolicy("all", true);
        private final String sysName;
        private final boolean hasMemCache;
        private static final /* synthetic */ CachePolicy[] $VALUES;

        public static CachePolicy[] values() {
            return (CachePolicy[])$VALUES.clone();
        }

        public static CachePolicy valueOf(String name) {
            return Enum.valueOf(CachePolicy.class, name);
        }

        private CachePolicy(String sysName, boolean hasMemCache) {
            assert (sysName != null);
            this.sysName = sysName;
            this.hasMemCache = hasMemCache;
        }

        String getSystemName() {
            return this.sysName;
        }

        boolean hasMemCache() {
            return this.hasMemCache;
        }

        static {
            $VALUES = new CachePolicy[]{NONE, DYNAMIC, ALL};
        }
    }
}

