/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.mixeddev.java;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.cnd.mixeddev.MixedDevUtils;
import org.netbeans.modules.cnd.mixeddev.java.JavaContextSupport;
import org.openide.util.NbBundle;

public abstract class AbstractJavaToCppHyperlinkProvider
implements HyperlinkProviderExt {
    private static final String JAVA_HYPERLINK_PROVIDER = "JavaHyperlinkProvider";
    private static HyperlinkProviderExt delegate;

    protected abstract String[] getCppNames(Document var1, int var2);

    protected abstract boolean navigate(Document var1, int var2);

    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        HyperlinkProviderExt defaultProvider = this.getDelegate();
        if (defaultProvider != null) {
            return defaultProvider.isHyperlinkPoint(doc, offset, type);
        }
        return this.getHyperlinkSpan(doc, offset, type) != null;
    }

    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        HyperlinkProviderExt defaultProvider = this.getDelegate();
        if (defaultProvider != null) {
            return defaultProvider.getHyperlinkSpan(doc, offset, type);
        }
        return JavaContextSupport.getIdentifierSpan(doc, offset, null);
    }

    public void performClickAction(Document doc, int offset, HyperlinkType type) {
        HyperlinkProviderExt defaultProvider;
        if (!this.navigate(doc, offset) && (defaultProvider = this.getDelegate()) != null) {
            defaultProvider.performClickAction(doc, offset, type);
        }
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        String[] cppNames = this.getCppNames(doc, offset);
        if (cppNames != null && cppNames.length > 0) {
            String msg = NbBundle.getMessage(MixedDevUtils.class, (String)"cnd.mixeddev.search_for_msg");
            StringBuilder sb = new StringBuilder();
            if (cppNames.length > 1) {
                for (String cppName : cppNames) {
                    sb.append("<br>");
                    sb.append(cppName);
                }
            } else {
                sb.append(cppNames[0]);
            }
            return MessageFormat.format(msg, sb.toString());
        }
        HyperlinkProviderExt defaultProvider = this.getDelegate();
        if (defaultProvider != null) {
            return defaultProvider.getTooltipText(doc, offset, type);
        }
        return NbBundle.getMessage(MixedDevUtils.class, (String)"cnd.mixeddev.cannot_navigate_msg");
    }

    private synchronized HyperlinkProviderExt getDelegate() {
        if (delegate == null) {
            MimePath mimePath = MimePath.parse((String)"text/x-java");
            Collection providers = MimeLookup.getLookup((MimePath)mimePath).lookupAll(HyperlinkProviderExt.class);
            for (HyperlinkProviderExt provider : providers) {
                if (!provider.getClass().getName().endsWith(JAVA_HYPERLINK_PROVIDER)) continue;
                delegate = provider;
                break;
            }
        }
        return delegate;
    }
}

