/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.mixeddev.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.wizards.WizardConstants;
import org.netbeans.modules.cnd.mixeddev.java.JNISupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.java.j2seproject.api.J2SEProjectPlatform;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class Generator
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.mixeddev.wizard");
    private static final RequestProcessor RP = new RequestProcessor(Generator.class.getName(), 2);
    private final FileObject fileObject;
    private final WizardDescriptor wiz;
    private volatile Project javaProject;
    private volatile Project makeProject;
    private volatile FileObject header;
    private volatile FileObject include;

    protected Generator(WizardDescriptor wiz, FileObject fileObject) {
        this.fileObject = fileObject;
        this.wiz = wiz;
    }

    protected void instantiate() throws IOException {
        try {
            if (this.generate()) {
                this.makeProject = this.instantiateImpl();
                if (this.makeProject != null) {
                    this.switchModel(false);
                    OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
                    OpenProjects.getDefault().open(new Project[]{this.makeProject}, true);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected String validate() {
        File workingDir;
        File classNamePath;
        ClassPath sourceCP = ClassPath.getClassPath((FileObject)this.fileObject, (String)"classpath/source");
        FileObject sr = sourceCP != null ? sourceCP.findOwnerRoot(this.fileObject) : null;
        this.javaProject = FileOwnerQuery.getOwner((FileObject)sr);
        if (this.javaProject == null) {
            return NbBundle.getMessage(Generator.class, (String)"Generator_NoOwner", (Object)sr.getPath());
        }
        J2SEProjectPlatform pp = (J2SEProjectPlatform)this.javaProject.getLookup().lookup(J2SEProjectPlatform.class);
        if (pp == null) {
            return NbBundle.getMessage(Generator.class, (String)"Generator_NoJavaSE", this.javaProject.getClass());
        }
        JavaPlatform jp = pp.getProjectPlatform();
        if (jp == null) {
            return NbBundle.getMessage(Generator.class, (String)"Generator_NoJavaPlatform", pp.getClass());
        }
        FileObject binFO = jp.findTool("javah");
        File javah = FileUtil.toFile((FileObject)binFO);
        if (javah == null) {
            return NbBundle.getMessage(Generator.class, (String)"Generator_NoJavah", jp.getClass());
        }
        String classNameRelPath = FileUtil.getRelativePath((FileObject)sr, (FileObject)this.fileObject);
        if (classNameRelPath.endsWith(".java")) {
            classNameRelPath = classNameRelPath.substring(0, classNameRelPath.length() - 5);
        }
        if (!(classNamePath = new File(workingDir = new File(FileUtil.toFile((FileObject)sr.getParent()), "build/classes"), classNameRelPath + ".class")).exists()) {
            return NbBundle.getMessage(Generator.class, (String)"Generator_NoCompiled", (Object)this.fileObject.getPath());
        }
        return null;
    }

    private boolean generate() {
        ClassPath sourceCP = ClassPath.getClassPath((FileObject)this.fileObject, (String)"classpath/source");
        ClassPath compileCP = ClassPath.getClassPath((FileObject)this.fileObject, (String)"classpath/compile");
        FileObject sr = sourceCP != null ? sourceCP.findOwnerRoot(this.fileObject) : null;
        this.javaProject = FileOwnerQuery.getOwner((FileObject)sr);
        J2SEProjectPlatform pp = (J2SEProjectPlatform)this.javaProject.getLookup().lookup(J2SEProjectPlatform.class);
        JavaPlatform jp = pp.getProjectPlatform();
        FileObject binFO = jp.findTool("javah");
        String headerName = this.fileObject.getName() + ".h";
        this.header = JNISupport.generateJNIHeader(binFO, sr, this.fileObject, headerName, sourceCP, compileCP);
        if (this.header != null) {
            this.include = binFO.getParent().getParent().getFileObject("include");
            return true;
        }
        return false;
    }

    private Project instantiateImpl() throws IOException {
        FSPath dirF = (FSPath)WizardConstants.PROPERTY_PROJECT_FOLDER.get(this.wiz);
        String hostUID = (String)WizardConstants.PROPERTY_HOST_UID.get(this.wiz);
        CompilerSet toolchain = (CompilerSet)WizardConstants.PROPERTY_TOOLCHAIN.get(this.wiz);
        boolean defaultToolchain = Boolean.TRUE.equals(WizardConstants.PROPERTY_TOOLCHAIN_DEFAULT.get(this.wiz));
        if (dirF != null) {
            ExecutionEnvironment ee = (ExecutionEnvironment)WizardConstants.PROPERTY_REMOTE_FILE_SYSTEM_ENV.get(this.wiz);
            if (ee == null) {
                ee = ExecutionEnvironmentFactory.getLocal();
            }
            dirF = new FSPath(dirF.getFileSystem(), RemoteFileUtil.normalizeAbsolutePath((String)dirF.getPath(), (ExecutionEnvironment)ee));
        }
        String projectName = (String)WizardConstants.PROPERTY_NAME.get(this.wiz);
        String makefileName = (String)WizardConstants.PROPERTY_GENERATED_MAKEFILE_NAME.get(this.wiz);
        int conftype = 2;
        LibraryItem.OptionItem lib = new LibraryItem.OptionItem("-lstdc++");
        List<LibraryItem> libs = Arrays.asList(lib);
        MakeConfiguration debug = MakeConfiguration.createConfiguration((FSPath)dirF, (String)"Debug", (int)conftype, null, (String)hostUID, (CompilerSet)toolchain, (boolean)defaultToolchain);
        debug.getCCompilerConfiguration().getDevelopmentMode().setValue(1);
        debug.getCCCompilerConfiguration().getDevelopmentMode().setValue(1);
        debug.getFortranCompilerConfiguration().getDevelopmentMode().setValue(1);
        debug.getAssemblerConfiguration().getDevelopmentMode().setValue(1);
        debug.getQmakeConfiguration().getBuildMode().setValue(0);
        debug.getCCCompilerConfiguration().getIncludeDirectories().setValue(this.getIncludePaths(dirF.getPath()));
        debug.getLinkerConfiguration().getLibrariesConfiguration().setValue(libs);
        MakeConfiguration release = MakeConfiguration.createConfiguration((FSPath)dirF, (String)"Release", (int)conftype, null, (String)hostUID, (CompilerSet)toolchain, (boolean)defaultToolchain);
        release.getCCompilerConfiguration().getDevelopmentMode().setValue(5);
        release.getCCCompilerConfiguration().getDevelopmentMode().setValue(5);
        release.getFortranCompilerConfiguration().getDevelopmentMode().setValue(5);
        release.getAssemblerConfiguration().getDevelopmentMode().setValue(5);
        release.getQmakeConfiguration().getBuildMode().setValue(1);
        release.getCCCompilerConfiguration().getIncludeDirectories().setValue(this.getIncludePaths(dirF.getPath()));
        release.getLinkerConfiguration().getLibrariesConfiguration().setValue(libs);
        MakeConfiguration[] confs = new MakeConfiguration[]{debug, release};
        ProjectGenerator.ProjectParameters prjParams = new ProjectGenerator.ProjectParameters(projectName, dirF);
        prjParams.setMakefileName(makefileName);
        prjParams.setConfigurations(confs);
        prjParams.setHostUID(hostUID);
        prjParams.setTemplateParams(new HashMap(this.wiz.getProperties()));
        Project createProject = ProjectGenerator.createProject((ProjectGenerator.ProjectParameters)prjParams);
        return createProject;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("openProjects") && evt.getNewValue() instanceof Project[]) {
            Project[] projects = (Project[])evt.getNewValue();
            if (projects.length == 0) {
                return;
            }
            OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    Generator.this.doWork();
                }
            });
        }
    }

    private void doWork() {
        block4: {
            try {
                ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
                pdp.getConfigurationDescriptor();
                if (!pdp.gotDescriptor()) break block4;
                MakeConfigurationDescriptor configurationDescriptor = pdp.getConfigurationDescriptor();
                if (this.header == null || !this.header.isValid()) break block4;
                FileObject newHeader = this.createHeader(configurationDescriptor);
                StringBuilder buf = new StringBuilder();
                FileObject newSource = this.createSource(configurationDescriptor, buf);
                configurationDescriptor.save();
                CsmModel model = CsmModelAccessor.getModel();
                if (model == null || this.makeProject == null) break block4;
                this.switchModel(true);
                NativeProject np = (NativeProject)this.makeProject.getLookup().lookup(NativeProject.class);
                CsmProject p = model.getProject((Object)np);
                LOG.log(Level.FINE, "Generate stub, CsmProject: {0}", p);
                if (p == null) break block4;
                p.waitParse();
                try {
                    Generator.createStub(newHeader, newSource, buf);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                p.waitParse();
                CsmUtilities.openSource((FileObject)newSource, (int)0);
                this.updateLibraryPath(configurationDescriptor);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void updateLibraryPath(MakeConfigurationDescriptor configurationDescriptor) throws FileNotFoundException, IOException {
        FileObject propFile = this.javaProject.getProjectDirectory().getFileObject("nbproject/project.properties");
        if (propFile != null && propFile.isValid() && configurationDescriptor.getActiveConfiguration() != null) {
            InputStream inputStream = propFile.getInputStream();
            Properties prop = new Properties();
            prop.load(inputStream);
            inputStream.close();
            String args = prop.getProperty("run.jvmargs", "");
            String outputValue = configurationDescriptor.getActiveConfiguration().getAbsoluteOutputValue();
            if (!args.contains("-Djava.library.path=")) {
                args = args + " -Djava.library.path=" + CndPathUtilities.getDirName((String)outputValue);
                prop.put("run.jvmargs", args);
                OutputStream outputStream = propFile.getOutputStream();
                prop.store(outputStream, args);
                outputStream.close();
            }
        }
    }

    private void switchModel(boolean state) {
        CsmModel model = CsmModelAccessor.getModel();
        if (model != null && this.makeProject != null) {
            NativeProject np = (NativeProject)this.makeProject.getLookup().lookup(NativeProject.class);
            if (state) {
                model.enableProject((Object)np);
            } else {
                model.disableProject((Object)np);
            }
        }
    }

    public static void createStub(FileObject newHeader, FileObject newSource, StringBuilder buf) throws IOException {
        CsmFile includeFile = CsmUtilities.getCsmFile((FileObject)newHeader, (boolean)true, (boolean)false);
        if (includeFile != null) {
            for (CsmOffsetableDeclaration declaration : includeFile.getDeclarations()) {
                if (!CsmKindUtilities.isFunction((CsmObject)declaration)) continue;
                CsmFunction f = (CsmFunction)declaration;
                String declarationText = f.getText().toString();
                int beg = declarationText.lastIndexOf(40);
                int end = declarationText.lastIndexOf(41);
                if (beg <= 0 || beg >= end) continue;
                buf.append('\n');
                buf.append(declarationText.substring(0, beg + 1));
                String[] params = declarationText.substring(beg + 1, end).split(",");
                for (int i = 0; i < params.length; ++i) {
                    if (i > 0) {
                        buf.append(',').append(' ');
                    }
                    if (i == 0) {
                        buf.append(params[i].trim()).append(' ').append("env");
                        continue;
                    }
                    if (i == 1) {
                        buf.append(params[i].trim()).append(' ').append("object");
                        continue;
                    }
                    buf.append(params[i].trim()).append(' ').append("param").append(Integer.toString(i - 1));
                }
                buf.append(") {\n}\n");
            }
            OutputStreamWriter w = new OutputStreamWriter(newSource.getOutputStream());
            w.write(buf.toString());
            ((Writer)w).close();
        }
    }

    private FileObject createSource(MakeConfigurationDescriptor configurationDescriptor, StringBuilder buf) throws IOException {
        Folder sourceFolder = Generator.getRootSource(configurationDescriptor);
        FileObject folder = sourceFolder.isDiskFolder() ? RemoteFileUtil.getFileObject((String)sourceFolder.getAbsolutePath(), (Project)this.makeProject) : configurationDescriptor.getBaseDirFileObject();
        FileObject newSource = folder.createData(this.header.getName(), "cpp");
        buf.append("// Native methods implementation of\n// ").append(this.fileObject.getPath()).append("\n\n");
        buf.append("#include \"").append(this.header.getNameExt()).append("\"\n");
        OutputStreamWriter w = new OutputStreamWriter(newSource.getOutputStream());
        w.write(buf.toString());
        ((Writer)w).close();
        Item item = Item.createInFileSystem((FileSystem)configurationDescriptor.getBaseDirFileSystem(), (String)newSource.getPath());
        sourceFolder.addItemAction(item);
        return newSource;
    }

    private List<String> getIncludePaths(String baseDir) {
        ArrayList<String> includeDirectoriesVector = new ArrayList<String>();
        String includeDirectory = this.include.getPath();
        includeDirectory = CndPathUtilities.toRelativePath((String)baseDir, (String)CndPathUtilities.naturalizeSlashes((String)includeDirectory));
        includeDirectory = CndPathUtilities.normalizeSlashes((String)includeDirectory);
        includeDirectoriesVector.add(includeDirectory);
        for (FileObject child : this.include.getChildren()) {
            if (!child.isFolder()) continue;
            includeDirectory = child.getPath();
            includeDirectory = CndPathUtilities.toRelativePath((String)baseDir, (String)CndPathUtilities.naturalizeSlashes((String)includeDirectory));
            includeDirectory = CndPathUtilities.normalizeSlashes((String)includeDirectory);
            includeDirectoriesVector.add(includeDirectory);
        }
        return includeDirectoriesVector;
    }

    private FileObject createHeader(MakeConfigurationDescriptor configurationDescriptor) throws IOException {
        Folder headersFolder = Generator.getRootHeader(configurationDescriptor);
        FileObject folder = headersFolder.isDiskFolder() ? RemoteFileUtil.getFileObject((String)headersFolder.getAbsolutePath(), (Project)this.makeProject) : configurationDescriptor.getBaseDirFileObject();
        FileObject newHeader = FileUtil.copyFile((FileObject)this.header, (FileObject)folder, (String)this.header.getName());
        Item item = Item.createInFileSystem((FileSystem)configurationDescriptor.getBaseDirFileSystem(), (String)newHeader.getPath());
        headersFolder.addItemAction(item);
        return newHeader;
    }

    public static Folder getRootHeader(MakeConfigurationDescriptor configurationDescriptor) {
        Folder folder = configurationDescriptor.getLogicalFolders();
        List sources = folder.getFolders();
        for (Folder sub : sources) {
            if (!sub.isProjectFiles() || !"HeaderFiles".equals(sub.getName())) continue;
            return sub;
        }
        return folder;
    }

    public static Folder getRootSource(MakeConfigurationDescriptor configurationDescriptor) {
        Folder folder = configurationDescriptor.getLogicalFolders();
        List sources = folder.getFolders();
        for (Folder sub : sources) {
            if (!sub.isProjectFiles() || !"SourceFiles".equals(sub.getName())) continue;
            return sub;
        }
        return folder;
    }
}

